/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightServicesUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InvertIfConditionAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.InvertIfConditionAction");

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiKeyword keyword;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/InvertIfConditionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/InvertIfConditionAction", "isAvailable"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class);
        if (ifStatement == null) {
            return false;
        }
        PsiExpression condition2 = ifStatement.getCondition();
        if (condition2 == null) {
            return false;
        }
        if (ifStatement.getThenBranch() == null) {
            return false;
        }
        if (element instanceof PsiKeyword && ((keyword = (PsiKeyword)element).getTokenType() == JavaTokenType.IF_KEYWORD || keyword.getTokenType() == JavaTokenType.ELSE_KEYWORD) && keyword.getParent() == ifStatement) {
            return true;
        }
        TextRange condTextRange = condition2.getTextRange();
        if (condTextRange == null) {
            return false;
        }
        if (!condTextRange.contains(offset)) {
            return false;
        }
        PsiElement block = InvertIfConditionAction.findCodeBlock(ifStatement);
        return block != null;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/InvertIfConditionAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.invert.if.condition", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/InvertIfConditionAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/InvertIfConditionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/InvertIfConditionAction", "invoke"));
        }
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class);
        LOG.assertTrue(ifStatement != null);
        PsiElement block = InvertIfConditionAction.findCodeBlock(ifStatement);
        ControlFlow controlFlow = InvertIfConditionAction.buildControlFlow(block);
        PsiExpression condition2 = (PsiExpression)ifStatement.getCondition().copy();
        ifStatement = InvertIfConditionAction.setupBranches(ifStatement, controlFlow);
        if (condition2 != null) {
            ifStatement.getCondition().replace((PsiElement)CodeInsightServicesUtil.invertCondition((PsiExpression)condition2));
        }
        InvertIfConditionAction.formatIf(ifStatement);
    }

    private static void formatIf(PsiIfStatement ifStatement) throws IncorrectOperationException {
        PsiBlockStatement codeBlock1;
        Project project2 = ifStatement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiElement thenBranch = ifStatement.getThenBranch().copy();
        PsiElement elseBranch = ifStatement.getElseBranch() != null ? ifStatement.getElseBranch().copy() : null;
        PsiElement condition2 = ifStatement.getCondition().copy();
        CodeStyleManager codeStyle = CodeStyleManager.getInstance((Project)project2);
        PsiBlockStatement codeBlock = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)ifStatement);
        codeBlock = (PsiBlockStatement)codeStyle.reformat((PsiElement)codeBlock);
        ifStatement.getThenBranch().replace((PsiElement)codeBlock);
        if (elseBranch != null) {
            ifStatement.getElseBranch().replace((PsiElement)codeBlock);
        }
        ifStatement.getCondition().replace((PsiElement)factory.createExpressionFromText("true", null));
        ifStatement = (PsiIfStatement)codeStyle.reformat((PsiElement)ifStatement);
        if (!(thenBranch instanceof PsiBlockStatement)) {
            codeBlock1 = (PsiBlockStatement)ifStatement.getThenBranch().replace((PsiElement)codeBlock);
            codeBlock1 = (PsiBlockStatement)codeStyle.reformat((PsiElement)codeBlock1);
            codeBlock1.getCodeBlock().add(thenBranch);
        } else {
            ifStatement.getThenBranch().replace(thenBranch);
        }
        if (elseBranch != null) {
            if (!(elseBranch instanceof PsiBlockStatement)) {
                codeBlock1 = (PsiBlockStatement)ifStatement.getElseBranch().replace((PsiElement)codeBlock);
                codeBlock1 = (PsiBlockStatement)codeStyle.reformat((PsiElement)codeBlock1);
                codeBlock1.getCodeBlock().add(elseBranch);
            } else {
                elseBranch = ifStatement.getElseBranch().replace(elseBranch);
                if (InvertIfConditionAction.emptyBlock(((PsiBlockStatement)elseBranch).getCodeBlock())) {
                    ifStatement.getElseBranch().delete();
                }
            }
        }
        ifStatement.getCondition().replace(condition2);
    }

    private static boolean emptyBlock(PsiCodeBlock block) {
        PsiElement[] children2;
        for (PsiElement child : children2 = block.getChildren()) {
            if (child instanceof PsiComment) {
                return false;
            }
            if (child instanceof PsiWhiteSpace || child instanceof PsiJavaToken) continue;
            return false;
        }
        return true;
    }

    private static PsiElement findCodeBlock(PsiIfStatement ifStatement) {
        PsiElement e = PsiTreeUtil.getParentOfType((PsiElement)ifStatement, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class, PsiLambdaExpression.class});
        if (e instanceof PsiMethod) {
            return ((PsiMethod)e).getBody();
        }
        if (e instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)e).getBody();
        }
        if (e instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)e).getBody();
        }
        return null;
    }

    private static ControlFlow buildControlFlow(PsiElement element) {
        try {
            return ControlFlowFactory.getInstance(element.getProject()).getControlFlow(element, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
        }
        catch (AnalysisCanceledException e) {
            return ControlFlow.EMPTY;
        }
    }

    private static PsiIfStatement setupBranches(PsiIfStatement ifStatement, ControlFlow flow) throws IncorrectOperationException {
        PsiElement parent;
        boolean nextUnreachable;
        PsiElement element;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)ifStatement.getProject()).getElementFactory();
        Project project2 = ifStatement.getProject();
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            elseBranch = (PsiStatement)elseBranch.copy();
            InvertIfConditionAction.setElseBranch(ifStatement, thenBranch, flow);
            ifStatement.getThenBranch().replace((PsiElement)elseBranch);
            return ifStatement;
        }
        CodeStyleManager codeStyle = CodeStyleManager.getInstance((Project)project2);
        if (flow.getSize() == 0) {
            ifStatement.setElseBranch(thenBranch);
            PsiStatement statement2 = factory.createStatementFromText("{}", (PsiElement)ifStatement);
            statement2 = (PsiStatement)codeStyle.reformat((PsiElement)statement2);
            statement2 = (PsiStatement)ifStatement.getThenBranch().replace((PsiElement)statement2);
            codeStyle.reformat((PsiElement)statement2);
            return ifStatement;
        }
        int endOffset = InvertIfConditionAction.calcEndOffset(flow, ifStatement);
        LOG.assertTrue(endOffset >= 0);
        if (endOffset >= flow.getSize()) {
            PsiStatement statement3 = factory.createStatementFromText("return;", (PsiElement)ifStatement);
            statement3 = (PsiStatement)codeStyle.reformat((PsiElement)statement3);
            if (thenBranch instanceof PsiBlockStatement) {
                PsiStatement[] statements = ((PsiBlockStatement)thenBranch).getCodeBlock().getStatements();
                if (statements.length > 0) {
                    PsiStatement firstElement = statements[0];
                    while (firstElement.getPrevSibling() instanceof PsiWhiteSpace || firstElement.getPrevSibling() instanceof PsiComment) {
                        firstElement = firstElement.getPrevSibling();
                    }
                    ifStatement.getParent().addRangeAfter((PsiElement)firstElement, (PsiElement)statements[statements.length - 1], (PsiElement)ifStatement);
                }
            } else if (!(thenBranch instanceof PsiReturnStatement)) {
                ifStatement = InvertIfConditionAction.addAfterWithinCodeBlock(ifStatement, thenBranch);
            }
            ifStatement.getThenBranch().replace((PsiElement)statement3);
            return ifStatement;
        }
        for (element = flow.getElement(endOffset); element != null && !(element instanceof PsiStatement); element = element.getParent()) {
        }
        if (element != null && element.getParent() instanceof PsiForStatement && ((PsiForStatement)element.getParent()).getUpdate() == element || element instanceof PsiWhileStatement && flow.getStartOffset(element) == endOffset || element instanceof PsiForeachStatement && flow.getStartOffset(element) + 1 == endOffset) {
            PsiStatement statement4 = factory.createStatementFromText("continue;", (PsiElement)ifStatement);
            statement4 = (PsiStatement)codeStyle.reformat((PsiElement)statement4);
            ifStatement = InvertIfConditionAction.addAfterWithinCodeBlock(ifStatement, thenBranch);
            ifStatement.getThenBranch().replace((PsiElement)statement4);
            return ifStatement;
        }
        if (element instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)element;
            ifStatement = InvertIfConditionAction.addAfterWithinCodeBlock(ifStatement, thenBranch);
            ifStatement.getThenBranch().replace(returnStatement.copy());
            ControlFlow flow2 = InvertIfConditionAction.buildControlFlow(InvertIfConditionAction.findCodeBlock(ifStatement));
            if (!ControlFlowUtil.isInstructionReachable(flow2, flow2.getStartOffset((PsiElement)returnStatement), 0)) {
                returnStatement.delete();
            }
            return ifStatement;
        }
        boolean bl = nextUnreachable = flow.getEndOffset((PsiElement)ifStatement) == flow.getSize();
        if (!nextUnreachable && (parent = ifStatement.getParent()) != null) {
            if (!(parent instanceof PsiCodeBlock)) {
                ifStatement = (PsiIfStatement)InvertIfConditionAction.wrapWithCodeBlock((PsiStatement)ifStatement);
                parent = ifStatement.getParent();
                thenBranch = ifStatement.getThenBranch();
            }
            ControlFlow localFlow = InvertIfConditionAction.buildControlFlow(parent);
            int startThenOffset = InvertIfConditionAction.getThenOffset(localFlow, ifStatement);
            int afterIfOffset = localFlow.getEndOffset((PsiElement)ifStatement);
            boolean bl2 = nextUnreachable = !ControlFlowUtil.isInstructionReachable(localFlow, afterIfOffset, startThenOffset);
        }
        if (nextUnreachable) {
            InvertIfConditionAction.setElseBranch(ifStatement, thenBranch, flow);
            PsiElement first = ifStatement.getNextSibling();
            if (first != null) {
                PsiElement last = first;
                for (PsiElement next = last.getNextSibling(); next != null && !(next instanceof PsiSwitchLabelStatement); next = next.getNextSibling()) {
                    last = next;
                }
                while (first != last && (last instanceof PsiWhiteSpace || last instanceof PsiJavaToken && ((PsiJavaToken)last).getTokenType() == JavaTokenType.RBRACE)) {
                    last = last.getPrevSibling();
                }
                PsiBlockStatement codeBlock = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)ifStatement);
                codeBlock.getCodeBlock().addRange(first, last);
                first.getParent().deleteChildRange(first, last);
                ifStatement.getThenBranch().replace((PsiElement)codeBlock);
            }
            codeStyle.reformat((PsiElement)ifStatement);
            return ifStatement;
        }
        InvertIfConditionAction.setElseBranch(ifStatement, thenBranch, flow);
        PsiStatement statement5 = factory.createStatementFromText("{}", (PsiElement)ifStatement);
        statement5 = (PsiStatement)codeStyle.reformat((PsiElement)statement5);
        statement5 = (PsiStatement)ifStatement.getThenBranch().replace((PsiElement)statement5);
        codeStyle.reformat((PsiElement)statement5);
        return ifStatement;
    }

    private static void setElseBranch(PsiIfStatement ifStatement, PsiStatement thenBranch, ControlFlow flow) throws IncorrectOperationException {
        if (flow.getEndOffset((PsiElement)ifStatement) == flow.getEndOffset((PsiElement)thenBranch)) {
            PsiStatement[] statements;
            Object[] statements2;
            PsiStatement body2;
            PsiLoopStatement loopStmt = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, PsiLoopStatement.class);
            if (loopStmt != null && (body2 = loopStmt.getBody()) instanceof PsiBlockStatement && (statements2 = ((PsiBlockStatement)body2).getCodeBlock().getStatements()).length > 0 && !PsiTreeUtil.isAncestor((PsiElement)statements2[statements2.length - 1], (PsiElement)ifStatement, (boolean)false) && ArrayUtilRt.find((Object[])statements2, (Object)ifStatement) < 0) {
                ifStatement.setElseBranch(thenBranch);
                return;
            }
            if (thenBranch instanceof PsiContinueStatement) {
                PsiStatement elseBranch = ifStatement.getElseBranch();
                if (elseBranch != null) {
                    elseBranch.delete();
                }
                return;
            }
            if (thenBranch instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)thenBranch).getCodeBlock().getStatements()).length > 0 && statements[statements.length - 1] instanceof PsiContinueStatement) {
                statements[statements.length - 1].delete();
            }
        }
        ifStatement.setElseBranch(thenBranch);
    }

    private static PsiStatement wrapWithCodeBlock(@NotNull PsiStatement statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/intention/impl/InvertIfConditionAction", "wrapWithCodeBlock"));
        }
        Project project2 = statement2.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        CodeStyleManager codeStyle = CodeStyleManager.getInstance((Project)project2);
        PsiCodeBlock codeBlock = factory.createCodeBlockFromText("{}", (PsiElement)statement2);
        codeBlock = (PsiCodeBlock)codeStyle.reformat((PsiElement)codeBlock);
        codeBlock.add((PsiElement)statement2);
        codeBlock = (PsiCodeBlock)statement2.replace((PsiElement)codeBlock);
        return codeBlock.getStatements()[0];
    }

    private static PsiIfStatement addAfterWithinCodeBlock(@NotNull PsiIfStatement ifStatement, @NotNull PsiStatement branch) {
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/intellij/codeInsight/intention/impl/InvertIfConditionAction", "addAfterWithinCodeBlock"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "com/intellij/codeInsight/intention/impl/InvertIfConditionAction", "addAfterWithinCodeBlock"));
        }
        PsiElement parent = ifStatement.getParent();
        if (parent != null && !(parent instanceof PsiCodeBlock)) {
            branch = (PsiStatement)branch.copy();
            ifStatement = (PsiIfStatement)InvertIfConditionAction.wrapWithCodeBlock((PsiStatement)ifStatement);
        }
        InvertIfConditionAction.addAfter(ifStatement, branch);
        return ifStatement;
    }

    static void addAfter(PsiIfStatement ifStatement, PsiStatement branch) throws IncorrectOperationException {
        if (branch instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)branch;
            PsiCodeBlock block = blockStatement.getCodeBlock();
            PsiElement firstBodyElement = block.getFirstBodyElement();
            PsiElement lastBodyElement = block.getLastBodyElement();
            if (firstBodyElement != null && lastBodyElement != null) {
                ifStatement.getParent().addRangeAfter(firstBodyElement, lastBodyElement, (PsiElement)ifStatement);
            }
        } else {
            ifStatement.getParent().addAfter((PsiElement)branch, (PsiElement)ifStatement);
        }
    }

    private static int getThenOffset(ControlFlow controlFlow, PsiIfStatement ifStatement) {
        PsiStatement thenBranch = ifStatement.getThenBranch();
        for (int i2 = 0; i2 < controlFlow.getSize(); ++i2) {
            if (!PsiTreeUtil.isAncestor((PsiElement)thenBranch, (PsiElement)controlFlow.getElement(i2), (boolean)false)) continue;
            return i2;
        }
        return -1;
    }

    private static int calcEndOffset(ControlFlow controlFlow, PsiIfStatement ifStatement) {
        int endOffset = -1;
        List<Instruction> instructions = controlFlow.getInstructions();
        for (int i2 = 0; i2 < instructions.size(); ++i2) {
            BranchingInstruction goToInstruction;
            Instruction instruction = instructions.get(i2);
            if (controlFlow.getElement(i2) != ifStatement) continue;
            if (instruction instanceof GoToInstruction) {
                goToInstruction = (GoToInstruction)instruction;
                if (goToInstruction.role != BranchingInstruction.Role.END) continue;
                endOffset = goToInstruction.offset;
                break;
            }
            if (!(instruction instanceof ConditionalGoToInstruction)) continue;
            goToInstruction = (ConditionalGoToInstruction)instruction;
            if (((ConditionalGoToInstruction)goToInstruction).role != BranchingInstruction.Role.END) continue;
            endOffset = ((ConditionalGoToInstruction)goToInstruction).offset;
            break;
        }
        if (endOffset == -1) {
            endOffset = controlFlow.getSize();
        }
        while (endOffset < instructions.size() && instructions.get(endOffset) instanceof GoToInstruction && !((GoToInstruction)instructions.get((int)endOffset)).isReturn && !(controlFlow.getElement(endOffset) instanceof PsiBreakStatement)) {
            endOffset = ((BranchingInstruction)instructions.get((int)endOffset)).offset;
        }
        return endOffset;
    }
}

