/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceCastWithVariableAction
extends PsiElementBaseIntentionAction {
    private String myReplaceVariableName = "";

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction", "isAvailable"));
        }
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeCastExpression.class);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (typeCastExpression == null || method == null) {
            return false;
        }
        PsiExpression operand2 = typeCastExpression.getOperand();
        if (!(operand2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression operandReference = (PsiReferenceExpression)operand2;
        PsiElement resolved = operandReference.resolve();
        if (resolved == null || !(resolved instanceof PsiParameter) && !(resolved instanceof PsiLocalVariable)) {
            return false;
        }
        PsiLocalVariable replacement = ReplaceCastWithVariableAction.findReplacement(method, (PsiVariable)resolved, typeCastExpression);
        if (replacement == null) {
            return false;
        }
        this.myReplaceVariableName = replacement.getName();
        this.setText(CodeInsightBundle.message((String)"intention.replace.cast.with.var.text", (Object[])new Object[]{typeCastExpression.getText(), this.myReplaceVariableName}));
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction", "invoke"));
        }
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeCastExpression.class);
        if (typeCastExpression == null) {
            return;
        }
        PsiTypeCastExpression toReplace = typeCastExpression.getParent() instanceof PsiParenthesizedExpression ? typeCastExpression.getParent() : typeCastExpression;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        toReplace.replace((PsiElement)factory.createExpressionFromText(this.myReplaceVariableName, (PsiElement)toReplace));
    }

    @Nullable
    private static PsiLocalVariable findReplacement(@NotNull PsiMethod method, @NotNull PsiVariable castedVar, @NotNull PsiTypeCastExpression expression2) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction", "findReplacement"));
        }
        if (castedVar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "castedVar", "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction", "findReplacement"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction", "findReplacement"));
        }
        TextRange expressionTextRange = expression2.getTextRange();
        for (PsiExpression occurrence : CodeInsightUtil.findExpressionOccurrences((PsiElement)method, (PsiExpression)expression2)) {
            ProgressIndicatorProvider.checkCanceled();
            TextRange occurrenceTextRange = occurrence.getTextRange();
            if (occurrence == expression2 || occurrenceTextRange.getEndOffset() >= expressionTextRange.getStartOffset()) continue;
            PsiLocalVariable variable = ReplaceCastWithVariableAction.getVariable(occurrence);
            PsiCodeBlock methodBody2 = method.getBody();
            if (variable == null || methodBody2 == null || ReplaceCastWithVariableAction.isChangedBetween(castedVar, (PsiElement)methodBody2, (PsiElement)occurrence, (PsiElement)expression2) || ReplaceCastWithVariableAction.isChangedBetween((PsiVariable)variable, (PsiElement)methodBody2, (PsiElement)occurrence, (PsiElement)expression2)) continue;
            return variable;
        }
        return null;
    }

    private static boolean isChangedBetween(final @NotNull PsiVariable variable, @NotNull PsiElement scope, final @NotNull PsiElement start, final @NotNull PsiElement end) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction", "isChangedBetween"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction", "isChangedBetween"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction", "isChangedBetween"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction", "isChangedBetween"));
        }
        if (variable.hasModifierProperty("final")) {
            return false;
        }
        final Ref result2 = new Ref();
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){
            private boolean inScope;

            public void visitElement(PsiElement element) {
                if (element == start) {
                    this.inScope = true;
                }
                if (element == end) {
                    this.inScope = false;
                    this.stopWalking();
                }
                super.visitElement(element);
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                PsiReferenceExpression referenceExpression;
                if (this.inScope && expression2.getLExpression() instanceof PsiReferenceExpression && variable.equals((referenceExpression = (PsiReferenceExpression)expression2.getLExpression()).resolve())) {
                    result2.set((Object)true);
                    this.stopWalking();
                }
                super.visitAssignmentExpression(expression2);
            }
        });
        return result2.get() == Boolean.TRUE;
    }

    @Nullable
    private static PsiLocalVariable getVariable(@NotNull PsiExpression occurrence) {
        PsiReferenceExpression referenceExpression;
        PsiElement resolved;
        PsiAssignmentExpression assignmentExpression;
        if (occurrence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrence", "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction", "getVariable"));
        }
        PsiElement parent = occurrence.getParent();
        if (parent instanceof PsiLocalVariable) {
            return (PsiLocalVariable)parent;
        }
        if (parent instanceof PsiAssignmentExpression && (assignmentExpression = (PsiAssignmentExpression)parent).getLExpression() instanceof PsiReferenceExpression && (resolved = (referenceExpression = (PsiReferenceExpression)assignmentExpression.getLExpression()).resolve()) instanceof PsiLocalVariable) {
            return (PsiLocalVariable)resolved;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.replace.cast.with.var.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ReplaceCastWithVariableAction", "getFamilyName"));
        }
        return string;
    }
}

