/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class TypeExpression
extends Expression {
    private final LinkedHashSet<SmartTypePointer> myItems;

    public TypeExpression(Project project2, PsiType[] types) {
        SmartTypePointerManager manager = SmartTypePointerManager.getInstance((Project)project2);
        this.myItems = new LinkedHashSet();
        for (PsiType type2 : types) {
            this.myItems.add(manager.createSmartTypePointer(type2));
        }
    }

    public Result calculateResult(ExpressionContext context) {
        Project project2 = context.getProject();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        if (this.myItems.isEmpty()) {
            return null;
        }
        final PsiType type2 = ((SmartTypePointer)this.myItems.iterator().next()).getType();
        return type2 == null ? null : new PsiTypeResult(type2, project2){

            @Override
            public void handleRecalc(PsiFile psiFile, Document document, int segmentStart, int segmentEnd) {
                if (TypeExpression.this.myItems.size() <= 1) {
                    super.handleRecalc(psiFile, document, segmentStart, segmentEnd);
                } else {
                    JavaTemplateUtil.updateTypeBindings(this.getType(), psiFile, document, segmentStart, segmentEnd, true);
                }
            }

            @Override
            public String toString() {
                return TypeExpression.this.myItems.size() == 1 ? super.toString() : type2.getPresentableText();
            }
        };
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        if (this.myItems.size() <= 1) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        ArrayList<PsiTypeLookupItem> result2 = new ArrayList<PsiTypeLookupItem>(this.myItems.size());
        for (SmartTypePointer item : this.myItems) {
            PsiType type2 = item.getType();
            if (type2 == null) continue;
            result2.add(PsiTypeLookupItem.createLookupItem(type2, null));
        }
        return result2.toArray(new LookupElement[result2.size()]);
    }
}

