/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.impl.config.PlainTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.ResourceTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BeforeAfterActionMetaData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.BeforeAfterActionMetaData");
    protected static final TextDescriptor[] EMPTY_EXAMPLE = new TextDescriptor[0];
    protected static final TextDescriptor EMPTY_DESCRIPTION = new PlainTextDescriptor("", "");
    @NonNls
    protected static final String DESCRIPTION_FILE_NAME = "description.html";
    @NonNls
    static final String EXAMPLE_USAGE_URL_SUFFIX = ".template";
    @NonNls
    private static final String BEFORE_TEMPLATE_PREFIX = "before";
    @NonNls
    private static final String AFTER_TEMPLATE_PREFIX = "after";
    protected final ClassLoader myLoader;
    protected final String myDescriptionDirectoryName;
    protected TextDescriptor[] myExampleUsagesBefore = null;
    protected TextDescriptor[] myExampleUsagesAfter = null;
    protected TextDescriptor myDescription = null;

    public BeforeAfterActionMetaData(ClassLoader loader, String descriptionDirectoryName) {
        this.myLoader = loader;
        this.myDescriptionDirectoryName = descriptionDirectoryName;
    }

    public BeforeAfterActionMetaData(TextDescriptor description, TextDescriptor[] exampleUsagesBefore, TextDescriptor[] exampleUsagesAfter) {
        this.myLoader = null;
        this.myDescriptionDirectoryName = null;
        this.myExampleUsagesBefore = exampleUsagesBefore;
        this.myExampleUsagesAfter = exampleUsagesAfter;
        this.myDescription = description;
    }

    @NotNull
    private static TextDescriptor[] retrieveURLs(@NotNull URL descriptionDirectory, @NotNull String prefix, @NotNull String suffix) throws MalformedURLException {
        FileType[] fileTypes;
        if (descriptionDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionDirectory", "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData", "retrieveURLs"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData", "retrieveURLs"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData", "retrieveURLs"));
        }
        ArrayList<ResourceTextDescriptor> urls = new ArrayList<ResourceTextDescriptor>();
        for (FileType fileType : fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            String[] extensions;
            block5: for (String extension : extensions = FileTypeManager.getInstance().getAssociatedExtensions(fileType)) {
                int i2 = 0;
                while (true) {
                    URL url = new URL(descriptionDirectory.toExternalForm() + "/" + prefix + "." + extension + (i2 == 0 ? "" : Integer.toString(i2)) + suffix);
                    try {
                        InputStream inputStream = url.openStream();
                        inputStream.close();
                        urls.add(new ResourceTextDescriptor(url));
                    }
                    catch (IOException ioe) {
                        continue block5;
                    }
                    ++i2;
                }
            }
        }
        if (urls.isEmpty()) {
            String[] children2;
            Exception cause = null;
            try {
                URI uri = descriptionDirectory.toURI();
                children2 = uri.isOpaque() ? null : (String[])ObjectUtils.notNull((Object)new File(uri).list(), (Object)ArrayUtil.EMPTY_STRING_ARRAY);
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                cause = e;
                children2 = null;
            }
            LOG.error("URLs not found for available file types and prefix: '" + prefix + "', suffix: '" + suffix + "'; in directory: '" + descriptionDirectory + "'" + (children2 == null ? "" : "; directory contents: " + Arrays.asList(children2)), (Throwable)cause);
            if (EMPTY_EXAMPLE == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData", "retrieveURLs"));
            }
            return EMPTY_EXAMPLE;
        }
        TextDescriptor[] textDescriptorArray = urls.toArray(new TextDescriptor[urls.size()]);
        if (textDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData", "retrieveURLs"));
        }
        return textDescriptorArray;
    }

    @NotNull
    public TextDescriptor[] getExampleUsagesBefore() {
        if (this.myExampleUsagesBefore == null) {
            try {
                this.myExampleUsagesBefore = BeforeAfterActionMetaData.retrieveURLs(this.getDirURL(), BEFORE_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
                if (EMPTY_EXAMPLE == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData", "getExampleUsagesBefore"));
                }
                return EMPTY_EXAMPLE;
            }
        }
        if (this.myExampleUsagesBefore == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData", "getExampleUsagesBefore"));
        }
        return this.myExampleUsagesBefore;
    }

    @NotNull
    public TextDescriptor[] getExampleUsagesAfter() {
        if (this.myExampleUsagesAfter == null) {
            try {
                this.myExampleUsagesAfter = BeforeAfterActionMetaData.retrieveURLs(this.getDirURL(), AFTER_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
                if (EMPTY_EXAMPLE == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData", "getExampleUsagesAfter"));
                }
                return EMPTY_EXAMPLE;
            }
        }
        if (this.myExampleUsagesAfter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData", "getExampleUsagesAfter"));
        }
        return this.myExampleUsagesAfter;
    }

    @NotNull
    public TextDescriptor getDescription() {
        if (this.myDescription == null) {
            try {
                URL dirURL = this.getDirURL();
                URL descriptionURL = new URL(dirURL.toExternalForm() + "/" + DESCRIPTION_FILE_NAME);
                this.myDescription = new ResourceTextDescriptor(descriptionURL);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
                TextDescriptor textDescriptor = EMPTY_DESCRIPTION;
                if (textDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData", "getDescription"));
                }
                return textDescriptor;
            }
        }
        TextDescriptor textDescriptor = this.myDescription;
        if (textDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/BeforeAfterActionMetaData", "getDescription"));
        }
        return textDescriptor;
    }

    @NotNull
    protected abstract URL getDirURL();
}

