/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.javadoc.AnnotationDocGenerator;
import com.intellij.codeInsight.javadoc.AnnotationFormat;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NonCodeAnnotationGenerator {
    private final PsiModifierListOwner myOwner;
    private final StringBuilder myOutput;

    NonCodeAnnotationGenerator(@NotNull PsiModifierListOwner owner2, StringBuilder output) {
        if (owner2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/javadoc/NonCodeAnnotationGenerator", "<init>"));
        }
        this.myOwner = owner2;
        this.myOutput = output;
    }

    void explainAnnotations() {
        MultiMap<PsiModifierListOwner, AnnotationDocGenerator> generators = NonCodeAnnotationGenerator.getSignatureNonCodeAnnotations(this.myOwner);
        if (generators.isEmpty()) {
            return;
        }
        this.myOutput.append("\n");
        this.myOutput.append(NonCodeAnnotationGenerator.getNonCodeHeader(generators.values())).append(":<br>\n");
        this.myOutput.append("<ul>\n");
        generators.keySet().forEach(owner2 -> {
            this.myOutput.append("<li>");
            if (generators.size() > 1) {
                this.myOutput.append(NonCodeAnnotationGenerator.getKind(owner2)).append(" <code>").append(((PsiNamedElement)owner2).getName()).append("</code>: ");
            }
            ArrayList annotations2 = ContainerUtil.newArrayList((Iterable)generators.get(owner2));
            for (int i2 = 0; i2 < annotations2.size(); ++i2) {
                if (i2 > 0) {
                    this.myOutput.append(" ");
                }
                ((AnnotationDocGenerator)annotations2.get(i2)).generateAnnotation(this.myOutput, AnnotationFormat.JavaDocComplete);
            }
            this.myOutput.append("</li>\n");
        });
        this.myOutput.append("</ul>\n");
    }

    @NotNull
    public static MultiMap<PsiModifierListOwner, AnnotationDocGenerator> getSignatureNonCodeAnnotations(PsiModifierListOwner owner2) {
        MultiMap generators = MultiMap.createLinked();
        for (PsiModifierListOwner each : NonCodeAnnotationGenerator.getSignatureOwners(owner2)) {
            List nonCode = ContainerUtil.filter(AnnotationDocGenerator.getAnnotationsToShow(each), a -> a.isExternal() || a.isInferred());
            if (nonCode.isEmpty()) continue;
            generators.putValues((Object)each, (Collection)nonCode);
        }
        MultiMap multiMap = generators;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/javadoc/NonCodeAnnotationGenerator", "getSignatureNonCodeAnnotations"));
        }
        return multiMap;
    }

    @NotNull
    private static List<PsiModifierListOwner> getSignatureOwners(PsiModifierListOwner owner2) {
        ArrayList<PsiModifierListOwner> allOwners = new ArrayList<PsiModifierListOwner>();
        allOwners.add(owner2);
        if (owner2 instanceof PsiMethod) {
            Collections.addAll(allOwners, ((PsiMethod)owner2).getParameterList().getParameters());
        }
        ArrayList<PsiModifierListOwner> arrayList = allOwners;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/javadoc/NonCodeAnnotationGenerator", "getSignatureOwners"));
        }
        return arrayList;
    }

    @NotNull
    public static String getNonCodeHeader(Collection<? extends AnnotationDocGenerator> values) {
        boolean hasExternal = values.stream().anyMatch(AnnotationDocGenerator::isExternal);
        boolean hasInferred = values.stream().anyMatch(AnnotationDocGenerator::isInferred);
        String string = (hasExternal && hasInferred ? "External and <i>inferred</i>" : (hasExternal ? "External" : "<i>Inferred</i>")) + " annotations available";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/javadoc/NonCodeAnnotationGenerator", "getNonCodeHeader"));
        }
        return string;
    }

    private static String getKind(PsiModifierListOwner owner2) {
        if (owner2 instanceof PsiParameter) {
            return "Parameter";
        }
        if (owner2 instanceof PsiMethod) {
            return ((PsiMethod)owner2).isConstructor() ? "Constructor" : "Method";
        }
        return owner2.getClass().getName();
    }
}

