/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.GotoTargetRendererProvider;
import com.intellij.codeInsight.navigation.ListBackgroundUpdaterTask;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindUtil;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.usages.UsageView;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.HashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GotoTargetHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(GotoTargetHandler.class);
    private final PsiElementListCellRenderer myDefaultTargetElementRenderer = new DefaultPsiElementListCellRenderer();
    private final DefaultListCellRenderer myActionElementRenderer = new ActionCellRenderer();

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/GotoTargetHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/GotoTargetHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/GotoTargetHandler", "invoke"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureUsedKey());
        try {
            GotoData gotoData = this.getSourceAndTargetElements(editor, file2);
            if (gotoData != null) {
                this.show(project2, editor, file2, gotoData);
            } else {
                this.chooseFromAmbiguousSources(editor, file2, (Consumer<GotoData>)((Consumer)data -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/GotoTargetHandler", "lambda$invoke$0"));
                    }
                    if (editor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/GotoTargetHandler", "lambda$invoke$0"));
                    }
                    if (file2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/GotoTargetHandler", "lambda$invoke$0"));
                    }
                    this.show(project2, editor, file2, (GotoData)data);
                }));
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project2).showDumbModeNotification("Navigation is not available here during index update");
        }
    }

    protected void chooseFromAmbiguousSources(Editor editor, PsiFile file2, Consumer<GotoData> successCallback) {
    }

    @NonNls
    protected abstract String getFeatureUsedKey();

    @Nullable
    protected abstract GotoData getSourceAndTargetElements(Editor var1, PsiFile var2);

    private void show(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2, final @NotNull GotoData gotoData) {
        boolean finished2;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/GotoTargetHandler", "show"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/GotoTargetHandler", "show"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/GotoTargetHandler", "show"));
        }
        if (gotoData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gotoData", "com/intellij/codeInsight/navigation/GotoTargetHandler", "show"));
        }
        PsiElement[] targets = gotoData.targets;
        List<AdditionalAction> additionalActions = gotoData.additionalActions;
        if (targets.length == 0 && additionalActions.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, this.getNotFoundMessage(project2, editor, file2));
            return;
        }
        boolean bl = finished2 = gotoData.listUpdaterTask == null || gotoData.listUpdaterTask.isFinished();
        if (targets.length == 1 && additionalActions.isEmpty() && finished2) {
            this.navigateToElement(targets[0]);
            return;
        }
        for (PsiElement eachTarget : targets) {
            gotoData.renderers.put(eachTarget, GotoTargetHandler.createRenderer(gotoData, eachTarget));
        }
        String name2 = ((PsiNamedElement)gotoData.source).getName();
        String title = this.getChooserTitle(gotoData.source, name2, targets.length, finished2);
        if (this.shouldSortTargets()) {
            Arrays.sort(targets, this.createComparator(gotoData.renderers, gotoData));
        }
        ArrayList<AdditionalAction> allElements = new ArrayList<AdditionalAction>(targets.length + additionalActions.size());
        Collections.addAll(allElements, targets);
        allElements.addAll(additionalActions);
        JBList list2 = new JBList((ListModel)new CollectionListModel(allElements));
        HintUpdateSupply.installSimpleHintUpdateSupply((JComponent)list2);
        list2.setFont(EditorUtil.getEditorFont());
        list2.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                if (value2 == null) {
                    return super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                }
                if (value2 instanceof AdditionalAction) {
                    return GotoTargetHandler.this.myActionElementRenderer.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                }
                PsiElementListCellRenderer renderer = GotoTargetHandler.this.getRenderer(value2, gotoData.renderers, gotoData);
                return renderer.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
            }
        });
        Runnable runnable2 = () -> {
            Object[] selectedElements;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/GotoTargetHandler", "lambda$show$1"));
            }
            int[] ids = list2.getSelectedIndices();
            if (ids == null || ids.length == 0) {
                return;
            }
            for (Object element : selectedElements = list2.getSelectedValues()) {
                if (element instanceof AdditionalAction) {
                    ((AdditionalAction)element).execute();
                    continue;
                }
                Navigatable nav = element instanceof Navigatable ? (Navigatable)element : EditSourceUtil.getDescriptor((PsiElement)((PsiElement)element));
                try {
                    if (nav == null || !nav.canNavigate()) continue;
                    this.navigateToElement(nav);
                }
                catch (IndexNotReadyException e) {
                    DumbService.getInstance((Project)project2).showDumbModeNotification("Navigation is not available while indexing");
                }
            }
        };
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list2);
        builder.setFilteringEnabled(o -> {
            if (gotoData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gotoData", "com/intellij/codeInsight/navigation/GotoTargetHandler", "lambda$show$2"));
            }
            if (o instanceof AdditionalAction) {
                return ((AdditionalAction)o).getText();
            }
            return this.getRenderer(o, gotoData.renderers, gotoData).getElementText((PsiElement)o);
        });
        Ref usageView = new Ref();
        JBPopup popup = builder.setTitle(title).setItemChoosenCallback(runnable2).setMovable(true).setCancelCallback(() -> {
            if (gotoData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gotoData", "com/intellij/codeInsight/navigation/GotoTargetHandler", "lambda$show$3"));
            }
            HintUpdateSupply.hideHint((JComponent)list2);
            ListBackgroundUpdaterTask task = gotoData.listUpdaterTask;
            if (task != null) {
                task.cancelTask();
            }
            return true;
        }).setCouldPin(popup1 -> {
            if (gotoData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gotoData", "com/intellij/codeInsight/navigation/GotoTargetHandler", "lambda$show$4"));
            }
            usageView.set((Object)FindUtil.showInUsageView(gotoData.source, gotoData.targets, this.getFindUsagesTitle(gotoData.source, name2, gotoData.targets.length), gotoData.source.getProject()));
            popup1.cancel();
            return false;
        }).setAdText(this.getAdText(gotoData.source, targets.length)).createPopup();
        builder.getScrollPane().setBorder(null);
        builder.getScrollPane().setViewportBorder(null);
        if (gotoData.listUpdaterTask != null) {
            Alarm alarm = new Alarm((Disposable)popup);
            alarm.addRequest(() -> {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/GotoTargetHandler", "lambda$show$5"));
                }
                popup.showInBestPositionFor(editor);
            }, 300);
            gotoData.listUpdaterTask.init((AbstractPopup)popup, list2, (Ref<UsageView>)usageView);
            ProgressManager.getInstance().run((Task)gotoData.listUpdaterTask);
        } else {
            popup.showInBestPositionFor(editor);
        }
    }

    @NotNull
    private PsiElementListCellRenderer getRenderer(Object value2, Map<Object, PsiElementListCellRenderer> targetsWithRenderers, GotoData gotoData) {
        PsiElementListCellRenderer renderer = targetsWithRenderers.get(value2);
        if (renderer == null) {
            renderer = gotoData.getRenderer(value2);
        }
        PsiElementListCellRenderer psiElementListCellRenderer = renderer != null ? renderer : this.myDefaultTargetElementRenderer;
        if (psiElementListCellRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/GotoTargetHandler", "getRenderer"));
        }
        return psiElementListCellRenderer;
    }

    @NotNull
    protected Comparator<PsiElement> createComparator(final Map<Object, PsiElementListCellRenderer> targetsWithRenderers, final GotoData gotoData) {
        Comparator<PsiElement> comparator2 = new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement o1, PsiElement o2) {
                return this.getComparingObject(o1).compareTo(this.getComparingObject(o2));
            }

            private Comparable getComparingObject(PsiElement o1) {
                return GotoTargetHandler.this.getRenderer(o1, targetsWithRenderers, gotoData).getComparingObject(o1);
            }
        };
        if (comparator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/GotoTargetHandler", "createComparator"));
        }
        return comparator2;
    }

    public static PsiElementListCellRenderer createRenderer(@NotNull GotoData gotoData, @NotNull PsiElement eachTarget) {
        GotoTargetRendererProvider eachProvider;
        if (gotoData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gotoData", "com/intellij/codeInsight/navigation/GotoTargetHandler", "createRenderer"));
        }
        if (eachTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eachTarget", "com/intellij/codeInsight/navigation/GotoTargetHandler", "createRenderer"));
        }
        PsiElementListCellRenderer renderer = null;
        GotoTargetRendererProvider[] gotoTargetRendererProviderArray = (GotoTargetRendererProvider[])Extensions.getExtensions(GotoTargetRendererProvider.EP_NAME);
        int n = gotoTargetRendererProviderArray.length;
        for (int j = 0; j < n && (renderer = (eachProvider = gotoTargetRendererProviderArray[j]).getRenderer(eachTarget, gotoData)) == null; ++j) {
        }
        return renderer;
    }

    protected boolean navigateToElement(PsiElement target2) {
        Navigatable descriptor;
        Navigatable navigatable = descriptor = target2 instanceof Navigatable ? (Navigatable)target2 : EditSourceUtil.getDescriptor((PsiElement)target2);
        if (descriptor != null && descriptor.canNavigate()) {
            this.navigateToElement(descriptor);
            return true;
        }
        return false;
    }

    protected void navigateToElement(@NotNull Navigatable descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/navigation/GotoTargetHandler", "navigateToElement"));
        }
        descriptor.navigate(true);
    }

    protected boolean shouldSortTargets() {
        return true;
    }

    @Deprecated
    @NotNull
    protected String getChooserTitle(PsiElement sourceElement, String name2, int length) {
        LOG.warn("Please override getChooserTitle(PsiElement, String, int, boolean) instead");
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/GotoTargetHandler", "getChooserTitle"));
        }
        return "";
    }

    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, String name2, int length, boolean finished2) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/codeInsight/navigation/GotoTargetHandler", "getChooserTitle"));
        }
        String string = this.getChooserTitle(sourceElement, name2, length);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/GotoTargetHandler", "getChooserTitle"));
        }
        return string;
    }

    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name2, int length) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/codeInsight/navigation/GotoTargetHandler", "getFindUsagesTitle"));
        }
        String string = this.getChooserTitle(sourceElement, name2, length, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/GotoTargetHandler", "getFindUsagesTitle"));
        }
        return string;
    }

    @NotNull
    protected abstract String getNotFoundMessage(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiFile var3);

    @Nullable
    protected String getAdText(PsiElement source, int length) {
        return null;
    }

    private static class ActionCellRenderer
    extends DefaultListCellRenderer {
        private ActionCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            Component result2 = super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
            if (value2 != null) {
                AdditionalAction action = (AdditionalAction)value2;
                this.setText(action.getText());
                this.setIcon(action.getIcon());
            }
            return result2;
        }
    }

    private static class DefaultPsiElementListCellRenderer
    extends PsiElementListCellRenderer {
        private DefaultPsiElementListCellRenderer() {
        }

        public String getElementText(PsiElement element) {
            String name2;
            if (element instanceof PsiNamedElement && (name2 = ((PsiNamedElement)element).getName()) != null) {
                return name2;
            }
            return element.getContainingFile().getName();
        }

        protected String getContainerText(PsiElement element, String name2) {
            if (element instanceof NavigationItem) {
                ItemPresentation presentation = ((NavigationItem)element).getPresentation();
                return presentation != null ? presentation.getLocationString() : null;
            }
            return null;
        }

        @Override
        protected int getIconFlags() {
            return 0;
        }
    }

    public static class GotoData {
        @NotNull
        public final PsiElement source;
        public PsiElement[] targets;
        public final List<AdditionalAction> additionalActions;
        private boolean hasDifferentNames;
        public ListBackgroundUpdaterTask listUpdaterTask;
        protected final Set<String> myNames;
        public Map<Object, PsiElementListCellRenderer> renderers;

        public GotoData(@NotNull PsiElement source, @NotNull PsiElement[] targets, @NotNull List<AdditionalAction> additionalActions) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/navigation/GotoTargetHandler$GotoData", "<init>"));
            }
            if (targets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/codeInsight/navigation/GotoTargetHandler$GotoData", "<init>"));
            }
            if (additionalActions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalActions", "com/intellij/codeInsight/navigation/GotoTargetHandler$GotoData", "<init>"));
            }
            this.renderers = new HashMap<Object, PsiElementListCellRenderer>();
            this.source = source;
            this.targets = targets;
            this.additionalActions = additionalActions;
            this.myNames = new HashSet();
            for (PsiElement target2 : targets) {
                if (!(target2 instanceof PsiNamedElement)) continue;
                this.myNames.add(((PsiNamedElement)target2).getName());
                if (this.myNames.size() > 1) break;
            }
            this.hasDifferentNames = this.myNames.size() > 1;
        }

        public boolean hasDifferentNames() {
            return this.hasDifferentNames;
        }

        public boolean addTarget(PsiElement element) {
            if (ArrayUtil.find((Object[])this.targets, (Object)element) > -1) {
                return false;
            }
            this.targets = (PsiElement[])ArrayUtil.append((Object[])this.targets, (Object)element);
            this.renderers.put(element, GotoTargetHandler.createRenderer(this, element));
            if (!this.hasDifferentNames && element instanceof PsiNamedElement) {
                String name2 = (String)ReadAction.compute(() -> ((PsiNamedElement)element).getName());
                this.myNames.add(name2);
                this.hasDifferentNames = this.myNames.size() > 1;
            }
            return true;
        }

        public PsiElementListCellRenderer getRenderer(Object value2) {
            return this.renderers.get(value2);
        }
    }

    public static interface AdditionalAction {
        @NotNull
        public String getText();

        public Icon getIcon();

        public void execute();
    }
}

