/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.preview.PreviewHintComponent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.reference.SoftReference;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImagePreviewComponent
extends JPanel
implements PreviewHintComponent {
    private static final Key<Long> TIMESTAMP_KEY = Key.create((String)"Image.timeStamp");
    private static final Key<SoftReference<BufferedImage>> BUFFERED_IMAGE_REF_KEY = Key.create((String)"Image.bufferedImage");
    private static final List<String> supportedExtensions = Arrays.asList(ImageIO.getReaderFormatNames());
    @NotNull
    private final BufferedImage myImage;

    private ImagePreviewComponent(@NotNull BufferedImage image, long imageFileSize) {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/intellij/codeInsight/preview/ImagePreviewComponent", "<init>"));
        }
        this.setLayout(new BorderLayout());
        this.myImage = image;
        this.add((Component)new ImageComp(), "Center");
        this.add((Component)ImagePreviewComponent.createLabel(image, imageFileSize), "South");
        this.setBackground(UIUtil.getToolTipBackground());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder((Color)JBColor.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
    }

    @Override
    public boolean isEqualTo(@Nullable PreviewHintComponent other) {
        if (!(other instanceof ImagePreviewComponent)) {
            return false;
        }
        ImagePreviewComponent otherPreview = (ImagePreviewComponent)other;
        if (this.myImage.getWidth() == otherPreview.myImage.getWidth() && this.myImage.getHeight() == otherPreview.myImage.getHeight()) {
            for (int x = 0; x < this.myImage.getWidth(); ++x) {
                for (int y = 0; y < this.myImage.getHeight(); ++y) {
                    if (this.myImage.getRGB(x, y) == otherPreview.myImage.getRGB(x, y)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    private static JLabel createLabel(@NotNull BufferedImage image, long imageFileSize) {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/intellij/codeInsight/preview/ImagePreviewComponent", "createLabel"));
        }
        int width = image.getWidth();
        int height = image.getHeight();
        ColorModel colorModel = image.getColorModel();
        int i2 = colorModel.getPixelSize();
        JLabel jLabel = new JLabel(String.format("%dx%d, %dbpp, %s", width, height, i2, StringUtil.formatFileSize((long)imageFileSize)));
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/preview/ImagePreviewComponent", "createLabel"));
        }
        return jLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean refresh(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/preview/ImagePreviewComponent", "refresh"));
        }
        Long loadedTimeStamp = (Long)file2.getUserData(TIMESTAMP_KEY);
        SoftReference imageRef = (SoftReference)file2.getUserData(BUFFERED_IMAGE_REF_KEY);
        if (loadedTimeStamp == null || loadedTimeStamp < file2.getTimeStamp() || SoftReference.dereference((Reference)imageRef) == null) {
            try {
                byte[] content = file2.contentsToByteArray();
                BufferedImage image = ImagePreviewComponent.readImageFromBytes(content);
                file2.putUserData(BUFFERED_IMAGE_REF_KEY, (Object)new SoftReference((Object)image));
                boolean bl = true;
                return bl;
            }
            finally {
                file2.putUserData(TIMESTAMP_KEY, (Object)System.currentTimeMillis());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static BufferedImage readImageFromBytes(@NotNull byte[] content) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/codeInsight/preview/ImagePreviewComponent", "readImageFromBytes"));
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content, 0, content.length);
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageInputStream);
        if (!imageReaders.hasNext()) throw new IOException("Can't read image from given content");
        ImageReader imageReader = imageReaders.next();
        ImageReadParam param = imageReader.getDefaultReadParam();
        imageReader.setInput(imageInputStream, true, true);
        int minIndex = imageReader.getMinIndex();
        BufferedImage bufferedImage = imageReader.read(minIndex, param);
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage2 != null) return bufferedImage2;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/preview/ImagePreviewComponent", "readImageFromBytes"));
        {
            catch (Exception e) {
                throw new IOException("Can't read image from given content", e);
            }
            finally {
                imageReader.dispose();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            imageInputStream.close();
        }
    }

    public static JComponent getPreviewComponent(@Nullable PsiElement parent) {
        PsiReference[] references;
        if (parent == null) {
            return null;
        }
        for (PsiReference reference : references = parent.getReferences()) {
            VirtualFile file2;
            PsiFileSystemItem item;
            PsiElement fileItem = reference.resolve();
            if (!(fileItem instanceof PsiFileSystemItem) || (item = (PsiFileSystemItem)fileItem).isDirectory() || (file2 = item.getVirtualFile()) == null || !supportedExtensions.contains(file2.getExtension())) continue;
            try {
                ImagePreviewComponent.refresh(file2);
                SoftReference imageRef = (SoftReference)file2.getUserData(BUFFERED_IMAGE_REF_KEY);
                BufferedImage image = (BufferedImage)SoftReference.dereference((Reference)imageRef);
                if (image == null) continue;
                return new ImagePreviewComponent(image, file2.getLength());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ImagePreviewComponent getPreviewComponent(@NotNull BufferedImage image, long imageFileSize) {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/intellij/codeInsight/preview/ImagePreviewComponent", "getPreviewComponent"));
        }
        return new ImagePreviewComponent(image, imageFileSize);
    }

    private class ImageComp
    extends JComponent {
        private final Dimension myPreferredSize;

        private ImageComp() {
            if (ImagePreviewComponent.this.myImage.getWidth() > 300 || ImagePreviewComponent.this.myImage.getHeight() > 300) {
                float factor = 300.0f / (float)Math.max(ImagePreviewComponent.this.myImage.getWidth(), ImagePreviewComponent.this.myImage.getHeight());
                this.myPreferredSize = new Dimension((int)((float)ImagePreviewComponent.this.myImage.getWidth() * factor), (int)((float)ImagePreviewComponent.this.myImage.getHeight() * factor));
            } else {
                this.myPreferredSize = new Dimension(ImagePreviewComponent.this.myImage.getWidth(), ImagePreviewComponent.this.myImage.getHeight());
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Rectangle r = this.getBounds();
            int width = ImagePreviewComponent.this.myImage.getWidth();
            int height = ImagePreviewComponent.this.myImage.getHeight();
            g.drawImage(ImagePreviewComponent.this.myImage, 0, 0, r.width > width ? width : r.width, r.height > height ? height : r.height, this);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.myPreferredSize;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

