/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.tokens;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateToken
extends ZenCodingToken {
    public static final String ATTRS = "ATTRS";
    public static final TemplateToken EMPTY_TEMPLATE_TOKEN = new TemplateToken("", Collections.emptyMap());
    @NotNull
    private final String myKey;
    private TemplateImpl myTemplate;
    @NotNull
    private final Map<String, String> myAttributes;
    private PsiFile myFile;

    public TemplateToken(@NotNull String key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "<init>"));
        }
        this(key2, Collections.emptyMap());
    }

    public TemplateToken(@NotNull String key2, @NotNull Map<String, String> attribute2value) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "<init>"));
        }
        if (attribute2value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute2value", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "<init>"));
        }
        this.myKey = key2;
        this.myAttributes = attribute2value;
    }

    @NotNull
    public Map<String, String> getAttributes() {
        Map<String, String> map2 = this.myAttributes;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "getAttributes"));
        }
        return map2;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public String getTemplateText() {
        return this.myFile.getText();
    }

    private void setFile(PsiFile file2) {
        this.myFile = file2;
    }

    @Nullable
    public XmlTag getXmlTag() {
        return (XmlTag)PsiTreeUtil.findChildOfType((PsiElement)this.myFile, XmlTag.class);
    }

    public void setTemplateText(@NotNull String templateText, @NotNull CustomTemplateCallback callback) {
        if (templateText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateText", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "setTemplateText"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "setTemplateText"));
        }
        PsiFile file2 = PsiFileFactory.getInstance((Project)callback.getProject()).createFileFromText("dummy.html", callback.getFile().getLanguage(), (CharSequence)templateText, true, true);
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        this.setFile(file2);
    }

    @NotNull
    public String getKey() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "getKey"));
        }
        return string;
    }

    public void setTemplate(@NotNull TemplateImpl template, @NotNull CustomTemplateCallback callback) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "setTemplate"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "setTemplate"));
        }
        this.myTemplate = template;
        this.setTemplateText(TemplateToken.createTemplateText(template, callback, this.getAttributes()), callback);
    }

    private static boolean containsAttrsVar(@NotNull TemplateImpl template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "containsAttrsVar"));
        }
        for (int i2 = 0; i2 < template.getVariableCount(); ++i2) {
            String varName = template.getVariableNameAt(i2);
            if (!ATTRS.equals(varName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String createTemplateText(@NotNull TemplateImpl template, @NotNull CustomTemplateCallback callback, @NotNull Map<String, String> attributes) {
        PsiFile dummyFile;
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "createTemplateText"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "createTemplateText"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "createTemplateText"));
        }
        XmlTag dummyRootTag = null;
        String templateString = template.getString();
        if (!TemplateToken.containsAttrsVar(template) && (dummyRootTag = (XmlTag)PsiTreeUtil.findChildOfType((PsiElement)(dummyFile = PsiFileFactory.getInstance((Project)callback.getProject()).createFileFromText("dummy.html", callback.getFile().getLanguage(), (CharSequence)templateString, false, true)), XmlTag.class)) != null && !attributes.isEmpty()) {
            TemplateToken.addMissingAttributes(dummyRootTag, attributes);
        }
        String string = dummyRootTag != null ? dummyRootTag.getContainingFile().getText() : templateString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "createTemplateText"));
        }
        return string;
    }

    private static void addMissingAttributes(@NotNull XmlTag tag, @NotNull Map<String, String> attributes) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "addMissingAttributes"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "addMissingAttributes"));
        }
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            XmlTag htmlTag;
            XmlAttribute newAttribute;
            if ("%default".equals(attribute.getKey()) || tag.getAttribute(attribute.getKey()) != null || (newAttribute = (XmlAttribute)ArrayUtil.getFirstElement((Object[])(htmlTag = XmlElementFactory.getInstance((Project)tag.getProject()).createHTMLTagFromText("<dummy " + attribute.getKey() + "=\"\"/>")).getAttributes())) == null) continue;
            tag.add((PsiElement)newAttribute);
        }
    }

    @Nullable
    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    @NotNull
    public String toString() {
        if ("TEMPLATE" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/tokens/TemplateToken", "toString"));
        }
        return "TEMPLATE";
    }
}

