/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.impl.LiveTemplateSettingsEditor;
import com.intellij.codeInsight.template.impl.LiveTemplateTree;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateExpandShortcutPanel;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.CompoundScheme;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateListPanel
extends JPanel
implements Disposable {
    private static final String NO_SELECTION = "NoSelection";
    private static final String TEMPLATE_SETTINGS = "TemplateSettings";
    private static final TemplateImpl MOCK_TEMPLATE = new TemplateImpl("mockTemplate-xxx", "mockTemplateGroup-yyy");
    public static final String ABBREVIATION = "<abbreviation>";
    public static final Comparator<TemplateImpl> TEMPLATE_COMPARATOR = (o1, o2) -> {
        int compareKey = o1.getKey().compareToIgnoreCase(o2.getKey());
        return compareKey != 0 ? compareKey : o1.getGroupName().compareToIgnoreCase(o2.getGroupName());
    };
    private CheckboxTree myTree;
    private final List<TemplateGroup> myTemplateGroups = new ArrayList<TemplateGroup>();
    private final TemplateExpandShortcutPanel myExpandByDefaultPanel = new TemplateExpandShortcutPanel(CodeInsightBundle.message((String)"templates.dialog.shortcut.chooser.label", (Object[])new Object[0]));
    private CheckedTreeNode myTreeRoot = new CheckedTreeNode(null);
    private final Alarm myAlarm = new Alarm();
    private boolean myUpdateNeeded = false;
    private static final Logger LOG;
    private final Map<TemplateImpl, Map<TemplateOptionalProcessor, Boolean>> myTemplateOptions = ContainerUtil.newIdentityHashMap();
    private final Map<TemplateImpl, TemplateContext> myTemplateContext = ContainerUtil.newIdentityHashMap();
    private final JPanel myDetailsPanel = new JPanel(new CardLayout());
    private LiveTemplateSettingsEditor myCurrentTemplateEditor;
    private final JLabel myEmptyCardLabel = new JLabel();
    private final CompoundScheme.MutatorHelper<TemplateGroup, TemplateImpl> mutatorHelper = new CompoundScheme.MutatorHelper();
    private final boolean isTest = ApplicationManager.getApplication().isUnitTestMode();

    public TemplateListPanel() {
        super(new BorderLayout());
        this.myDetailsPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.myEmptyCardLabel.setHorizontalAlignment(0);
        this.myDetailsPanel.add((Component)this.myEmptyCardLabel, NO_SELECTION);
        this.createTemplateEditor(MOCK_TEMPLATE, "Tab", MOCK_TEMPLATE.createOptions(), MOCK_TEMPLATE.createContext());
        this.add((Component)this.myExpandByDefaultPanel, "North");
        Splitter splitter = new Splitter(true, 0.9f);
        splitter.setFirstComponent((JComponent)this.createTable());
        splitter.setSecondComponent((JComponent)this.myDetailsPanel);
        this.add((Component)splitter, "Center");
    }

    public void dispose() {
        this.myCurrentTemplateEditor.dispose();
        this.myAlarm.cancelAllRequests();
    }

    public void reset() {
        this.myTemplateOptions.clear();
        this.myTemplateContext.clear();
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        List<TemplateGroup> groups = TemplateListPanel.getSortedGroups(templateSettings);
        this.initTemplates(groups, templateSettings.getLastSelectedTemplateGroup(), templateSettings.getLastSelectedTemplateKey());
        this.myExpandByDefaultPanel.setSelectedChar(templateSettings.getDefaultShortcutChar());
        UiNotifyConnector.doWhenFirstShown((JComponent)this, () -> this.updateTemplateDetails(false, false));
        this.myUpdateNeeded = true;
    }

    @NotNull
    private static List<TemplateGroup> getSortedGroups(TemplateSettings templateSettings) {
        ArrayList<TemplateGroup> groups = new ArrayList<TemplateGroup>(templateSettings.getTemplateGroups());
        Collections.sort(groups, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        ArrayList<TemplateGroup> arrayList = groups;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateListPanel", "getSortedGroups"));
        }
        return arrayList;
    }

    public void apply() throws ConfigurationException {
        List<TemplateGroup> templateGroups = this.getTemplateGroups();
        for (TemplateGroup templateGroup : templateGroups) {
            HashSet names = ContainerUtil.newHashSet();
            List templates = templateGroup.getElements();
            for (TemplateImpl template : templates) {
                if (StringUtil.isEmptyOrSpaces((String)template.getKey())) {
                    throw new ConfigurationException("A live template with an empty key has been found in " + templateGroup.getName() + " group, such live templates cannot be invoked");
                }
                if (StringUtil.isEmptyOrSpaces((String)template.getString())) {
                    throw new ConfigurationException("A live template with an empty text has been found in " + templateGroup.getName() + " group, such live templates cannot be invoked");
                }
                if (names.add(template.getKey())) continue;
                throw new ConfigurationException("Duplicate " + template.getKey() + " live templates in " + templateGroup.getName() + " group");
            }
        }
        for (TemplateGroup templateGroup : templateGroups) {
            for (TemplateImpl template : templateGroup.getElements()) {
                template.applyOptions(this.getTemplateOptions(template));
                template.applyContext(this.getTemplateContext(template));
            }
        }
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        templateSettings.setTemplates(this.mutatorHelper.apply(templateGroups, (original, copied) -> {
            List copiedElements;
            if (original.isModified()) {
                return;
            }
            List originalElements = original.getElements();
            if (!originalElements.equals(copiedElements = copied.getElements())) {
                original.setModified(true);
            } else {
                for (int i2 = 0; i2 < originalElements.size(); ++i2) {
                    if (((TemplateImpl)originalElements.get(i2)).getTemplateContext().getDifference(((TemplateImpl)copiedElements.get(i2)).getTemplateContext()) == null) continue;
                    original.setModified(true);
                    break;
                }
            }
        }));
        templateSettings.setDefaultShortcutChar(this.myExpandByDefaultPanel.getSelectedChar());
    }

    public boolean isModified() {
        List<TemplateImpl> newGroup;
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        if (templateSettings.getDefaultShortcutChar() != this.myExpandByDefaultPanel.getSelectedChar()) {
            if (this.isTest) {
                System.err.println("LiveTemplatesConfig: templateSettings.getDefaultShortcutChar()=" + templateSettings.getDefaultShortcutChar() + "; myExpandByDefaultComponent.getSelectedChar()=" + this.myExpandByDefaultPanel.getSelectedChar());
            }
            return true;
        }
        List<TemplateGroup> originalGroups = TemplateListPanel.getSortedGroups(templateSettings);
        List<TemplateGroup> newGroups = this.getTemplateGroups();
        if (!ContainerUtil.map2Set(originalGroups, CompoundScheme::getName).equals(ContainerUtil.map2Set(newGroups, CompoundScheme::getName))) {
            return true;
        }
        List<TemplateImpl> originalGroup = TemplateListPanel.collectTemplates(originalGroups);
        String msg = this.checkAreEqual(originalGroup, newGroup = TemplateListPanel.collectTemplates(newGroups));
        if (msg == null) {
            return false;
        }
        if (this.isTest) {
            System.err.println("LiveTemplatesConfig: " + msg);
        }
        return true;
    }

    public void editTemplate(TemplateImpl template) {
        this.selectTemplate(template.getGroupName(), template.getKey());
        this.updateTemplateDetails(true, false);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.getTemplate(this.getSingleSelectedIndex()) != null) {
            return this.myCurrentTemplateEditor.getKeyField();
        }
        return null;
    }

    private static List<TemplateImpl> collectTemplates(@NotNull List<TemplateGroup> groups) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/codeInsight/template/impl/TemplateListPanel", "collectTemplates"));
        }
        ArrayList<TemplateImpl> result2 = new ArrayList<TemplateImpl>();
        for (TemplateGroup group : groups) {
            result2.addAll(group.getElements());
        }
        Collections.sort(result2, (o1, o2) -> {
            int groupsEqual = o1.getGroupName().compareToIgnoreCase(o2.getGroupName());
            if (groupsEqual != 0) {
                return groupsEqual;
            }
            return o1.getKey().compareToIgnoreCase(o2.getKey());
        });
        return result2;
    }

    private String checkAreEqual(@NotNull List<TemplateImpl> originalGroup, @NotNull List<TemplateImpl> newGroup) {
        if (originalGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalGroup", "com/intellij/codeInsight/template/impl/TemplateListPanel", "checkAreEqual"));
        }
        if (newGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newGroup", "com/intellij/codeInsight/template/impl/TemplateListPanel", "checkAreEqual"));
        }
        if (originalGroup.size() != newGroup.size()) {
            return "different sizes";
        }
        for (int i2 = 0; i2 < newGroup.size(); ++i2) {
            TemplateImpl t2;
            TemplateImpl t1 = newGroup.get(i2);
            if (!this.templatesDiffer(t1, t2 = originalGroup.get(i2))) continue;
            if (this.isTest) {
                return "Templates differ: new=" + t1 + "; original=" + t2 + "; equals=" + t1.equals(t2) + "; vars=" + t1.getVariables().equals(t2.getVariables()) + "; options=" + this.areOptionsEqual(t1, t2) + "; diff=" + this.getTemplateContext(t1).getDifference(t2.getTemplateContext()) + "\ncontext1=" + this.getTemplateContext(t1) + "\ncontext2=" + this.getTemplateContext(t2);
            }
            return "templates differ";
        }
        return null;
    }

    private boolean areOptionsEqual(@NotNull TemplateImpl newTemplate, @NotNull TemplateImpl originalTemplate) {
        if (newTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTemplate", "com/intellij/codeInsight/template/impl/TemplateListPanel", "areOptionsEqual"));
        }
        if (originalTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalTemplate", "com/intellij/codeInsight/template/impl/TemplateListPanel", "areOptionsEqual"));
        }
        Map<TemplateOptionalProcessor, Boolean> templateOptions = this.getTemplateOptions(newTemplate);
        for (TemplateOptionalProcessor processor2 : templateOptions.keySet()) {
            if (processor2.isEnabled(originalTemplate) == templateOptions.get(processor2).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private TemplateContext getTemplateContext(TemplateImpl newTemplate) {
        return this.myTemplateContext.get(newTemplate);
    }

    private Map<TemplateOptionalProcessor, Boolean> getTemplateOptions(@NotNull TemplateImpl newTemplate) {
        if (newTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTemplate", "com/intellij/codeInsight/template/impl/TemplateListPanel", "getTemplateOptions"));
        }
        return this.myTemplateOptions.get(newTemplate);
    }

    private List<TemplateGroup> getTemplateGroups() {
        return this.myTemplateGroups;
    }

    private void createTemplateEditor(TemplateImpl template, String shortcut, Map<TemplateOptionalProcessor, Boolean> options, TemplateContext context) {
        this.myCurrentTemplateEditor = new LiveTemplateSettingsEditor(template, shortcut, options, context, () -> {
            DefaultMutableTreeNode node = this.getNode(this.getSingleSelectedIndex());
            if (node != null) {
                ((DefaultTreeModel)this.myTree.getModel()).nodeChanged(node);
                TemplateSettings.getInstance().setLastSelectedTemplate(template.getGroupName(), template.getKey());
            }
        }, TemplateSettings.getInstance().getTemplate(template.getKey(), template.getGroupName()) != null);
        for (Component component : this.myDetailsPanel.getComponents()) {
            if (!(component instanceof LiveTemplateSettingsEditor)) continue;
            this.myDetailsPanel.remove(component);
        }
        this.myDetailsPanel.add((Component)this.myCurrentTemplateEditor, TEMPLATE_SETTINGS);
    }

    @Nullable
    private TemplateImpl getTemplate(int row) {
        DefaultMutableTreeNode node;
        CheckboxTree tree = this.myTree;
        TreePath path = ((JTree)((Object)tree)).getPathForRow(row);
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof TemplateImpl) {
            return (TemplateImpl)node.getUserObject();
        }
        return null;
    }

    @Nullable
    private TemplateGroup getGroup(int row) {
        DefaultMutableTreeNode node;
        TreePath path = this.myTree.getPathForRow(row);
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof TemplateGroup) {
            return (TemplateGroup)node.getUserObject();
        }
        return null;
    }

    private void moveTemplates(Map<TemplateImpl, DefaultMutableTreeNode> map2, @NotNull String newGroupName) {
        if (newGroupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newGroupName", "com/intellij/codeInsight/template/impl/TemplateListPanel", "moveTemplates"));
        }
        ArrayList<TreePath> toSelect2 = new ArrayList<TreePath>();
        for (TemplateImpl template : map2.keySet()) {
            DefaultMutableTreeNode oldTemplateNode = map2.get(template);
            TemplateGroup oldGroup = this.getTemplateGroup(template.getGroupName());
            if (oldGroup != null) {
                oldGroup.removeElement(template);
            }
            template.setGroupName(newGroupName);
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)oldTemplateNode.getParent();
            this.removeNodeFromParent(oldTemplateNode);
            if (parent.getChildCount() == 0) {
                this.removeNodeFromParent(parent);
            }
            toSelect2.add(new TreePath(this.registerTemplate(template).getPath()));
        }
        this.myTree.getSelectionModel().clearSelection();
        for (TreePath path : toSelect2) {
            this.myTree.expandPath(path.getParentPath());
            this.myTree.addSelectionPath(path);
            this.myTree.scrollRowToVisible(this.myTree.getRowForPath(path));
        }
    }

    @Nullable
    private DefaultMutableTreeNode getNode(int row) {
        CheckboxTree tree = this.myTree;
        TreePath path = ((JTree)((Object)tree)).getPathForRow(row);
        if (path != null) {
            return (DefaultMutableTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    @Nullable
    private TemplateGroup getTemplateGroup(String groupName) {
        for (TemplateGroup group : this.myTemplateGroups) {
            if (!group.getName().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    private void addTemplate() {
        String defaultGroup = "user";
        DefaultMutableTreeNode node = this.getNode(this.getSingleSelectedIndex());
        if (node != null) {
            if (node.getUserObject() instanceof TemplateImpl) {
                defaultGroup = ((TemplateImpl)node.getUserObject()).getGroupName();
            } else if (node.getUserObject() instanceof TemplateGroup) {
                defaultGroup = ((TemplateGroup)node.getUserObject()).getName();
            }
        }
        this.addTemplate(new TemplateImpl(ABBREVIATION, "", defaultGroup));
    }

    public void addTemplate(TemplateImpl template) {
        this.myTemplateOptions.put(template, template.createOptions());
        this.myTemplateContext.put(template, template.createContext());
        this.registerTemplate(template);
        this.updateTemplateDetails(true, false);
    }

    private void copyRow() {
        int selected = this.getSingleSelectedIndex();
        if (selected < 0) {
            return;
        }
        TemplateImpl orTemplate = this.getTemplate(selected);
        LOG.assertTrue(orTemplate != null);
        TemplateImpl template = orTemplate.copy();
        template.setKey(ABBREVIATION);
        this.myTemplateOptions.put(template, new HashMap<TemplateOptionalProcessor, Boolean>(this.getTemplateOptions(orTemplate)));
        this.myTemplateContext.put(template, this.getTemplateContext(orTemplate).createCopy());
        this.registerTemplate(template);
        this.updateTemplateDetails(true, false);
    }

    private int getSingleSelectedIndex() {
        int[] rows = this.myTree.getSelectionRows();
        return rows != null && rows.length == 1 ? rows[0] : -1;
    }

    private void removeRows() {
        TreeNode toSelect2 = null;
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (TreePath path : paths) {
            TemplateImpl template;
            TemplateGroup templateGroup;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object o = node.getUserObject();
            if (o instanceof TemplateGroup) {
                this.myTemplateGroups.remove(o);
                this.removeNodeFromParent(node);
                continue;
            }
            if (!(o instanceof TemplateImpl) || (templateGroup = this.getTemplateGroup((template = (TemplateImpl)o).getGroupName())) == null) continue;
            templateGroup.removeElement(template);
            toSelect2 = ((DefaultMutableTreeNode)node.getParent()).getChildAfter(node);
            this.removeNodeFromParent(node);
        }
        if (toSelect2 instanceof DefaultMutableTreeNode) {
            this.setSelectedNode((DefaultMutableTreeNode)toSelect2);
        }
    }

    private JPanel createTable() {
        this.myTreeRoot = new CheckedTreeNode(null);
        this.myTree = new LiveTemplateTree(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value2 instanceof DefaultMutableTreeNode)) {
                    return;
                }
                if ((value2 = ((DefaultMutableTreeNode)value2).getUserObject()) instanceof TemplateImpl) {
                    TemplateImpl template = (TemplateImpl)value2;
                    TemplateImpl defaultTemplate = TemplateSettings.getInstance().getDefaultTemplate(template);
                    JBColor fgColor = defaultTemplate != null && TemplateListPanel.this.templatesDiffer(template, defaultTemplate) ? JBColor.BLUE : null;
                    this.getTextRenderer().append(template.getKey(), new SimpleTextAttributes(0, (Color)fgColor));
                    String description = template.getDescription();
                    if (StringUtil.isNotEmpty((String)description)) {
                        this.getTextRenderer().append(" (" + description + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                } else if (value2 instanceof TemplateGroup) {
                    this.getTextRenderer().append(((TemplateGroup)value2).getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
            }
        }, this.myTreeRoot, this);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$2", "valueChanged"));
                }
                TemplateSettings templateSettings = TemplateSettings.getInstance();
                TemplateImpl template = TemplateListPanel.this.getTemplate(TemplateListPanel.this.getSingleSelectedIndex());
                if (template != null) {
                    templateSettings.setLastSelectedTemplate(template.getGroupName(), template.getKey());
                } else {
                    templateSettings.setLastSelectedTemplate(null, null);
                    TemplateListPanel.this.showEmptyCard();
                }
                if (TemplateListPanel.this.myUpdateNeeded) {
                    TemplateListPanel.this.myAlarm.cancelAllRequests();
                    TemplateListPanel.this.myAlarm.addRequest(() -> TemplateListPanel.this.updateTemplateDetails(false, false), 100);
                }
            }
        });
        this.myTree.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@Nullable ActionEvent event) {
                TemplateListPanel.this.myCurrentTemplateEditor.focusKey();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.installPopup();
        DnDSupport.createBuilder((JComponent)((Object)this.myTree)).setBeanProvider((Function)((NullableFunction)dnDActionInfo -> {
            Point point = dnDActionInfo.getPoint();
            if (this.myTree.getPathForLocation(point.x, point.y) == null) {
                return null;
            }
            Map<TemplateImpl, DefaultMutableTreeNode> templates = this.getSelectedTemplates();
            return !templates.isEmpty() ? new DnDDragStartBean(templates) : null;
        })).setDisposableParent((Disposable)this).setTargetChecker(new DnDTargetChecker(){

            public boolean update(DnDEvent event) {
                Set oldGroupNames = TemplateListPanel.getAllGroups((Map)event.getAttachedObject());
                TemplateGroup group = TemplateListPanel.this.getDropGroup(event);
                boolean differentGroup = group != null && !oldGroupNames.contains(group.getName());
                event.setDropPossible(differentGroup, "");
                return true;
            }
        }).setDropHandler(new DnDDropHandler(){

            public void drop(DnDEvent event) {
                TemplateListPanel.this.moveTemplates((Map)event.getAttachedObject(), ((TemplateGroup)ObjectUtils.assertNotNull((Object)TemplateListPanel.this.getDropGroup(event))).getName());
            }
        }).setImageProvider((Function)((NullableFunction)dnDActionInfo -> {
            Point point = dnDActionInfo.getPoint();
            TreePath path = this.myTree.getPathForLocation(point.x, point.y);
            return path == null ? null : new DnDImage((Image)DnDAwareTree.getDragImage((Tree)this.myTree, (TreePath)path, (Point)point).first);
        })).install();
        if (this.myTemplateGroups.size() > 0) {
            this.myTree.setSelectionInterval(0, 0);
        }
        return this.initToolbar().createPanel();
    }

    private void showEmptyCard() {
        int[] rows = this.myTree.getSelectionRows();
        boolean multiSelection = rows != null && rows.length > 1;
        this.myEmptyCardLabel.setText(multiSelection ? "Multiple live templates are selected" : "No live templates are selected");
        ((CardLayout)this.myDetailsPanel.getLayout()).show(this.myDetailsPanel, NO_SELECTION);
    }

    private boolean templatesDiffer(@NotNull TemplateImpl template, @NotNull TemplateImpl defaultTemplate) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/impl/TemplateListPanel", "templatesDiffer"));
        }
        if (defaultTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultTemplate", "com/intellij/codeInsight/template/impl/TemplateListPanel", "templatesDiffer"));
        }
        template.parseSegments();
        defaultTemplate.parseSegments();
        return !template.equals(defaultTemplate) || !template.getVariables().equals(defaultTemplate.getVariables()) || !this.areOptionsEqual(template, defaultTemplate) || this.getTemplateContext(template).getDifference(defaultTemplate.getTemplateContext()) != null;
    }

    private ToolbarDecorator initToolbar() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)this.myTree)).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TemplateListPanel.this.addTemplateOrGroup(button);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TemplateListPanel.this.removeRows();
            }
        }).disableDownAction().disableUpAction().addExtraAction(new AnActionButton("Duplicate", PlatformIcons.COPY_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$7", "actionPerformed"));
                }
                TemplateListPanel.this.copyRow();
            }

            public void updateButton(AnActionEvent e) {
                e.getPresentation().setEnabled(TemplateListPanel.this.getTemplate(TemplateListPanel.this.getSingleSelectedIndex()) != null);
            }
        }).addExtraAction(new AnActionButton("Restore deleted defaults", AllIcons.General.TodoDefault){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$6", "actionPerformed"));
                }
                TemplateSettings.getInstance().reset();
                TemplateListPanel.this.reset();
            }

            public boolean isEnabled() {
                return super.isEnabled() && !TemplateSettings.getInstance().getDeletedTemplates().isEmpty();
            }
        });
        return decorator.setToolbarPosition(ActionToolbarPosition.RIGHT);
    }

    private void addTemplateOrGroup(AnActionButton button) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new DumbAwareAction("Live Template"){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$10", "actionPerformed"));
                }
                TemplateListPanel.this.addTemplate();
            }
        });
        group.add((AnAction)new DumbAwareAction("Template Group..."){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$11", "actionPerformed"));
                }
                String newName = Messages.showInputDialog((Component)((Object)TemplateListPanel.this.myTree), (String)"Enter the new group name:", (String)"Create New Group", null, (String)"", (InputValidator)new TemplateGroupInputValidator(null));
                if (newName != null) {
                    TemplateGroup newGroup = new TemplateGroup(newName);
                    TemplateListPanel.this.setSelectedNode(TemplateListPanel.this.insertNewGroup(newGroup));
                }
            }
        });
        DataContext context = DataManager.getInstance().getDataContext((Component)button.getContextComponent());
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true, null);
        popup.show(button.getPreferredPopupPoint());
    }

    @Nullable
    private TemplateGroup getDropGroup(DnDEvent event) {
        Point point = event.getPointOn((Component)((Object)this.myTree));
        return this.getGroup(this.myTree.getRowForLocation(point.x, point.y));
    }

    private void installPopup() {
        final DumbAwareAction rename = new DumbAwareAction("Rename"){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$12", "update"));
                }
                TemplateGroup templateGroup = TemplateListPanel.this.getSingleSelectedGroup();
                boolean enabled = templateGroup != null;
                e.getPresentation().setEnabled(enabled);
                e.getPresentation().setVisible(enabled);
                super.update(e);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$12", "actionPerformed"));
                }
                TemplateListPanel.this.renameGroup();
            }
        };
        rename.registerCustomShortcutSet(ActionManager.getInstance().getAction("RenameElement").getShortcutSet(), (JComponent)((Object)this.myTree));
        final DefaultActionGroup move = new DefaultActionGroup("Move", true){

            public void update(AnActionEvent e) {
                final Map<TemplateImpl, DefaultMutableTreeNode> templates = TemplateListPanel.this.getSelectedTemplates();
                boolean enabled = !templates.isEmpty();
                e.getPresentation().setEnabled(enabled);
                e.getPresentation().setVisible(enabled);
                if (enabled) {
                    Set oldGroups = TemplateListPanel.getAllGroups(templates);
                    this.removeAll();
                    for (TemplateGroup group : TemplateListPanel.this.getTemplateGroups()) {
                        final String newGroupName = group.getName();
                        if (oldGroups.contains(newGroupName)) continue;
                        this.add((AnAction)new DumbAwareAction(newGroupName){

                            public void actionPerformed(@NotNull AnActionEvent e) {
                                if (e == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$13$1", "actionPerformed"));
                                }
                                TemplateListPanel.this.moveTemplates(templates, newGroupName);
                            }
                        });
                    }
                    this.addSeparator();
                    this.add((AnAction)new DumbAwareAction("New group..."){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$13$2", "actionPerformed"));
                            }
                            String newName = Messages.showInputDialog((Component)((Object)TemplateListPanel.this.myTree), (String)"Enter the new group name:", (String)"Move to a New Group", null, (String)"", (InputValidator)new TemplateGroupInputValidator(null));
                            if (newName != null) {
                                TemplateListPanel.this.moveTemplates(templates, newName);
                            }
                        }
                    });
                }
            }
        };
        final DumbAwareAction changeContext = new DumbAwareAction("Change context..."){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$14", "update"));
                }
                boolean enabled = !TemplateListPanel.this.getSelectedTemplates().isEmpty();
                e.getPresentation().setEnabled(enabled);
                super.update(e);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$14", "actionPerformed"));
                }
                Map<TemplateImpl, DefaultMutableTreeNode> templates = TemplateListPanel.this.getSelectedTemplates();
                TemplateContext context = new TemplateContext();
                JPanel contextPanel = LiveTemplateSettingsEditor.createPopupContextPanel(EmptyRunnable.INSTANCE, context);
                DialogBuilder builder = new DialogBuilder((Component)TemplateListPanel.this);
                builder.setCenterPanel((JComponent)contextPanel);
                builder.setTitle("Change Context Type For Selected Templates");
                int result2 = builder.show();
                if (result2 == 0) {
                    for (TemplateImpl template : templates.keySet()) {
                        TemplateListPanel.this.myTemplateContext.put(template, context);
                    }
                }
                TemplateListPanel.this.updateTemplateDetails(false, true);
                TemplateListPanel.this.myTree.repaint();
            }
        };
        final DumbAwareAction revert = new DumbAwareAction("Restore defaults", "Restore default setting for the selected templates", null){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$15", "update"));
                }
                boolean enabled = false;
                Map<TemplateImpl, DefaultMutableTreeNode> templates = TemplateListPanel.this.getSelectedTemplates();
                for (TemplateImpl template : templates.keySet()) {
                    TemplateImpl defaultTemplate = TemplateSettings.getInstance().getDefaultTemplate(template);
                    if (defaultTemplate == null || !TemplateListPanel.this.templatesDiffer(template, defaultTemplate)) continue;
                    enabled = true;
                }
                e.getPresentation().setEnabled(enabled);
                e.getPresentation().setVisible(enabled);
                super.update(e);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateListPanel$15", "actionPerformed"));
                }
                Map<TemplateImpl, DefaultMutableTreeNode> templates = TemplateListPanel.this.getSelectedTemplates();
                for (TemplateImpl template : templates.keySet()) {
                    TemplateImpl defaultTemplate = TemplateSettings.getInstance().getDefaultTemplate(template);
                    if (defaultTemplate == null) continue;
                    TemplateListPanel.this.myTemplateOptions.put(template, defaultTemplate.createOptions());
                    TemplateListPanel.this.myTemplateContext.put(template, defaultTemplate.createContext());
                    template.resetFrom(defaultTemplate);
                }
                TemplateListPanel.this.updateTemplateDetails(false, true);
                TemplateListPanel.this.myTree.repaint();
            }
        };
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.add((AnAction)rename);
                group.add((AnAction)move);
                group.add((AnAction)changeContext);
                group.add((AnAction)revert);
                group.add(ActionManager.getInstance().getAction("$Copy"));
                group.add(ActionManager.getInstance().getAction("$Paste"));
                ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group).getComponent().show(comp, x, y);
            }
        });
    }

    @Nullable
    TemplateGroup getSingleSelectedGroup() {
        return this.getGroup(this.getSingleSelectedIndex());
    }

    private static Set<String> getAllGroups(Map<TemplateImpl, DefaultMutableTreeNode> templates) {
        HashSet<String> oldGroups = new HashSet<String>();
        for (TemplateImpl template : templates.keySet()) {
            oldGroups.add(template.getGroupName());
        }
        return oldGroups;
    }

    Map<TemplateImpl, DefaultMutableTreeNode> getSelectedTemplates() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<TemplateImpl, DefaultMutableTreeNode> templates = new LinkedHashMap<TemplateImpl, DefaultMutableTreeNode>();
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object o = node.getUserObject();
            if (!(o instanceof TemplateImpl)) {
                return Collections.emptyMap();
            }
            templates.put((TemplateImpl)o, node);
        }
        return templates;
    }

    private void renameGroup() {
        TemplateGroup templateGroup = this.getSingleSelectedGroup();
        if (templateGroup == null) {
            return;
        }
        String oldName = templateGroup.getName();
        String newName = Messages.showInputDialog((Component)((Object)this.myTree), (String)"Enter the new group name:", (String)"Rename", null, (String)oldName, (InputValidator)new TemplateGroupInputValidator(oldName));
        if (newName != null && !newName.equals(oldName)) {
            templateGroup.setName(newName);
            ((DefaultTreeModel)this.myTree.getModel()).nodeChanged(this.getNode(this.getSingleSelectedIndex()));
        }
    }

    private void updateTemplateDetails(boolean focusKey, boolean forceReload) {
        int selected = this.getSingleSelectedIndex();
        CardLayout layout = (CardLayout)this.myDetailsPanel.getLayout();
        if (selected < 0 || this.getTemplate(selected) == null) {
            this.showEmptyCard();
        } else {
            TemplateImpl newTemplate = this.getTemplate(selected);
            if (this.myCurrentTemplateEditor == null || forceReload || this.myCurrentTemplateEditor.getTemplate() != newTemplate) {
                if (this.myCurrentTemplateEditor != null) {
                    this.myCurrentTemplateEditor.dispose();
                }
                this.createTemplateEditor(newTemplate, this.myExpandByDefaultPanel.getSelectedString(), this.getTemplateOptions(newTemplate), this.getTemplateContext(newTemplate));
                this.myCurrentTemplateEditor.resetUi();
                if (focusKey) {
                    this.myCurrentTemplateEditor.focusKey();
                }
            }
            layout.show(this.myDetailsPanel, TEMPLATE_SETTINGS);
        }
    }

    private CheckedTreeNode registerTemplate(TemplateImpl template) {
        TemplateGroup newGroup = this.getTemplateGroup(template.getGroupName());
        if (newGroup == null) {
            newGroup = new TemplateGroup(template.getGroupName());
            this.insertNewGroup(newGroup);
        }
        if (!newGroup.contains(template)) {
            newGroup.addElement(template);
        }
        CheckedTreeNode node = new CheckedTreeNode((Object)template);
        node.setChecked(!template.isDeactivated());
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.myTreeRoot.getFirstChild();
        while (child != null) {
            if (((TemplateGroup)child.getUserObject()).getName().equals(template.getGroupName())) {
                int index = TemplateListPanel.getIndexToInsert(child, template.getKey());
                child.insert((MutableTreeNode)node, index);
                ((DefaultTreeModel)this.myTree.getModel()).nodesWereInserted(child, new int[]{index});
                this.setSelectedNode((DefaultMutableTreeNode)node);
            }
            child = (DefaultMutableTreeNode)this.myTreeRoot.getChildAfter((TreeNode)child);
        }
        return node;
    }

    private DefaultMutableTreeNode insertNewGroup(TemplateGroup newGroup) {
        this.myTemplateGroups.add(newGroup);
        int index = TemplateListPanel.getIndexToInsert((DefaultMutableTreeNode)this.myTreeRoot, newGroup.getName());
        CheckedTreeNode groupNode = new CheckedTreeNode((Object)newGroup);
        this.myTreeRoot.insert((MutableTreeNode)groupNode, index);
        ((DefaultTreeModel)this.myTree.getModel()).nodesWereInserted((TreeNode)this.myTreeRoot, new int[]{index});
        return groupNode;
    }

    private static int getIndexToInsert(DefaultMutableTreeNode parent, String key2) {
        if (parent.getChildCount() == 0) {
            return 0;
        }
        int res = 0;
        DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getFirstChild();
        while (child != null) {
            String key1;
            Object o = child.getUserObject();
            String string = key1 = o instanceof TemplateImpl ? ((TemplateImpl)o).getKey() : ((TemplateGroup)o).getName();
            if (key1.compareToIgnoreCase(key2) > 0) {
                return res;
            }
            ++res;
            child = (DefaultMutableTreeNode)parent.getChildAfter(child);
        }
        return res;
    }

    private void setSelectedNode(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.myTree.expandPath(path.getParentPath());
        int row = this.myTree.getRowForPath(path);
        this.myTree.setSelectionRow(row);
        this.myTree.scrollRowToVisible(row);
    }

    private void removeNodeFromParent(DefaultMutableTreeNode node) {
        TreeNode parent = node.getParent();
        int idx = parent.getIndex(node);
        node.removeFromParent();
        ((DefaultTreeModel)this.myTree.getModel()).nodesWereRemoved(parent, new int[]{idx}, new TreeNode[]{node});
    }

    private void initTemplates(List<TemplateGroup> groups, String lastSelectedGroup, String lastSelectedKey) {
        this.myTreeRoot.removeAllChildren();
        this.myTemplateGroups.clear();
        this.mutatorHelper.clear();
        for (TemplateGroup group : groups) {
            this.myTemplateGroups.add(this.mutatorHelper.copy(group));
        }
        for (TemplateGroup group : this.myTemplateGroups) {
            CheckedTreeNode groupNode = new CheckedTreeNode((Object)group);
            this.addTemplateNodes(group, groupNode);
            this.myTreeRoot.add((MutableTreeNode)groupNode);
        }
        this.fireStructureChange();
        this.selectTemplate(lastSelectedGroup, lastSelectedKey);
    }

    void selectNode(@NotNull String searchQuery) {
        if (searchQuery == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchQuery", "com/intellij/codeInsight/template/impl/TemplateListPanel", "selectNode"));
        }
        ((SpeedSearchSupply)ObjectUtils.assertNotNull((Object)SpeedSearchSupply.getSupply((JComponent)((Object)this.myTree), (boolean)true))).findAndSelectElement(searchQuery);
    }

    private void selectTemplate(@Nullable String groupName, @Nullable String templateKey) {
        TreeUtil.traverseDepth((TreeNode)this.myTreeRoot, node -> {
            Object o = ((DefaultMutableTreeNode)node).getUserObject();
            if (templateKey == null && o instanceof TemplateGroup && Comparing.equal((String)groupName, (String)((TemplateGroup)o).getName()) || o instanceof TemplateImpl && Comparing.equal((String)templateKey, (String)((TemplateImpl)o).getKey()) && Comparing.equal((String)groupName, (String)((TemplateImpl)o).getGroupName())) {
                this.setSelectedNode((DefaultMutableTreeNode)node);
                return false;
            }
            return true;
        });
    }

    private void fireStructureChange() {
        ((DefaultTreeModel)this.myTree.getModel()).nodeStructureChanged((TreeNode)this.myTreeRoot);
    }

    private void addTemplateNodes(TemplateGroup group, CheckedTreeNode groupNode) {
        ArrayList templates = new ArrayList(group.getElements());
        Collections.sort(templates, TEMPLATE_COMPARATOR);
        for (TemplateImpl template : templates) {
            this.myTemplateOptions.put(template, template.createOptions());
            this.myTemplateContext.put(template, template.createContext());
            CheckedTreeNode node = new CheckedTreeNode((Object)template);
            node.setChecked(!template.isDeactivated());
            groupNode.add((MutableTreeNode)node);
        }
    }

    static {
        MOCK_TEMPLATE.setString("");
        LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.impl.TemplateListPanel");
    }

    private class TemplateGroupInputValidator
    implements InputValidator {
        private final String myOldName;

        public TemplateGroupInputValidator(String oldName) {
            this.myOldName = oldName;
        }

        public boolean checkInput(String inputString) {
            return StringUtil.isNotEmpty((String)inputString) && (TemplateListPanel.this.getTemplateGroup(inputString) == null || inputString.equals(this.myOldName));
        }

        public boolean canClose(String inputString) {
            return this.checkInput(inputString);
        }
    }
}

