/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.InvokeActionResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseCompleteMacro
extends Macro {
    private final String myName;
    private final boolean myCheckCompletionChar;

    protected BaseCompleteMacro(@NonNls String name2) {
        this(name2, true);
    }

    protected BaseCompleteMacro(@NonNls String name2, boolean checkCompletionChar) {
        this.myName = name2;
        this.myCheckCompletionChar = checkCompletionChar;
    }

    public String getName() {
        return this.myName;
    }

    public String getPresentableName() {
        return this.myName + "()";
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/BaseCompleteMacro", "getDefaultValue"));
        }
        return "a";
    }

    public final Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/BaseCompleteMacro", "calculateResult"));
        }
        return new InvokeActionResult(() -> this.invokeCompletion(context));
    }

    private void invokeCompletion(ExpressionContext context) {
        Project project2 = context.getProject();
        Editor editor = context.getEditor();
        PsiFile psiFile = editor != null ? PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project2) : null;
        Runnable runnable2 = () -> {
            if (project2.isDisposed() || editor == null || editor.isDisposed() || psiFile == null || !psiFile.isValid()) {
                return;
            }
            if (CompletionServiceImpl.getCompletionService().getCurrentCompletion() != null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                this.invokeCompletionHandler(project2, editor);
                LookupEx lookup = LookupManager.getInstance(project2).getActiveLookup();
                if (lookup != null) {
                    lookup.addLookupListener(new MyLookupListener(context, this.myCheckCompletionChar));
                }
            }, "", null);
        };
        ApplicationManager.getApplication().invokeLater(runnable2);
    }

    protected abstract void invokeCompletionHandler(Project var1, Editor var2);

    private static class MyLookupListener
    extends LookupAdapter {
        private final ExpressionContext myContext;
        private final boolean myCheckCompletionChar;

        public MyLookupListener(@NotNull ExpressionContext context, boolean checkCompletionChar) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/macro/BaseCompleteMacro$MyLookupListener", "<init>"));
            }
            this.myContext = context;
            this.myCheckCompletionChar = checkCompletionChar;
        }

        @Override
        public void itemSelected(LookupEvent event) {
            final LookupElement item = event.getItem();
            if (item == null) {
                return;
            }
            char c = event.getCompletionChar();
            if (this.myCheckCompletionChar && !LookupEvent.isSpecialCompletionChar((char)c)) {
                return;
            }
            Project project2 = this.myContext.getProject();
            if (project2 == null) {
                return;
            }
            Runnable runnable2 = () -> new WriteCommandAction(project2, new PsiFile[0]){

                protected void run(@NotNull com.intellij.openapi.application.Result result2) throws Throwable {
                    TemplateState templateState;
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/template/macro/BaseCompleteMacro$MyLookupListener$1", "run"));
                    }
                    Editor editor = myContext.getEditor();
                    if (editor != null && (templateState = TemplateManagerImpl.getTemplateState(editor)) != null) {
                        templateState.considerNextTabOnLookupItemSelected(item);
                    }
                }
            }.execute();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                runnable2.run();
            } else {
                ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.current(), project2.getDisposed());
            }
        }
    }
}

