/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MacroBase
extends Macro {
    private final String myName;
    private final String myDescription;

    public MacroBase(String name2, String description) {
        this.myName = name2;
        this.myDescription = description;
    }

    @Nullable
    protected abstract Result calculateResult(@NotNull Expression[] var1, ExpressionContext var2, boolean var3);

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/MacroBase", "calculateResult"));
        }
        return this.calculateResult(params, context, false);
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/MacroBase", "calculateQuickResult"));
        }
        return this.calculateResult(params, context, true);
    }

    public String getName() {
        return this.myName;
    }

    public String getPresentableName() {
        return this.myDescription;
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/MacroBase", "getDefaultValue"));
        }
        return "a";
    }

    @Nullable
    public static String getTextResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/MacroBase", "getTextResult"));
        }
        return MacroBase.getTextResult(params, context, false);
    }

    @Nullable
    public static String getTextResult(@NotNull Expression[] params, ExpressionContext context, boolean useSelection) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/MacroBase", "getTextResult"));
        }
        if (params.length == 1) {
            String property;
            Result result2 = params[0].calculateResult(context);
            if (result2 == null && useSelection && (property = (String)context.getProperty(ExpressionContext.SELECTION)) != null) {
                result2 = new TextResult(property);
            }
            return result2 == null ? null : result2.toString();
        }
        return null;
    }
}

