/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.Consumer;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class SubtypesMacro
extends Macro {
    public String getName() {
        return "subtypes";
    }

    public String getPresentableName() {
        return "subtypes(TYPE)";
    }

    @NotNull
    public String getDefaultValue() {
        if ("A" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/SubtypesMacro", "getDefaultValue"));
        }
        return "A";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/SubtypesMacro", "calculateResult"));
        }
        if (params.length == 0) {
            return null;
        }
        return params[0].calculateQuickResult(context);
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/SubtypesMacro", "calculateQuickResult"));
        }
        return this.calculateResult(params, context);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/SubtypesMacro", "calculateLookupItems"));
        }
        if (params.length == 0) {
            return LookupElement.EMPTY_ARRAY;
        }
        Result paramResult = params[0].calculateQuickResult(context);
        if (paramResult instanceof PsiTypeResult) {
            PsiType type2 = ((PsiTypeResult)paramResult).getType();
            PsiFile file2 = PsiDocumentManager.getInstance((Project)context.getProject()).getPsiFile(context.getEditor().getDocument());
            PsiElement element = file2.findElementAt(context.getStartOffset());
            LinkedHashSet<LookupElement> set2 = new LinkedHashSet<LookupElement>();
            JavaTemplateUtil.addTypeLookupItem(set2, type2);
            CodeInsightUtil.processSubTypes(type2, element, false, PrefixMatcher.ALWAYS_TRUE, (Consumer<PsiType>)((Consumer)psiType -> JavaTemplateUtil.addTypeLookupItem(set2, psiType)));
            return set2.toArray(new LookupElement[set2.size()]);
        }
        return LookupElement.EMPTY_ARRAY;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

