/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class InstanceofExpressionPostfixTemplate
extends PostfixTemplate {
    public InstanceofExpressionPostfixTemplate() {
        this("instanceof");
    }

    public InstanceofExpressionPostfixTemplate(String alias) {
        super(alias, "expr instanceof Type ? ((Type) expr). : null");
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/InstanceofExpressionPostfixTemplate", "isApplicable"));
        }
        if (copyDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyDocument", "com/intellij/codeInsight/template/postfix/templates/InstanceofExpressionPostfixTemplate", "isApplicable"));
        }
        return JavaPostfixTemplatesUtils.isNotPrimitiveTypeExpression(JavaPostfixTemplatesUtils.getTopmostExpression(context));
    }

    @Override
    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/InstanceofExpressionPostfixTemplate", "expand"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/postfix/templates/InstanceofExpressionPostfixTemplate", "expand"));
        }
        PsiExpression expression2 = JavaPostfixTemplatesUtils.getTopmostExpression(context);
        if (!JavaPostfixTemplatesUtils.isNotPrimitiveTypeExpression(expression2)) {
            return;
        }
        InstanceofExpressionPostfixTemplate.surroundExpression(context.getProject(), editor, expression2);
    }

    private static void surroundExpression(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiExpression expr) throws IncorrectOperationException {
        TextRange range;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/template/postfix/templates/InstanceofExpressionPostfixTemplate", "surroundExpression"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/postfix/templates/InstanceofExpressionPostfixTemplate", "surroundExpression"));
        }
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/template/postfix/templates/InstanceofExpressionPostfixTemplate", "surroundExpression"));
        }
        assert (expr.isValid());
        PsiType[] types = GuessManager.getInstance(project2).guessTypeToCast(expr);
        boolean parenthesesNeeded = expr instanceof PsiPolyadicExpression || expr instanceof PsiConditionalExpression || expr instanceof PsiAssignmentExpression;
        String exprText = parenthesesNeeded ? "(" + expr.getText() + ")" : expr.getText();
        Template template = InstanceofExpressionPostfixTemplate.generateTemplate(project2, exprText, types);
        if (expr.isPhysical()) {
            range = expr.getTextRange();
        } else {
            RangeMarker rangeMarker = (RangeMarker)expr.getUserData(ElementToWorkOn.TEXT_RANGE);
            if (rangeMarker == null) {
                PostfixTemplatesUtils.showErrorHint(project2, editor);
                return;
            }
            range = new TextRange(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        }
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        editor.getCaretModel().moveToOffset(range.getStartOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        TemplateManager.getInstance(project2).startTemplate(editor, template);
    }

    private static Template generateTemplate(Project project2, String exprText, PsiType[] suggestedTypes) {
        Object type22;
        TemplateManager templateManager = TemplateManager.getInstance(project2);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        LinkedHashSet<PsiTypeLookupItem> itemSet = new LinkedHashSet<PsiTypeLookupItem>();
        for (Object type22 : suggestedTypes) {
            itemSet.add(PsiTypeLookupItem.createLookupItem(type22, null));
        }
        final LookupElement[] lookupItems = itemSet.toArray(new LookupElement[itemSet.size()]);
        final PsiTypeResult result2 = suggestedTypes.length > 0 ? new PsiTypeResult(suggestedTypes[0], project2) : null;
        Expression expr = new Expression(){

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return lookupItems.length > 1 ? lookupItems : null;
            }

            public Result calculateResult(ExpressionContext context) {
                return result2;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return null;
            }
        };
        template.addTextSegment(exprText);
        template.addTextSegment(" instanceof ");
        type22 = "type";
        template.addVariable((String)type22, expr, expr, true);
        template.addTextSegment(" ? ((");
        template.addVariableSegment((String)type22);
        template.addTextSegment(")" + exprText + ")");
        template.addEndVariable();
        template.addTextSegment(" : null;");
        return template;
    }
}

