/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.util;

import com.intellij.codeInsight.CodeInsightServicesUtil;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelectorBase;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatePsiInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaPostfixTemplatesUtils {
    public static final PostfixTemplatePsiInfo JAVA_PSI_INFO = new PostfixTemplatePsiInfo(){

        @Override
        @NotNull
        public PsiElement createExpression(@NotNull PsiElement context, @NotNull String prefix, @NotNull String suffix) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$4", "createExpression"));
            }
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$4", "createExpression"));
            }
            if (suffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$4", "createExpression"));
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
            PsiExpression psiExpression = factory.createExpressionFromText(prefix + context.getText() + suffix, context);
            if (psiExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$4", "createExpression"));
            }
            return psiExpression;
        }

        @NotNull
        public PsiExpression getNegatedExpression(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$4", "getNegatedExpression"));
            }
            assert (element instanceof PsiExpression);
            PsiExpression psiExpression = CodeInsightServicesUtil.invertCondition((PsiExpression)((PsiExpression)element));
            if (psiExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$4", "getNegatedExpression"));
            }
            return psiExpression;
        }
    };
    public static final Condition<PsiElement> IS_NUMBER = element -> element instanceof PsiExpression && JavaPostfixTemplatesUtils.isNumber(((PsiExpression)element).getType());
    public static final Condition<PsiElement> IS_BOOLEAN = element -> element instanceof PsiExpression && JavaPostfixTemplatesUtils.isBoolean(((PsiExpression)element).getType());
    public static final Condition<PsiElement> IS_THROWABLE = element -> element instanceof PsiExpression && JavaPostfixTemplatesUtils.isThrowable(((PsiExpression)element).getType());
    public static final Condition<PsiElement> IS_NON_VOID = element -> element instanceof PsiExpression && JavaPostfixTemplatesUtils.isNonVoid(((PsiExpression)element).getType());
    public static final Condition<PsiElement> IS_NOT_PRIMITIVE = element -> element instanceof PsiExpression && JavaPostfixTemplatesUtils.isNotPrimitiveTypeExpression((PsiExpression)element);
    public static final Condition<PsiElement> IS_ARRAY = element -> {
        if (!(element instanceof PsiExpression)) {
            return false;
        }
        PsiType type2 = ((PsiExpression)element).getType();
        return JavaPostfixTemplatesUtils.isArray(type2);
    };
    public static final Condition<PsiElement> IS_ITERABLE_OR_ARRAY = element -> {
        if (!(element instanceof PsiExpression)) {
            return false;
        }
        PsiType type2 = ((PsiExpression)element).getType();
        return JavaPostfixTemplatesUtils.isArray(type2) || JavaPostfixTemplatesUtils.isIterable(type2);
    };

    private JavaPostfixTemplatesUtils() {
    }

    public static PostfixTemplateExpressionSelector atLeastJava8Selector(final PostfixTemplateExpressionSelector selector2) {
        return new PostfixTemplateExpressionSelector(){

            @Override
            public boolean hasExpression(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "hasExpression"));
                }
                if (copyDocument == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyDocument", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "hasExpression"));
                }
                return PsiUtil.isLanguageLevel8OrHigher((PsiElement)context) && selector2.hasExpression(context, copyDocument, newOffset);
            }

            @Override
            @NotNull
            public List<PsiElement> getExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "getExpressions"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "getExpressions"));
                }
                List<PsiElement> list2 = PsiUtil.isLanguageLevel8OrHigher((PsiElement)context) ? selector2.getExpressions(context, document, offset) : Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "getExpressions"));
                }
                return list2;
            }

            @Override
            @NotNull
            public Function<PsiElement, String> getRenderer() {
                Function<PsiElement, String> function = selector2.getRenderer();
                if (function == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$1", "getRenderer"));
                }
                return function;
            }
        };
    }

    public static PostfixTemplateExpressionSelector selectorTopmost() {
        return JavaPostfixTemplatesUtils.selectorTopmost((Condition<PsiElement>)Conditions.alwaysTrue());
    }

    public static PostfixTemplateExpressionSelector selectorTopmost(Condition<PsiElement> additionalFilter) {
        return new PostfixTemplateExpressionSelectorBase((Condition)additionalFilter){

            @Override
            protected List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$2", "getNonFilteredExpressions"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$2", "getNonFilteredExpressions"));
                }
                return ContainerUtil.createMaybeSingletonList((Object)JavaPostfixTemplatesUtils.getTopmostExpression(context));
            }

            @Override
            protected Condition<PsiElement> getFilters(int offset) {
                return Conditions.and(super.getFilters(offset), this.getPsiErrorFilter());
            }

            @Override
            @NotNull
            public Function<PsiElement, String> getRenderer() {
                Function<PsiElement, String> function = JavaPostfixTemplatesUtils.getRenderer();
                if (function == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$2", "getRenderer"));
                }
                return function;
            }
        };
    }

    public static PostfixTemplateExpressionSelector selectorAllExpressionsWithCurrentOffset() {
        return JavaPostfixTemplatesUtils.selectorAllExpressionsWithCurrentOffset((Condition<PsiElement>)Conditions.alwaysTrue());
    }

    public static PostfixTemplateExpressionSelector selectorAllExpressionsWithCurrentOffset(Condition<PsiElement> additionalFilter) {
        return new PostfixTemplateExpressionSelectorBase((Condition)additionalFilter){

            @Override
            protected List<PsiElement> getNonFilteredExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$3", "getNonFilteredExpressions"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$3", "getNonFilteredExpressions"));
                }
                return ContainerUtil.newArrayList(IntroduceVariableBase.collectExpressions(context.getContainingFile(), document, Math.max(offset - 1, 0), false));
            }

            @Override
            @NotNull
            public List<PsiElement> getExpressions(@NotNull PsiElement context, @NotNull Document document, int offset) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$3", "getExpressions"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$3", "getExpressions"));
                }
                if (DumbService.getInstance((Project)context.getProject()).isDumb()) {
                    List<PsiElement> list2 = Collections.emptyList();
                    if (list2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$3", "getExpressions"));
                    }
                    return list2;
                }
                List<PsiElement> expressions2 = super.getExpressions(context, document, offset);
                if (!expressions2.isEmpty()) {
                    List<PsiElement> list3 = expressions2;
                    if (list3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$3", "getExpressions"));
                    }
                    return list3;
                }
                List list4 = ContainerUtil.filter((Collection)ContainerUtil.createMaybeSingletonList((Object)JavaPostfixTemplatesUtils.getTopmostExpression(context)), this.getFilters(offset));
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$3", "getExpressions"));
                }
                return list4;
            }

            @Override
            @NotNull
            public Function<PsiElement, String> getRenderer() {
                Function<PsiElement, String> function = JavaPostfixTemplatesUtils.getRenderer();
                if (function == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils$3", "getRenderer"));
                }
                return function;
            }
        };
    }

    @Contract(value="null -> false")
    public static boolean isNotPrimitiveTypeExpression(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        PsiType type2 = expression2.getType();
        return type2 != null && !(type2 instanceof PsiPrimitiveType);
    }

    @Contract(value="null -> false")
    public static boolean isIterable(@Nullable PsiType type2) {
        return type2 != null && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Iterable");
    }

    @Contract(value="null -> false")
    public static boolean isThrowable(@Nullable PsiType type2) {
        return type2 != null && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Throwable");
    }

    @Contract(value="null -> false")
    public static boolean isArray(@Nullable PsiType type2) {
        return type2 != null && type2 instanceof PsiArrayType;
    }

    @Contract(value="null -> false")
    public static boolean isBoolean(@Nullable PsiType type2) {
        return type2 != null && (PsiType.BOOLEAN.equals((Object)type2) || PsiType.BOOLEAN.equals((Object)PsiPrimitiveType.getUnboxedType((PsiType)type2)));
    }

    @Contract(value="null -> false")
    public static boolean isNonVoid(@Nullable PsiType type2) {
        return type2 != null && !PsiType.VOID.equals((Object)type2);
    }

    @Contract(value="null -> false")
    public static boolean isNumber(@Nullable PsiType type2) {
        if (type2 == null) {
            return false;
        }
        if (PsiType.INT.equals((Object)type2) || PsiType.BYTE.equals((Object)type2) || PsiType.LONG.equals((Object)type2)) {
            return true;
        }
        PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)type2);
        return PsiType.INT.equals((Object)unboxedType) || PsiType.BYTE.equals((Object)unboxedType) || PsiType.LONG.equals((Object)unboxedType);
    }

    @NotNull
    public static Function<PsiElement, String> getRenderer() {
        Function function = element -> {
            assert (element instanceof PsiExpression);
            return new PsiExpressionTrimRenderer.RenderFunction().fun((PsiExpression)element);
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/util/JavaPostfixTemplatesUtils", "getRenderer"));
        }
        return function;
    }

    @Nullable
    public static PsiExpression getTopmostExpression(PsiElement context) {
        PsiExpressionStatement statement2 = (PsiExpressionStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiExpressionStatement.class});
        return statement2 != null ? statement2.getExpression() : null;
    }
}

