/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionApplication;
import com.intellij.codeInspection.InspectionToolCmdlineOptions;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.openapi.diagnostic.Logger;
import com.sampullara.cli.Args;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInspectionCmdlineOptions
implements InspectionToolCmdlineOptions {
    private static final Logger LOG = Logger.getInstance(AbstractInspectionCmdlineOptions.class);

    @Nullable
    protected abstract String getProfileNameOrPathProperty();

    @Nullable
    protected abstract String getProjectPathProperty();

    @Nullable
    protected abstract String getOutputPathProperty();

    @Nullable
    protected abstract String getDirToInspectProperty();

    @Nullable
    protected abstract String getOutputFormatProperty();

    @Nullable
    protected abstract String getXSLTSchemePathProperty();

    @Nullable
    protected abstract Boolean getErrorCodeRequiredProperty();

    @Nullable
    protected abstract Boolean getRunWithEditorSettingsProperty();

    @NotNull
    protected abstract String[] optionsBanner();

    @Override
    public void initApplication(InspectionApplication app) {
        String xsltSchemePath;
        Boolean runWithEditorSettings;
        app.myHelpProvider = this;
        app.myProjectPath = this.determineProjectPath();
        app.myProfileName = this.getProfileNameOrPathProperty();
        app.myOutPath = this.determineOutputPath();
        app.mySourceDirectory = this.determineDirectoryToInspect(app.myProjectPath);
        app.setVerboseLevel(this.getVerboseLevelProperty());
        Boolean errorCodeRequired = this.getErrorCodeRequiredProperty();
        if (errorCodeRequired != null) {
            app.myErrorCodeRequired = errorCodeRequired;
        }
        if ((runWithEditorSettings = this.getRunWithEditorSettingsProperty()) != null) {
            app.myRunWithEditorSettings = runWithEditorSettings;
        }
        if ((xsltSchemePath = this.getXSLTSchemePathProperty()) != null) {
            app.myOutputFormat = xsltSchemePath;
        } else {
            String outputFormat = this.getOutputFormatProperty();
            if (outputFormat != null) {
                app.myOutputFormat = outputFormat.toLowerCase();
            }
        }
    }

    @Override
    public void validate() throws InspectionToolCmdlineOptions.CmdlineArgsValidationException {
        File xsltScheme;
        String dirToInspect;
        String projectPath = this.determineProjectPath();
        if (projectPath == null) {
            throw new InspectionToolCmdlineOptions.CmdlineArgsValidationException("Project not found.");
        }
        if (!new File(projectPath).exists()) {
            throw new InspectionToolCmdlineOptions.CmdlineArgsValidationException("Project '" + projectPath + "' not found.");
        }
        if (this.getDirToInspectProperty() != null && (dirToInspect = this.determineDirectoryToInspect(projectPath)) == null) {
            throw new InspectionToolCmdlineOptions.CmdlineArgsValidationException("Directory '" + dirToInspect + "' not found.");
        }
        String xsltSchemePath = this.getXSLTSchemePathProperty();
        if (xsltSchemePath != null && !(xsltScheme = new File(xsltSchemePath)).exists()) {
            throw new InspectionToolCmdlineOptions.CmdlineArgsValidationException("XSLT scheme '" + xsltSchemePath + "' not found.");
        }
        String outputFormat = this.getOutputFormatProperty();
        if (outputFormat != null) {
            StringBuilder builder = new StringBuilder();
            for (InspectionsReportConverter converter : (InspectionsReportConverter[])InspectionsReportConverter.EP_NAME.getExtensions()) {
                String converterFormat = converter.getFormatName();
                if (outputFormat == converterFormat) {
                    builder = null;
                    break;
                }
                if (builder.length() != 0) {
                    builder.append(", ");
                }
                builder.append(converterFormat);
            }
            if (builder != null) {
                throw new InspectionToolCmdlineOptions.CmdlineArgsValidationException("Unsupported format option '" + outputFormat + "'. Please use one of: " + builder.toString());
            }
        }
    }

    @Nullable
    protected String determineOutputPath() {
        String outputPathProperty = this.getOutputPathProperty();
        return outputPathProperty != null ? outputPathProperty : (this.getOutputFormatProperty() == "plain" ? null : this.getDefaultOutputPath());
    }

    @Override
    public void printHelpAndExit() {
        String[] bannerLines;
        for (String line : bannerLines = this.optionsBanner()) {
            System.out.println(line);
        }
        Args.usage((Object)this);
        System.exit(1);
    }

    @Nullable
    protected String determineProjectPath() {
        String projectPath = this.getProjectPathProperty();
        return projectPath != null ? projectPath : this.getDefaultProjectPath();
    }

    @Nullable
    protected String determineDirectoryToInspect(@Nullable String projectPath) {
        String dirToInspect = this.getDirToInspectProperty();
        if (dirToInspect == null) {
            return null;
        }
        try {
            File relativePathFile = new File(projectPath + File.separatorChar + dirToInspect);
            if (relativePathFile.exists()) {
                return relativePathFile.getCanonicalPath();
            }
            File absPathFile = new File(dirToInspect);
            if (absPathFile.exists()) {
                return absPathFile.getCanonicalPath();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return null;
    }

    protected String getDefaultOutputPath() {
        return this.getOutputPathProperty() + "/results";
    }

    @Nullable
    protected String getDefaultProjectPath() {
        return null;
    }
}

