/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnonymousCanBeMethodReferenceInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(AnonymousCanBeMethodReferenceInspection.class);
    public boolean reportNotAnnotatedInterfaces = true;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Anonymous type can be replaced with method reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection", "getDisplayName"));
        }
        return "Anonymous type can be replaced with method reference";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("Anonymous2MethodRef" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection", "getShortName"));
        }
        return "Anonymous2MethodRef";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Report when interface is not annotated with @FunctionalInterface", (InspectionProfileEntry)this, "reportNotAnnotatedInterfaces");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                super.visitAnonymousClass(aClass);
                if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, true, AnonymousCanBeMethodReferenceInspection.this.reportNotAnnotatedInterfaces, Collections.emptySet())) {
                    PsiJavaCodeReferenceElement classReference2;
                    PsiElement parent;
                    PsiCallExpression callExpression;
                    PsiMethod resolveMethod;
                    PsiMethod method = aClass.getMethods()[0];
                    PsiCodeBlock body2 = method.getBody();
                    LambdaCanBeMethodReferenceInspection.MethodReferenceCandidate methodReferenceCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression((PsiElement)body2);
                    if (methodReferenceCandidate == null) {
                        return;
                    }
                    PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiVariable[])method.getParameterList().getParameters(), (PsiType)aClass.getBaseClassType(), aClass.getParent(), methodReferenceCandidate.myExpression);
                    if (candidate instanceof PsiCallExpression && (resolveMethod = (callExpression = (PsiCallExpression)candidate).resolveMethod()) != method && !AnonymousCanBeLambdaInspection.functionalInterfaceMethodReferenced(resolveMethod, aClass, callExpression) && (parent = aClass.getParent()) instanceof PsiNewExpression && (classReference2 = ((PsiNewExpression)parent).getClassOrAnonymousClassReference()) != null) {
                        PsiElement lBrace = aClass.getLBrace();
                        LOG.assertTrue(lBrace != null);
                        TextRange rangeInElement = new TextRange(0, aClass.getStartOffsetInParent() + lBrace.getStartOffsetInParent());
                        ProblemHighlightType type2 = methodReferenceCandidate.mySafeQualifier && methodReferenceCandidate.myConformsCodeStyle ? ProblemHighlightType.LIKE_UNUSED_SYMBOL : ProblemHighlightType.INFORMATION;
                        ProblemDescriptorBase descriptor = new ProblemDescriptorBase(parent, parent, "Anonymous #ref #loc can be replaced with method reference", new LocalQuickFix[]{new ReplaceWithMethodRefFix()}, type2, false, rangeInElement, type2 != ProblemHighlightType.INFORMATION, true);
                        holder.registerProblem((ProblemDescriptor)descriptor);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    static void replaceWithMethodReference(@NotNull Project project2, String methodRefText, PsiType castType, PsiElement replacementTarget) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection", "replaceWithMethodReference"));
        }
        List comments = ContainerUtil.map((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)replacementTarget, PsiComment.class), comment -> (PsiComment)comment.copy());
        if (methodRefText != null) {
            PsiElement anchor;
            String canonicalText = castType.getCanonicalText();
            PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText("(" + canonicalText + ")" + methodRefText, replacementTarget);
            PsiElement castExpr = replacementTarget.replace((PsiElement)psiExpression);
            if (RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)castExpr))) {
                PsiExpression operand2 = ((PsiTypeCastExpression)castExpr).getOperand();
                LOG.assertTrue(operand2 != null);
                castExpr = castExpr.replace((PsiElement)operand2);
            }
            if ((anchor = PsiTreeUtil.getParentOfType((PsiElement)castExpr, PsiStatement.class)) == null) {
                anchor = castExpr;
            }
            for (PsiComment comment2 : comments) {
                anchor.getParent().addBefore((PsiElement)comment2, anchor);
            }
            JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(castExpr);
        }
    }

    private static class ReplaceWithMethodRefFix
    implements LocalQuickFix {
        private ReplaceWithMethodRefFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with method reference" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "getFamilyName"));
            }
            return "Replace with method reference";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/AnonymousCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiNewExpression) {
                PsiAnonymousClass anonymousClass = ((PsiNewExpression)element).getAnonymousClass();
                if (anonymousClass == null) {
                    return;
                }
                PsiMethod[] methods = anonymousClass.getMethods();
                if (methods.length != 1) {
                    return;
                }
                PsiParameter[] parameters2 = methods[0].getParameterList().getParameters();
                PsiClassType functionalInterfaceType = anonymousClass.getBaseClassType();
                LambdaCanBeMethodReferenceInspection.MethodReferenceCandidate methodRefCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression((PsiElement)methods[0].getBody());
                if (methodRefCandidate == null) {
                    return;
                }
                PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiVariable[])parameters2, (PsiType)functionalInterfaceType, anonymousClass.getParent(), methodRefCandidate.myExpression);
                String methodRefText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText((PsiElement)candidate, (PsiType)functionalInterfaceType, (PsiVariable[])parameters2);
                AnonymousCanBeMethodReferenceInspection.replaceWithMethodReference(project2, methodRefText, (PsiType)anonymousClass.getBaseClassType(), anonymousClass.getParent());
            }
        }
    }
}

