/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.SuppressAllForClassFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByJavaCommentFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressForClassFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressLocalWithCommentFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressParameterFix;
import com.intellij.codeInspection.BatchSuppressManager;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchSuppressManagerImpl
implements BatchSuppressManager {
    @NotNull
    public SuppressQuickFix[] createBatchSuppressActions(@NotNull HighlightDisplayKey displayKey) {
        if (displayKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayKey", "com/intellij/codeInspection/BatchSuppressManagerImpl", "createBatchSuppressActions"));
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SuppressByJavaCommentFix(displayKey), new SuppressLocalWithCommentFix(displayKey), new SuppressParameterFix(displayKey), new SuppressFix(displayKey), new SuppressForClassFix(displayKey), new SuppressAllForClassFix()};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/BatchSuppressManagerImpl", "createBatchSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/BatchSuppressManagerImpl", "isSuppressedFor"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/BatchSuppressManagerImpl", "isSuppressedFor"));
        }
        return JavaSuppressionUtil.getElementToolSuppressedIn(element, toolId) != null;
    }

    @Nullable
    public PsiElement getElementMemberSuppressedIn(@NotNull PsiDocCommentOwner owner2, @NotNull String inspectionToolID) {
        if (owner2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/BatchSuppressManagerImpl", "getElementMemberSuppressedIn"));
        }
        if (inspectionToolID == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionToolID", "com/intellij/codeInspection/BatchSuppressManagerImpl", "getElementMemberSuppressedIn"));
        }
        return JavaSuppressionUtil.getElementMemberSuppressedIn((PsiJavaDocumentedElement)owner2, inspectionToolID);
    }

    @Nullable
    public PsiElement getAnnotationMemberSuppressedIn(@NotNull PsiModifierListOwner owner2, @NotNull String inspectionToolID) {
        if (owner2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/BatchSuppressManagerImpl", "getAnnotationMemberSuppressedIn"));
        }
        if (inspectionToolID == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionToolID", "com/intellij/codeInspection/BatchSuppressManagerImpl", "getAnnotationMemberSuppressedIn"));
        }
        return JavaSuppressionUtil.getAnnotationMemberSuppressedIn(owner2, inspectionToolID);
    }

    @Nullable
    public PsiElement getDocCommentToolSuppressedIn(@NotNull PsiDocCommentOwner owner2, @NotNull String inspectionToolID) {
        if (owner2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/BatchSuppressManagerImpl", "getDocCommentToolSuppressedIn"));
        }
        if (inspectionToolID == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionToolID", "com/intellij/codeInspection/BatchSuppressManagerImpl", "getDocCommentToolSuppressedIn"));
        }
        return JavaSuppressionUtil.getDocCommentToolSuppressedIn((PsiJavaDocumentedElement)owner2, inspectionToolID);
    }

    @NotNull
    public Collection<String> getInspectionIdsSuppressedInAnnotation(@NotNull PsiModifierListOwner owner2) {
        if (owner2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/BatchSuppressManagerImpl", "getInspectionIdsSuppressedInAnnotation"));
        }
        Collection<String> collection = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(owner2);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/BatchSuppressManagerImpl", "getInspectionIdsSuppressedInAnnotation"));
        }
        return collection;
    }

    @Nullable
    public String getSuppressedInspectionIdsIn(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/BatchSuppressManagerImpl", "getSuppressedInspectionIdsIn"));
        }
        return JavaSuppressionUtil.getSuppressedInspectionIdsIn(element);
    }

    @Nullable
    public PsiElement getElementToolSuppressedIn(@NotNull PsiElement place, @NotNull String toolId) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInspection/BatchSuppressManagerImpl", "getElementToolSuppressedIn"));
        }
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/BatchSuppressManagerImpl", "getElementToolSuppressedIn"));
        }
        return JavaSuppressionUtil.getElementToolSuppressedIn(place, toolId);
    }

    public boolean canHave15Suppressions(@NotNull PsiElement file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/BatchSuppressManagerImpl", "canHave15Suppressions"));
        }
        return JavaSuppressionUtil.canHave15Suppressions(file2);
    }

    public boolean alreadyHas14Suppressions(@NotNull PsiDocCommentOwner commentOwner) {
        if (commentOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commentOwner", "com/intellij/codeInspection/BatchSuppressManagerImpl", "alreadyHas14Suppressions"));
        }
        return JavaSuppressionUtil.alreadyHas14Suppressions((PsiJavaDocumentedElement)commentOwner);
    }
}

