/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.siyeh.ig.controlflow.UnnecessaryReturnInspection;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeVoidQuickFix
implements LocalQuickFix {
    private final ProblemDescriptionsProcessor myProcessor;
    private static final Logger LOG = Logger.getInstance(MakeVoidQuickFix.class);

    public MakeVoidQuickFix(@Nullable ProblemDescriptionsProcessor processor2) {
        this.myProcessor = processor2;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.unused.return.value.make.void.quickfix", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/MakeVoidQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/MakeVoidQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/MakeVoidQuickFix", "applyFix"));
        }
        PsiMethod psiMethod = null;
        if (this.myProcessor != null) {
            RefElement refElement = (RefElement)this.myProcessor.getElement((CommonProblemDescriptor)descriptor);
            if (refElement instanceof RefMethod && refElement.isValid()) {
                RefMethod refMethod = (RefMethod)refElement;
                psiMethod = (PsiMethod)refMethod.getElement();
            }
        } else {
            psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
        }
        if (psiMethod == null) {
            return;
        }
        MakeVoidQuickFix.makeMethodHierarchyVoid(project2, psiMethod);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/intellij/codeInspection/MakeVoidQuickFix", "getElementToMakeWritable"));
        }
        return currentFile;
    }

    private static void makeMethodHierarchyVoid(Project project2, @NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/MakeVoidQuickFix", "makeMethodHierarchyVoid"));
        }
        SmartList methodsToModify = new SmartList((Object)psiMethod);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (psiMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/MakeVoidQuickFix", "lambda$makeMethodHierarchyVoid$0"));
            }
            methodsToModify.addAll(OverridingMethodsSearch.search((PsiMethod)psiMethod).findAll());
        }, InspectionsBundle.message((String)"psi.search.overriding.progress", (Object[])new Object[0]), true, project2)) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)methodsToModify)) {
            return;
        }
        for (PsiMethod method : methodsToModify) {
            MakeVoidQuickFix.replaceReturnStatements(method);
        }
        ChangeSignatureProcessor csp = new ChangeSignatureProcessor(project2, psiMethod, false, null, psiMethod.getName(), (PsiType)PsiType.VOID, ParameterInfoImpl.fromMethod(psiMethod));
        csp.run();
    }

    private static void replaceReturnStatements(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/MakeVoidQuickFix", "replaceReturnStatements"));
        }
        PsiReturnStatement[] statements = PsiUtil.findReturnStatements((PsiMethod)method);
        if (statements.length > 0) {
            WriteAction.run(() -> {
                for (int i2 = statements.length - 1; i2 >= 0; --i2) {
                    PsiReturnStatement returnStatement = statements[i2];
                    try {
                        PsiExpression expression2 = returnStatement.getReturnValue();
                        if (expression2 == null) continue;
                        List<PsiExpression> sideEffectExpressions = SideEffectChecker.extractSideEffectExpressions(expression2);
                        PsiStatement[] sideEffectStatements = StatementExtractor.generateStatements(sideEffectExpressions, expression2);
                        if (sideEffectStatements.length > 0) {
                            PsiStatement added = BlockUtils.addBefore((PsiStatement)returnStatement, sideEffectStatements);
                            returnStatement = (PsiReturnStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)added, PsiReturnStatement.class);
                        }
                        if (returnStatement == null || returnStatement.getReturnValue() == null) continue;
                        returnStatement.getReturnValue().delete();
                        if (!UnnecessaryReturnInspection.isReturnRedundant(returnStatement, false, null)) continue;
                        returnStatement.delete();
                        continue;
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        }
    }
}

