/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SimplifyOptionalCallChainsInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final CallMatcher OPTIONAL_OR_ELSE = CallMatcher.instanceCall("java.util.Optional", "orElse").parameterCount(1);
    private static final CallMatcher OPTIONAL_OR_ELSE_GET = CallMatcher.instanceCall("java.util.Optional", "orElseGet").parameterCount(1);
    private static final CallMatcher OPTIONAL_MAP = CallMatcher.instanceCall("java.util.Optional", "map").parameterCount(1);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiExpression falseArg = null;
                boolean useOrElseGet = false;
                if (OPTIONAL_OR_ELSE.test(call)) {
                    falseArg = call.getArgumentList().getExpressions()[0];
                } else if (OPTIONAL_OR_ELSE_GET.test(call)) {
                    useOrElseGet = true;
                    PsiLambdaExpression lambda2 = SimplifyOptionalCallChainsInspection.getLambda(call.getArgumentList().getExpressions()[0]);
                    if (lambda2 == null || lambda2.getParameterList().getParametersCount() != 0) {
                        return;
                    }
                    falseArg = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
                }
                if (falseArg == null) {
                    return;
                }
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
                if (!OPTIONAL_MAP.test(qualifierCall)) {
                    return;
                }
                PsiLambdaExpression lambda3 = SimplifyOptionalCallChainsInspection.getLambda(qualifierCall.getArgumentList().getExpressions()[0]);
                if (lambda3 == null) {
                    return;
                }
                PsiExpression trueArg = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda3.getBody());
                if (trueArg == null) {
                    return;
                }
                PsiParameter[] parameters2 = lambda3.getParameterList().getParameters();
                if (parameters2.length != 1) {
                    return;
                }
                PsiExpression qualifier = qualifierCall.getMethodExpression().getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                String opt = qualifier.getText();
                PsiParameter parameter = parameters2[0];
                String proposed = OptionalUtil.generateOptionalUnwrap(opt, (PsiVariable)parameter, trueArg, falseArg, call.getType(), useOrElseGet);
                String canonicalOrElse = useOrElseGet && !ExpressionUtils.isSimpleExpression(falseArg) ? ".orElseGet(() -> " + falseArg.getText() + ")" : ".orElse(" + falseArg.getText() + ")";
                String canonical = opt + ".map(" + LambdaUtil.createLambda((PsiVariable)parameter, (PsiExpression)trueArg) + ")" + canonicalOrElse;
                if (proposed.length() < canonical.length()) {
                    String displayCode;
                    if (proposed.equals(opt)) {
                        displayCode = "";
                    } else if (opt.length() > 10) {
                        opt = "(($))";
                        String template = OptionalUtil.generateOptionalUnwrap(opt, (PsiVariable)parameter, trueArg, falseArg, call.getType(), useOrElseGet);
                        displayCode = PsiExpressionTrimRenderer.render((PsiExpression)JavaPsiFacade.getElementFactory((Project)holder.getProject()).createExpressionFromText(template, (PsiElement)call));
                        displayCode = displayCode.replaceFirst(Pattern.quote(opt), "..");
                    } else {
                        displayCode = PsiExpressionTrimRenderer.render((PsiExpression)JavaPsiFacade.getElementFactory((Project)holder.getProject()).createExpressionFromText(proposed, (PsiElement)call));
                    }
                    holder.registerProblem(Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement()), "Optional chain can be simplified", new LocalQuickFix[]{new SimplifyOptionalChainFix(proposed, displayCode)});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static PsiLambdaExpression getLambda(PsiExpression initializer) {
        PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)initializer);
        if (expression2 instanceof PsiLambdaExpression) {
            return (PsiLambdaExpression)expression2;
        }
        if (expression2 instanceof PsiMethodReferenceExpression) {
            return LambdaRefactoringUtil.createLambda((PsiMethodReferenceExpression)expression2, true);
        }
        return null;
    }

    private static class SimplifyOptionalChainFix
    implements LocalQuickFix {
        private final String myReplacement;
        private final String myDisplayCode;

        public SimplifyOptionalChainFix(String replacement, String displayCode) {
            this.myReplacement = replacement;
            this.myDisplayCode = displayCode;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myDisplayCode.isEmpty() ? "Remove redundant steps from optional chain" : "Simplify optional chain to '" + this.myDisplayCode + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$SimplifyOptionalChainFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Simplify optional call chain" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$SimplifyOptionalChainFix", "getFamilyName"));
            }
            return "Simplify optional call chain";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$SimplifyOptionalChainFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/SimplifyOptionalCallChainsInspection$SimplifyOptionalChainFix", "applyFix"));
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpression replacementExpression = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(this.myReplacement, (PsiElement)call);
            PsiElement result2 = call.replace((PsiElement)replacementExpression);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result2);
            PsiDiamondTypeUtil.removeRedundantTypeArguments(result2);
        }
    }
}

