/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SuspiciousArrayMethodCallInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Set<String> INTERESTING_NAMES = ContainerUtil.set((Object[])new String[]{"fill", "binarySearch", "equals", "mismatch"});

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/SuspiciousArrayMethodCallInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                String name2 = nameElement.getText();
                if (!INTERESTING_NAMES.contains(name2)) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null || !"java.util.Arrays".equals(aClass.getQualifiedName())) {
                    return;
                }
                PsiExpression[] args = call.getArgumentList().getExpressions();
                switch (name2) {
                    case "fill": 
                    case "binarySearch": {
                        if (args.length == 2) {
                            this.handleArrayElement(args[0], args[1]);
                            break;
                        }
                        if (args.length != 4) break;
                        this.handleArrayElement(args[0], args[3]);
                        break;
                    }
                    case "equals": 
                    case "mismatch": {
                        if (args.length == 2) {
                            this.handleArrays(nameElement, args[0], args[1]);
                            break;
                        }
                        if (args.length != 6) break;
                        this.handleArrays(nameElement, args[0], args[3]);
                    }
                }
            }

            private void handleArrayElement(PsiExpression array, PsiExpression element) {
                PsiType arrayType = array.getType();
                PsiType elementType = element.getType();
                if (elementType == null || !(arrayType instanceof PsiArrayType)) {
                    return;
                }
                PsiType arrayElementType = ((PsiArrayType)arrayType).getComponentType();
                if (arrayElementType instanceof PsiPrimitiveType) {
                    return;
                }
                if (!TypeConversionUtil.areTypesConvertible((PsiType)(elementType = TypeConversionUtil.erasure((PsiType)elementType)), (PsiType)(arrayElementType = TypeConversionUtil.erasure((PsiType)arrayElementType)))) {
                    holder.registerProblem((PsiElement)element, InspectionsBundle.message((String)"inspection.suspicious.array.method.call.problem.element", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            private void handleArrays(PsiElement context, PsiExpression array1, PsiExpression array2) {
                PsiType array1Type = array1.getType();
                PsiType array2Type = array2.getType();
                if (!(array1Type instanceof PsiArrayType) || !(array2Type instanceof PsiArrayType)) {
                    return;
                }
                PsiType array1ElementType = ((PsiArrayType)array1Type).getComponentType();
                PsiType array2ElementType = ((PsiArrayType)array2Type).getComponentType();
                if (array1ElementType instanceof PsiPrimitiveType || array2ElementType instanceof PsiPrimitiveType) {
                    return;
                }
                if (!TypeConversionUtil.areTypesConvertible((PsiType)(array1ElementType = TypeConversionUtil.erasure((PsiType)array1ElementType)), (PsiType)(array2ElementType = TypeConversionUtil.erasure((PsiType)array2ElementType))) || !TypeConversionUtil.areTypesConvertible((PsiType)array2ElementType, (PsiType)array1ElementType)) {
                    holder.registerProblem(context, InspectionsBundle.message((String)"inspection.suspicious.array.method.call.problem.arrays", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SuspiciousArrayMethodCallInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }
}

