/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.ClassDataIndexer;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equations;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.HMethod;
import com.intellij.codeInspection.bytecodeAnalysis.HardCodedPurity;
import com.intellij.codeInspection.bytecodeAnalysis.KeyedMethodVisitor;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.MethodDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class BytecodeAnalysisIndex
extends ScalarIndexExtension<HMethod> {
    private static final ID<HMethod, Void> NAME = ID.create((String)"bytecodeAnalysis");
    private static final HKeyDescriptor KEY_DESCRIPTOR = new HKeyDescriptor();
    private static final int VERSION = 5;
    private static final int VERSION_MODIFIER = HardCodedPurity.AGGRESSIVE_HARDCODED_PURITY ? 1 : 0;
    private static final int FINAL_VERSION = 10 + VERSION_MODIFIER;
    private static final VirtualFileGist<Map<HMethod, Equations>> ourGist = GistManager.getInstance().newVirtualFileGist("BytecodeAnalysisIndex", FINAL_VERSION, (DataExternalizer)new EquationsExternalizer(), (VirtualFileGist.GistCalculator)new ClassDataIndexer());

    @NotNull
    public ID<HMethod, Void> getName() {
        ID<HMethod, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<HMethod, Void, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            try {
                return BytecodeAnalysisIndex.collectKeys(inputData.getContent());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during indexing of bytecode", e);
                return Collections.emptyMap();
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    private static Map<HMethod, Void> collectKeys(byte[] content) throws NoSuchAlgorithmException {
        final HashMap<HMethod, Void> map2 = new HashMap<HMethod, Void>();
        final MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
        new ClassReader(content).accept((ClassVisitor)new KeyedMethodVisitor(){

            @Override
            @Nullable
            MethodVisitor visitMethod(MethodNode node, Method method, EKey key2) {
                map2.put(method.hashed(md), null);
                return null;
            }
        }, 6);
        HashMap<HMethod, Void> hashMap = map2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "collectKeys"));
        }
        return hashMap;
    }

    @NotNull
    public KeyDescriptor<HMethod> getKeyDescriptor() {
        HKeyDescriptor hKeyDescriptor = KEY_DESCRIPTOR;
        if (hKeyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getKeyDescriptor"));
        }
        return hKeyDescriptor;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaClassFileType.INSTANCE});
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 10;
    }

    @NotNull
    static List<Equations> getEquations(GlobalSearchScope scope, HMethod key2) {
        Project project2 = ProjectManager.getInstance().getDefaultProject();
        List list2 = ContainerUtil.mapNotNull((Collection)FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)key2, scope), file2 -> (Equations)((Map)ourGist.getFileData(project2, file2)).get(key2));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getEquations"));
        }
        return list2;
    }

    public static class EquationsExternalizer
    implements DataExternalizer<Map<HMethod, Equations>> {
        public void save(@NotNull DataOutput out, Map<HMethod, Equations> value2) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer", "save"));
            }
            DataInputOutputUtilRt.writeSeq((DataOutput)out, value2.entrySet(), entry -> {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer", "lambda$save$0"));
                }
                KEY_DESCRIPTOR.save(out, (HMethod)entry.getKey());
                EquationsExternalizer.saveEquations(out, (Equations)entry.getValue());
            });
        }

        public Map<HMethod, Equations> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer", "read"));
            }
            return DataInputOutputUtilRt.readSeq((DataInput)in, () -> {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer", "lambda$read$1"));
                }
                return Pair.create((Object)KEY_DESCRIPTOR.read(in), (Object)EquationsExternalizer.readEquations(in));
            }).stream().collect(Collectors.toMap(p -> (HMethod)p.getFirst(), p -> (Equations)p.getSecond()));
        }

        private static void saveEquations(@NotNull DataOutput out, Equations eqs) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer", "saveEquations"));
            }
            out.writeBoolean(eqs.stable);
            MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
            DataInputOutputUtil.writeINT((DataOutput)out, (int)eqs.results.size());
            for (DirectionResultPair pair2 : eqs.results) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)pair2.directionKey);
                Result rhs = pair2.result;
                if (rhs instanceof Final) {
                    Final finalResult = (Final)rhs;
                    out.writeBoolean(true);
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)finalResult.value.ordinal());
                    continue;
                }
                if (rhs instanceof Pending) {
                    Pending pendResult = (Pending)rhs;
                    out.writeBoolean(false);
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)pendResult.delta.length);
                    for (Component component : pendResult.delta) {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)component.value.ordinal());
                        EKey[] ids = component.ids;
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)ids.length);
                        for (EKey hKey : ids) {
                            EquationsExternalizer.writeKey(out, hKey, md);
                        }
                    }
                    continue;
                }
                if (!(rhs instanceof Effects)) continue;
                Effects effects = (Effects)rhs;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)effects.effects.size());
                for (EffectQuantum effect : effects.effects) {
                    EquationsExternalizer.writeEffect(out, effect, md);
                }
                EquationsExternalizer.writeDataValue(out, effects.returnValue, md);
            }
        }

        private static Equations readEquations(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer", "readEquations"));
            }
            boolean stable = in.readBoolean();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            ArrayList<DirectionResultPair> results = new ArrayList<DirectionResultPair>(size);
            for (int k = 0; k < size; ++k) {
                int directionKey = DataInputOutputUtil.readINT((DataInput)in);
                Direction direction = Direction.fromInt(directionKey);
                if (direction == Direction.Pure) {
                    HashSet<EffectQuantum> effects = new HashSet<EffectQuantum>();
                    int effectsSize = DataInputOutputUtil.readINT((DataInput)in);
                    for (int i2 = 0; i2 < effectsSize; ++i2) {
                        effects.add(EquationsExternalizer.readEffect(in));
                    }
                    DataValue returnValue = EquationsExternalizer.readDataValue(in);
                    results.add(new DirectionResultPair(directionKey, new Effects(returnValue, effects)));
                    continue;
                }
                boolean isFinal = in.readBoolean();
                if (isFinal) {
                    int ordinal = DataInputOutputUtil.readINT((DataInput)in);
                    Value value2 = Value.values()[ordinal];
                    results.add(new DirectionResultPair(directionKey, new Final(value2)));
                    continue;
                }
                int sumLength = DataInputOutputUtil.readINT((DataInput)in);
                Component[] components = new Component[sumLength];
                for (int i3 = 0; i3 < sumLength; ++i3) {
                    int ordinal = DataInputOutputUtil.readINT((DataInput)in);
                    Value value3 = Value.values()[ordinal];
                    int componentSize = DataInputOutputUtil.readINT((DataInput)in);
                    EKey[] ids = new EKey[componentSize];
                    for (int j = 0; j < componentSize; ++j) {
                        ids[j] = EquationsExternalizer.readKey(in);
                    }
                    components[i3] = new Component(value3, ids);
                }
                results.add(new DirectionResultPair(directionKey, new Pending(components)));
            }
            return new Equations(results, stable);
        }

        @NotNull
        private static EKey readKey(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer", "readKey"));
            }
            byte[] bytes = new byte[14];
            in.readFully(bytes);
            int rawDirKey = DataInputOutputUtil.readINT((DataInput)in);
            EKey eKey = new EKey((MethodDescriptor)new HMethod(bytes), Direction.fromInt(Math.abs(rawDirKey)), in.readBoolean(), rawDirKey < 0);
            if (eKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer", "readKey"));
            }
            return eKey;
        }

        private static void writeKey(@NotNull DataOutput out, EKey key2, MessageDigest md) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer", "writeKey"));
            }
            out.write(key2.method.hashed((MessageDigest)md).myBytes);
            int rawDirKey = key2.negated ? -key2.dirKey : key2.dirKey;
            DataInputOutputUtil.writeINT((DataOutput)out, (int)rawDirKey);
            out.writeBoolean(key2.stable);
        }

        private static void writeEffect(@NotNull DataOutput out, EffectQuantum effect, MessageDigest md) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer", "writeEffect"));
            }
            if (effect == EffectQuantum.TopEffectQuantum) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-1);
            } else if (effect == EffectQuantum.ThisChangeQuantum) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-2);
            } else if (effect instanceof EffectQuantum.CallQuantum) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-3);
                EffectQuantum.CallQuantum callQuantum = (EffectQuantum.CallQuantum)effect;
                EquationsExternalizer.writeKey(out, callQuantum.key, md);
                out.writeBoolean(callQuantum.isStatic);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)callQuantum.data.length);
                for (DataValue dataValue : callQuantum.data) {
                    EquationsExternalizer.writeDataValue(out, dataValue, md);
                }
            } else if (effect instanceof EffectQuantum.ReturnChangeQuantum) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-4);
                EquationsExternalizer.writeKey(out, ((EffectQuantum.ReturnChangeQuantum)effect).key, md);
            } else if (effect instanceof EffectQuantum.ParamChangeQuantum) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)((EffectQuantum.ParamChangeQuantum)effect).n);
            }
        }

        private static EffectQuantum readEffect(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer", "readEffect"));
            }
            int effectMask = DataInputOutputUtil.readINT((DataInput)in);
            switch (effectMask) {
                case -1: {
                    return EffectQuantum.TopEffectQuantum;
                }
                case -2: {
                    return EffectQuantum.ThisChangeQuantum;
                }
                case -3: {
                    EKey key2 = EquationsExternalizer.readKey(in);
                    boolean isStatic = in.readBoolean();
                    int dataLength = DataInputOutputUtil.readINT((DataInput)in);
                    DataValue[] data = new DataValue[dataLength];
                    for (int di = 0; di < dataLength; ++di) {
                        data[di] = EquationsExternalizer.readDataValue(in);
                    }
                    return new EffectQuantum.CallQuantum(key2, data, isStatic);
                }
                case -4: {
                    return new EffectQuantum.ReturnChangeQuantum(EquationsExternalizer.readKey(in));
                }
            }
            return new EffectQuantum.ParamChangeQuantum(effectMask);
        }

        private static void writeDataValue(@NotNull DataOutput out, DataValue dataValue, MessageDigest md) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer", "writeDataValue"));
            }
            if (dataValue == DataValue.ThisDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-1);
            } else if (dataValue == DataValue.LocalDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-2);
            } else if (dataValue == DataValue.OwnedDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-3);
            } else if (dataValue == DataValue.UnknownDataValue1) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-4);
            } else if (dataValue == DataValue.UnknownDataValue2) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-5);
            } else if (dataValue instanceof DataValue.ReturnDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)-6);
                EquationsExternalizer.writeKey(out, ((DataValue.ReturnDataValue)dataValue).key, md);
            } else if (dataValue instanceof DataValue.ParameterDataValue) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)((DataValue.ParameterDataValue)dataValue).n);
            }
        }

        private static DataValue readDataValue(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$EquationsExternalizer", "readDataValue"));
            }
            int dataI = DataInputOutputUtil.readINT((DataInput)in);
            switch (dataI) {
                case -1: {
                    return DataValue.ThisDataValue;
                }
                case -2: {
                    return DataValue.LocalDataValue;
                }
                case -3: {
                    return DataValue.OwnedDataValue;
                }
                case -4: {
                    return DataValue.UnknownDataValue1;
                }
                case -5: {
                    return DataValue.UnknownDataValue2;
                }
                case -6: {
                    return new DataValue.ReturnDataValue(EquationsExternalizer.readKey(in));
                }
            }
            return new DataValue.ParameterDataValue(dataI);
        }
    }

    private static class HKeyDescriptor
    implements KeyDescriptor<HMethod>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private HKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, HMethod value2) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HKeyDescriptor", "save"));
            }
            out.write(value2.myBytes);
        }

        public HMethod read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HKeyDescriptor", "read"));
            }
            byte[] bytes = new byte[14];
            in.readFully(bytes);
            return new HMethod(bytes);
        }

        public int getHashCode(HMethod value2) {
            return value2.hashCode();
        }

        public boolean isEqual(HMethod val1, HMethod val2) {
            return val1.equals(val2);
        }
    }
}

