/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class Component {
    static final Component[] EMPTY_ARRAY = new Component[0];
    @NotNull
    Value value;
    @NotNull
    final EKey[] ids;

    Component(@NotNull Value value2, @NotNull Set<EKey> ids) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/bytecodeAnalysis/Component", "<init>"));
        }
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/codeInspection/bytecodeAnalysis/Component", "<init>"));
        }
        this(value2, ids.toArray(new EKey[0]));
    }

    Component(@NotNull Value value2, @NotNull EKey[] ids) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/bytecodeAnalysis/Component", "<init>"));
        }
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/codeInspection/bytecodeAnalysis/Component", "<init>"));
        }
        this.value = value2;
        this.ids = ids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component that = (Component)o;
        return this.value == that.value && Arrays.equals(this.ids, that.ids);
    }

    public int hashCode() {
        return 31 * this.value.hashCode() + Arrays.hashCode(this.ids);
    }

    public boolean remove(@NotNull EKey id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInspection/bytecodeAnalysis/Component", "remove"));
        }
        boolean removed = false;
        for (int i2 = 0; i2 < this.ids.length; ++i2) {
            if (!id.equals(this.ids[i2])) continue;
            this.ids[i2] = null;
            removed = true;
        }
        return removed;
    }

    public boolean isEmpty() {
        for (EKey id : this.ids) {
            if (id == null) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Component copy() {
        Component component = new Component(this.value, (EKey[])this.ids.clone());
        if (component == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/Component", "copy"));
        }
        return component;
    }
}

