/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.MethodDescriptor;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.security.MessageDigest;
import java.util.Arrays;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public final class HMethod
implements MethodDescriptor {
    private static final int CLASS_HASH_SIZE = 10;
    private static final int SIGNATURE_HASH_SIZE = 4;
    static final int HASH_SIZE = 14;
    @NotNull
    final byte[] myBytes;

    HMethod(Method method, MessageDigest md) {
        if (md == null) {
            md = BytecodeAnalysisConverter.getMessageDigest();
        }
        byte[] classDigest = md.digest(method.internalClassName.getBytes(CharsetToolkit.UTF8_CHARSET));
        md.update(method.methodName.getBytes(CharsetToolkit.UTF8_CHARSET));
        md.update(method.methodDesc.getBytes(CharsetToolkit.UTF8_CHARSET));
        byte[] sigDigest = md.digest();
        this.myBytes = new byte[14];
        System.arraycopy(classDigest, 0, this.myBytes, 0, 10);
        System.arraycopy(sigDigest, 0, this.myBytes, 10, 4);
    }

    public HMethod(@NotNull byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/codeInspection/bytecodeAnalysis/HMethod", "<init>"));
        }
        this.myBytes = bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.myBytes, ((HMethod)o).myBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.myBytes);
    }

    @Override
    @NotNull
    public HMethod hashed(MessageDigest md) {
        HMethod hMethod = this;
        if (hMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/HMethod", "hashed"));
        }
        return hMethod;
    }

    public String toString() {
        return HMethod.bytesToString(this.myBytes);
    }

    static String bytesToString(byte[] key2) {
        return IntStreamEx.of((byte[])key2).mapToObj(b -> String.format("%02x", b & 0xFF)).joining((CharSequence)".");
    }
}

