/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.ContractAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

class InThrowAnalysis
extends ContractAnalysis {
    private BasicValue myReturnValue;
    boolean myHasNonTrivialReturn;

    protected InThrowAnalysis(RichControlFlow richControlFlow, Direction direction, boolean[] resultOrigins, boolean stable, State[] pending) {
        super(richControlFlow, direction, resultOrigins, stable, pending);
    }

    @Override
    boolean handleReturn(Frame<BasicValue> frame, int opcode) throws AnalyzerException {
        Final subResult;
        if (this.interpreter.deReferenced) {
            subResult = new Final(Value.Top);
        } else {
            switch (opcode) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    BasicValue value2 = (BasicValue)frame.pop();
                    if (!(value2 instanceof AbstractValues.NthParamValue) && value2 != AbstractValues.NullValue && value2 != AbstractValues.TrueValue && value2 != AbstractValues.FalseValue || this.myReturnValue != null && !this.myReturnValue.equals((Object)value2)) {
                        this.myHasNonTrivialReturn = true;
                    } else {
                        this.myReturnValue = value2;
                    }
                    subResult = new Final(Value.Top);
                    break;
                }
                case 177: {
                    subResult = new Final(Value.Top);
                    break;
                }
                case 191: {
                    subResult = new Final(Value.Fail);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        this.internalResult = resultUtil.join(this.internalResult, subResult);
        if (this.internalResult instanceof Final && ((Final)this.internalResult).value == Value.Top && this.myHasNonTrivialReturn) {
            this.earlyResult = this.internalResult;
        }
        return true;
    }
}

