/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.MethodData;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ContractInference {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.ContractInferenceInterpreter");
    public static final int MAX_CONTRACT_COUNT = 10;

    @NotNull
    public static List<StandardMethodContract> inferContracts(@NotNull PsiMethodImpl method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "inferContracts"));
        }
        if (!InferenceFromSourceUtil.shouldInferFromSource(method)) {
            List<StandardMethodContract> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "inferContracts"));
            }
            return list2;
        }
        List list3 = (List)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            MethodData data;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "lambda$inferContracts$1"));
            }
            List<Object> preContracts = (data = ContractInferenceIndexKt.getIndexedData(method)) == null ? Collections.emptyList() : data.getContracts();
            List result2 = (List)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "lambda$null$0"));
                }
                return ContractInference.postProcessContracts(method, data, preContracts);
            });
            if (result2 == null) {
                result2 = Collections.emptyList();
            }
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "inferContracts"));
        }
        return list3;
    }

    @NotNull
    private static List<StandardMethodContract> postProcessContracts(@NotNull PsiMethodImpl method, MethodData data, List<PreContract> rawContracts) {
        List compatible;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "postProcessContracts"));
        }
        List<StandardMethodContract> contracts2 = ContainerUtil.concat(rawContracts, c -> {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "lambda$postProcessContracts$2"));
            }
            return c.toContracts(method, data.methodBody(method));
        });
        if (contracts2.isEmpty()) {
            List<StandardMethodContract> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "postProcessContracts"));
            }
            return list2;
        }
        PsiType returnType = method.getReturnType();
        if (returnType != null && !(returnType instanceof PsiPrimitiveType)) {
            contracts2 = ContractInference.boxReturnValues(contracts2);
        }
        if ((compatible = ContainerUtil.filter((Collection)contracts2, contract -> {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "lambda$postProcessContracts$3"));
            }
            return ContractInference.isContractCompatibleWithMethod(method, returnType, contract);
        })).size() > 10) {
            LOG.debug("Too many contracts for " + PsiUtil.getMemberQualifiedName((PsiMember)method) + ", shrinking the list");
            List<StandardMethodContract> list3 = compatible.subList(0, 10);
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "postProcessContracts"));
            }
            return list3;
        }
        List list4 = compatible;
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "postProcessContracts"));
        }
        return list4;
    }

    private static boolean isContractCompatibleWithMethod(@NotNull PsiMethod method, PsiType returnType, StandardMethodContract contract) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "isContractCompatibleWithMethod"));
        }
        if (ContractInference.hasContradictoryExplicitParameterNullity(method, contract)) {
            return false;
        }
        if (ContractInference.isReturnNullitySpecifiedExplicitly(method, contract)) {
            return false;
        }
        if (ContractInference.isContradictingExplicitNullableReturn(method, contract)) {
            return false;
        }
        return InferenceFromSourceUtil.isReturnTypeCompatible(returnType, contract.returnValue);
    }

    private static boolean hasContradictoryExplicitParameterNullity(@NotNull PsiMethod method, StandardMethodContract contract) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "hasContradictoryExplicitParameterNullity"));
        }
        for (int i2 = 0; i2 < contract.arguments.length; ++i2) {
            if (contract.arguments[i2] != MethodContract.ValueConstraint.NULL_VALUE || !NullableNotNullManager.isNotNull((PsiModifierListOwner)method.getParameterList().getParameters()[i2])) continue;
            return true;
        }
        return false;
    }

    private static boolean isContradictingExplicitNullableReturn(@NotNull PsiMethod method, StandardMethodContract contract) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "isContradictingExplicitNullableReturn"));
        }
        return contract.returnValue == MethodContract.ValueConstraint.NOT_NULL_VALUE && Arrays.stream(contract.arguments).allMatch(c -> c == MethodContract.ValueConstraint.ANY_VALUE) && NullableNotNullManager.getInstance((Project)method.getProject()).isNullable((PsiModifierListOwner)method, false);
    }

    private static boolean isReturnNullitySpecifiedExplicitly(@NotNull PsiMethod method, StandardMethodContract contract) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ContractInference", "isReturnNullitySpecifiedExplicitly"));
        }
        if (contract.returnValue != MethodContract.ValueConstraint.NOT_NULL_VALUE && contract.returnValue != MethodContract.ValueConstraint.NULL_VALUE) {
            return false;
        }
        return NullableNotNullManager.getInstance((Project)method.getProject()).isNotNull((PsiModifierListOwner)method, false);
    }

    @NotNull
    private static List<StandardMethodContract> boxReturnValues(List<StandardMethodContract> contracts2) {
        List list2 = ContainerUtil.mapNotNull(contracts2, contract -> {
            if (contract.returnValue == MethodContract.ValueConstraint.FALSE_VALUE || contract.returnValue == MethodContract.ValueConstraint.TRUE_VALUE) {
                return new StandardMethodContract(contract.arguments, MethodContract.ValueConstraint.NOT_NULL_VALUE);
            }
            return contract;
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInference", "boxReturnValues"));
        }
        return list2;
    }
}

