/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaFactMap {
    public static final DfaFactMap EMPTY = new DfaFactMap(KeyFMap.EMPTY_MAP);
    @NotNull
    private final KeyFMap myMap;

    private DfaFactMap(@NotNull KeyFMap map2) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/codeInspection/dataFlow/DfaFactMap", "<init>"));
        }
        this.myMap = map2;
    }

    @Nullable
    public <T> T get(@NotNull DfaFactType<T> type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/DfaFactMap", "get"));
        }
        return (T)this.myMap.get(type2);
    }

    @NotNull
    public <T> DfaFactMap with(@NotNull DfaFactType<T> type2, @Nullable T value2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/DfaFactMap", "with"));
        }
        KeyFMap newMap = value2 == null ? this.myMap.minus(type2) : this.myMap.plus(type2, value2);
        DfaFactMap dfaFactMap = newMap == this.myMap ? this : new DfaFactMap(newMap);
        if (dfaFactMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaFactMap", "with"));
        }
        return dfaFactMap;
    }

    public boolean isSuperStateOf(DfaFactMap subMap) {
        for (Key key2 : this.myMap.getKeys()) {
            DfaFactType type2 = (DfaFactType)key2;
            Object other = subMap.get(type2);
            if (other == null) {
                return false;
            }
            Object thisValue = this.myMap.get((Key)type2);
            Objects.requireNonNull(thisValue);
            if (type2.isSuper(thisValue, other)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public <T> DfaFactMap intersect(@NotNull DfaFactType<T> type2, @Nullable T value2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/DfaFactMap", "intersect"));
        }
        if (value2 == null) {
            return this;
        }
        T curFact = this.get(type2);
        if (curFact == null) {
            return this.with(type2, value2);
        }
        T newFact = type2.intersectFacts(curFact, value2);
        return newFact == null ? null : this.with(type2, newFact);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof DfaFactMap && this.myMap.equals(((DfaFactMap)o).myMap);
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    public String toString() {
        return StreamEx.of((Object[])this.myMap.getKeys()).map(key2 -> ((DfaFactType)((Object)key2)).toString(this.myMap.get(key2))).joining((CharSequence)", ");
    }

    public static DfaFactMap calcFromVariable(@NotNull DfaVariableValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaFactMap", "calcFromVariable"));
        }
        return (DfaFactMap)StreamEx.of(DfaFactType.getTypes()).foldLeft((Object)EMPTY, (factMap, type2) -> {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaFactMap", "lambda$calcFromVariable$1"));
            }
            return DfaFactMap.updateMap(factMap, type2, value2);
        });
    }

    private static <T> DfaFactMap updateMap(DfaFactMap map2, DfaFactType<T> factType, DfaVariableValue value2) {
        return map2.with(factType, factType.calcFromVariable(value2));
    }
}

