/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaOptionalValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.siyeh.ig.psiutils.MethodUtils;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongIterator;
import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaMemoryStateImpl
implements DfaMemoryState {
    private final DfaValueFactory myFactory;
    private final List<EqClass> myEqClasses;
    private final TIntObjectHashMap<int[]> myIdToEqClassesIndices;
    private final Stack<DfaValue> myStack;
    private final TLongHashSet myDistinctClasses;
    private final LinkedHashMap<DfaVariableValue, DfaVariableState> myVariableStates;
    private final Map<DfaVariableValue, DfaVariableState> myDefaultVariableStates;
    private final LinkedHashSet<DfaVariableValue> myUnknownVariables;
    private boolean myEphemeral;
    private LinkedHashSet<UnorderedPair<EqClass>> myCachedDistinctClassPairs;
    private LinkedHashSet<EqClass> myCachedNonTrivialEqClasses;
    private Integer myCachedHash;

    protected DfaMemoryStateImpl(DfaValueFactory factory) {
        this.myFactory = factory;
        this.myDefaultVariableStates = ContainerUtil.newTroveMap();
        this.myEqClasses = ContainerUtil.newArrayList();
        this.myUnknownVariables = ContainerUtil.newLinkedHashSet();
        this.myVariableStates = ContainerUtil.newLinkedHashMap();
        this.myDistinctClasses = new TLongHashSet();
        this.myStack = new Stack();
        this.myIdToEqClassesIndices = new MyIdMap(20);
    }

    protected DfaMemoryStateImpl(DfaMemoryStateImpl toCopy) {
        this.myFactory = toCopy.myFactory;
        this.myEphemeral = toCopy.myEphemeral;
        this.myDefaultVariableStates = toCopy.myDefaultVariableStates;
        this.myStack = new Stack(toCopy.myStack);
        this.myDistinctClasses = new TLongHashSet(toCopy.myDistinctClasses.size());
        toCopy.myDistinctClasses.forEach(arg_0 -> ((TLongHashSet)this.myDistinctClasses).add(arg_0));
        this.myUnknownVariables = ContainerUtil.newLinkedHashSet(toCopy.myUnknownVariables);
        this.myEqClasses = ContainerUtil.newArrayList(toCopy.myEqClasses);
        this.myIdToEqClassesIndices = new MyIdMap(toCopy.myIdToEqClassesIndices.size());
        toCopy.myIdToEqClassesIndices.forEachEntry((id, set2) -> {
            this.myIdToEqClassesIndices.put(id, set2);
            return true;
        });
        this.myVariableStates = ContainerUtil.newLinkedHashMap(toCopy.myVariableStates);
        this.myCachedDistinctClassPairs = toCopy.myCachedDistinctClassPairs;
        this.myCachedNonTrivialEqClasses = toCopy.myCachedNonTrivialEqClasses;
        this.myCachedHash = toCopy.myCachedHash;
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myFactory;
        if (dfaValueFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getFactory"));
        }
        return dfaValueFactory;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        DfaMemoryStateImpl dfaMemoryStateImpl = new DfaMemoryStateImpl(this);
        if (dfaMemoryStateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "createCopy"));
        }
        return dfaMemoryStateImpl;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createClosureState() {
        DfaMemoryStateImpl copy = this.createCopy();
        copy.flushFields();
        HashSet<DfaVariableValue> vars = new HashSet<DfaVariableValue>(copy.getVariableStates().keySet());
        for (DfaVariableValue value2 : vars) {
            copy.flushDependencies(value2);
        }
        copy.emptyStack();
        DfaMemoryStateImpl dfaMemoryStateImpl = copy;
        if (dfaMemoryStateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "createClosureState"));
        }
        return dfaMemoryStateImpl;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaMemoryStateImpl)) {
            return false;
        }
        DfaMemoryStateImpl that = (DfaMemoryStateImpl)obj;
        if (this.myCachedHash != null && that.myCachedHash != null && !this.myCachedHash.equals(that.myCachedHash)) {
            return false;
        }
        return this.equalsSuperficially(that) && this.equalsByUnknownVariables(that) && this.equalsByRelations(that) && this.equalsByVariableStates(that);
    }

    private boolean equalsByUnknownVariables(DfaMemoryStateImpl that) {
        return this.myUnknownVariables.equals(that.myUnknownVariables);
    }

    Object getSuperficialKey() {
        return Pair.create((Object)this.myEphemeral, this.myStack);
    }

    private boolean equalsSuperficially(DfaMemoryStateImpl other) {
        return this.myEphemeral == other.myEphemeral && this.myStack.equals(other.myStack);
    }

    boolean equalsByRelations(DfaMemoryStateImpl that) {
        return this.getNonTrivialEqClasses().equals(that.getNonTrivialEqClasses()) && this.getDistinctClassPairs().equals(that.getDistinctClassPairs());
    }

    boolean equalsByVariableStates(DfaMemoryStateImpl that) {
        return this.myVariableStates.equals(that.myVariableStates);
    }

    LinkedHashSet<UnorderedPair<EqClass>> getDistinctClassPairs() {
        if (this.myCachedDistinctClassPairs != null) {
            return this.myCachedDistinctClassPairs;
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (long encodedPair : this.myDistinctClasses.toArray()) {
            result2.add(new UnorderedPair((Object)this.myEqClasses.get(DfaMemoryStateImpl.low(encodedPair)), (Object)this.myEqClasses.get(DfaMemoryStateImpl.high(encodedPair))));
        }
        this.myCachedDistinctClassPairs = result2;
        return this.myCachedDistinctClassPairs;
    }

    LinkedHashSet<EqClass> getNonTrivialEqClasses() {
        if (this.myCachedNonTrivialEqClasses != null) {
            return this.myCachedNonTrivialEqClasses;
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (EqClass eqClass : this.myEqClasses) {
            if (eqClass == null || eqClass.size() <= 1) continue;
            result2.add(eqClass);
        }
        this.myCachedNonTrivialEqClasses = result2;
        return this.myCachedNonTrivialEqClasses;
    }

    public int hashCode() {
        if (this.myCachedHash != null) {
            return this.myCachedHash;
        }
        int hash = this.getPartialHashCode(true, true);
        this.myCachedHash = hash;
        return hash;
    }

    int getPartialHashCode(boolean unknowns, boolean varStates) {
        int hash = (this.getNonTrivialEqClasses().hashCode() * 31 + this.getDistinctClassPairs().hashCode()) * 31 + this.myStack.hashCode();
        if (varStates) {
            hash = hash * 31 + this.myVariableStates.hashCode();
        }
        if (unknowns && !this.myUnknownVariables.isEmpty()) {
            hash = hash * 31 + this.myUnknownVariables.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append('<');
        if (this.myEphemeral) {
            result2.append("ephemeral, ");
        }
        for (EqClass set2 : this.getNonTrivialEqClasses()) {
            result2.append(set2);
        }
        if (!this.myDistinctClasses.isEmpty()) {
            result2.append("\n  distincts: ");
            String distincts = ((StreamEx)StreamEx.of(this.getDistinctClassPairs()).map(pair2 -> "{" + pair2.first + ", " + pair2.second + "}").sorted()).joining((CharSequence)" ");
            result2.append(distincts);
        }
        if (!this.myStack.isEmpty()) {
            result2.append("\n  stack: ").append(StringUtil.join(this.myStack, (String)","));
        }
        if (!this.myVariableStates.isEmpty()) {
            result2.append("\n  vars: ");
            this.myVariableStates.forEach((key2, value2) -> result2.append("[").append(key2).append("->").append(value2).append("] "));
        }
        if (!this.myUnknownVariables.isEmpty()) {
            result2.append("\n  unknowns: ").append(new HashSet<DfaVariableValue>(this.myUnknownVariables));
        }
        result2.append('>');
        return result2.toString();
    }

    @Override
    public DfaValue pop() {
        this.myCachedHash = null;
        return (DfaValue)this.myStack.pop();
    }

    @Override
    public DfaValue peek() {
        return (DfaValue)this.myStack.peek();
    }

    @Override
    public void push(@NotNull DfaValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "push"));
        }
        this.myCachedHash = null;
        this.myStack.push((Object)value2);
    }

    @Override
    public void emptyStack() {
        this.myCachedHash = null;
        while (!this.myStack.isEmpty() && !(this.myStack.peek() instanceof DfaControlTransferValue)) {
            this.myStack.pop();
        }
    }

    @Override
    public void setVarValue(DfaVariableValue var, DfaValue value2) {
        if (var == value2) {
            return;
        }
        value2 = this.handleFlush(var, value2);
        this.flushVariable(var);
        if (value2 instanceof DfaUnknownValue) {
            this.setVariableState(var, this.getVariableState(var).withNotNull());
            return;
        }
        this.setVariableState(var, this.withValueNullability(value2, this.getVariableState(var).withValue(value2)));
        if (value2 instanceof DfaTypeValue) {
            DfaRelationValue dfaInstanceof = this.myFactory.getRelationFactory().createRelation(var, DfaRelationValue.RelationType.IS, value2);
            if (((DfaTypeValue)value2).isNotNull()) {
                this.applyCondition(dfaInstanceof);
            } else {
                this.applyInstanceofOrNull(dfaInstanceof);
            }
        } else {
            DfaRelationValue dfaEqual = this.myFactory.getRelationFactory().createRelation(var, DfaRelationValue.RelationType.EQ, value2);
            if (dfaEqual == null) {
                return;
            }
            this.applyCondition(dfaEqual);
            if (value2 instanceof DfaVariableValue) {
                this.setVariableState(var, this.getVariableState((DfaVariableValue)value2));
            }
        }
        if (this.getVariableState(var).isNotNull()) {
            DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
            this.applyCondition(this.myFactory.getRelationFactory().createRelation(var, DfaRelationValue.RelationType.NE, dfaNull));
        }
    }

    private DfaVariableState withValueNullability(DfaValue value2, DfaVariableState state) {
        if (value2 instanceof DfaTypeValue) {
            return state.withFact(DfaFactType.CAN_BE_NULL, NullnessUtil.toBoolean(((DfaTypeValue)value2).getNullness()));
        }
        if (this.isNull(value2)) {
            return state.withFact(DfaFactType.CAN_BE_NULL, true);
        }
        return state;
    }

    private DfaValue handleFlush(DfaVariableValue flushed, DfaValue value2) {
        if (value2 instanceof DfaVariableValue && (value2 == flushed || this.myFactory.getVarFactory().getAllQualifiedBy(flushed).contains(value2))) {
            Nullness nullability = this.isNotNull(value2) ? Nullness.NOT_NULL : ((DfaVariableValue)value2).getInherentNullability();
            return this.myFactory.createTypeValue(((DfaVariableValue)value2).getVariableType(), nullability);
        }
        return value2;
    }

    @Nullable(value="for boxed values which can't be compared by ==")
    private Integer getOrCreateEqClassIndex(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getOrCreateEqClassIndex"));
        }
        int i = this.getEqClassIndex(dfaValue);
        if (i != -1) {
            return i;
        }
        if (!DfaMemoryStateImpl.canBeInRelation(dfaValue) || !this.canBeReused(dfaValue) && !(((DfaBoxedValue)dfaValue).getWrappedValue() instanceof DfaConstValue)) {
            return null;
        }
        int freeIndex = this.myEqClasses.indexOf(null);
        int resultIndex = freeIndex >= 0 ? freeIndex : this.myEqClasses.size();
        EqClass aClass = new EqClass(this.myFactory);
        aClass.add(dfaValue.getID());
        if (freeIndex >= 0) {
            this.myEqClasses.set(freeIndex, aClass);
        } else {
            this.myEqClasses.add(aClass);
        }
        this.addToMap(dfaValue.getID(), resultIndex);
        return this.tryMergeClassByQualifier(resultIndex);
    }

    private int tryMergeClassByQualifier(int classIndex) {
        List<DfaValue> values = this.myEqClasses.get(classIndex).getMemberValues();
        if (values.size() != 1) {
            return classIndex;
        }
        DfaValue dfaValue = values.get(0);
        if (!(dfaValue instanceof DfaVariableValue)) {
            return classIndex;
        }
        DfaVariableValue variableValue = (DfaVariableValue)dfaValue;
        DfaVariableValue qualifier = variableValue.getQualifier();
        PsiModifierListOwner variable = variableValue.getPsiVariable();
        if (qualifier == null) {
            return classIndex;
        }
        Integer index = this.getOrCreateEqClassIndex(qualifier);
        if (index == null) {
            return classIndex;
        }
        for (DfaValue eqQualifier : this.myEqClasses.get(index).getMemberValues()) {
            DfaVariableValue eqValue;
            int i;
            if (eqQualifier == qualifier || !(eqQualifier instanceof DfaVariableValue) || (i = this.getEqClassIndex(eqValue = this.getFactory().getVarFactory().createVariableValue(variable, variableValue.getVariableType(), variableValue.isNegated(), (DfaVariableValue)eqQualifier))) == -1) continue;
            this.uniteClasses(i, classIndex);
            return i;
        }
        return classIndex;
    }

    private void addToMap(int id, int index) {
        int[] classes2 = (int[])this.myIdToEqClassesIndices.get(id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID());
        if (classes2 == null) {
            classes2 = new int[]{index};
            this.myIdToEqClassesIndices.put(id, (Object)classes2);
        } else {
            classes2 = ArrayUtil.append((int[])classes2, (int)index);
            this.myIdToEqClassesIndices.put(id, (Object)classes2);
        }
    }

    private void removeFromMap(int id, int index) {
        int i;
        int[] classes2 = (int[])this.myIdToEqClassesIndices.get(id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID());
        if (classes2 != null && (i = ArrayUtil.indexOf((int[])classes2, (int)index)) != -1) {
            classes2 = ArrayUtil.remove((int[])classes2, (int)i);
            this.myIdToEqClassesIndices.put(id, (Object)classes2);
        }
    }

    private void removeAllFromMap(int id) {
        if (id < 0) {
            return;
        }
        id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID();
        this.myIdToEqClassesIndices.remove(id);
    }

    public boolean isSuperStateOf(DfaMemoryStateImpl that) {
        if (!(this.equalsSuperficially(that) && this.equalsByUnknownVariables(that) && this.getNonTrivialEqClasses().equals(that.getNonTrivialEqClasses()) && that.getDistinctClassPairs().containsAll(this.getDistinctClassPairs()))) {
            return false;
        }
        if (this.myVariableStates.size() != that.myVariableStates.size()) {
            return false;
        }
        for (Map.Entry<DfaVariableValue, DfaVariableState> entry : this.myVariableStates.entrySet()) {
            DfaVariableState thatState;
            DfaVariableState thisState = entry.getValue();
            if (Objects.equals(thisState, thatState = that.myVariableStates.get(entry.getKey())) || thatState != null && thisState != null && thisState.isSuperStateOf(thatState)) continue;
            return false;
        }
        return true;
    }

    private static boolean canBeInRelation(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "canBeInRelation"));
        }
        DfaValue unwrapped = DfaMemoryStateImpl.unwrap(dfaValue);
        return unwrapped instanceof DfaVariableValue || unwrapped instanceof DfaConstValue;
    }

    @NotNull
    List<DfaValue> getEquivalentValues(@NotNull DfaValue dfaValue) {
        EqClass set2;
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getEquivalentValues"));
        }
        int index = this.getEqClassIndex(dfaValue);
        EqClass eqClass = set2 = index == -1 ? null : this.myEqClasses.get(index);
        if (set2 == null) {
            List<DfaValue> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getEquivalentValues"));
            }
            return list2;
        }
        List<DfaValue> list3 = set2.getMemberValues();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getEquivalentValues"));
        }
        return list3;
    }

    private boolean canBeNaN(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "canBeNaN"));
        }
        for (DfaValue eq : this.getEquivalentValues(dfaValue)) {
            if (eq instanceof DfaBoxedValue) {
                eq = ((DfaBoxedValue)eq).getWrappedValue();
            }
            if (!(eq instanceof DfaConstValue) || DfaMemoryStateImpl.isNaN(eq)) continue;
            return false;
        }
        return dfaValue instanceof DfaVariableValue && TypeConversionUtil.isFloatOrDoubleType((PsiType)((DfaVariableValue)dfaValue).getVariableType());
    }

    private boolean isEffectivelyNaN(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "isEffectivelyNaN"));
        }
        for (DfaValue eqClass : this.getEquivalentValues(dfaValue)) {
            if (!DfaMemoryStateImpl.isNaN(eqClass)) continue;
            return true;
        }
        return false;
    }

    private int getEqClassIndex(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getEqClassIndex"));
        }
        int id = DfaMemoryStateImpl.unwrap(dfaValue).getID();
        int[] classes2 = (int[])this.myIdToEqClassesIndices.get(id);
        int result2 = -1;
        if (classes2 != null) {
            for (int index : classes2) {
                EqClass aClass = this.myEqClasses.get(index);
                if (!aClass.contains(dfaValue.getID())) continue;
                if (!this.canBeReused(dfaValue) && aClass.size() > 1) break;
                result2 = index;
                break;
            }
        }
        return result2;
    }

    private boolean canBeReused(@NotNull DfaValue dfaValue) {
        if (dfaValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "canBeReused"));
        }
        if (dfaValue instanceof DfaBoxedValue) {
            DfaValue valueToWrap = ((DfaBoxedValue)dfaValue).getWrappedValue();
            if (valueToWrap instanceof DfaConstValue) {
                return DfaMemoryStateImpl.cacheable((DfaConstValue)valueToWrap);
            }
            if (valueToWrap instanceof DfaVariableValue) {
                if (PsiType.BOOLEAN.equals((Object)((DfaVariableValue)valueToWrap).getVariableType())) {
                    return true;
                }
                for (DfaValue value2 : this.getEquivalentValues(valueToWrap)) {
                    if (!(value2 instanceof DfaConstValue) || !DfaMemoryStateImpl.cacheable((DfaConstValue)value2)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean cacheable(@NotNull DfaConstValue dfaConstValue) {
        if (dfaConstValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaConstValue", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "cacheable"));
        }
        Object value2 = dfaConstValue.getValue();
        return DfaMemoryStateImpl.box(value2) == DfaMemoryStateImpl.box(value2);
    }

    private static Object box(Object value2) {
        Constable newBoxedValue;
        if (value2 instanceof Integer) {
            newBoxedValue = (int)((Integer)value2);
        } else if (value2 instanceof Byte) {
            newBoxedValue = (byte)((Byte)value2);
        } else if (value2 instanceof Short) {
            newBoxedValue = (short)((Short)value2);
        } else if (value2 instanceof Long) {
            newBoxedValue = (long)((Long)value2);
        } else if (value2 instanceof Boolean) {
            newBoxedValue = (Boolean)value2;
        } else if (value2 instanceof Character) {
            newBoxedValue = Character.valueOf(((Character)value2).charValue());
        } else {
            return new Object();
        }
        return newBoxedValue;
    }

    private boolean uniteClasses(int c1Index, int c2Index) {
        int i;
        long[] distincts;
        EqClass c1 = this.myEqClasses.get(c1Index);
        EqClass c2 = this.myEqClasses.get(c2Index);
        THashSet vars = ContainerUtil.newTroveSet();
        THashSet negatedVars = ContainerUtil.newTroveSet();
        int[] cs = new int[c1.size() + c2.size()];
        c1.set(0, cs, 0, c1.size());
        c2.set(0, cs, c1.size(), c2.size());
        int nConst = 0;
        for (int c : cs) {
            DfaValue dfaValue = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(c));
            if (dfaValue instanceof DfaConstValue) {
                ++nConst;
            }
            if (dfaValue instanceof DfaVariableValue) {
                DfaVariableValue variableValue = (DfaVariableValue)dfaValue;
                if (variableValue.isNegated()) {
                    negatedVars.add(variableValue.createNegated());
                } else {
                    vars.add(variableValue);
                }
            }
            if (nConst <= 1) continue;
            return false;
        }
        if (ContainerUtil.intersects((Collection)vars, (Collection)negatedVars)) {
            return false;
        }
        TLongArrayList c2Pairs = new TLongArrayList();
        for (long distinct : distincts = this.myDistinctClasses.toArray()) {
            int pc1 = DfaMemoryStateImpl.low(distinct);
            int pc2 = DfaMemoryStateImpl.high(distinct);
            boolean addedToC1 = false;
            if (pc1 == c1Index || pc2 == c1Index) {
                addedToC1 = true;
            }
            if (pc1 != c2Index && pc2 != c2Index) continue;
            if (addedToC1) {
                return false;
            }
            c2Pairs.add(distinct);
        }
        EqClass newClass = new EqClass(c1);
        this.myEqClasses.set(c1Index, newClass);
        for (i = 0; i < c2.size(); ++i) {
            int c = c2.get(i);
            newClass.add(c);
            this.removeFromMap(c, c2Index);
            this.addToMap(c, c1Index);
        }
        for (i = 0; i < c2Pairs.size(); ++i) {
            long c = c2Pairs.get(i);
            this.myDistinctClasses.remove(c);
            this.myDistinctClasses.add(DfaMemoryStateImpl.createPair(c1Index, DfaMemoryStateImpl.low(c) == c2Index ? DfaMemoryStateImpl.high(c) : DfaMemoryStateImpl.low(c)));
        }
        this.myEqClasses.set(c2Index, null);
        return true;
    }

    private static int low(long l) {
        return (int)l;
    }

    private static int high(long l) {
        return (int)((l & 0xFFFFFFFF00000000L) >> 32);
    }

    private static long createPair(int i1, int i2) {
        if (i1 < i2) {
            long l = i1;
            l <<= 32;
            return l += (long)i2;
        }
        long l = i2;
        l <<= 32;
        return l += (long)i1;
    }

    private void makeClassesDistinct(int c1Index, int c2Index) {
        this.myDistinctClasses.add(DfaMemoryStateImpl.createPair(c1Index, c2Index));
    }

    @Override
    public boolean isNull(DfaValue dfaValue) {
        if (dfaValue instanceof DfaConstValue) {
            return ((DfaConstValue)dfaValue).getValue() == null;
        }
        if (dfaValue instanceof DfaVariableValue) {
            int c1Index = this.getEqClassIndex(dfaValue);
            return c1Index >= 0 && c1Index == this.getEqClassIndex(this.myFactory.getConstFactory().getNull());
        }
        return false;
    }

    @Override
    public boolean isNotNull(DfaValue dfaVar) {
        long[] pairs;
        if (dfaVar instanceof DfaConstValue) {
            return ((DfaConstValue)dfaVar).getValue() != null;
        }
        if (dfaVar instanceof DfaBoxedValue) {
            return true;
        }
        if (dfaVar instanceof DfaTypeValue) {
            return ((DfaTypeValue)dfaVar).isNotNull();
        }
        if (dfaVar instanceof DfaVariableValue) {
            if (this.getVariableState((DfaVariableValue)dfaVar).isNotNull()) {
                return true;
            }
            DfaConstValue constantValue = this.getConstantValue((DfaVariableValue)dfaVar);
            if (constantValue != null && constantValue.getValue() != null) {
                return true;
            }
        }
        DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
        int c1Index = this.getEqClassIndex(dfaVar);
        int c2Index = this.getEqClassIndex(dfaNull);
        if (c1Index < 0 || c2Index < 0) {
            return false;
        }
        for (long pair2 : pairs = this.myDistinctClasses.toArray()) {
            if ((c1Index != DfaMemoryStateImpl.low(pair2) || c2Index != DfaMemoryStateImpl.high(pair2)) && (c1Index != DfaMemoryStateImpl.high(pair2) || c2Index != DfaMemoryStateImpl.low(pair2))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public DfaConstValue getConstantValue(@NotNull DfaVariableValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getConstantValue"));
        }
        int index = this.getEqClassIndex(value2);
        EqClass ec = index == -1 ? null : this.myEqClasses.get(index);
        return ec == null ? null : (DfaConstValue)DfaMemoryStateImpl.unwrap(ec.findConstant(true));
    }

    @Override
    public void markEphemeral() {
        this.myEphemeral = true;
    }

    @Override
    public boolean isEphemeral() {
        return this.myEphemeral;
    }

    @Override
    public boolean applyInstanceofOrNull(@NotNull DfaRelationValue dfaCond) {
        if (dfaCond == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaCond", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyInstanceofOrNull"));
        }
        DfaValue left = DfaMemoryStateImpl.unwrap(dfaCond.getLeftOperand());
        if (!(left instanceof DfaVariableValue)) {
            return true;
        }
        DfaVariableValue dfaVar = (DfaVariableValue)left;
        DfaTypeValue dfaType = (DfaTypeValue)dfaCond.getRightOperand();
        if (this.isUnknownState(dfaVar) || this.isNull(dfaVar)) {
            return true;
        }
        DfaVariableState newState = this.getVariableState(dfaVar).withInstanceofValue(dfaType);
        if (newState != null) {
            this.setVariableState(dfaVar, newState);
            return true;
        }
        return false;
    }

    <T> void setFact(DfaValue target2, DfaFactType<T> factType, T fact) {
        if (target2 instanceof DfaVariableValue && !this.isUnknownState(target2)) {
            this.setVariableState((DfaVariableValue)target2, this.getVariableState((DfaVariableValue)target2).withFact(factType, fact));
        }
    }

    <T> boolean applyFact(DfaVariableValue target2, DfaFactType<T> factType, T range) {
        if (!this.isUnknownState(target2) && range != null) {
            DfaVariableState state = this.getVariableState(target2);
            DfaVariableState newState = state.intersectFact(factType, range);
            if (newState == null) {
                return false;
            }
            this.setVariableState(target2, newState);
        }
        return true;
    }

    static DfaValue unwrap(DfaValue value2) {
        if (value2 instanceof DfaBoxedValue) {
            return ((DfaBoxedValue)value2).getWrappedValue();
        }
        if (value2 instanceof DfaUnboxedValue) {
            return ((DfaUnboxedValue)value2).getVariable();
        }
        return value2;
    }

    @Override
    public boolean applyContractCondition(DfaValue condition2) {
        DfaRelationValue relation;
        if (condition2 instanceof DfaRelationValue && (relation = (DfaRelationValue)condition2).isEquality() && relation.getRightOperand() == this.myFactory.getConstFactory().getNull() && (relation.getLeftOperand() instanceof DfaUnknownValue || relation.getLeftOperand() instanceof DfaVariableValue && this.getVariableState((DfaVariableValue)relation.getLeftOperand()).getNullability() == Nullness.UNKNOWN)) {
            this.markEphemeral();
        }
        return this.applyCondition(condition2);
    }

    @Override
    public boolean applyCondition(DfaValue dfaCond) {
        if (dfaCond instanceof DfaUnknownValue) {
            return true;
        }
        if (dfaCond instanceof DfaUnboxedValue) {
            DfaVariableValue dfaVar = ((DfaUnboxedValue)dfaCond).getVariable();
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? dfaVar.createNegated() : dfaVar;
            DfaValue boxedTrue = this.myFactory.getBoxedFactory().createBoxed(this.myFactory.getConstFactory().getTrue());
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaNormalVar, DfaRelationValue.RelationType.equivalence(!isNegated), boxedTrue));
        }
        if (dfaCond instanceof DfaVariableValue) {
            DfaVariableValue dfaVar = (DfaVariableValue)dfaCond;
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? dfaVar.createNegated() : dfaVar;
            DfaConstValue dfaTrue = this.myFactory.getConstFactory().getTrue();
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaNormalVar, DfaRelationValue.RelationType.equivalence(!isNegated), dfaTrue));
        }
        if (dfaCond instanceof DfaConstValue) {
            return dfaCond == this.myFactory.getConstFactory().getTrue() || dfaCond != this.myFactory.getConstFactory().getFalse();
        }
        if (!(dfaCond instanceof DfaRelationValue)) {
            return true;
        }
        return this.applyRelationCondition((DfaRelationValue)dfaCond);
    }

    private boolean applyRelationCondition(@NotNull DfaRelationValue dfaRelation) {
        if (dfaRelation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaRelation", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyRelationCondition"));
        }
        DfaValue dfaLeft = dfaRelation.getLeftOperand();
        DfaValue dfaRight = dfaRelation.getRightOperand();
        if (dfaLeft instanceof DfaUnknownValue || dfaRight instanceof DfaUnknownValue) {
            return true;
        }
        DfaRelationValue.RelationType relationType = dfaRelation.getRelation();
        LongRangeSet left = this.getValueFact(DfaFactType.RANGE, dfaLeft);
        LongRangeSet right = this.getValueFact(DfaFactType.RANGE, dfaRight);
        if (left != null && right != null) {
            if (dfaLeft instanceof DfaVariableValue && !this.applyFact((DfaVariableValue)dfaLeft, DfaFactType.RANGE, right.fromRelation(relationType))) {
                return false;
            }
            if (dfaRight instanceof DfaVariableValue && !this.applyFact((DfaVariableValue)dfaRight, DfaFactType.RANGE, left.fromRelation(relationType.getFlipped()))) {
                return false;
            }
        }
        if (dfaLeft instanceof DfaVariableValue && dfaRight instanceof DfaOptionalValue && (relationType == DfaRelationValue.RelationType.IS || relationType == DfaRelationValue.RelationType.IS_NOT)) {
            boolean present = ((DfaOptionalValue)dfaRight).isPresent() == (relationType == DfaRelationValue.RelationType.IS);
            return this.applyFact((DfaVariableValue)dfaLeft, DfaFactType.OPTIONAL_PRESENCE, present);
        }
        if (dfaRight instanceof DfaTypeValue) {
            if (dfaLeft instanceof DfaVariableValue) {
                DfaVariableValue dfaVar = (DfaVariableValue)dfaLeft;
                if (this.isUnknownState(dfaVar)) {
                    return true;
                }
                DfaTypeValue typeValue = (DfaTypeValue)dfaRight;
                switch (relationType) {
                    case EQ: 
                    case NE: {
                        return !dfaRelation.isEquality() || !typeValue.isNotNull() || !this.isNull(dfaVar);
                    }
                    case IS_NOT: {
                        DfaVariableState newState = this.getVariableState(dfaVar).withNotInstanceofValue(typeValue);
                        if (newState != null) {
                            this.setVariableState(dfaVar, newState);
                            return true;
                        }
                        return !this.getVariableState(dfaVar).isNotNull() && this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), false);
                    }
                    case IS: {
                        DfaVariableState newState;
                        if (this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), true) && (newState = this.getVariableState(dfaVar).withInstanceofValue(typeValue)) != null) {
                            this.setVariableState(dfaVar, newState);
                            return true;
                        }
                        return false;
                    }
                }
            }
            return true;
        }
        if (this.isEffectivelyNaN(dfaLeft) || this.isEffectivelyNaN(dfaRight)) {
            this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
            return relationType == DfaRelationValue.RelationType.NE;
        }
        if (this.canBeNaN(dfaLeft) && this.canBeNaN(dfaRight)) {
            if (dfaLeft == dfaRight && dfaLeft instanceof DfaVariableValue && !(((DfaVariableValue)dfaLeft).getVariableType() instanceof PsiPrimitiveType)) {
                return !dfaRelation.isNonEquality();
            }
            this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
            return true;
        }
        return this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
    }

    private void updateVarStateOnComparison(@NotNull DfaVariableValue dfaVar, DfaValue value2) {
        if (dfaVar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaVar", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "updateVarStateOnComparison"));
        }
        if (!this.isUnknownState(dfaVar)) {
            if (value2 instanceof DfaConstValue && ((DfaConstValue)value2).getValue() == null) {
                this.setVariableState(dfaVar, this.getVariableState(dfaVar).withFact(DfaFactType.CAN_BE_NULL, true));
            } else if (this.isNotNull(value2) && !this.isNotNull(dfaVar)) {
                this.setVariableState(dfaVar, this.getVariableState(dfaVar).withoutFact(DfaFactType.CAN_BE_NULL));
                this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), true);
            }
        }
    }

    private boolean applyEquivalenceRelation(@NotNull DfaRelationValue dfaRelation, DfaValue dfaLeft, DfaValue dfaRight) {
        boolean containsCalls;
        if (dfaRelation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaRelation", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyEquivalenceRelation"));
        }
        boolean isNegated = dfaRelation.isNonEquality();
        if (!isNegated && !dfaRelation.isEquality()) {
            return true;
        }
        boolean bl = containsCalls = dfaLeft instanceof DfaVariableValue && ((DfaVariableValue)dfaLeft).containsCalls();
        if (containsCalls && !this.isNotNull(dfaLeft) && this.isNull(dfaRight) && !isNegated) {
            return true;
        }
        if (dfaLeft == dfaRight) {
            return containsCalls || !isNegated;
        }
        if (this.isNull(dfaLeft) && this.isNotNull(dfaRight) || this.isNull(dfaRight) && this.isNotNull(dfaLeft)) {
            return isNegated;
        }
        if (!isNegated) {
            if (dfaLeft instanceof DfaVariableValue) {
                this.updateVarStateOnComparison((DfaVariableValue)dfaLeft, dfaRight);
            }
            if (dfaRight instanceof DfaVariableValue) {
                this.updateVarStateOnComparison((DfaVariableValue)dfaRight, dfaLeft);
            }
        }
        if (!this.applyRelation(dfaLeft, dfaRight, isNegated)) {
            return false;
        }
        if (!this.checkCompareWithBooleanLiteral(dfaLeft, dfaRight, isNegated)) {
            return false;
        }
        if (dfaLeft instanceof DfaVariableValue) {
            if (!this.applyUnboxedRelation((DfaVariableValue)dfaLeft, dfaRight, isNegated)) {
                return false;
            }
            if (!this.applyBoxedRelation((DfaVariableValue)dfaLeft, dfaRight, isNegated)) {
                return false;
            }
        }
        if (!isNegated && dfaRight instanceof DfaOptionalValue) {
            this.setFact(dfaLeft, DfaFactType.OPTIONAL_PRESENCE, ((DfaOptionalValue)dfaRight).isPresent());
        }
        return true;
    }

    private boolean applyBoxedRelation(@NotNull DfaVariableValue dfaLeft, DfaValue dfaRight, boolean negated) {
        if (dfaLeft == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaLeft", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyBoxedRelation"));
        }
        if (!TypeConversionUtil.isPrimitiveAndNotNull((PsiType)dfaLeft.getVariableType())) {
            return true;
        }
        DfaBoxedValue.Factory boxedFactory = this.myFactory.getBoxedFactory();
        DfaValue boxedLeft = boxedFactory.createBoxed(dfaLeft);
        DfaValue boxedRight = boxedFactory.createBoxed(dfaRight);
        return boxedLeft == null || boxedRight == null || this.applyRelation(boxedLeft, boxedRight, negated);
    }

    private boolean applyUnboxedRelation(@NotNull DfaVariableValue dfaLeft, DfaValue dfaRight, boolean negated) {
        DfaValue unboxedRight;
        if (dfaLeft == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaLeft", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyUnboxedRelation"));
        }
        if (negated) {
            return true;
        }
        PsiType type2 = dfaLeft.getVariableType();
        if (!TypeConversionUtil.isPrimitiveWrapper((PsiType)type2)) {
            return true;
        }
        DfaBoxedValue.Factory boxedFactory = this.myFactory.getBoxedFactory();
        DfaValue unboxedLeft = boxedFactory.createUnboxed(dfaLeft);
        return this.applyRelation(unboxedLeft, unboxedRight = boxedFactory.createUnboxed(dfaRight), false) && this.checkCompareWithBooleanLiteral(unboxedLeft, unboxedRight, false);
    }

    private boolean checkCompareWithBooleanLiteral(DfaValue dfaLeft, DfaValue dfaRight, boolean negated) {
        Object constVal;
        if (dfaRight instanceof DfaConstValue && (constVal = ((DfaConstValue)dfaRight).getValue()) instanceof Boolean) {
            DfaConstValue negVal = this.myFactory.getConstFactory().createFromValue((Boolean)constVal == false, (PsiType)PsiType.BOOLEAN, null);
            if (!this.applyRelation(dfaLeft, negVal, !negated)) {
                return false;
            }
            if (!this.applyRelation(dfaLeft.createNegated(), negVal, negated)) {
                return false;
            }
        }
        return true;
    }

    static boolean isNaN(DfaValue dfa) {
        return dfa instanceof DfaConstValue && DfaUtil.isNaN(((DfaConstValue)dfa).getValue());
    }

    private boolean applyRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight, boolean isNegated) {
        if (dfaLeft == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaLeft", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyRelation"));
        }
        if (dfaRight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaRight", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "applyRelation"));
        }
        if (this.isUnknownState(dfaLeft) || this.isUnknownState(dfaRight)) {
            return true;
        }
        Integer c1Index = this.getOrCreateEqClassIndex(dfaLeft);
        Integer c2Index = this.getOrCreateEqClassIndex(dfaRight);
        if (c1Index == null || c2Index == null) {
            return true;
        }
        if (!isNegated) {
            if (c1Index.equals(c2Index) || this.areCompatibleConstants(c1Index, c2Index)) {
                return true;
            }
            if (!this.uniteClasses(c1Index, c2Index)) {
                return false;
            }
            for (long encodedPair : this.myDistinctClasses.toArray()) {
                EqClass c1 = this.myEqClasses.get(DfaMemoryStateImpl.low(encodedPair));
                EqClass c2 = this.myEqClasses.get(DfaMemoryStateImpl.high(encodedPair));
                DfaConstValue const1 = (DfaConstValue)c1.findConstant(false);
                DfaConstValue const2 = (DfaConstValue)c2.findConstant(false);
                if (const1 == null || const2 == null || DfaMemoryStateImpl.preserveConstantDistinction(const1.getValue(), const2.getValue())) continue;
                this.myDistinctClasses.remove(encodedPair);
            }
            this.myCachedDistinctClassPairs = null;
            this.myCachedNonTrivialEqClasses = null;
            this.myCachedHash = null;
        } else {
            if (c1Index.equals(c2Index) || this.areCompatibleConstants(c1Index, c2Index)) {
                return false;
            }
            if (this.isNull(dfaLeft) && DfaMemoryStateImpl.isPrimitive(dfaRight) || this.isNull(dfaRight) && DfaMemoryStateImpl.isPrimitive(dfaLeft)) {
                return true;
            }
            this.makeClassesDistinct(c1Index, c2Index);
            this.myCachedDistinctClassPairs = null;
            this.myCachedHash = null;
        }
        return true;
    }

    private static boolean isPrimitive(DfaValue value2) {
        return value2 instanceof DfaVariableValue && ((DfaVariableValue)value2).getVariableType() instanceof PsiPrimitiveType;
    }

    private static boolean preserveConstantDistinction(Object c1, Object c2) {
        return c1 == null && c2 instanceof PsiEnumConstant || c2 == null && c1 instanceof PsiEnumConstant;
    }

    private boolean areCompatibleConstants(int i1, int i2) {
        Double dv1 = this.getDoubleValue(i1);
        return dv1 != null && dv1.equals(this.getDoubleValue(i2));
    }

    @Nullable
    private Double getDoubleValue(int eqClassIndex) {
        EqClass ec = this.myEqClasses.get(eqClassIndex);
        DfaValue dfaConst = ec == null ? null : ec.findConstant(false);
        Object constValue = dfaConst instanceof DfaConstValue ? ((DfaConstValue)dfaConst).getValue() : null;
        return constValue instanceof Number ? Double.valueOf(((Number)constValue).doubleValue()) : null;
    }

    private boolean isUnknownState(DfaValue val) {
        if ((val = DfaMemoryStateImpl.unwrap(val)) instanceof DfaVariableValue) {
            if (this.myUnknownVariables.contains(val)) {
                return true;
            }
            DfaVariableValue negatedValue = ((DfaVariableValue)val).getNegatedValue();
            if (negatedValue != null && this.myUnknownVariables.contains(negatedValue)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkNotNullable(DfaValue value2) {
        if (value2 == this.myFactory.getConstFactory().getNull()) {
            return false;
        }
        if (value2 instanceof DfaTypeValue && ((DfaTypeValue)value2).isNullable()) {
            return false;
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue varValue = (DfaVariableValue)value2;
            if (varValue.getVariableType() instanceof PsiPrimitiveType) {
                return true;
            }
            if (this.isNotNull(varValue)) {
                return true;
            }
            if (this.getVariableState(varValue).getNullability() == Nullness.NULLABLE) {
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public <T> T getValueFact(@NotNull DfaFactType<T> factType, @NotNull DfaValue value2) {
        LongRangeSet range;
        if (factType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factType", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getValueFact"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getValueFact"));
        }
        if (factType == DfaFactType.RANGE && (range = this.getRange(value2)) != null) {
            return (T)range;
        }
        if (value2 instanceof DfaVariableValue) {
            T fact;
            DfaVariableState state = this.myVariableStates.get((DfaVariableValue)value2);
            if (state != null && (fact = state.getFact(factType)) != null) {
                return fact;
            }
            DfaConstValue constValue = this.getConstantValue((DfaVariableValue)value2);
            if (constValue != null) {
                value2 = constValue;
            }
        }
        return factType.fromDfaValue(value2);
    }

    @Nullable
    private LongRangeSet getRange(DfaValue value2) {
        DfaConstValue constValue;
        DfaVariableValue qualifier;
        DfaVariableValue var;
        if (value2 instanceof DfaVariableValue && (var = (DfaVariableValue)value2).getPsiVariable() instanceof PsiMethod && MethodUtils.isStringLength((PsiMethod)var.getPsiVariable()) && (qualifier = var.getQualifier()) != null && (constValue = this.getConstantValue(qualifier)) != null && constValue.getValue() instanceof String) {
            return LongRangeSet.point(((String)constValue.getValue()).length());
        }
        return null;
    }

    void setVariableState(DfaVariableValue dfaVar, DfaVariableState state) {
        assert (!this.myUnknownVariables.contains(dfaVar));
        if (state.equals(this.myDefaultVariableStates.get(dfaVar))) {
            this.myVariableStates.remove(dfaVar);
        } else {
            this.myVariableStates.put(dfaVar, state);
        }
        this.myCachedHash = null;
    }

    DfaVariableState getVariableState(DfaVariableValue dfaVar) {
        DfaVariableState state = this.myVariableStates.get(dfaVar);
        if (state == null) {
            state = this.myDefaultVariableStates.get(dfaVar);
            if (state == null) {
                state = this.createVariableState(dfaVar);
                DfaTypeValue initialType = dfaVar.getTypeValue();
                if (initialType != null) {
                    state = state.withInstanceofValue(initialType);
                    assert (state != null);
                }
                this.myDefaultVariableStates.put(dfaVar, state);
            }
            if (this.isUnknownState(dfaVar)) {
                return state.withNotNull();
            }
        }
        return state;
    }

    @NotNull
    Map<DfaVariableValue, DfaVariableState> getVariableStates() {
        LinkedHashMap<DfaVariableValue, DfaVariableState> linkedHashMap = this.myVariableStates;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getVariableStates"));
        }
        return linkedHashMap;
    }

    @NotNull
    protected DfaVariableState createVariableState(@NotNull DfaVariableValue var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "createVariableState"));
        }
        DfaVariableState dfaVariableState = new DfaVariableState(var);
        if (dfaVariableState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "createVariableState"));
        }
        return dfaVariableState;
    }

    @Override
    public void flushFields() {
        LinkedHashSet vars = ContainerUtil.newLinkedHashSet(this.getChangedVariables());
        for (EqClass aClass : this.myEqClasses) {
            if (aClass == null) continue;
            vars.addAll(aClass.getVariables(true));
        }
        for (DfaVariableValue value2 : vars) {
            if (!value2.isFlushableByCalls()) continue;
            this.doFlush(value2, this.shouldMarkUnknown(value2));
        }
    }

    private boolean shouldMarkUnknown(@NotNull DfaVariableValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "shouldMarkUnknown"));
        }
        int eqClassIndex = this.getEqClassIndex(value2);
        if (eqClassIndex < 0) {
            return false;
        }
        EqClass eqClass = this.myEqClasses.get(eqClassIndex);
        if (eqClass == null) {
            return false;
        }
        if (eqClass.findConstant(true) != null) {
            return true;
        }
        for (UnorderedPair unorderedPair : this.getDistinctClassPairs()) {
            if ((unorderedPair.first != eqClass || ((EqClass)unorderedPair.second).findConstant(true) == null) && (unorderedPair.second != eqClass || ((EqClass)unorderedPair.first).findConstant(true) == null)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    Set<DfaVariableValue> getChangedVariables() {
        Set<DfaVariableValue> set2 = this.myVariableStates.keySet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getChangedVariables"));
        }
        return set2;
    }

    @Override
    public void flushVariable(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "flushVariable"));
        }
        List updatedStack = ContainerUtil.map(this.myStack, value2 -> {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "lambda$flushVariable$3"));
            }
            return this.handleFlush(variable, (DfaValue)value2);
        });
        this.myStack.clear();
        for (DfaValue value3 : updatedStack) {
            this.myStack.push((Object)value3);
        }
        this.doFlush(variable, false);
        this.flushDependencies(variable);
        this.myUnknownVariables.remove(variable);
        this.myUnknownVariables.removeAll(this.myFactory.getVarFactory().getAllQualifiedBy(variable));
        this.myCachedHash = null;
    }

    void flushDependencies(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "flushDependencies"));
        }
        for (DfaVariableValue dependent : this.myFactory.getVarFactory().getAllQualifiedBy(variable)) {
            this.doFlush(dependent, false);
        }
    }

    @NotNull
    Set<DfaVariableValue> getUnknownVariables() {
        LinkedHashSet<DfaVariableValue> linkedHashSet = this.myUnknownVariables;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "getUnknownVariables"));
        }
        return linkedHashSet;
    }

    void doFlush(@NotNull DfaVariableValue varPlain, boolean markUnknown) {
        if (varPlain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varPlain", "com/intellij/codeInspection/dataFlow/DfaMemoryStateImpl", "doFlush"));
        }
        DfaVariableValue varNegated = varPlain.getNegatedValue();
        int idPlain = varPlain.getID();
        int idNegated = varNegated == null ? -1 : varNegated.getID();
        int[] classes2 = (int[])this.myIdToEqClassesIndices.get(idPlain);
        int[] negatedClasses = (int[])this.myIdToEqClassesIndices.get(idNegated);
        int[] result2 = ArrayUtil.mergeArrays((int[])((int[])ObjectUtils.notNull((Object)classes2, (Object)ArrayUtil.EMPTY_INT_ARRAY)), (int[])((int[])ObjectUtils.notNull((Object)negatedClasses, (Object)ArrayUtil.EMPTY_INT_ARRAY)));
        int interruptCount = 0;
        for (int varClassIndex : result2) {
            TLongIterator iterator;
            EqClass varClass = this.myEqClasses.get(varClassIndex);
            if ((++interruptCount & 0xF) == 0) {
                ProgressManager.checkCanceled();
            }
            varClass = new EqClass(varClass);
            this.myEqClasses.set(varClassIndex, varClass);
            for (int id : varClass.toNativeArray()) {
                int idUnwrapped;
                if (id != idPlain && id != idNegated && (idUnwrapped = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID()) != idPlain && idUnwrapped != idNegated) continue;
                varClass.removeValue(id);
            }
            if (varClass.isEmpty()) {
                this.myEqClasses.set(varClassIndex, null);
                iterator = this.myDistinctClasses.iterator();
                while (iterator.hasNext()) {
                    long pair2 = iterator.next();
                    if (DfaMemoryStateImpl.low(pair2) != varClassIndex && DfaMemoryStateImpl.high(pair2) != varClassIndex) continue;
                    iterator.remove();
                }
                continue;
            }
            if (!varClass.containsConstantsOnly()) continue;
            iterator = this.myDistinctClasses.iterator();
            while (iterator.hasNext()) {
                long pair3 = iterator.next();
                if ((DfaMemoryStateImpl.low(pair3) != varClassIndex || !this.myEqClasses.get(DfaMemoryStateImpl.high(pair3)).containsConstantsOnly()) && (DfaMemoryStateImpl.high(pair3) != varClassIndex || !this.myEqClasses.get(DfaMemoryStateImpl.low(pair3)).containsConstantsOnly())) continue;
                iterator.remove();
            }
        }
        this.removeAllFromMap(idPlain);
        this.removeAllFromMap(idNegated);
        this.myVariableStates.remove(varPlain);
        if (varNegated != null) {
            this.myVariableStates.remove(varNegated);
        }
        if (markUnknown) {
            this.myUnknownVariables.add(varPlain);
        }
        this.myCachedNonTrivialEqClasses = null;
        this.myCachedDistinctClassPairs = null;
        this.myCachedHash = null;
    }

    private class MyIdMap
    extends TIntObjectHashMap<int[]> {
        private MyIdMap(int initialCapacity) {
            super(initialCapacity);
        }

        public String toString() {
            final StringBuilder s = new StringBuilder("{");
            this.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<int[]>(){

                public boolean execute(int id, int[] set2) {
                    DfaValue value2 = DfaMemoryStateImpl.this.myFactory.getValue(id);
                    s.append(value2).append(" -> ").append(Arrays.toString(set2)).append(", ");
                    return true;
                }
            });
            s.append("}");
            return s.toString();
        }
    }
}

