/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.ValuableDataFlowRunner;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.LambdaInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaUtil {
    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    public static Collection<PsiExpression> getCachedVariableValues(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        Collection concatenations;
        if (variable == null || context == null) {
            return Collections.emptyList();
        }
        PsiElement codeBlock = DfaPsiUtil.getEnclosingCodeBlock(variable, context);
        if (codeBlock == null) {
            return Collections.emptyList();
        }
        Map<PsiElement, ValuableInstructionVisitor.PlaceResult> value2 = DfaUtil.getCachedPlaceResults(codeBlock);
        if (value2 == null) {
            return null;
        }
        ValuableInstructionVisitor.PlaceResult placeResult = value2.get(context);
        Collection collection = concatenations = placeResult == null ? null : placeResult.myValues.get((Object)variable);
        if (concatenations != null) {
            return ContainerUtil.map((Collection)concatenations, DfaUtil::concatenateExpressions);
        }
        return Collections.emptyList();
    }

    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    private static Map<PsiElement, ValuableInstructionVisitor.PlaceResult> getCachedPlaceResults(@NotNull PsiElement codeBlock) {
        if (codeBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeBlock", "com/intellij/codeInspection/dataFlow/DfaUtil", "getCachedPlaceResults"));
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)codeBlock, () -> {
            if (codeBlock == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeBlock", "com/intellij/codeInspection/dataFlow/DfaUtil", "lambda$getCachedPlaceResults$0"));
            }
            ValuableInstructionVisitor visitor = new ValuableInstructionVisitor();
            RunnerResult runnerResult = new ValuableDataFlowRunner().analyzeMethod(codeBlock, visitor);
            return CachedValueProvider.Result.create(runnerResult == RunnerResult.OK ? visitor.myResults : null, (Object[])new Object[]{codeBlock});
        });
    }

    @NotNull
    public static Nullness checkNullness(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        ValuableInstructionVisitor.PlaceResult placeResult;
        if (variable == null || context == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
            }
            return nullness;
        }
        PsiElement codeBlock = DfaPsiUtil.getEnclosingCodeBlock(variable, context);
        Map<PsiElement, ValuableInstructionVisitor.PlaceResult> results = codeBlock == null ? null : DfaUtil.getCachedPlaceResults(codeBlock);
        ValuableInstructionVisitor.PlaceResult placeResult2 = placeResult = results == null ? null : results.get(context);
        if (placeResult == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
            }
            return nullness;
        }
        if (placeResult.myNulls.contains(variable) && !placeResult.myNotNulls.contains(variable)) {
            Nullness nullness = Nullness.NULLABLE;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
            }
            return nullness;
        }
        if (placeResult.myNotNulls.contains(variable) && !placeResult.myNulls.contains(variable)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
        }
        return nullness;
    }

    @NotNull
    public static Collection<PsiExpression> getPossibleInitializationElements(@NotNull PsiElement qualifierExpression2) {
        if (qualifierExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
        }
        if (qualifierExpression2 instanceof PsiMethodCallExpression) {
            List<PsiMethodCallExpression> list2 = Collections.singletonList((PsiMethodCallExpression)qualifierExpression2);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
            }
            return list2;
        }
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiElement targetElement = ((PsiReferenceExpression)qualifierExpression2).resolve();
            if (!(targetElement instanceof PsiVariable)) {
                List<PsiExpression> list3 = Collections.emptyList();
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
                }
                return list3;
            }
            Collection<PsiExpression> variableValues = DfaUtil.getCachedVariableValues((PsiVariable)targetElement, qualifierExpression2);
            if (variableValues == null || variableValues.isEmpty()) {
                Collection<PsiExpression> collection = DfaPsiUtil.getVariableAssignmentsInFile((PsiVariable)targetElement, false, qualifierExpression2);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
                }
                return collection;
            }
            Collection<PsiExpression> collection = variableValues;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
            }
            return collection;
        }
        if (qualifierExpression2 instanceof PsiLiteralExpression) {
            List<PsiLiteralExpression> list4 = Collections.singletonList((PsiLiteralExpression)qualifierExpression2);
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
            }
            return list4;
        }
        List<PsiExpression> list5 = Collections.emptyList();
        if (list5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
        }
        return list5;
    }

    @Nullable
    static PsiElement getClosureInside(Instruction instruction) {
        if (instruction instanceof MethodCallInstruction) {
            PsiCall anchor = ((MethodCallInstruction)instruction).getCallExpression();
            if (anchor instanceof PsiNewExpression) {
                return ((PsiNewExpression)anchor).getAnonymousClass();
            }
        } else {
            PsiElement anchor;
            if (instruction instanceof LambdaInstruction) {
                return ((LambdaInstruction)instruction).getLambdaExpression();
            }
            if (instruction instanceof EmptyInstruction && (anchor = ((EmptyInstruction)instruction).getAnchor()) instanceof PsiClass) {
                return anchor;
            }
        }
        return null;
    }

    @NotNull
    public static Nullness inferMethodNullity(PsiMethod method) {
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null || PsiUtil.resolveClassInType((PsiType)method.getReturnType()) == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "inferMethodNullity"));
            }
            return nullness;
        }
        Nullness nullness = DfaUtil.inferBlockNullity((PsiElement)body2, InferenceFromSourceUtil.suppressNullable(method));
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "inferMethodNullity"));
        }
        return nullness;
    }

    @NotNull
    public static Nullness inferLambdaNullity(PsiLambdaExpression lambda2) {
        PsiElement body2 = lambda2.getBody();
        if (body2 == null || LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2) == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "inferLambdaNullity"));
            }
            return nullness;
        }
        Nullness nullness = DfaUtil.inferBlockNullity(body2, false);
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "inferLambdaNullity"));
        }
        return nullness;
    }

    @NotNull
    private static Nullness inferBlockNullity(final PsiElement body2, boolean suppressNullable) {
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner();
        final AtomicBoolean hasNulls = new AtomicBoolean();
        final AtomicBoolean hasNotNulls = new AtomicBoolean();
        final AtomicBoolean hasUnknowns = new AtomicBoolean();
        RunnerResult rc = dfaRunner.analyzeMethod(body2, new StandardInstructionVisitor(){

            @Override
            public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                if (PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)instruction.getReturn(), (boolean)false)) {
                    DfaValue returned = memState.peek();
                    if (memState.isNull(returned)) {
                        hasNulls.set(true);
                    } else if (memState.isNotNull(returned)) {
                        hasNotNulls.set(true);
                    } else {
                        hasUnknowns.set(true);
                    }
                }
                return super.visitCheckReturnValue(instruction, runner, memState);
            }
        });
        if (rc == RunnerResult.OK) {
            if (hasNulls.get()) {
                Nullness nullness = suppressNullable ? Nullness.UNKNOWN : Nullness.NULLABLE;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "inferBlockNullity"));
                }
                return nullness;
            }
            if (hasNotNulls.get() && !hasUnknowns.get()) {
                Nullness nullness = Nullness.NOT_NULL;
                if (nullness == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "inferBlockNullity"));
                }
                return nullness;
            }
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "inferBlockNullity"));
        }
        return nullness;
    }

    private static PsiExpression concatenateExpressions(FList<PsiExpression> concatenation) {
        if (concatenation.size() == 1) {
            return (PsiExpression)concatenation.getHead();
        }
        String text2 = StringUtil.join((Collection)ContainerUtil.reverse(new ArrayList<PsiExpression>((Collection<PsiExpression>)concatenation)), expression2 -> expression2.getText(), (String)"+");
        try {
            return JavaPsiFacade.getElementFactory((Project)((PsiExpression)concatenation.getHead()).getProject()).createExpressionFromText(text2, (PsiElement)concatenation.getHead());
        }
        catch (IncorrectOperationException e) {
            return (PsiExpression)concatenation.getHead();
        }
    }

    public static boolean isNaN(Object value2) {
        if (value2 instanceof Double && ((Double)value2).isNaN()) {
            return true;
        }
        return value2 instanceof Float && ((Float)value2).isNaN();
    }

    private static class ValuableInstructionVisitor
    extends StandardInstructionVisitor {
        final Map<PsiElement, PlaceResult> myResults = ContainerUtil.newHashMap();

        private ValuableInstructionVisitor() {
        }

        @Override
        public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            PsiExpression place = instruction.getPlace();
            if (place != null) {
                PsiModifierListOwner element;
                PlaceResult result2 = this.myResults.computeIfAbsent((PsiElement)place, __ -> new PlaceResult());
                Map<DfaVariableValue, DfaVariableState> map2 = ((ValuableDataFlowRunner.MyDfaMemoryState)memState).getVariableStates();
                for (Map.Entry<DfaVariableValue, DfaVariableState> entry : map2.entrySet()) {
                    PsiModifierListOwner element2;
                    ValuableDataFlowRunner.ValuableDfaVariableState state = (ValuableDataFlowRunner.ValuableDfaVariableState)entry.getValue();
                    DfaVariableValue variableValue = entry.getKey();
                    FList<PsiExpression> concatenation = state.myConcatenation;
                    if (concatenation.isEmpty() || variableValue.getQualifier() != null || !((element2 = variableValue.getPsiVariable()) instanceof PsiVariable)) continue;
                    result2.myValues.put((Object)((PsiVariable)element2), concatenation);
                }
                DfaValue value2 = instruction.getValue();
                if (value2 instanceof DfaVariableValue && ((DfaVariableValue)value2).getQualifier() == null && (element = ((DfaVariableValue)value2).getPsiVariable()) instanceof PsiVariable) {
                    if (memState.isNotNull(value2)) {
                        result2.myNotNulls.add((PsiVariable)element);
                    }
                    if (memState.isNull(value2)) {
                        result2.myNulls.add((PsiVariable)element);
                    }
                }
            }
            return super.visitPush(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState _memState) {
            Instruction nextInstruction = runner.getInstruction(instruction.getIndex() + 1);
            ValuableDataFlowRunner.MyDfaMemoryState memState = (ValuableDataFlowRunner.MyDfaMemoryState)_memState;
            DfaValue dfaSource = memState.pop();
            DfaValue dfaDest = memState.pop();
            if (dfaDest instanceof DfaVariableValue) {
                DfaVariableValue var = (DfaVariableValue)dfaDest;
                PsiExpression rightValue = instruction.getRExpression();
                PsiElement parent = rightValue == null ? null : rightValue.getParent();
                IElementType type2 = parent instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)parent).getOperationTokenType() : JavaTokenType.EQ;
                FList<PsiExpression> prevValue = ((ValuableDataFlowRunner.ValuableDfaVariableState)memState.getVariableState((DfaVariableValue)var)).myConcatenation;
                memState.setVarValue(var, dfaSource);
                ValuableDataFlowRunner.ValuableDfaVariableState curState = (ValuableDataFlowRunner.ValuableDfaVariableState)memState.getVariableState(var);
                FList curValue = curState.myConcatenation;
                FList nextValue = type2 == JavaTokenType.PLUSEQ && !prevValue.isEmpty() && rightValue != null ? prevValue.prepend((Object)rightValue) : (curValue.isEmpty() && rightValue != null ? curValue.prepend((Object)rightValue) : curValue);
                memState.setVariableState(var, curState.withExpression((FList<PsiExpression>)nextValue));
            }
            memState.push(dfaDest);
            return new DfaInstructionState[]{new DfaInstructionState(nextInstruction, memState)};
        }

        static class PlaceResult {
            final MultiValuesMap<PsiVariable, FList<PsiExpression>> myValues = new MultiValuesMap(true);
            final Set<PsiVariable> myNulls = new THashSet();
            final Set<PsiVariable> myNotNulls = new THashSet();

            PlaceResult() {
            }
        }
    }
}

