/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HardcodedContracts {
    private static final Pattern FIRST_OR_LAST = Pattern.compile("first|last");
    private static final Pattern CONTAINS_KEY_VALUE = Pattern.compile("containsKey|containsValue");
    private static final Pattern ARRAY_RANGED_METHODS = Pattern.compile("binarySearch|fill|parallelPrefix|parallelSort|sort|spliterator|stream");
    private static final List<MethodContract> ARRAY_RANGE_CONTRACTS = ContainerUtil.immutableList((Object[])new MethodContract[]{HardcodedContracts.nonnegativeArgumentContract(1), HardcodedContracts.nonnegativeArgumentContract(2), MethodContract.singleConditionContract(ContractValue.argument(1), DfaRelationValue.RelationType.GT, ContractValue.argument(0).specialField(SpecialField.ARRAY_LENGTH), MethodContract.ValueConstraint.THROW_EXCEPTION), MethodContract.singleConditionContract(ContractValue.argument(2), DfaRelationValue.RelationType.GT, ContractValue.argument(0).specialField(SpecialField.ARRAY_LENGTH), MethodContract.ValueConstraint.THROW_EXCEPTION), MethodContract.singleConditionContract(ContractValue.argument(1), DfaRelationValue.RelationType.GT, ContractValue.argument(2), MethodContract.ValueConstraint.THROW_EXCEPTION)});

    public static List<MethodContract> getHardcodedContracts(@NotNull PsiMethod method, @Nullable PsiMethodCallExpression call) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/HardcodedContracts", "getHardcodedContracts"));
        }
        PsiClass owner2 = method.getContainingClass();
        if (owner2 == null || InjectedLanguageManager.getInstance((Project)owner2.getProject()).isInjectedFragment(owner2.getContainingFile())) {
            return Collections.emptyList();
        }
        int paramCount = method.getParameterList().getParametersCount();
        String className = owner2.getQualifiedName();
        if (className == null) {
            return Collections.emptyList();
        }
        String methodName = method.getName();
        if ("java.lang.System".equals(className)) {
            if ("exit".equals(methodName)) {
                return Collections.singletonList(new StandardMethodContract(StandardMethodContract.createConstraintArray(paramCount), MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
        } else if ("com.google.common.base.Preconditions".equals(className)) {
            if ("checkNotNull".equals(methodName) && paramCount > 0) {
                return HardcodedContracts.failIfNull(0, paramCount);
            }
            if (("checkArgument".equals(methodName) || "checkState".equals(methodName)) && paramCount > 0) {
                MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                constraints[0] = MethodContract.ValueConstraint.FALSE_VALUE;
                return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
        } else if ("java.util.Objects".equals(className)) {
            if ("requireNonNull".equals(methodName) && paramCount > 0) {
                return HardcodedContracts.failIfNull(0, paramCount);
            }
        } else if ("java.lang.String".equals(className)) {
            if (("charAt".equals(methodName) || "codePointAt".equals(methodName)) && paramCount == 1) {
                return Arrays.asList(HardcodedContracts.nonnegativeArgumentContract(0), HardcodedContracts.specialFieldRangeContract(0, DfaRelationValue.RelationType.LT, SpecialField.STRING_LENGTH));
            }
            if (("substring".equals(methodName) || "subSequence".equals(methodName)) && paramCount <= 2) {
                ArrayList<MethodContract> contracts2 = new ArrayList<MethodContract>(5);
                contracts2.add(HardcodedContracts.nonnegativeArgumentContract(0));
                contracts2.add(HardcodedContracts.specialFieldRangeContract(0, DfaRelationValue.RelationType.LE, SpecialField.STRING_LENGTH));
                if (paramCount == 2) {
                    contracts2.add(HardcodedContracts.nonnegativeArgumentContract(1));
                    contracts2.add(HardcodedContracts.specialFieldRangeContract(1, DfaRelationValue.RelationType.LE, SpecialField.STRING_LENGTH));
                    contracts2.add(MethodContract.singleConditionContract(ContractValue.argument(0), DfaRelationValue.RelationType.LE.getNegated(), ContractValue.argument(1), MethodContract.ValueConstraint.THROW_EXCEPTION));
                }
                return contracts2;
            }
            if ("isEmpty".equals(methodName) && paramCount == 0) {
                return SpecialField.STRING_LENGTH.getEmptyContracts();
            }
        } else {
            if (MethodUtils.methodMatches(method, "java.util.Collection", (PsiType)PsiType.BOOLEAN, "isEmpty", new PsiType[0])) {
                return SpecialField.COLLECTION_SIZE.getEmptyContracts();
            }
            if (MethodUtils.methodMatches(method, "java.util.Collection", (PsiType)PsiType.BOOLEAN, "contains", new PsiType[]{null})) {
                return Collections.singletonList(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), DfaRelationValue.RelationType.EQ, ContractValue.zero(), MethodContract.ValueConstraint.FALSE_VALUE));
            }
            if (MethodUtils.methodMatches(method, "java.util.Set", (PsiType)PsiType.BOOLEAN, "equals", new PsiType[]{null}) || MethodUtils.methodMatches(method, "java.util.List", (PsiType)PsiType.BOOLEAN, "equals", new PsiType[]{null})) {
                return Collections.singletonList(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), DfaRelationValue.RelationType.NE, ContractValue.argument(0).specialField(SpecialField.COLLECTION_SIZE), MethodContract.ValueConstraint.FALSE_VALUE));
            }
            if (MethodUtils.methodMatches(method, "java.util.List", null, "get", new PsiType[]{PsiType.INT})) {
                return Arrays.asList(HardcodedContracts.nonnegativeArgumentContract(0), HardcodedContracts.specialFieldRangeContract(0, DfaRelationValue.RelationType.LT, SpecialField.COLLECTION_SIZE));
            }
            if (MethodUtils.methodMatches(method, "java.util.SortedSet", null, FIRST_OR_LAST, new PsiType[0])) {
                return Collections.singletonList(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), DfaRelationValue.RelationType.EQ, ContractValue.zero(), MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
            if (MethodUtils.methodMatches(method, "java.util.Map", (PsiType)PsiType.BOOLEAN, "isEmpty", new PsiType[0])) {
                return SpecialField.MAP_SIZE.getEmptyContracts();
            }
            if (MethodUtils.methodMatches(method, "java.util.Map", (PsiType)PsiType.BOOLEAN, CONTAINS_KEY_VALUE, new PsiType[]{null})) {
                return Collections.singletonList(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.MAP_SIZE), DfaRelationValue.RelationType.EQ, ContractValue.zero(), MethodContract.ValueConstraint.FALSE_VALUE));
            }
            if (MethodUtils.methodMatches(method, "java.util.Map", (PsiType)PsiType.BOOLEAN, "equals", new PsiType[]{null})) {
                return Collections.singletonList(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.MAP_SIZE), DfaRelationValue.RelationType.NE, ContractValue.argument(0).specialField(SpecialField.MAP_SIZE), MethodContract.ValueConstraint.FALSE_VALUE));
            }
            if (MethodUtils.methodMatches(method, "java.util.Arrays", null, ARRAY_RANGED_METHODS, (PsiType[])null) && paramCount >= 3) {
                return ARRAY_RANGE_CONTRACTS;
            }
            if ("org.apache.commons.lang.Validate".equals(className) || "org.apache.commons.lang3.Validate".equals(className) || "org.springframework.util.Assert".equals(className)) {
                if (("isTrue".equals(methodName) || "state".equals(methodName)) && paramCount > 0) {
                    MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                    constraints[0] = MethodContract.ValueConstraint.FALSE_VALUE;
                    return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
                }
                if ("notNull".equals(methodName) && paramCount > 0) {
                    MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                    constraints[0] = MethodContract.ValueConstraint.NULL_VALUE;
                    return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
                }
            } else {
                if (HardcodedContracts.isJunit(className) || HardcodedContracts.isTestng(className) || className.startsWith("com.google.common.truth.") || className.startsWith("org.assertj.core.api.")) {
                    return HardcodedContracts.handleTestFrameworks(paramCount, className, methodName, call);
                }
                if (TypeUtils.isOptional(owner2)) {
                    if (DfaOptionalSupport.isOptionalGetMethodName(methodName) || "orElseThrow".equals(methodName)) {
                        return Arrays.asList(HardcodedContracts.optionalAbsentContract(MethodContract.ValueConstraint.THROW_EXCEPTION), MethodContract.trivialContract(MethodContract.ValueConstraint.NOT_NULL_VALUE));
                    }
                    if ("isPresent".equals(methodName)) {
                        return Arrays.asList(HardcodedContracts.optionalAbsentContract(MethodContract.ValueConstraint.FALSE_VALUE), MethodContract.trivialContract(MethodContract.ValueConstraint.TRUE_VALUE));
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    static MethodContract optionalAbsentContract(MethodContract.ValueConstraint returnValue) {
        return MethodContract.singleConditionContract(ContractValue.qualifier(), DfaRelationValue.RelationType.IS, ContractValue.optionalValue(false), returnValue);
    }

    static MethodContract nonnegativeArgumentContract(int argNumber) {
        return MethodContract.singleConditionContract(ContractValue.argument(argNumber), DfaRelationValue.RelationType.LT, ContractValue.zero(), MethodContract.ValueConstraint.THROW_EXCEPTION);
    }

    static MethodContract specialFieldRangeContract(int index, DfaRelationValue.RelationType type2, SpecialField specialField) {
        return MethodContract.singleConditionContract(ContractValue.argument(index), type2.getNegated(), ContractValue.qualifier().specialField(specialField), MethodContract.ValueConstraint.THROW_EXCEPTION);
    }

    private static boolean isJunit(String className) {
        return className.startsWith("junit.framework.") || className.startsWith("org.junit.");
    }

    private static boolean isJunit5(String className) {
        return className.startsWith("org.junit.jupiter.");
    }

    private static boolean isTestng(String className) {
        return className.startsWith("org.testng.");
    }

    private static boolean isNotNullMatcher(PsiExpression expr) {
        if (expr instanceof PsiMethodCallExpression) {
            PsiExpression[] args;
            PsiExpression[] equalArgs;
            PsiExpression[] notArgs;
            String calledName = ((PsiMethodCallExpression)expr).getMethodExpression().getReferenceName();
            if ("notNullValue".equals(calledName)) {
                return true;
            }
            if ("not".equals(calledName) && (notArgs = ((PsiMethodCallExpression)expr).getArgumentList().getExpressions()).length == 1 && notArgs[0] instanceof PsiMethodCallExpression && "equalTo".equals(((PsiMethodCallExpression)notArgs[0]).getMethodExpression().getReferenceName()) && (equalArgs = ((PsiMethodCallExpression)notArgs[0]).getArgumentList().getExpressions()).length == 1 && ExpressionUtils.isNullLiteral(equalArgs[0])) {
                return true;
            }
            if ("is".equals(calledName) && (args = ((PsiMethodCallExpression)expr).getArgumentList().getExpressions()).length == 1) {
                return HardcodedContracts.isNotNullMatcher(args[0]);
            }
        }
        return false;
    }

    private static List<MethodContract> handleTestFrameworks(int paramCount, String className, String methodName, @Nullable PsiMethodCallExpression call) {
        if (("assertThat".equals(methodName) || "assumeThat".equals(methodName) || "that".equals(methodName)) && call != null) {
            return HardcodedContracts.handleAssertThat(paramCount, call);
        }
        if (!HardcodedContracts.isJunit(className) && !HardcodedContracts.isTestng(className)) {
            return Collections.emptyList();
        }
        boolean testng = HardcodedContracts.isTestng(className);
        if ("fail".equals(methodName)) {
            return Collections.singletonList(new StandardMethodContract(StandardMethodContract.createConstraintArray(paramCount), MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if (paramCount == 0) {
            return Collections.emptyList();
        }
        int checkedParam = testng || HardcodedContracts.isJunit5(className) ? 0 : paramCount - 1;
        MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
        if ("assertTrue".equals(methodName) || "assumeTrue".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.FALSE_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertFalse".equals(methodName) || "assumeFalse".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.TRUE_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertNull".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.NOT_NULL_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertNotNull".equals(methodName) || "assumeNotNull".equals(methodName)) {
            return HardcodedContracts.failIfNull(checkedParam, paramCount);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<MethodContract> handleAssertThat(int paramCount, @NotNull PsiMethodCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/HardcodedContracts", "handleAssertThat"));
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length == paramCount) {
            for (int i2 = 1; i2 < args.length; ++i2) {
                if (!HardcodedContracts.isNotNullMatcher(args[i2])) continue;
                List<MethodContract> list2 = HardcodedContracts.failIfNull(i2 - 1, paramCount);
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/HardcodedContracts", "handleAssertThat"));
                }
                return list2;
            }
            if (args.length == 1 && HardcodedContracts.hasNotNullChainCall(call)) {
                List<MethodContract> list3 = HardcodedContracts.failIfNull(0, 1);
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/HardcodedContracts", "handleAssertThat"));
                }
                return list3;
            }
        }
        List<MethodContract> list4 = Collections.emptyList();
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/HardcodedContracts", "handleAssertThat"));
        }
        return list4;
    }

    private static boolean hasNotNullChainCall(PsiMethodCallExpression call) {
        JBIterable exprParents = SyntaxTraverser.psiApi().parents((Object)call).takeWhile(e -> !(e instanceof PsiStatement) && !(e instanceof PsiMember));
        return ContainerUtil.exists((Iterable)exprParents, HardcodedContracts::isNotNullCall);
    }

    private static boolean isNotNullCall(PsiElement ref) {
        return ref instanceof PsiReferenceExpression && "isNotNull".equals(((PsiReferenceExpression)ref).getReferenceName()) && ref.getParent() instanceof PsiMethodCallExpression;
    }

    @NotNull
    private static List<MethodContract> failIfNull(int argIndex, int argCount) {
        MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(argCount);
        constraints[argIndex] = MethodContract.ValueConstraint.NULL_VALUE;
        List<MethodContract> list2 = Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/HardcodedContracts", "failIfNull"));
        }
        return list2;
    }

    public static boolean isHardcodedPure(PsiMethod method) {
        PsiParameter[] parameters2;
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String className = aClass.getQualifiedName();
        if (className == null) {
            return false;
        }
        String name2 = method.getName();
        if ("java.util.Objects".equals(className) && "requireNonNull".equals(name2) && (parameters2 = method.getParameterList().getParameters()).length == 2 && parameters2[1].getType().getCanonicalText().contains("Supplier")) {
            return false;
        }
        if ("java.lang.System".equals(className)) {
            return false;
        }
        if ("java.util.Arrays".equals(className)) {
            return name2.equals("binarySearch") || name2.equals("spliterator") || name2.equals("stream");
        }
        return true;
    }

    public static boolean hasHardcodedContracts(@Nullable PsiElement element) {
        if (element instanceof PsiMethod) {
            return !HardcodedContracts.getHardcodedContracts((PsiMethod)element, null).isEmpty();
        }
        if (element instanceof PsiParameter) {
            PsiElement parent = element.getParent();
            return parent != null && HardcodedContracts.hasHardcodedContracts(parent.getParent());
        }
        return false;
    }
}

