/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.ExpressionRange;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodData;
import com.intellij.codeInspection.dataFlow.PurityInferenceResult;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PurityInference {
    public static boolean inferPurity(@NotNull PsiMethodImpl method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/PurityInference", "inferPurity"));
        }
        if (!InferenceFromSourceUtil.shouldInferFromSource(method) || PsiType.VOID.equals((Object)method.getReturnType()) || method.isConstructor()) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/PurityInference", "lambda$inferPurity$1"));
            }
            MethodData data = ContractInferenceIndexKt.getIndexedData(method);
            PurityInferenceResult result2 = data == null ? null : data.getPurity();
            Boolean pure = (Boolean)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/PurityInference", "lambda$null$0"));
                }
                return result2 != null && result2.isPure(method, data.methodBody(method));
            });
            return CachedValueProvider.Result.create((Object)(pure == Boolean.TRUE ? 1 : 0), (Object[])new Object[]{method});
        });
    }

    static class PurityInferenceVisitor {
        private final LighterAST tree;
        private final LighterASTNode body;
        private List<LighterASTNode> mutatedRefs = new ArrayList<LighterASTNode>();
        private boolean hasReturns;
        private List<LighterASTNode> calls = new ArrayList<LighterASTNode>();

        PurityInferenceVisitor(LighterAST tree, LighterASTNode body2) {
            this.tree = tree;
            this.body = body2;
        }

        void visitNode(LighterASTNode element) {
            IElementType type2 = element.getTokenType();
            if (type2 == JavaElementType.ASSIGNMENT_EXPRESSION) {
                this.mutatedRefs.add((LighterASTNode)this.tree.getChildren(element).get(0));
            } else if (type2 == JavaElementType.RETURN_STATEMENT && JavaLightTreeUtil.findExpressionChild(this.tree, element) != null) {
                this.hasReturns = true;
            } else if ((type2 == JavaElementType.PREFIX_EXPRESSION || type2 == JavaElementType.POSTFIX_EXPRESSION) && this.isMutatingOperation(element)) {
                ContainerUtil.addIfNotNull(this.mutatedRefs, (Object)JavaLightTreeUtil.findExpressionChild(this.tree, element));
            } else if (this.isCall(element, type2)) {
                this.calls.add(element);
            }
        }

        private boolean isCall(@NotNull LighterASTNode element, IElementType type2) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/dataFlow/PurityInference$PurityInferenceVisitor", "isCall"));
            }
            return type2 == JavaElementType.NEW_EXPRESSION && LightTreeUtil.firstChildOfType(this.tree, element, JavaElementType.EXPRESSION_LIST) != null || type2 == JavaElementType.METHOD_CALL_EXPRESSION;
        }

        private boolean isMutatingOperation(@NotNull LighterASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/dataFlow/PurityInference$PurityInferenceVisitor", "isMutatingOperation"));
            }
            return LightTreeUtil.firstChildOfType(this.tree, element, JavaTokenType.PLUSPLUS) != null || LightTreeUtil.firstChildOfType(this.tree, element, JavaTokenType.MINUSMINUS) != null;
        }

        @Nullable
        PurityInferenceResult getResult() {
            if (this.calls.size() > 1 || !this.hasReturns) {
                return null;
            }
            int bodyStart = this.body.getStartOffset();
            return new PurityInferenceResult(ContainerUtil.map(this.mutatedRefs, node -> ExpressionRange.create(node, bodyStart)), this.calls.isEmpty() ? null : ExpressionRange.create(this.calls.get(0), bodyStart));
        }
    }
}

