/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaExpressionFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory");
    private static final Condition<String> FALSE_GETTERS = DfaExpressionFactory.parseFalseGetters();
    private final DfaValueFactory myFactory;
    private final Map<Integer, PsiVariable> myMockIndices = ContainerUtil.newHashMap();

    private static Condition<String> parseFalseGetters() {
        try {
            String regex = Registry.stringValue((String)"ide.dfa.getters.with.side.effects").trim();
            if (!StringUtil.isEmpty((String)regex)) {
                Pattern pattern = Pattern.compile(regex);
                return s -> pattern.matcher((CharSequence)s).matches();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return Conditions.alwaysFalse();
    }

    public DfaExpressionFactory(DfaValueFactory factory) {
        this.myFactory = factory;
    }

    @Nullable
    public DfaValue getExpressionDfaValue(@Nullable PsiExpression expression2) {
        PsiType type2;
        DfaValue qualifier;
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            return this.getExpressionDfaValue(((PsiParenthesizedExpression)expression2).getExpression());
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiVariable indexVar;
            PsiExpression arrayExpression = ((PsiArrayAccessExpression)expression2).getArrayExpression();
            qualifier = this.getExpressionDfaValue(arrayExpression);
            if (qualifier instanceof DfaVariableValue && (indexVar = this.getArrayIndexVariable(((PsiArrayAccessExpression)expression2).getIndexExpression())) != null) {
                return this.myFactory.getVarFactory().createVariableValue((PsiModifierListOwner)indexVar, expression2.getType(), false, (DfaVariableValue)qualifier);
            }
            PsiType type3 = expression2.getType();
            if (type3 != null) {
                return this.myFactory.createTypeValue(type3, DfaPsiUtil.getElementNullability(type3, null));
            }
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            return this.createReferenceValue(((PsiMethodCallExpression)expression2).getMethodExpression());
        }
        if (expression2 instanceof PsiReferenceExpression) {
            return this.createReferenceValue((PsiReferenceExpression)expression2);
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return this.myFactory.createLiteralValue((PsiLiteralExpression)expression2);
        }
        if (expression2 instanceof PsiNewExpression || expression2 instanceof PsiLambdaExpression) {
            return this.myFactory.createTypeValue(expression2.getType(), Nullness.NOT_NULL);
        }
        Object value2 = JavaConstantExpressionEvaluator.computeConstantExpression(expression2, false);
        if (value2 != null && (type2 = expression2.getType()) != null) {
            return this.myFactory.getConstFactory().createFromValue(value2, type2, null);
        }
        if (expression2 instanceof PsiThisExpression) {
            PsiElement target2;
            qualifier = ((PsiThisExpression)expression2).getQualifier();
            PsiElement psiElement = target2 = qualifier == null ? null : qualifier.resolve();
            if (target2 instanceof PsiClass) {
                return this.myFactory.getVarFactory().createVariableValue((PsiModifierListOwner)target2, null, false, null);
            }
        }
        return null;
    }

    private DfaValue createReferenceValue(@NotNull PsiReferenceExpression refExpr) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/codeInspection/dataFlow/value/DfaExpressionFactory", "createReferenceValue"));
        }
        PsiModifierListOwner var = DfaExpressionFactory.getAccessedVariableOrGetter(refExpr.resolve());
        if (var == null) {
            return null;
        }
        if (!var.hasModifierProperty("volatile")) {
            DfaValue constValue;
            if (var instanceof PsiVariable && var.hasModifierProperty("final") && !PsiUtil.isAccessedForWriting((PsiExpression)refExpr) && (constValue = this.myFactory.getConstFactory().create((PsiVariable)var)) != null) {
                return constValue;
            }
            if (DfaValueFactory.isEffectivelyUnqualified(refExpr)) {
                if (DfaExpressionFactory.isFieldDereferenceBeforeInitialization(refExpr)) {
                    return this.myFactory.getConstFactory().getNull();
                }
                return this.myFactory.getVarFactory().createVariableValue(var, refExpr.getType(), false, null);
            }
            DfaValue qualifierValue = this.getExpressionDfaValue(refExpr.getQualifierExpression());
            if (qualifierValue instanceof DfaVariableValue) {
                return this.myFactory.getVarFactory().createVariableValue(var, refExpr.getType(), false, (DfaVariableValue)qualifierValue);
            }
        }
        PsiType type2 = refExpr.getType();
        return this.myFactory.createTypeValue(type2, DfaPsiUtil.getElementNullability(type2, var));
    }

    private static boolean isFieldDereferenceBeforeInitialization(PsiReferenceExpression ref) {
        PsiField placeField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiField.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (placeField == null) {
            return false;
        }
        PsiElement target2 = ref.resolve();
        return target2 instanceof PsiField && placeField.getContainingClass() == ((PsiField)target2).getContainingClass() && ((PsiField)target2).getInitializer() == null;
    }

    @Nullable
    private static PsiModifierListOwner getAccessedVariableOrGetter(PsiElement target2) {
        if (target2 instanceof PsiVariable) {
            return (PsiVariable)target2;
        }
        if (target2 instanceof PsiMethod) {
            String qName;
            PsiMethod method = (PsiMethod)target2;
            if (!(!PropertyUtil.isSimplePropertyGetter((PsiMethod)method) || method.getReturnType() instanceof PsiPrimitiveType || (qName = PsiUtil.getMemberQualifiedName((PsiMember)method)) != null && FALSE_GETTERS.value((Object)qName))) {
                return method;
            }
            for (SpecialField sf : SpecialField.values()) {
                if (!sf.isMyAccessor((PsiModifierListOwner)method)) continue;
                return sf.getCanonicalOwner(null, ((PsiMethod)target2).getContainingClass());
            }
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)method.getContainingClass(), (String[])new String[]{"javax.annotation.concurrent.Immutable"}) != null) {
                return method;
            }
        }
        return null;
    }

    @Nullable
    private PsiVariable getArrayIndexVariable(@Nullable PsiExpression indexExpression) {
        Object constant = JavaConstantExpressionEvaluator.computeConstantExpression(indexExpression, false);
        if (constant instanceof Integer && (Integer)constant >= 0) {
            PsiVariable mockVar = this.myMockIndices.get(constant);
            if (mockVar == null) {
                PsiJavaFile file2 = (PsiJavaFile)PsiFileFactory.getInstance((Project)indexExpression.getProject()).createFileFromText("ArrayIndex.java", (FileType)JavaFileType.INSTANCE, (CharSequence)("class _Index_ { int $array$index$" + constant + ";}"));
                mockVar = file2.getClasses()[0].getFields()[0];
                this.myMockIndices.put((Integer)constant, mockVar);
            }
            return mockVar;
        }
        return null;
    }
}

