/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.deadCode.DeadHTMLComposer;
import com.intellij.codeInspection.deadCode.UnreferencedFilter;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.EntryPointsNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspectionBase;
import com.intellij.codeInspection.util.RefFilter;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedDeclarationPresentation
extends DefaultInspectionToolPresentation {
    private final Set<RefEntity> myIgnoreElements;
    private final Map<RefEntity, UnusedDeclarationHint> myFixedElements;
    private WeakUnreferencedFilter myFilter;
    private DeadHTMLComposer myComposer;
    @NonNls
    private static final String DELETE = "delete";
    @NonNls
    private static final String COMMENT = "comment";
    final QuickFixAction[] myQuickFixActions;
    private static final String DELETE_QUICK_FIX = InspectionsBundle.message((String)"inspection.dead.code.safe.delete.quickfix", (Object[])new Object[0]);
    private static final String COMMENT_OUT_QUICK_FIX = InspectionsBundle.message((String)"inspection.dead.code.comment.quickfix", (Object[])new Object[0]);

    public UnusedDeclarationPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "<init>"));
        }
        super(toolWrapper, context);
        this.myIgnoreElements = ContainerUtil.newConcurrentSet((TObjectHashingStrategy)ContainerUtil.identityStrategy());
        this.myFixedElements = ContainerUtil.newConcurrentMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
        this.myQuickFixActions = this.createQuickFixes(toolWrapper);
        ((EntryPointsManagerBase)this.getEntryPointsManager()).setAddNonJavaEntries(this.getTool().ADD_NONJAVA_TO_ENTRIES);
    }

    public RefFilter getFilter() {
        if (this.myFilter == null) {
            this.myFilter = new WeakUnreferencedFilter(this.getTool(), this.getContext());
        }
        return this.myFilter;
    }

    @NotNull
    private UnusedDeclarationInspectionBase getTool() {
        UnusedDeclarationInspectionBase unusedDeclarationInspectionBase = (UnusedDeclarationInspectionBase)this.getToolWrapper().getTool();
        if (unusedDeclarationInspectionBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "getTool"));
        }
        return unusedDeclarationInspectionBase;
    }

    @Override
    @NotNull
    public DeadHTMLComposer getComposer() {
        if (this.myComposer == null) {
            this.myComposer = new DeadHTMLComposer(this);
        }
        DeadHTMLComposer deadHTMLComposer = this.myComposer;
        if (deadHTMLComposer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "getComposer"));
        }
        return deadHTMLComposer;
    }

    @Override
    public void exportResults(@NotNull org.jdom.Element parentNode, @NotNull RefEntity refEntity, @NotNull Predicate<CommonProblemDescriptor> excludedDescriptions) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "exportResults"));
        }
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "exportResults"));
        }
        if (excludedDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedDescriptions", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "exportResults"));
        }
        if (!(refEntity instanceof RefJavaElement)) {
            return;
        }
        RefFilter filter = this.getFilter();
        if (!this.getIgnoredRefElements().contains(refEntity) && filter.accepts((RefJavaElement)refEntity)) {
            refEntity = this.getRefManager().getRefinedElement(refEntity);
            if (!refEntity.isValid()) {
                return;
            }
            RefJavaElement refElement = (RefJavaElement)refEntity;
            if (!UnusedDeclarationPresentation.compareVisibilities(refElement, this.getTool().getSharedLocalInspectionTool())) {
                return;
            }
            if (this.skipEntryPoints(refElement)) {
                return;
            }
            org.jdom.Element element = refEntity.getRefManager().export(refEntity, parentNode, -1);
            if (element == null) {
                return;
            }
            org.jdom.Element problemClassElement = new org.jdom.Element(InspectionsBundle.message((String)"inspection.export.results.problem.element.tag", (Object[])new Object[0]));
            HighlightSeverity severity = this.getSeverity((RefElement)refElement);
            String attributeKey = UnusedDeclarationPresentation.getTextAttributeKey(refElement.getRefManager().getProject(), severity, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            problemClassElement.setAttribute("severity", severity.myName);
            problemClassElement.setAttribute("attribute_key", attributeKey);
            problemClassElement.addContent(InspectionsBundle.message((String)"inspection.export.results.dead.code", (Object[])new Object[0]));
            element.addContent(problemClassElement);
            org.jdom.Element hintsElement = new org.jdom.Element("hints");
            for (UnusedDeclarationHint hint : UnusedDeclarationHint.values()) {
                org.jdom.Element hintElement = new org.jdom.Element("hint");
                hintElement.setAttribute("value", hint.toString().toLowerCase());
                hintsElement.addContent(hintElement);
            }
            element.addContent(hintsElement);
            org.jdom.Element descriptionElement = new org.jdom.Element(InspectionsBundle.message((String)"inspection.export.results.description.tag", (Object[])new Object[0]));
            StringBuffer buf = new StringBuffer();
            DeadHTMLComposer.appendProblemSynopsis((RefElement)refEntity, buf);
            descriptionElement.addContent(buf.toString());
            element.addContent(descriptionElement);
        }
        super.exportResults(parentNode, refEntity, excludedDescriptions);
    }

    @Override
    @NotNull
    public QuickFixAction[] getQuickFixes(@NotNull RefEntity[] refElements, @Nullable InspectionTree tree) {
        if (refElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "getQuickFixes"));
        }
        boolean showFixes = false;
        for (RefEntity element : refElements) {
            if (this.getIgnoredRefElements().contains(element) || !element.isValid()) continue;
            showFixes = true;
            break;
        }
        if (showFixes) {
            long count;
            TreePath[] paths;
            TreePath[] treePathArray = paths = tree != null ? tree.getSelectionPaths() : null;
            if (paths != null && (count = Arrays.stream(paths).map(TreePath::getLastPathComponent).filter(component -> component instanceof ProblemDescriptionNode).count()) > 0L) {
                QuickFixAction[] fixes = super.getQuickFixes(refElements, tree);
                QuickFixAction[] quickFixActionArray = count == (long)paths.length ? fixes : (QuickFixAction[])ArrayUtil.mergeArrays((Object[])fixes, (Object[])this.myQuickFixActions);
                if (quickFixActionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "getQuickFixes"));
                }
                return quickFixActionArray;
            }
            if (this.myQuickFixActions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "getQuickFixes"));
            }
            return this.myQuickFixActions;
        }
        if (QuickFixAction.EMPTY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "getQuickFixes"));
        }
        return QuickFixAction.EMPTY;
    }

    @NotNull
    private QuickFixAction[] createQuickFixes(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "createQuickFixes"));
        }
        QuickFixAction[] quickFixActionArray = new QuickFixAction[]{new PermanentDeleteAction(toolWrapper), new CommentOutBin(toolWrapper), new MoveToEntries(toolWrapper)};
        if (quickFixActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "createQuickFixes"));
        }
        return quickFixActionArray;
    }

    private EntryPointsManager getEntryPointsManager() {
        return ((GlobalJavaInspectionContext)this.getContext().getExtension(GlobalJavaInspectionContext.CONTEXT)).getEntryPointsManager(this.getContext().getRefManager());
    }

    private static void commentOutDead(PsiElement psiElement) {
        Document doc;
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile != null && (doc = PsiDocumentManager.getInstance((Project)psiElement.getProject()).getDocument(psiFile)) != null) {
            int line2;
            TextRange textRange = psiElement.getTextRange();
            String date = DateFormatUtil.formatDateTime((Date)new Date());
            int startOffset = textRange.getStartOffset();
            CharSequence chars = doc.getCharsSequence();
            while (CharArrayUtil.regionMatches((CharSequence)chars, (int)startOffset, (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.comment", (Object[])new Object[0]))) {
                int line = doc.getLineNumber(startOffset) + 1;
                if (line >= doc.getLineCount()) continue;
                startOffset = doc.getLineStartOffset(line);
                startOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t");
            }
            int endOffset = textRange.getEndOffset();
            int line1 = doc.getLineNumber(startOffset);
            if (line1 == (line2 = doc.getLineNumber(endOffset - 1))) {
                doc.insertString(startOffset, (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.date.comment", (Object[])new Object[]{date}));
            } else {
                for (int i2 = line1; i2 <= line2; ++i2) {
                    doc.insertString(doc.getLineStartOffset(i2), (CharSequence)"//");
                }
                doc.insertString(doc.getLineStartOffset(Math.min(line2 + 1, doc.getLineCount() - 1)), (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.stop.comment", (Object[])new Object[]{date}));
                doc.insertString(doc.getLineStartOffset(line1), (CharSequence)InspectionsBundle.message((String)"inspection.dead.code.start.comment", (Object[])new Object[]{date}));
            }
        }
    }

    @Override
    public void createToolNode(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode node, @NotNull InspectionRVContentProvider provider, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupByStructure) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "createToolNode"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "createToolNode"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "createToolNode"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "createToolNode"));
        }
        EntryPointsNode entryPointsNode = new EntryPointsNode(context);
        InspectionToolWrapper dummyToolWrapper = entryPointsNode.getToolWrapper();
        InspectionToolPresentation presentation = context.getPresentation(dummyToolWrapper);
        presentation.updateContent();
        provider.appendToolNodeContent(context, entryPointsNode, node, showStructure, groupByStructure);
        this.myToolNode = entryPointsNode;
    }

    @Override
    @NotNull
    public RefElementNode createRefNode(@Nullable RefEntity entity) {
        RefElementNode refElementNode = new RefElementNode(entity, this){

            @Override
            @Nullable
            public String getTailText() {
                UnusedDeclarationHint hint = (UnusedDeclarationHint)((Object)UnusedDeclarationPresentation.this.myFixedElements.get(this.getElement()));
                if (hint != null) {
                    return hint.getDescription();
                }
                return super.getTailText();
            }

            @Override
            public boolean isQuickFixAppliedFromView() {
                return UnusedDeclarationPresentation.this.myFixedElements.containsKey(this.getElement());
            }
        };
        if (refElementNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "createRefNode"));
        }
        return refElementNode;
    }

    @Override
    public void updateContent() {
        this.getTool().checkForReachableRefs(this.getContext());
        this.myContents.clear();
        final UnusedSymbolLocalInspectionBase localInspectionTool = this.getTool().getSharedLocalInspectionTool();
        this.getContext().getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$2", "visitElement"));
                }
                if (!(refEntity instanceof RefJavaElement)) {
                    return;
                }
                RefJavaElement refElement = (RefJavaElement)refEntity;
                if (!UnusedDeclarationPresentation.compareVisibilities(refElement, localInspectionTool)) {
                    return;
                }
                if ((!UnusedDeclarationPresentation.this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS || !UnusedDeclarationPresentation.this.getIgnoredRefElements().contains(refElement)) && refElement.isValid() && UnusedDeclarationPresentation.this.getFilter().accepts(refElement)) {
                    if (UnusedDeclarationPresentation.this.skipEntryPoints(refElement)) {
                        return;
                    }
                    UnusedDeclarationPresentation.this.registerContentEntry(refEntity, RefJavaUtil.getInstance().getPackageName(refEntity));
                }
            }
        });
        this.updateProblemElements();
    }

    protected boolean skipEntryPoints(RefJavaElement refElement) {
        return this.getTool().isEntryPoint((RefElement)refElement);
    }

    @PsiModifier.ModifierConstant
    private static String getAcceptedVisibility(UnusedSymbolLocalInspectionBase tool, RefJavaElement element) {
        if (element instanceof RefImplicitConstructor) {
            element = ((RefImplicitConstructor)element).getOwnerClass();
        }
        if (element instanceof RefClass) {
            return element.getOwner() instanceof RefClass ? tool.getInnerClassVisibility() : tool.getClassVisibility();
        }
        if (element instanceof RefField) {
            return tool.getFieldVisibility();
        }
        if (element instanceof RefMethod) {
            PsiModifierListOwner listOwner;
            String methodVisibility = tool.getMethodVisibility();
            if (methodVisibility != null && tool.isIgnoreAccessors() && (listOwner = ((RefMethod)element).getElement()) instanceof PsiMethod && PropertyUtil.isSimplePropertyAccessor((PsiMethod)((PsiMethod)listOwner))) {
                return null;
            }
            return methodVisibility;
        }
        if (element instanceof RefParameter) {
            return tool.getParameterVisibility();
        }
        return "public";
    }

    protected static boolean compareVisibilities(RefJavaElement listOwner, UnusedSymbolLocalInspectionBase localInspectionTool) {
        return UnusedDeclarationPresentation.compareVisibilities(listOwner, UnusedDeclarationPresentation.getAcceptedVisibility(localInspectionTool, listOwner));
    }

    protected static boolean compareVisibilities(RefJavaElement listOwner, String acceptedVisibility) {
        if (acceptedVisibility != null) {
            while (listOwner != null) {
                if (VisibilityUtil.compare((String)listOwner.getAccessModifier(), (String)acceptedVisibility) >= 0) {
                    return true;
                }
                RefEntity parent = listOwner.getOwner();
                if (!(parent instanceof RefJavaElement)) break;
                listOwner = (RefJavaElement)parent;
            }
        }
        return false;
    }

    @Override
    public boolean hasReportedProblems() {
        return !this.myContents.isEmpty() || super.hasReportedProblems();
    }

    @Override
    public void ignoreCurrentElement(RefEntity refEntity) {
        if (refEntity == null) {
            return;
        }
        this.myIgnoreElements.add(refEntity);
    }

    @Override
    public void ignoreElement(@NotNull RefEntity refEntity) {
        CommonProblemDescriptor[] descriptors;
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "ignoreElement"));
        }
        if (refEntity instanceof RefElement && (descriptors = this.getProblemElements().get(refEntity)) != null) {
            PsiElement psiElement = (PsiElement)ReadAction.compute(() -> {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "lambda$ignoreElement$1"));
                }
                return ((RefElement)refEntity).getElement();
            });
            ArrayList<CommonProblemDescriptor> foreignDescriptors = new ArrayList<CommonProblemDescriptor>();
            for (CommonProblemDescriptor descriptor : descriptors) {
                if (descriptor instanceof ProblemDescriptor && ReadAction.compute(() -> ((ProblemDescriptor)descriptor).getPsiElement()) == psiElement) continue;
                foreignDescriptors.add(descriptor);
            }
            if (foreignDescriptors.size() == descriptors.length) {
                return;
            }
        }
        super.ignoreElement(refEntity);
    }

    @Override
    public void amnesty(RefEntity refEntity) {
        this.myIgnoreElements.remove(refEntity);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.myIgnoreElements.clear();
    }

    @Override
    public void finalCleanup() {
        super.finalCleanup();
    }

    @Override
    public boolean isGraphNeeded() {
        return true;
    }

    @Override
    public boolean isElementIgnored(RefEntity element) {
        return this.myIgnoreElements.contains(element);
    }

    @Override
    @NotNull
    public FileStatus getElementStatus(RefEntity element) {
        FileStatus fileStatus = FileStatus.NOT_CHANGED;
        if (fileStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "getElementStatus"));
        }
        return fileStatus;
    }

    @Override
    @NotNull
    public Set<RefEntity> getIgnoredRefElements() {
        Set<RefEntity> set2 = this.myIgnoreElements;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "getIgnoredRefElements"));
        }
        return set2;
    }

    @Override
    @Nullable
    public IntentionAction findQuickFixes(@NotNull CommonProblemDescriptor descriptor, String hint) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation", "findQuickFixes"));
        }
        if (descriptor instanceof ProblemDescriptor) {
            if (DELETE.equals(hint)) {
                return new PermanentDeleteFix(((ProblemDescriptor)descriptor).getPsiElement());
            }
            if (COMMENT.equals(hint)) {
                return new CommentOutFix(((ProblemDescriptor)descriptor).getPsiElement());
            }
            return super.findQuickFixes(descriptor, hint);
        }
        return null;
    }

    @Override
    public JComponent getCustomPreviewPanel(RefEntity entity) {
        final Project project2 = entity.getRefManager().getProject();
        JEditorPane htmlView = new JEditorPane(){

            @Override
            public String getToolTipText(MouseEvent evt) {
                String objectPackage;
                HTMLDocument hdoc;
                Element e;
                AttributeSet a;
                SimpleAttributeSet value2;
                int pos = this.viewToModel(evt.getPoint());
                if (pos >= 0 && (value2 = (SimpleAttributeSet)(a = (e = (hdoc = (HTMLDocument)this.getDocument()).getCharacterElement(pos)).getAttributes()).getAttribute(HTML.Tag.A)) != null && (objectPackage = (String)value2.getAttribute("qualifiedname")) != null) {
                    return objectPackage;
                }
                return null;
            }
        };
        htmlView.setContentType("text/html");
        htmlView.setEditable(false);
        htmlView.setOpaque(false);
        htmlView.setBackground(UIUtil.getLabelBackground());
        htmlView.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                URL url = e.getURL();
                if (url == null) {
                    return;
                }
                String ref = url.getRef();
                int offset = Integer.parseInt(ref);
                String fileURL = url.toExternalForm();
                fileURL = fileURL.substring(0, fileURL.indexOf(35));
                VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(fileURL);
                if (vFile == null) {
                    vFile = VfsUtil.findFileByURL((URL)url);
                }
                if (vFile != null) {
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project2, vFile, offset);
                    FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor, true);
                }
            }
        });
        StyleSheet css = ((HTMLEditorKit)htmlView.getEditorKit()).getStyleSheet();
        css.addRule("p.problem-description-group {text-indent: " + JBUI.scale((int)9) + "px;font-weight:bold;}");
        css.addRule("div.problem-description {margin-left: " + JBUI.scale((int)9) + "px;}");
        css.addRule("ul {margin-left:" + JBUI.scale((int)10) + "px;text-indent: 0}");
        css.addRule("code {font-family:" + UIUtil.getLabelFont().getFamily() + "}");
        StringBuffer buf = new StringBuffer();
        this.getComposer().compose(buf, entity, false);
        String text2 = buf.toString();
        SingleInspectionProfilePanel.readHTML(htmlView, SingleInspectionProfilePanel.toHTML(htmlView, text2, false));
        return ScrollPaneFactory.createScrollPane((Component)htmlView, (boolean)true);
    }

    @Override
    public int getProblemsCount(InspectionTree tree) {
        return 0;
    }

    private static class PermanentDeleteFix
    implements IntentionAction {
        private final PsiElement myElement;

        private PermanentDeleteFix(PsiElement element) {
            this.myElement = element;
        }

        @NotNull
        public String getText() {
            String string = DELETE_QUICK_FIX;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteFix", "getText"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteFix", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteFix", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteFix", "invoke"));
            }
            if (this.myElement != null && this.myElement.isValid()) {
                SafeDeleteHandler.invoke(this.myElement.getProject(), new PsiElement[]{PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiModifierListOwner.class)}, false);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }
    }

    private static class CommentOutFix
    implements IntentionAction {
        private final PsiElement myElement;

        private CommentOutFix(PsiElement element) {
            this.myElement = element;
        }

        @NotNull
        public String getText() {
            String string = COMMENT_OUT_QUICK_FIX;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$CommentOutFix", "getText"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$CommentOutFix", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$CommentOutFix", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$CommentOutFix", "invoke"));
            }
            if (this.myElement != null && this.myElement.isValid()) {
                UnusedDeclarationPresentation.commentOutDead(PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiModifierListOwner.class));
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    class CommentOutBin
    extends QuickFixAction {
        CommentOutBin(InspectionToolWrapper toolWrapper) {
            if (toolWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$CommentOutBin", "<init>"));
            }
            super(COMMENT_OUT_QUICK_FIX, null, KeyStroke.getKeyStroke(47, SystemInfo.isMac ? 4 : 2), toolWrapper);
        }

        @Override
        protected boolean applyFix(@NotNull RefEntity[] refElements) {
            if (refElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$CommentOutBin", "applyFix"));
            }
            if (!super.applyFix(refElements)) {
                return false;
            }
            ArrayList deletedRefs = new ArrayList(1);
            RefFilter filter = UnusedDeclarationPresentation.this.getFilter();
            for (RefEntity refElement : refElements) {
                PsiElement psiElement;
                PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null;
                if (psiElement == null || filter.getElementProblemCount((RefJavaElement)refElement) == 0) continue;
                RefEntity owner2 = refElement.getOwner();
                if (!(owner2 instanceof RefJavaElement) || filter.getElementProblemCount((RefJavaElement)owner2) == 0 || ArrayUtil.find((Object[])refElements, (Object)owner2) <= -1) {
                    UnusedDeclarationPresentation.commentOutDead(psiElement);
                }
                refElement.getRefManager().removeRefElement((RefElement)refElement, deletedRefs);
            }
            EntryPointsManager entryPointsManager = UnusedDeclarationPresentation.this.getEntryPointsManager();
            for (RefElement refElement : deletedRefs) {
                entryPointsManager.removeEntryPoint(refElement);
            }
            for (RefElement ref : deletedRefs) {
                UnusedDeclarationPresentation.this.myFixedElements.put(ref, UnusedDeclarationHint.COMMENT);
            }
            return true;
        }
    }

    class MoveToEntries
    extends QuickFixAction {
        MoveToEntries(InspectionToolWrapper toolWrapper) {
            if (toolWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$MoveToEntries", "<init>"));
            }
            super(InspectionsBundle.message((String)"inspection.dead.code.entry.point.quickfix", (Object[])new Object[0]), null, null, toolWrapper);
        }

        @Override
        public void update(AnActionEvent e) {
            super.update(e);
            if (e.getPresentation().isEnabledAndVisible()) {
                RefEntity[] elements;
                for (RefEntity element : elements = MoveToEntries.getInvoker(e).getTree().getSelectedElements()) {
                    if (((RefElement)element).isEntry()) continue;
                    return;
                }
                e.getPresentation().setEnabled(false);
            }
        }

        @Override
        protected boolean applyFix(@NotNull RefEntity[] refElements) {
            if (refElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$MoveToEntries", "applyFix"));
            }
            EntryPointsManager entryPointsManager = UnusedDeclarationPresentation.this.getEntryPointsManager();
            for (RefEntity refElement : refElements) {
                if (!(refElement instanceof RefElement)) continue;
                entryPointsManager.addEntryPoint((RefElement)refElement, true);
            }
            return true;
        }
    }

    class PermanentDeleteAction
    extends QuickFixAction {
        PermanentDeleteAction(InspectionToolWrapper toolWrapper) {
            if (toolWrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteAction", "<init>"));
            }
            super(DELETE_QUICK_FIX, AllIcons.Actions.Cancel, null, toolWrapper);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("SafeDelete"));
        }

        @Override
        protected boolean applyFix(@NotNull RefEntity[] refElements) {
            if (refElements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteAction", "applyFix"));
            }
            if (!super.applyFix(refElements)) {
                return false;
            }
            PsiElement[] psiElements = (PsiElement[])Arrays.stream(refElements).filter(obj -> obj instanceof RefJavaElement && UnusedDeclarationPresentation.this.getFilter().accepts((RefJavaElement)obj)).map(e -> ((RefElement)e).getElement()).filter(e -> e != null).toArray(PsiElement[]::new);
            if (psiElements.length == 0) {
                return false;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (refElements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteAction", "lambda$applyFix$5"));
                }
                Project project2 = UnusedDeclarationPresentation.this.getContext().getProject();
                if (UnusedDeclarationPresentation.this.isDisposed() || project2.isDisposed()) {
                    return;
                }
                SafeDeleteHandler.invoke(project2, psiElements, false, () -> {
                    if (refElements == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElements", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$PermanentDeleteAction", "lambda$null$4"));
                    }
                    PermanentDeleteAction.removeElements(refElements, project2, this.myToolWrapper);
                    for (RefEntity ref : refElements) {
                        UnusedDeclarationPresentation.this.myFixedElements.put(ref, UnusedDeclarationHint.DELETE);
                    }
                });
            });
            return false;
        }
    }

    private static class WeakUnreferencedFilter
    extends UnreferencedFilter {
        private WeakUnreferencedFilter(@NotNull UnusedDeclarationInspectionBase tool, @NotNull GlobalInspectionContextImpl context) {
            if (tool == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$WeakUnreferencedFilter", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$WeakUnreferencedFilter", "<init>"));
            }
            super(tool, context);
        }

        @Override
        public int getElementProblemCount(@NotNull RefJavaElement refElement) {
            if (refElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInspection/deadCode/UnusedDeclarationPresentation$WeakUnreferencedFilter", "getElementProblemCount"));
            }
            int problemCount = super.getElementProblemCount(refElement);
            if (problemCount > -1) {
                return problemCount;
            }
            if (!((RefElementImpl)refElement).hasSuspiciousCallers() || ((RefJavaElementImpl)refElement).isSuspiciousRecursive()) {
                return 1;
            }
            for (RefElement element : refElement.getInReferences()) {
                if (!((UnusedDeclarationInspectionBase)this.myTool).isEntryPoint(element)) continue;
                return 1;
            }
            return 0;
        }
    }

    private static enum UnusedDeclarationHint {
        COMMENT("Commented out"),
        DELETE("Deleted");

        private final String myDescription;

        private UnusedDeclarationHint(String description) {
            this.myDescription = description;
        }

        public String getDescription() {
            return this.myDescription;
        }
    }
}

