/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.defUse;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DefUseInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    public boolean REPORT_PREFIX_EXPRESSIONS;
    public boolean REPORT_POSTFIX_EXPRESSIONS = true;
    public boolean REPORT_REDUNDANT_INITIALIZER = true;
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.unused.assignment.display.name", (Object[])new Object[0]);
    public static final String SHORT_NAME = "UnusedAssignment";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/defUse/DefUseInspectionBase", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                DefUseInspectionBase.this.checkCodeBlock(method.getBody(), holder, isOnTheFly);
            }

            public void visitClassInitializer(PsiClassInitializer initializer) {
                DefUseInspectionBase.this.checkCodeBlock(initializer.getBody(), holder, isOnTheFly);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                PsiElement body2 = expression2.getBody();
                if (body2 instanceof PsiCodeBlock) {
                    DefUseInspectionBase.this.checkCodeBlock((PsiCodeBlock)body2, holder, isOnTheFly);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/defUse/DefUseInspectionBase", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private void checkCodeBlock(PsiCodeBlock body2, ProblemsHolder holder, boolean isOnTheFly) {
        if (body2 == null) {
            return;
        }
        THashSet usedVariables = new THashSet();
        List<DefUseUtil.Info> unusedDefs = DefUseUtil.getUnusedDefs(body2, (Set<PsiVariable>)usedVariables);
        if (unusedDefs != null && !unusedDefs.isEmpty()) {
            Collections.sort(unusedDefs, (o1, o2) -> {
                int offset2;
                int offset1 = o1.getContext().getTextOffset();
                if (offset1 == (offset2 = o2.getContext().getTextOffset())) {
                    return 0;
                }
                if (offset1 < offset2) {
                    return -1;
                }
                return 1;
            });
            for (DefUseUtil.Info info : unusedDefs) {
                PsiElement context = info.getContext();
                PsiVariable psiVariable = info.getVariable();
                if (context instanceof PsiDeclarationStatement || context instanceof PsiResourceVariable) {
                    if (!info.isRead() || !this.REPORT_REDUNDANT_INITIALIZER) continue;
                    List fixes = ContainerUtil.createMaybeSingletonList((Object)(DefUseInspectionBase.isOnTheFlyOrNoSideEffects(isOnTheFly, psiVariable, psiVariable.getInitializer()) ? this.createRemoveInitializerFix() : null));
                    holder.registerProblem((PsiElement)ObjectUtils.notNull((Object)psiVariable.getInitializer(), (Object)psiVariable), InspectionsBundle.message((String)"inspection.unused.assignment.problem.descriptor2", (Object[])new Object[]{"<code>" + psiVariable.getName() + "</code>", "<code>#ref</code> #loc"}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes.toArray(new LocalQuickFix[fixes.size()]));
                    continue;
                }
                if (context instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)context;
                    List fixes = ContainerUtil.createMaybeSingletonList((Object)(DefUseInspectionBase.isOnTheFlyOrNoSideEffects(isOnTheFly, psiVariable, assignment.getRExpression()) ? this.createRemoveAssignmentFix() : null));
                    holder.registerProblem((PsiElement)assignment.getLExpression(), InspectionsBundle.message((String)"inspection.unused.assignment.problem.descriptor3", (Object[])new Object[]{((PsiExpression)ObjectUtils.assertNotNull((Object)assignment.getRExpression())).getText(), "<code>#ref</code> #loc"}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes.toArray(new LocalQuickFix[fixes.size()]));
                    continue;
                }
                if ((!(context instanceof PsiPrefixExpression) || !this.REPORT_PREFIX_EXPRESSIONS) && (!(context instanceof PsiPostfixExpression) || !this.REPORT_POSTFIX_EXPRESSIONS)) continue;
                holder.registerProblem(context, InspectionsBundle.message((String)"inspection.unused.assignment.problem.descriptor4", (Object[])new Object[]{"<code>#ref</code> #loc"}), new LocalQuickFix[0]);
            }
        }
    }

    private static boolean isOnTheFlyOrNoSideEffects(boolean isOnTheFly, PsiVariable psiVariable, PsiExpression initializer) {
        return isOnTheFly || !RemoveUnusedVariableUtil.checkSideEffects(initializer, psiVariable, new ArrayList<PsiElement>());
    }

    protected LocalQuickFix createRemoveInitializerFix() {
        return null;
    }

    protected LocalQuickFix createRemoveAssignmentFix() {
        return null;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/defUse/DefUseInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/defUse/DefUseInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/defUse/DefUseInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myReportPrefix;
        private final JCheckBox myReportPostfix;
        private final JCheckBox myReportInitializer;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.anchor = 18;
            this.myReportInitializer = new JCheckBox(InspectionsBundle.message((String)"inspection.unused.assignment.option2", (Object[])new Object[0]));
            this.myReportInitializer.setSelected(DefUseInspectionBase.this.REPORT_REDUNDANT_INITIALIZER);
            this.myReportInitializer.getModel().addItemListener(e -> {
                DefUseInspectionBase.this.REPORT_REDUNDANT_INITIALIZER = this.myReportInitializer.isSelected();
            });
            gc.insets = JBUI.insetsBottom((int)15);
            gc.gridy = 0;
            this.add((Component)this.myReportInitializer, gc);
            this.myReportPrefix = new JCheckBox(InspectionsBundle.message((String)"inspection.unused.assignment.option", (Object[])new Object[0]));
            this.myReportPrefix.setSelected(DefUseInspectionBase.this.REPORT_PREFIX_EXPRESSIONS);
            this.myReportPrefix.getModel().addItemListener(e -> {
                DefUseInspectionBase.this.REPORT_PREFIX_EXPRESSIONS = this.myReportPrefix.isSelected();
            });
            gc.insets = JBUI.emptyInsets();
            ++gc.gridy;
            this.add((Component)this.myReportPrefix, gc);
            this.myReportPostfix = new JCheckBox(InspectionsBundle.message((String)"inspection.unused.assignment.option1", (Object[])new Object[0]));
            this.myReportPostfix.setSelected(DefUseInspectionBase.this.REPORT_POSTFIX_EXPRESSIONS);
            this.myReportPostfix.getModel().addItemListener(e -> {
                DefUseInspectionBase.this.REPORT_POSTFIX_EXPRESSIONS = this.myReportPostfix.isSelected();
            });
            gc.weighty = 1.0;
            ++gc.gridy;
            this.add((Component)this.myReportPostfix, gc);
        }
    }
}

