/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Descriptor {
    private final String myText;
    private final String[] myGroup;
    private final HighlightDisplayKey myKey;
    private Element myConfig;
    private final InspectionToolWrapper myToolWrapper;
    private final HighlightDisplayLevel myLevel;
    private boolean myEnabled;
    @Nullable
    private final NamedScope myScope;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.Descriptor");
    private final ScopeToolState myState;
    private final InspectionProfileModifiableModel myInspectionProfile;
    private final String myScopeName;

    public Descriptor(@NotNull ScopeToolState state, @NotNull InspectionProfileModifiableModel inspectionProfile, @NotNull Project project2) {
        String[] stringArray;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInspection/ex/Descriptor", "<init>"));
        }
        if (inspectionProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/codeInspection/ex/Descriptor", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/Descriptor", "<init>"));
        }
        this.myEnabled = false;
        this.myState = state;
        this.myInspectionProfile = inspectionProfile;
        InspectionToolWrapper tool = state.getTool();
        this.myText = tool.getDisplayName();
        String[] groupPath = tool.getGroupPath();
        if (groupPath.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = InspectionProfileEntry.GENERAL_GROUP_NAME;
        } else {
            stringArray = groupPath;
        }
        this.myGroup = stringArray;
        this.myKey = HighlightDisplayKey.find((String)tool.getShortName());
        this.myScopeName = state.getScopeName();
        this.myScope = state.getScope(project2);
        this.myLevel = inspectionProfile.getErrorLevel(this.myKey, this.myScope, project2);
        this.myEnabled = inspectionProfile.isToolEnabled(this.myKey, this.myScope, project2);
        this.myToolWrapper = tool;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Descriptor)) {
            return false;
        }
        Descriptor descriptor = (Descriptor)obj;
        return this.myKey.equals(descriptor.getKey()) && this.myLevel.equals(descriptor.getLevel()) && this.myEnabled == descriptor.isEnabled() && this.myState.equalTo(descriptor.getState());
    }

    public int hashCode() {
        int hash = this.myKey.hashCode() + 29 * this.myLevel.hashCode();
        return this.myScope != null ? this.myScope.hashCode() + 29 * hash : hash;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public String getText() {
        return this.myText;
    }

    @NotNull
    public HighlightDisplayKey getKey() {
        HighlightDisplayKey highlightDisplayKey = this.myKey;
        if (highlightDisplayKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/Descriptor", "getKey"));
        }
        return highlightDisplayKey;
    }

    public HighlightDisplayLevel getLevel() {
        return this.myLevel;
    }

    @Nullable
    public Element getConfig() {
        return this.myConfig;
    }

    public void loadConfig() {
        if (this.myConfig == null) {
            InspectionToolWrapper toolWrapper = this.getToolWrapper();
            this.myConfig = Descriptor.createConfigElement(toolWrapper);
        }
    }

    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        InspectionToolWrapper inspectionToolWrapper = this.myToolWrapper;
        if (inspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/Descriptor", "getToolWrapper"));
        }
        return inspectionToolWrapper;
    }

    @Nullable
    public String loadDescription() {
        this.loadConfig();
        return this.myToolWrapper.loadDescription();
    }

    public InspectionProfileModifiableModel getInspectionProfile() {
        return this.myInspectionProfile;
    }

    public static Element createConfigElement(InspectionToolWrapper toolWrapper) {
        Element element = new Element("options");
        try {
            toolWrapper.getTool().writeSettings(element);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return element;
    }

    @NotNull
    public String[] getGroup() {
        if (this.myGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/Descriptor", "getGroup"));
        }
        return this.myGroup;
    }

    @NotNull
    public String getScopeName() {
        String string = this.myScopeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/Descriptor", "getScopeName"));
        }
        return string;
    }

    @Nullable
    public NamedScope getScope() {
        return this.myScope;
    }

    public ScopeToolState getState() {
        return this.myState;
    }

    public String toString() {
        return this.myKey.toString();
    }
}

