/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import gnu.trove.THashSet;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class InspectionProfileWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionProfileWrapper");
    public static final Key<Function<InspectionProfileImpl, InspectionProfileWrapper>> CUSTOMIZATION_KEY = Key.create((String)"Inspection Profile Wrapper Customization");
    private static boolean alreadyChecked;
    protected final InspectionProfileImpl myProfile;

    public InspectionProfileWrapper(@NotNull InspectionProfileImpl profile2) {
        if (profile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInspection/ex/InspectionProfileWrapper", "<init>"));
        }
        this.myProfile = profile2;
    }

    public static void checkInspectionsDuplicates(@NotNull InspectionToolWrapper[] toolWrappers) {
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/codeInspection/ex/InspectionProfileWrapper", "checkInspectionsDuplicates"));
        }
        if (alreadyChecked) {
            return;
        }
        alreadyChecked = true;
        THashSet uniqueTools = new THashSet(toolWrappers.length);
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            ProgressManager.checkCanceled();
            if (uniqueTools.add(toolWrapper.getTool())) continue;
            LOG.error("Inspection " + toolWrapper.getDisplayName() + " (" + toolWrapper.getTool().getClass() + ") already registered");
        }
    }

    public boolean isToolEnabled(HighlightDisplayKey key2, PsiElement element) {
        return this.myProfile.isToolEnabled(key2, element);
    }

    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey inspectionToolKey, PsiElement element) {
        if (inspectionToolKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionToolKey", "com/intellij/codeInspection/ex/InspectionProfileWrapper", "getErrorLevel"));
        }
        return this.myProfile.getErrorLevel(inspectionToolKey, element);
    }

    public InspectionToolWrapper getInspectionTool(String shortName, PsiElement element) {
        return this.myProfile.getInspectionTool(shortName, element);
    }

    @NotNull
    public InspectionProfileImpl getInspectionProfile() {
        InspectionProfileImpl inspectionProfileImpl = this.myProfile;
        if (inspectionProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionProfileWrapper", "getInspectionProfile"));
        }
        return inspectionProfileImpl;
    }
}

