/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolsRegistrarCore;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class InspectionToolRegistrar
implements Supplier<List<InspectionToolWrapper>> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionToolRegistrar");
    private final List<Supplier<InspectionToolWrapper>> myInspectionToolFactories = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myInspectionComponentsLoaded;

    private synchronized void ensureInitialized() {
        if (this.myInspectionComponentsLoaded) {
            return;
        }
        this.myInspectionComponentsLoaded = true;
        THashSet providers2 = new THashSet();
        providers2.addAll(((ComponentManagerImpl)ApplicationManager.getApplication()).getComponentInstancesOfType(InspectionToolProvider.class));
        ContainerUtil.addAll((Collection)providers2, (Object[])InspectionToolProvider.EXTENSION_POINT_NAME.getExtensions());
        ArrayList<Supplier<InspectionToolWrapper>> factories = new ArrayList<Supplier<InspectionToolWrapper>>();
        InspectionToolRegistrar.registerTools((Collection<InspectionToolProvider>)providers2, factories);
        boolean isInternal = ApplicationManager.getApplication().isInternal();
        for (LocalInspectionEP localInspectionEP : (LocalInspectionEP[])LocalInspectionEP.LOCAL_INSPECTION.getExtensions()) {
            if (!isInternal && localInspectionEP.isInternal) continue;
            factories.add(() -> new LocalInspectionToolWrapper(ep));
        }
        for (LocalInspectionEP localInspectionEP : (InspectionEP[])InspectionEP.GLOBAL_INSPECTION.getExtensions()) {
            if (!isInternal && localInspectionEP.isInternal) continue;
            factories.add(() -> InspectionToolRegistrar.lambda$ensureInitialized$1((InspectionEP)localInspectionEP));
        }
        this.myInspectionToolFactories.addAll(factories);
    }

    @NotNull
    public static InspectionToolWrapper wrapTool(@NotNull InspectionProfileEntry profileEntry) {
        if (profileEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profileEntry", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "wrapTool"));
        }
        if (profileEntry instanceof LocalInspectionTool) {
            LocalInspectionToolWrapper localInspectionToolWrapper = new LocalInspectionToolWrapper((LocalInspectionTool)profileEntry);
            if (localInspectionToolWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "wrapTool"));
            }
            return localInspectionToolWrapper;
        }
        if (profileEntry instanceof GlobalInspectionTool) {
            GlobalInspectionToolWrapper globalInspectionToolWrapper = new GlobalInspectionToolWrapper((GlobalInspectionTool)profileEntry);
            if (globalInspectionToolWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "wrapTool"));
            }
            return globalInspectionToolWrapper;
        }
        throw new RuntimeException("unknown inspection class: " + profileEntry + "; " + profileEntry.getClass());
    }

    private static void registerTools(@NotNull Collection<InspectionToolProvider> providers2, @NotNull List<Supplier<InspectionToolWrapper>> factories) {
        if (providers2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerTools"));
        }
        if (factories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factories", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerTools"));
        }
        for (InspectionToolProvider provider : providers2) {
            for (Class aClass : provider.getInspectionClasses()) {
                factories.add(() -> {
                    InspectionProfileEntry entry = (InspectionProfileEntry)InspectionToolsRegistrarCore.instantiateTool((Class)aClass);
                    return entry == null ? null : InspectionToolRegistrar.wrapTool(entry);
                });
            }
        }
    }

    public static InspectionToolRegistrar getInstance() {
        return (InspectionToolRegistrar)ServiceManager.getService(InspectionToolRegistrar.class);
    }

    @Override
    @NotNull
    public List<InspectionToolWrapper> get() {
        List<InspectionToolWrapper> list2 = this.createTools();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "get"));
        }
        return list2;
    }

    @NotNull
    public List<InspectionToolWrapper> createTools() {
        this.ensureInitialized();
        ArrayList<InspectionToolWrapper> tools = new ArrayList<InspectionToolWrapper>(this.myInspectionToolFactories.size());
        for (Supplier<InspectionToolWrapper> factory : this.myInspectionToolFactories) {
            ProgressManager.checkCanceled();
            InspectionToolWrapper toolWrapper = factory.get();
            if (toolWrapper == null || InspectionToolRegistrar.checkTool(toolWrapper) != null) continue;
            tools.add(toolWrapper);
        }
        ArrayList<InspectionToolWrapper> arrayList = tools;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "createTools"));
        }
        return arrayList;
    }

    private static String checkTool(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "checkTool"));
        }
        if (!(toolWrapper instanceof LocalInspectionToolWrapper)) {
            return null;
        }
        String message2 = null;
        try {
            String id = toolWrapper.getID();
            if (id == null || !LocalInspectionTool.isValidID((String)id)) {
                message2 = InspectionsBundle.message((String)"inspection.disabled.wrong.id", (Object[])new Object[]{toolWrapper.getShortName(), id, "[a-zA-Z_0-9.-]+"});
            }
        }
        catch (Throwable t) {
            message2 = InspectionsBundle.message((String)"inspection.disabled.error", (Object[])new Object[]{toolWrapper.getShortName(), t.getMessage()});
        }
        if (message2 != null) {
            LOG.error(message2);
        }
        return message2;
    }

    private static /* synthetic */ InspectionToolWrapper lambda$ensureInitialized$1(InspectionEP ep) {
        return new GlobalInspectionToolWrapper(ep);
    }
}

