/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.AddCustomHtmlElementIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownElementInspection;
import com.intellij.codeInspection.htmlInspections.RemoveAttributeIntentionAction;
import com.intellij.codeInspection.htmlInspections.SwitchToHtml5WithHighPriorityAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.EditDistance;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlUnknownAttributeInspectionBase
extends HtmlUnknownElementInspection {
    private static final Key<HtmlUnknownElementInspection> ATTRIBUTE_KEY = Key.create((String)"HtmlUnknownAttribute");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.htmlInspections.HtmlUnknownAttributeInspection");

    public HtmlUnknownAttributeInspectionBase() {
        this("");
    }

    public HtmlUnknownAttributeInspectionBase(String defaultValues) {
        super(defaultValues);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.unknown.attribute", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("HtmlUnknownAttribute" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase", "getShortName"));
        }
        return "HtmlUnknownAttribute";
    }

    @Override
    protected String getCheckboxTitle() {
        return XmlBundle.message((String)"html.inspections.unknown.tag.attribute.checkbox.title", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected String getPanelTitle() {
        String string = XmlBundle.message((String)"html.inspections.unknown.tag.attribute.title", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase", "getPanelTitle"));
        }
        return string;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase", "getLogger"));
        }
        return logger;
    }

    @Override
    protected void checkAttribute(@NotNull XmlAttribute attribute, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase", "checkAttribute"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase", "checkAttribute"));
        }
        XmlTag tag = attribute.getParent();
        if (tag instanceof HtmlTag) {
            String name2;
            XmlElementDescriptor elementDescriptor = tag.getDescriptor();
            if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor) {
                return;
            }
            XmlAttributeDescriptor attributeDescriptor = elementDescriptor.getAttributeDescriptor(attribute);
            if (!(attributeDescriptor != null || attribute.isNamespaceDeclaration() || XmlUtil.attributeFromTemplateFramework(name2 = attribute.getName(), tag) || this.isCustomValuesEnabled() && this.isCustomValue(name2))) {
                boolean maySwitchToHtml5 = HtmlUtil.isCustomHtml5Attribute(name2) && !HtmlUtil.hasNonHtml5Doctype((XmlElement)tag);
                ArrayList<LocalQuickFix> quickfixes = new ArrayList<LocalQuickFix>(6);
                quickfixes.add(new AddCustomHtmlElementIntentionAction(ATTRIBUTE_KEY, name2, XmlBundle.message((String)"add.custom.html.attribute", (Object[])new Object[]{name2})));
                quickfixes.add(new RemoveAttributeIntentionAction(name2));
                if (maySwitchToHtml5) {
                    quickfixes.add(new SwitchToHtml5WithHighPriorityAction());
                }
                HtmlUnknownAttributeInspectionBase.addSimilarAttributesQuickFixes(tag, name2, quickfixes);
                HtmlUnknownAttributeInspectionBase.registerProblemOnAttributeName(attribute, XmlErrorMessages.message("attribute.is.not.allowed.here", attribute.getName()), holder, quickfixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    private static void addSimilarAttributesQuickFixes(XmlTag tag, String name2, ArrayList<LocalQuickFix> quickfixes) {
        XmlElementDescriptor descriptor = tag.getDescriptor();
        if (descriptor == null) {
            return;
        }
        XmlAttributeDescriptor[] descriptors = descriptor.getAttributesDescriptors(tag);
        int initialSize = quickfixes.size();
        for (XmlAttributeDescriptor attr : descriptors) {
            if (EditDistance.optimalAlignment((CharSequence)name2, (CharSequence)attr.getName(), (boolean)false) <= 1) {
                quickfixes.add(new RenameAttributeFix(attr));
            }
            if (quickfixes.size() >= initialSize + 3) break;
        }
    }

    private static class RenameAttributeFix
    implements LocalQuickFix,
    HighPriorityAction {
        private String name;

        public RenameAttributeFix(XmlAttributeDescriptor attr) {
            this.name = attr.getName();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Rename attribute" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase$RenameAttributeFix", "getFamilyName"));
            }
            return "Rename attribute";
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Rename attribute to " + this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase$RenameAttributeFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase$RenameAttributeFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase$RenameAttributeFix", "applyFix"));
            }
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlAttribute.class);
            if (attribute == null) {
                return;
            }
            attribute.setName(this.name);
        }
    }
}

