/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class Java8ListSortInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java18api/Java8ListSortInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8ListSortInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiClass containingClass;
                PsiMethod method;
                super.visitMethodCallExpression(expression2);
                PsiElement nameElement = expression2.getMethodExpression().getReferenceNameElement();
                if (nameElement != null && expression2.getArgumentList().getExpressions().length == 2 && "sort".equals(nameElement.getText()) && (method = expression2.resolveMethod()) != null && (containingClass = method.getContainingClass()) != null && "java.util.Collections".equals(containingClass.getQualifiedName())) {
                    holder.registerProblem(nameElement, QuickFixBundle.message("java.8.list.sort.inspection.description", new Object[0]), new LocalQuickFix[]{new ReplaceWithListSortFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8ListSortInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static class ReplaceWithListSortFix
    implements LocalQuickFix {
        private ReplaceWithListSortFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("java.8.list.sort.inspection.fix.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8ListSortInspection$ReplaceWithListSortFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiExpression[] args;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java18api/Java8ListSortInspection$ReplaceWithListSortFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java18api/Java8ListSortInspection$ReplaceWithListSortFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
            if (methodCallExpression != null && (args = methodCallExpression.getArgumentList().getExpressions()).length == 2) {
                PsiExpression list2 = args[0];
                PsiExpression comparator2 = args[1];
                String replacement = ParenthesesUtils.getText(list2, 2) + ".sort(" + comparator2.getText() + ")";
                methodCallExpression.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(replacement, (PsiElement)methodCallExpression));
            }
        }
    }
}

