/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.longLine;

import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.longLine.LongLineInspectionPolicy;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.SmartList;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongLineInspection
extends LocalInspectionTool {
    @Nullable
    public JComponent createOptionsPanel() {
        HyperlinkLabel codeStyleHyperlink = new HyperlinkLabel("Edit Code Style settings");
        codeStyleHyperlink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DataManager.getInstance().getDataContextFromFocus().doWhenDone(context -> {
                    if (context != null) {
                        Settings settings = (Settings)Settings.KEY.getData(context);
                        if (settings != null) {
                            settings.select((Configurable)settings.find(CodeStyleSchemesConfigurable.class));
                        } else {
                            ShowSettingsUtil.getInstance().showSettingsDialog((Project)CommonDataKeys.PROJECT.getData(context), CodeStyleSchemesConfigurable.class);
                        }
                    }
                });
            }
        });
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)codeStyleHyperlink, "North");
        return panel2;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/longLine/LongLineInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/longLine/LongLineInspection", "checkFile"));
        }
        Project project2 = manager.getProject();
        int codeStyleRightMargin = CodeStyleSettingsManager.getSettings((Project)project2).getRightMargin(file2.getLanguage());
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile instanceof VirtualFileWindow) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(vFile);
        if (document == null) {
            return null;
        }
        SmartList descriptors = new SmartList();
        for (int idx = 0; idx < document.getLineCount(); ++idx) {
            TextRange exceedingRange = LongLineInspection.getExceedingRange(document, idx, codeStyleRightMargin);
            if (exceedingRange.isEmpty() || LongLineInspection.ignoreFor(LongLineInspection.findElementInRange(file2, exceedingRange.shiftRight(-1)))) continue;
            descriptors.add(manager.createProblemDescriptor((PsiElement)file2, exceedingRange, String.format("Line is longer than allowed by code style (> %s columns)", codeStyleRightMargin), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
        }
        return descriptors.isEmpty() ? null : descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    @NotNull
    public static TextRange getExceedingRange(@NotNull Document document, int line, int rightMargin) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInspection/longLine/LongLineInspection", "getExceedingRange"));
        }
        int start = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        TextRange textRange = end > start + rightMargin ? new TextRange(start + rightMargin, end) : TextRange.EMPTY_RANGE;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/longLine/LongLineInspection", "getExceedingRange"));
        }
        return textRange;
    }

    @Nullable
    private static PsiElement findElementInRange(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/longLine/LongLineInspection", "findElementInRange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInspection/longLine/LongLineInspection", "findElementInRange"));
        }
        PsiElement leftElement = file2.findElementAt(range.getStartOffset());
        if (leftElement == null) {
            return null;
        }
        PsiElement rightElement = file2.findElementAt(range.getEndOffset());
        if (rightElement == null) {
            return null;
        }
        return PsiTreeUtil.findCommonParent((PsiElement)leftElement, (PsiElement)rightElement);
    }

    private static boolean ignoreFor(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        for (LongLineInspectionPolicy policy : (LongLineInspectionPolicy[])LongLineInspectionPolicy.EP_NAME.getExtensions()) {
            if (!policy.ignoreLongLineFor(element)) continue;
            return true;
        }
        return false;
    }
}

