/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.impl.AddNotNullAnnotationFix;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.nullable.AnnotateOverriddenMethodParameterFix;
import com.intellij.codeInspection.nullable.ChangeNullableDefaultsFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullableStuffInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @Deprecated
    public boolean REPORT_NULLABLE_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE = true;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_PARAMETER_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_GETTER = true;
    public boolean IGNORE_EXTERNAL_SUPER_NOTNULL;
    public boolean REQUIRE_NOTNULL_FIELDS_INITIALIZED = true;
    public boolean REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_SETTER_PARAMETER = true;
    @Deprecated
    public boolean REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS = true;
    public boolean REPORT_NULLS_PASSED_TO_NON_ANNOTATED_METHOD = true;
    public boolean REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = true;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.nullable.NullableStuffInspectionBase");

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "writeSettings"));
        }
        super.writeSettings(node);
        for (Element child : new ArrayList(node.getChildren())) {
            String name2 = child.getAttributeValue("name");
            String value2 = child.getAttributeValue("value");
            if (!("IGNORE_EXTERNAL_SUPER_NOTNULL".equals(name2) && "false".equals(value2) || "REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED".equals(name2) && "false".equals(value2) || "REQUIRE_NOTNULL_FIELDS_INITIALIZED".equals(name2) && "true".equals(value2)) && (!"REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER".equals(name2) || !"true".equals(value2))) continue;
            node.removeContent((Content)child);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "buildVisitor"));
        }
        PsiFile file2 = holder.getFile();
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2) || NullableStuffInspectionBase.nullabilityAnnotationsNotAvailable(file2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                NullableStuffInspectionBase.this.checkNullableStuffForMethod(method, holder, isOnTheFly);
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                NullableStuffInspectionBase.this.checkMethodReference(expression2, holder);
                JavaResolveResult result2 = expression2.advancedResolve(false);
                PsiElement target2 = result2.getElement();
                if (target2 instanceof PsiMethod) {
                    this.checkCollectionNullityOnAssignment((PsiElement)expression2, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression2), result2.getSubstitutor().substitute(((PsiMethod)target2).getReturnType()));
                }
            }

            public void visitField(PsiField field) {
                PsiType type2 = field.getType();
                Annotated annotated = NullableStuffInspectionBase.check((PsiModifierListOwner)field, holder, type2);
                if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type2)) {
                    return;
                }
                Project project2 = holder.getProject();
                NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
                if (annotated.isDeclaredNotNull ^ annotated.isDeclaredNullable) {
                    List annoToRemove;
                    String anno = annotated.isDeclaredNotNull ? manager.getDefaultNotNull() : manager.getDefaultNullable();
                    List list2 = annoToRemove = annotated.isDeclaredNotNull ? manager.getNullables() : manager.getNotNulls();
                    if (!NullableStuffInspectionBase.checkNonStandardAnnotations(field, annotated, manager, anno, holder)) {
                        return;
                    }
                    NullableStuffInspectionBase.this.checkAccessors(field, annotated, project2, manager, anno, annoToRemove, holder);
                    NullableStuffInspectionBase.this.checkConstructorParameters(field, annotated, manager, anno, annoToRemove, holder);
                }
                if (NullableStuffInspectionBase.this.REQUIRE_NOTNULL_FIELDS_INITIALIZED && !annotated.isDeclaredNullable) {
                    NullableStuffInspectionBase.checkNotNullFieldsInitialized(field, manager, holder);
                }
            }

            public void visitParameter(PsiParameter parameter) {
                NullableStuffInspectionBase.check((PsiModifierListOwner)parameter, holder, parameter.getType());
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                PsiClass psiClass;
                if (!"org.jetbrains.annotations.NotNull".equals(annotation.getQualifiedName())) {
                    return;
                }
                PsiAnnotationMemberValue value2 = annotation.findDeclaredAttributeValue("exception");
                if (value2 instanceof PsiClassObjectAccessExpression && (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiClassObjectAccessExpression)value2).getOperand().getType())) != null && !this.hasStringConstructor(psiClass)) {
                    holder.registerProblem((PsiElement)value2, "Custom exception class should have a constructor with a single message parameter of String type", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }

            private boolean hasStringConstructor(PsiClass aClass) {
                for (PsiMethod method : aClass.getConstructors()) {
                    PsiParameterList list2 = method.getParameterList();
                    if (list2.getParametersCount() != 1 || !list2.getParameters()[0].getType().equalsToText("java.lang.String")) continue;
                    return true;
                }
                return false;
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                this.checkNullableNotNullInstantiationConflict(reference);
            }

            private void checkNullableNotNullInstantiationConflict(PsiJavaCodeReferenceElement reference) {
                PsiElement element = reference.resolve();
                if (element instanceof PsiClass) {
                    PsiTypeParameter[] typeParameters = ((PsiClass)element).getTypeParameters();
                    PsiTypeElement[] typeArguments = this.getReferenceTypeArguments(reference);
                    if (typeParameters.length > 0 && typeParameters.length == typeArguments.length) {
                        for (int i2 = 0; i2 < typeParameters.length; ++i2) {
                            if (!this.isNullityConflict((PsiType)JavaPsiFacade.getElementFactory((Project)element.getProject()).createType((PsiClass)typeParameters[i2]), typeArguments[i2].getType())) continue;
                            holder.registerProblem((PsiElement)typeArguments[i2], "Nullable type argument where non-null one is expected", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                        }
                    }
                }
            }

            private PsiTypeElement[] getReferenceTypeArguments(PsiJavaCodeReferenceElement reference) {
                PsiReferenceParameterList typeArgList = reference.getParameterList();
                return typeArgList == null ? PsiTypeElement.EMPTY_ARRAY : typeArgList.getTypeParameterElements();
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                this.checkCollectionNullityOnAssignment((PsiElement)expression2.getOperationSign(), expression2.getLExpression().getType(), expression2.getRExpression());
            }

            public void visitLocalVariable(PsiLocalVariable variable) {
                PsiIdentifier identifier = variable.getNameIdentifier();
                if (identifier != null) {
                    this.checkCollectionNullityOnAssignment((PsiElement)identifier, variable.getType(), variable.getInitializer());
                }
            }

            public void visitReturnStatement(PsiReturnStatement statement2) {
                PsiExpression returnValue = statement2.getReturnValue();
                if (returnValue == null) {
                    return;
                }
                this.checkCollectionNullityOnAssignment((PsiElement)statement2.getReturnValue(), PsiTypesUtil.getMethodReturnType((PsiElement)statement2), returnValue);
            }

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                super.visitLambdaExpression(lambda2);
                PsiElement body2 = lambda2.getBody();
                if (body2 instanceof PsiExpression) {
                    this.checkCollectionNullityOnAssignment(body2, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2), (PsiExpression)body2);
                }
            }

            public void visitCallExpression(PsiCallExpression callExpression) {
                PsiExpressionList argList = callExpression.getArgumentList();
                JavaResolveResult result2 = callExpression.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)result2.getElement();
                if (method == null || argList == null) {
                    return;
                }
                PsiSubstitutor substitutor = result2.getSubstitutor();
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                PsiExpression[] arguments = argList.getExpressions();
                for (int i2 = 0; i2 < arguments.length; ++i2) {
                    PsiExpression argument = arguments[i2];
                    if (i2 >= parameters2.length || i2 >= parameters2.length - 1 && MethodCallInstruction.isVarArgCall(method, substitutor, arguments, parameters2)) continue;
                    this.checkCollectionNullityOnAssignment((PsiElement)argument, substitutor.substitute(parameters2[i2].getType()), argument);
                }
            }

            private void checkCollectionNullityOnAssignment(@NotNull PsiElement errorElement, @Nullable PsiType expectedType, @Nullable PsiExpression assignedExpression) {
                if (errorElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorElement", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$1", "checkCollectionNullityOnAssignment"));
                }
                if (assignedExpression == null) {
                    return;
                }
                this.checkCollectionNullityOnAssignment(errorElement, expectedType, assignedExpression.getType());
            }

            private void checkCollectionNullityOnAssignment(@NotNull PsiElement errorElement, @Nullable PsiType expectedType, @Nullable PsiType assignedType) {
                if (errorElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorElement", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$1", "checkCollectionNullityOnAssignment"));
                }
                if (this.isNullableNotNullCollectionConflict(errorElement, expectedType, assignedType)) {
                    holder.registerProblem(errorElement, "Assigning a collection of nullable elements into a collection of non-null elements", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }

            private boolean isNullableNotNullCollectionConflict(PsiElement place, @Nullable PsiType expectedType, @Nullable PsiType assignedType) {
                if (this.isNullityConflict(JavaGenericsUtil.getCollectionItemType((PsiType)expectedType, (GlobalSearchScope)place.getResolveScope()), JavaGenericsUtil.getCollectionItemType((PsiType)assignedType, (GlobalSearchScope)place.getResolveScope()))) {
                    return true;
                }
                for (int i2 = 0; i2 <= 1; ++i2) {
                    PsiType assignedArg;
                    PsiType expectedArg = PsiUtil.substituteTypeParameter((PsiType)expectedType, (String)"java.util.Map", (int)i2, (boolean)false);
                    if (!this.isNullityConflict(expectedArg, assignedArg = PsiUtil.substituteTypeParameter((PsiType)assignedType, (String)"java.util.Map", (int)i2, (boolean)false))) continue;
                    return true;
                }
                return false;
            }

            private boolean isNullityConflict(PsiType expected, PsiType assigned) {
                return DfaPsiUtil.getTypeNullability(expected) == Nullness.NOT_NULL && DfaPsiUtil.getTypeNullability(assigned) == Nullness.NULLABLE;
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private void checkMethodReference(PsiMethodReferenceExpression expression2, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkMethodReference"));
        }
        PsiMethod superMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)expression2);
        PsiMethod targetMethod = (PsiMethod)ObjectUtils.tryCast((Object)expression2.resolve(), PsiMethod.class);
        if (superMethod == null || targetMethod == null) {
            return;
        }
        PsiElement refName = expression2.getReferenceNameElement();
        assert (refName != null);
        if (this.isNullableOverridingNotNull(NullableStuffInspectionBase.check((PsiModifierListOwner)targetMethod, holder, expression2.getType()), superMethod)) {
            holder.registerProblem(refName, InspectionsBundle.message((String)"inspection.nullable.problems.Nullable.method.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)targetMethod), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        } else if (this.isNonAnnotatedOverridingNotNull(targetMethod, superMethod)) {
            holder.registerProblem(refName, "Not annotated method is used as an override for a method annotated with " + NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{this.createFixForNonAnnotatedOverridesNotNull(targetMethod, superMethod)});
        }
    }

    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter) {
        return null;
    }

    private static boolean nullabilityAnnotationsNotAvailable(PsiFile file2) {
        Project project2 = file2.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project2);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        return ContainerUtil.find((Iterable)NullableNotNullManager.getInstance((Project)project2).getNullables(), s -> facade.findClass(s, scope) != null) == null;
    }

    private static boolean checkNonStandardAnnotations(PsiField field, Annotated annotated, NullableNotNullManager manager, String anno, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkNonStandardAnnotations"));
        }
        if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)field, (String)anno)) {
            PsiAnnotation annotation;
            PsiAnnotation notNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, (Collection)manager.getNotNulls());
            PsiAnnotation nullable = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, (Collection)manager.getNullables());
            String message2 = "Not '";
            if (annotated.isDeclaredNullable) {
                message2 = message2 + nullable.getQualifiedName();
                annotation = nullable;
            } else {
                message2 = message2 + notNull.getQualifiedName();
                annotation = notNull;
            }
            message2 = message2 + "' but '" + anno + "' would be used for code generation.";
            PsiJavaCodeReferenceElement annotationNameReferenceElement = annotation.getNameReferenceElement();
            holder.registerProblem((PsiElement)(annotationNameReferenceElement != null && annotationNameReferenceElement.isPhysical() ? annotationNameReferenceElement : field.getNameIdentifier()), message2, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new ChangeNullableDefaultsFix(notNull, nullable, manager)});
            return false;
        }
        return true;
    }

    private void checkAccessors(PsiField field, Annotated annotated, Project project2, NullableNotNullManager manager, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        PsiClass containingClass;
        PsiMethod setter;
        PsiIdentifier nameIdentifier;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkAccessors"));
        }
        String propName = JavaCodeStyleManager.getInstance((Project)project2).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
        boolean isStatic = field.hasModifierProperty("static");
        PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)field.getContainingClass(), (String)propName, (boolean)isStatic, (boolean)false);
        PsiIdentifier psiIdentifier = nameIdentifier = getter == null ? null : getter.getNameIdentifier();
        if (nameIdentifier != null && nameIdentifier.isPhysical() && PropertyUtil.isSimpleGetter((PsiMethod)getter)) {
            AnnotateMethodFix getterAnnoFix = new AnnotateMethodFix(anno, ArrayUtil.toStringArray(annoToRemove)){

                @Override
                public int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project2) {
                    return 1;
                }
            };
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)getter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)getter.getReturnType())) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.getter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{getterAnnoFix});
            }
            if (annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)getter, false) || annotated.isDeclaredNullable && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)getter, false, false)) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.getter.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)getter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{getterAnnoFix});
            }
        }
        if ((setter = PropertyUtil.findPropertySetter((PsiClass)(containingClass = field.getContainingClass()), (String)propName, (boolean)isStatic, (boolean)false)) != null && setter.isPhysical()) {
            PsiIdentifier nameIdentifier1;
            PsiParameter[] parameters2 = setter.getParameterList().getParameters();
            assert (parameters2.length == 1) : setter.getText();
            PsiParameter parameter = parameters2[0];
            LOG.assertTrue(parameter != null, (Object)setter.getText());
            AddAnnotationPsiFix addAnnoFix = NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter);
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)parameter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter.getType())) {
                nameIdentifier1 = parameter.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter, parameter, nameIdentifier1);
                holder.registerProblem((PsiElement)nameIdentifier1, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.setter.parameter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{addAnnoFix});
            }
            if (PropertyUtil.isSimpleSetter((PsiMethod)setter) && annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)parameter, false)) {
                nameIdentifier1 = parameter.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter, parameter, nameIdentifier1);
                holder.registerProblem((PsiElement)nameIdentifier1, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.setter.parameter.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{addAnnoFix});
            }
        }
    }

    @NotNull
    private static AddAnnotationPsiFix createAddAnnotationFix(String anno, List<String> annoToRemove, PsiParameter parameter) {
        AddAnnotationPsiFix addAnnotationPsiFix = new AddAnnotationPsiFix(anno, (PsiModifierListOwner)parameter, PsiNameValuePair.EMPTY_ARRAY, ArrayUtil.toStringArray(annoToRemove));
        if (addAnnotationPsiFix == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "createAddAnnotationFix"));
        }
        return addAnnotationPsiFix;
    }

    private static void assertValidElement(PsiMethod setter, PsiParameter parameter, PsiIdentifier nameIdentifier1) {
        LOG.assertTrue(nameIdentifier1 != null && nameIdentifier1.isPhysical(), (Object)setter.getText());
        LOG.assertTrue(parameter.isPhysical(), (Object)setter.getText());
    }

    private static void checkNotNullFieldsInitialized(PsiField field, NullableNotNullManager manager, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkNotNullFieldsInitialized"));
        }
        PsiAnnotation annotation = manager.getNotNullAnnotation((PsiModifierListOwner)field, false);
        if (annotation == null || HighlightControlFlowUtil.isFieldInitializedAfterObjectConstruction(field)) {
            return;
        }
        boolean byDefault = manager.isContainerAnnotation(annotation);
        PsiJavaCodeReferenceElement name2 = annotation.getNameReferenceElement();
        holder.registerProblem((PsiElement)(annotation.isPhysical() && !byDefault ? annotation : field.getNameIdentifier()), (byDefault && name2 != null ? "@" + name2.getReferenceName() : "Not-null") + " fields must be initialized", new LocalQuickFix[0]);
    }

    private void checkConstructorParameters(PsiField field, Annotated annotated, NullableNotNullManager manager, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "checkConstructorParameters"));
        }
        List<PsiExpression> initializers = DfaPsiUtil.findAllConstructorInitializers(field);
        if (initializers.isEmpty()) {
            return;
        }
        ArrayList notNullParams = ContainerUtil.newArrayList();
        boolean isFinal = field.hasModifierProperty("final");
        for (PsiExpression rhs : initializers) {
            PsiIdentifier nameIdentifier;
            PsiElement target2;
            if (!(rhs instanceof PsiReferenceExpression) || !NullableStuffInspectionBase.isConstructorParameter(target2 = ((PsiReferenceExpression)rhs).resolve()) || !target2.isPhysical()) continue;
            PsiParameter parameter = (PsiParameter)target2;
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)parameter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter.getType()) && (nameIdentifier = parameter.getNameIdentifier()) != null && nameIdentifier.isPhysical()) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.constructor.parameter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter)});
                continue;
            }
            if (!isFinal || !annotated.isDeclaredNullable || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false)) continue;
            notNullParams.add(parameter);
        }
        if (notNullParams.size() != initializers.size()) {
            return;
        }
        PsiIdentifier nameIdentifier = field.getNameIdentifier();
        if (nameIdentifier.isPhysical()) {
            holder.registerProblem((PsiElement)nameIdentifier, "@" + NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field) + " field is always initialized not-null", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AddNotNullAnnotationFix((PsiModifierListOwner)field)});
        }
    }

    private static boolean isConstructorParameter(@Nullable PsiElement parameter) {
        return parameter instanceof PsiParameter && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiParameterList.class).withParent((ElementPattern)PsiJavaPatterns.psiMethod().constructor(true))).accepts((Object)parameter.getParent());
    }

    @NotNull
    private static String getPresentableAnnoName(@NotNull PsiModifierListOwner owner2) {
        if (owner2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner2.getProject());
        HashSet names = ContainerUtil.newHashSet((Iterable)manager.getNullables());
        names.addAll(manager.getNotNulls());
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)owner2, (Set)names);
        if (annotation != null) {
            String string = NullableStuffInspectionBase.getPresentableAnnoName(annotation);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
            }
            return string;
        }
        String anno = manager.getNotNull(owner2);
        String string = StringUtil.getShortName((String)(anno != null ? anno : StringUtil.notNullize((String)manager.getNullable(owner2), (String)"???")));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
        }
        return string;
    }

    public static String getPresentableAnnoName(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
        }
        return StringUtil.getShortName((String)StringUtil.notNullize((String)annotation.getQualifiedName(), (String)"???"));
    }

    private static Annotated check(PsiModifierListOwner parameter, ProblemsHolder holder, PsiType type2) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)holder.getProject());
        PsiAnnotation isDeclaredNotNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (Collection)manager.getNotNulls());
        PsiAnnotation isDeclaredNullable = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (Collection)manager.getNullables());
        if (isDeclaredNullable != null && isDeclaredNotNull != null) {
            NullableStuffInspectionBase.reportNullableNotNullConflict(holder, parameter, isDeclaredNullable, isDeclaredNotNull);
        }
        if ((isDeclaredNotNull != null || isDeclaredNullable != null) && type2 != null && TypeConversionUtil.isPrimitive((String)type2.getCanonicalText())) {
            PsiAnnotation annotation = isDeclaredNotNull == null ? isDeclaredNullable : isDeclaredNotNull;
            NullableStuffInspectionBase.reportPrimitiveType(holder, (PsiElement)annotation, annotation, parameter);
        }
        if (parameter.getParent() instanceof PsiForeachStatement) {
            PsiExpression iteratedValue2 = ((PsiForeachStatement)parameter.getParent()).getIteratedValue();
            Nullness itemTypeNullability = DfaPsiUtil.getTypeNullability(iteratedValue2 == null ? null : JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue2));
            if (isDeclaredNotNull != null && itemTypeNullability == Nullness.NULLABLE) {
                holder.registerProblem((PsiElement)isDeclaredNotNull, "Loop parameter can be null", new LocalQuickFix[]{new RemoveAnnotationQuickFix(isDeclaredNotNull, null)});
            } else if (isDeclaredNullable != null && itemTypeNullability == Nullness.NOT_NULL) {
                holder.registerProblem((PsiElement)isDeclaredNullable, "Loop parameter is always not-null", new LocalQuickFix[]{new RemoveAnnotationQuickFix(isDeclaredNullable, null)});
            }
        }
        return new Annotated(isDeclaredNotNull != null, isDeclaredNullable != null);
    }

    private static void reportPrimitiveType(ProblemsHolder holder, PsiElement psiElement, PsiAnnotation annotation, PsiModifierListOwner listOwner) {
        holder.registerProblem(psiElement.isPhysical() ? psiElement : listOwner.getNavigationElement(), InspectionsBundle.message((String)"inspection.nullable.problems.primitive.type.annotation", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(annotation, listOwner)});
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.nullable.problems.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("NullableProblems" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getShortName"));
        }
        return "NullableProblems";
    }

    private void checkNullableStuffForMethod(PsiMethod method, ProblemsHolder holder, boolean isOnFly) {
        Annotated annotated = NullableStuffInspectionBase.check((PsiModifierListOwner)method, holder, method.getReturnType());
        List superMethods = ContainerUtil.map((Collection)method.findSuperMethodSignaturesIncludingStatic(true), signature -> signature.getMethod());
        NullableNotNullManager nullableManager = NullableNotNullManager.getInstance((Project)holder.getProject());
        this.checkSupers(method, holder, annotated, superMethods);
        this.checkParameters(method, holder, superMethods, nullableManager, isOnFly);
        this.checkOverriders(method, holder, annotated, nullableManager);
    }

    private void checkSupers(PsiMethod method, ProblemsHolder holder, Annotated annotated, List<PsiMethod> superMethods) {
        for (PsiMethod superMethod : superMethods) {
            if (this.isNullableOverridingNotNull(annotated, superMethod)) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (Collection)this.getNullityManager(method).getNullables(), (boolean)true);
                holder.registerProblem((PsiElement)(annotation != null ? annotation : method.getNameIdentifier()), InspectionsBundle.message((String)"inspection.nullable.problems.Nullable.method.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)method), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                break;
            }
            if (!this.isNonAnnotatedOverridingNotNull(method, superMethod)) continue;
            holder.registerProblem((PsiElement)method.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.method.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{this.createFixForNonAnnotatedOverridesNotNull(method, superMethod)});
            break;
        }
    }

    private NullableNotNullManager getNullityManager(PsiMethod method) {
        return NullableNotNullManager.getInstance((Project)method.getProject());
    }

    private LocalQuickFix createFixForNonAnnotatedOverridesNotNull(PsiMethod method, PsiMethod superMethod) {
        NullableNotNullManager nullableManager = this.getNullityManager(method);
        String defaultNotNull = nullableManager.getDefaultNotNull();
        String[] annotationsToRemove = ArrayUtil.toStringArray((Collection)nullableManager.getNullables());
        return AnnotationUtil.isAnnotatingApplicable((PsiElement)method, (String)defaultNotNull) ? this.createAnnotateMethodFix(defaultNotNull, annotationsToRemove) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)superMethod);
    }

    private boolean isNullableOverridingNotNull(Annotated methodInfo, PsiMethod superMethod) {
        return this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE && methodInfo.isDeclaredNullable && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)superMethod, true, false);
    }

    private boolean isNonAnnotatedOverridingNotNull(PsiMethod method, PsiMethod superMethod) {
        return this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL && !(method.getReturnType() instanceof PsiPrimitiveType) && !method.isConstructor() && !this.getNullityManager(method).hasNullability((PsiModifierListOwner)method) && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)superMethod, true, this.IGNORE_EXTERNAL_SUPER_NOTNULL) && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)superMethod);
    }

    private static boolean hasInheritableNotNull(PsiModifierListOwner owner2) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)owner2, (String)"javax.annotation.constraints.NotNull", (boolean)true);
    }

    private void checkParameters(PsiMethod method, ProblemsHolder holder, List<PsiMethod> superMethods, NullableNotNullManager nullableManager, boolean isOnFly) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            PsiParameter parameter = parameters2[i2];
            ArrayList superParameters = ContainerUtil.newArrayList();
            for (PsiMethod superMethod : superMethods) {
                PsiParameter[] _superParameters = superMethod.getParameterList().getParameters();
                if (_superParameters.length != parameters2.length) continue;
                superParameters.add(_superParameters[i2]);
            }
            if (this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE) {
                for (PsiParameter superParameter : superParameters) {
                    if (!NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false) || !NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)superParameter, false)) continue;
                    PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (Collection)nullableManager.getNotNulls(), (boolean)true);
                    holder.registerProblem((PsiElement)(annotation != null ? annotation : parameter.getNameIdentifier()), InspectionsBundle.message((String)"inspection.nullable.problems.NotNull.parameter.overrides.Nullable", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superParameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    break;
                }
            }
            if (this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL) {
                for (PsiParameter superParameter : superParameters) {
                    if (nullableManager.hasNullability((PsiModifierListOwner)parameter) || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)superParameter, false, this.IGNORE_EXTERNAL_SUPER_NOTNULL) || NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)superParameter)) continue;
                    AddNotNullAnnotationFix fix = AnnotationUtil.isAnnotatingApplicable((PsiElement)parameter, (String)nullableManager.getDefaultNotNull()) ? new AddNotNullAnnotationFix((PsiModifierListOwner)parameter) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)superParameter);
                    holder.registerProblem((PsiElement)parameter.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.parameter.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superParameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                    break;
                }
            }
            if (this.REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED) {
                for (PsiParameter superParameter : superParameters) {
                    if (nullableManager.hasNullability((PsiModifierListOwner)superParameter) || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false)) continue;
                    PsiAnnotation notNullAnnotation = nullableManager.getNotNullAnnotation((PsiModifierListOwner)parameter, false);
                    assert (notNullAnnotation != null);
                    boolean physical = PsiTreeUtil.isAncestor((PsiElement)parameter, (PsiElement)notNullAnnotation, (boolean)true);
                    RemoveAnnotationQuickFix fix = physical ? new RemoveAnnotationQuickFix(notNullAnnotation, (PsiModifierListOwner)parameter) : null;
                    holder.registerProblem((PsiElement)(physical ? notNullAnnotation : parameter.getNameIdentifier()), InspectionsBundle.message((String)"inspection.nullable.problems.NotNull.parameter.overrides.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                    break;
                }
            }
            this.checkNullLiteralArgumentOfNotNullParameterUsages(method, holder, nullableManager, isOnFly, i2, parameter);
        }
    }

    private void checkNullLiteralArgumentOfNotNullParameterUsages(PsiMethod method, ProblemsHolder holder, NullableNotNullManager nullableManager, boolean isOnFly, int parameterIdx, PsiParameter parameter) {
        if (this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER && isOnFly && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false)) {
            PsiAnnotation notNullAnnotation = nullableManager.getNotNullAnnotation((PsiModifierListOwner)parameter, false);
            if (JavaNullMethodArgumentUtil.hasNullArgument(method, parameterIdx)) {
                boolean physical = PsiTreeUtil.isAncestor((PsiElement)parameter, (PsiElement)notNullAnnotation, (boolean)true);
                holder.registerProblem((PsiElement)(physical ? notNullAnnotation : parameter.getNameIdentifier()), InspectionsBundle.message((String)"inspection.nullable.problems.NotNull.parameter.receives.null.literal", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{this.createNavigateToNullParameterUsagesFix(parameter)});
            }
        }
    }

    private void checkOverriders(PsiMethod method, ProblemsHolder holder, Annotated annotated, NullableNotNullManager nullableManager) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (this.REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS) {
            boolean[] parameterAnnotated = new boolean[parameters2.length];
            boolean[] parameterQuickFixSuggested = new boolean[parameters2.length];
            boolean hasAnnotatedParameter = false;
            for (int i2 = 0; i2 < parameters2.length; ++i2) {
                PsiParameter parameter = parameters2[i2];
                parameterAnnotated[i2] = NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false) && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)parameter);
                hasAnnotatedParameter |= parameterAnnotated[i2];
            }
            if (hasAnnotatedParameter || annotated.isDeclaredNotNull && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)method)) {
                PsiManager manager = method.getManager();
                String defaultNotNull = nullableManager.getDefaultNotNull();
                boolean superMethodApplicable = AnnotationUtil.isAnnotatingApplicable((PsiElement)method, (String)defaultNotNull);
                PsiMethod[] overridings = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY);
                boolean methodQuickFixSuggested = false;
                for (PsiMethod overriding : overridings) {
                    if (!manager.isInProject((PsiElement)overriding)) continue;
                    boolean applicable = AnnotationUtil.isAnnotatingApplicable((PsiElement)overriding, (String)defaultNotNull);
                    if (!(methodQuickFixSuggested || !annotated.isDeclaredNotNull || NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)overriding, false, false) || !NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)overriding, false) && NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)overriding, true))) {
                        method.getNameIdentifier();
                        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (Collection)nullableManager.getNotNulls());
                        String[] annotationsToRemove = ArrayUtil.toStringArray((Collection)nullableManager.getNullables());
                        LocalQuickFix fix = applicable ? new MyAnnotateMethodFix(defaultNotNull, annotationsToRemove) : (superMethodApplicable ? null : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)method));
                        PsiAnnotation psiElement = annotation;
                        if (!annotation.isPhysical() && (psiElement = method.getNameIdentifier()) == null) continue;
                        holder.registerProblem((PsiElement)psiElement, InspectionsBundle.message((String)"nullable.stuff.problems.overridden.methods.are.not.annotated", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                        methodQuickFixSuggested = true;
                    }
                    if (!hasAnnotatedParameter) continue;
                    PsiParameter[] psiParameters = overriding.getParameterList().getParameters();
                    for (int i3 = 0; i3 < psiParameters.length; ++i3) {
                        PsiAnnotation annotation;
                        if (parameterQuickFixSuggested[i3]) continue;
                        PsiParameter parameter = psiParameters[i3];
                        if (!parameterAnnotated[i3] || NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter, false, false) || NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)parameter, false)) continue;
                        parameters2[i3].getNameIdentifier();
                        PsiAnnotation psiElement = annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameters2[i3], (Collection)nullableManager.getNotNulls());
                        if ((annotation == null || !annotation.isPhysical()) && (psiElement = parameters2[i3].getNameIdentifier()) == null) continue;
                        holder.registerProblem((PsiElement)psiElement, InspectionsBundle.message((String)"nullable.stuff.problems.overridden.method.parameters.are.not.annotated", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{!applicable ? NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)parameters2[i3]) : new AnnotateOverriddenMethodParameterFix(defaultNotNull, nullableManager.getDefaultNullable())});
                        parameterQuickFixSuggested[i3] = true;
                    }
                }
            }
        }
    }

    private static boolean isNotNullNotInferred(@NotNull PsiModifierListOwner owner2, boolean checkBases, boolean skipExternal) {
        if (owner2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "isNotNullNotInferred"));
        }
        Project project2 = owner2.getProject();
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
        if (!manager.isNotNull(owner2, checkBases)) {
            return false;
        }
        PsiAnnotation anno = manager.getNotNullAnnotation(owner2, checkBases);
        if (anno == null || AnnotationUtil.isInferredAnnotation((PsiAnnotation)anno)) {
            return false;
        }
        return !skipExternal || !AnnotationUtil.isExternalAnnotation((PsiAnnotation)anno);
    }

    public static boolean isNullableNotInferred(@NotNull PsiModifierListOwner owner2, boolean checkBases) {
        if (owner2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "isNullableNotInferred"));
        }
        Project project2 = owner2.getProject();
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
        if (!manager.isNullable(owner2, checkBases)) {
            return false;
        }
        PsiAnnotation anno = manager.getNullableAnnotation(owner2, checkBases);
        return anno == null || !AnnotationUtil.isInferredAnnotation((PsiAnnotation)anno);
    }

    private static LocalQuickFix createChangeDefaultNotNullFix(NullableNotNullManager nullableManager, PsiModifierListOwner modifierListOwner) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierListOwner, (Collection)nullableManager.getNotNulls());
        if (annotation != null && (referenceElement = annotation.getNameReferenceElement()) != null && referenceElement.resolve() != null) {
            return new ChangeNullableDefaultsFix(annotation.getQualifiedName(), null, nullableManager);
        }
        return null;
    }

    protected AnnotateMethodFix createAnnotateMethodFix(String defaultNotNull, String[] annotationsToRemove) {
        return new AnnotateMethodFix(defaultNotNull, annotationsToRemove);
    }

    private static void reportNullableNotNullConflict(ProblemsHolder holder, PsiModifierListOwner listOwner, PsiAnnotation declaredNullable, PsiAnnotation declaredNotNull) {
        String bothNullableNotNullMessage = InspectionsBundle.message((String)"inspection.nullable.problems.Nullable.NotNull.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName(declaredNullable), NullableStuffInspectionBase.getPresentableAnnoName(declaredNotNull)});
        holder.registerProblem((PsiElement)(declaredNotNull.isPhysical() ? declaredNotNull : listOwner.getNavigationElement()), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(declaredNotNull, listOwner)});
        holder.registerProblem((PsiElement)(declaredNullable.isPhysical() ? declaredNullable : listOwner.getNavigationElement()), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(declaredNullable, listOwner)});
    }

    public JComponent createOptionsPanel() {
        throw new RuntimeException("No UI in headless mode");
    }

    private static class MyAnnotateMethodFix
    extends AnnotateMethodFix {
        public MyAnnotateMethodFix(String defaultNotNull, String[] annotationsToRemove) {
            super(defaultNotNull, annotationsToRemove);
        }

        @Override
        protected boolean annotateOverriddenMethods() {
            return true;
        }

        @Override
        public int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project2) {
            return 1;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"annotate.overridden.methods.as.notnull", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$MyAnnotateMethodFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.annotate.overridden.method.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$MyAnnotateMethodFix", "getFamilyName"));
            }
            return string;
        }
    }

    private static class Annotated {
        private final boolean isDeclaredNotNull;
        private final boolean isDeclaredNullable;

        private Annotated(boolean isDeclaredNotNull, boolean isDeclaredNullable) {
            this.isDeclaredNotNull = isDeclaredNotNull;
            this.isDeclaredNullable = isDeclaredNullable;
        }
    }
}

