/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.SyntheticElement;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefJavaElementImpl
extends RefElementImpl
implements RefJavaElement {
    private Set<RefClass> myOutTypeReferences;
    private static final int ACCESS_MODIFIER_MASK = 3;
    private static final int ACCESS_PRIVATE = 0;
    private static final int ACCESS_PROTECTED = 1;
    private static final int ACCESS_PACKAGE = 2;
    private static final int ACCESS_PUBLIC = 3;
    private static final int IS_STATIC_MASK = 4;
    private static final int IS_FINAL_MASK = 8;
    private static final int IS_USES_DEPRECATION_MASK = 512;
    private static final int IS_SYNTHETIC_JSP_ELEMENT_MASK = 1024;
    private static final int IS_USED_QUALIFIED_OUTSIDE_PACKAGE_MASK = 2048;

    protected RefJavaElementImpl(@NotNull String name2, @NotNull RefJavaElement owner2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/reference/RefJavaElementImpl", "<init>"));
        }
        if (owner2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInspection/reference/RefJavaElementImpl", "<init>"));
        }
        super(name2, (RefElement)owner2);
        String am = owner2.getAccessModifier();
        this.doSetAccessModifier(am);
        boolean synthOwner = owner2.isSyntheticJSP();
        if (synthOwner) {
            this.setSyntheticJSP(true);
        }
    }

    protected RefJavaElementImpl(PsiModifierListOwner elem, RefManager manager) {
        super(RefJavaElementImpl.getName((PsiElement)elem), (PsiElement)elem, manager);
        boolean isSynth;
        this.setAccessModifier(RefJavaUtil.getInstance().getAccessModifier(elem));
        boolean bl = isSynth = elem instanceof PsiMethod && elem instanceof SyntheticElement || elem instanceof PsiSyntheticClass;
        if (isSynth) {
            this.setSyntheticJSP(true);
        }
        this.setIsStatic(elem.hasModifierProperty("static"));
        this.setIsFinal(elem.hasModifierProperty("final"));
    }

    @NotNull
    public synchronized Collection<RefClass> getOutTypeReferences() {
        Collection collection = (Collection)ObjectUtils.notNull(this.myOutTypeReferences, Collections.emptySet());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaElementImpl", "getOutTypeReferences"));
        }
        return collection;
    }

    synchronized void addOutTypeReference(RefClass refClass) {
        if (this.myOutTypeReferences == null) {
            this.myOutTypeReferences = new THashSet();
        }
        this.myOutTypeReferences.add(refClass);
    }

    @NotNull
    private static String getName(PsiElement element) {
        if (element instanceof PsiAnonymousClass) {
            PsiAnonymousClass psiAnonymousClass = (PsiAnonymousClass)element;
            PsiClass psiBaseClass = psiAnonymousClass.getBaseClassType().resolve();
            if (psiBaseClass == null) {
                if ("anonymous class" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaElementImpl", "getName"));
                }
                return "anonymous class";
            }
            String string = InspectionsBundle.message((String)"inspection.reference.anonymous.name", (Object[])new Object[]{psiBaseClass.getName()});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaElementImpl", "getName"));
            }
            return string;
        }
        if (element instanceof PsiSyntheticClass) {
            PsiSyntheticClass jspClass = (PsiSyntheticClass)element;
            PsiFile jspxFile = jspClass.getContainingFile();
            String string = "<" + jspxFile.getName() + ">";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaElementImpl", "getName"));
            }
            return string;
        }
        if (element instanceof PsiMethod && element instanceof SyntheticElement) {
            String string = InspectionsBundle.message((String)"inspection.reference.jsp.holder.method.anonymous.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaElementImpl", "getName"));
            }
            return string;
        }
        String name2 = null;
        if (element instanceof PsiNamedElement) {
            name2 = ((PsiNamedElement)element).getName();
        }
        String string = name2 == null ? InspectionsBundle.message((String)"inspection.reference.anonymous", (Object[])new Object[0]) : name2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaElementImpl", "getName"));
        }
        return string;
    }

    public boolean isFinal() {
        return this.checkFlag(8L);
    }

    public boolean isStatic() {
        return this.checkFlag(4L);
    }

    void setIsStatic(boolean isStatic) {
        this.setFlag(isStatic, 4L);
    }

    public boolean isUsesDeprecatedApi() {
        return this.checkFlag(512L);
    }

    void setUsesDeprecatedApi(boolean usesDeprecatedApi) {
        this.setFlag(usesDeprecatedApi, 512L);
    }

    void setIsFinal(boolean isFinal) {
        this.setFlag(isFinal, 8L);
    }

    public void setReachable(boolean reachable) {
        this.setFlag(reachable, 64L);
    }

    public boolean isSyntheticJSP() {
        return this.checkFlag(1024L);
    }

    private void setSyntheticJSP(boolean b) {
        this.setFlag(b, 1024L);
    }

    @Nullable
    public String getAccessModifier() {
        long access_id = this.myFlags & 3L;
        if (access_id == 0L) {
            return "private";
        }
        if (access_id == 3L) {
            return "public";
        }
        if (access_id == 2L) {
            return "packageLocal";
        }
        return "protected";
    }

    public void setAccessModifier(String am) {
        this.doSetAccessModifier(am);
    }

    private void doSetAccessModifier(@NotNull String am) {
        if (am == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "am", "com/intellij/codeInspection/reference/RefJavaElementImpl", "doSetAccessModifier"));
        }
        int access_id = "private".equals(am) ? 0 : ("public".equals(am) ? 3 : ("packageLocal".equals(am) ? 2 : 1));
        this.myFlags = this.myFlags & 0xFFFFFFFFFFFFFFFCL | (long)access_id;
    }

    public boolean isSuspiciousRecursive() {
        return this.isCalledOnlyFrom(this, (Stack<RefJavaElement>)new Stack());
    }

    private boolean isCalledOnlyFrom(RefJavaElement refElement, Stack<RefJavaElement> callStack) {
        if (callStack.contains((Object)this)) {
            return refElement == this;
        }
        if (this.getInReferences().isEmpty()) {
            return false;
        }
        if (refElement instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refElement;
            for (RefMethod refSuper : refMethod.getSuperMethods()) {
                if (refSuper.getInReferences().isEmpty()) continue;
                return false;
            }
            if (refMethod.isConstructor()) {
                boolean unreachable = true;
                for (RefElement refOut : refMethod.getOutReferences()) {
                    unreachable &= !refOut.isReachable();
                }
                if (unreachable) {
                    return true;
                }
            }
        }
        callStack.push((Object)this);
        for (RefElement refCaller : this.getInReferences()) {
            if (((RefElementImpl)refCaller).isSuspicious() && ((RefJavaElementImpl)refCaller).isCalledOnlyFrom(refElement, callStack)) continue;
            callStack.pop();
            return false;
        }
        callStack.pop();
        return true;
    }

    void addReference(RefElement refWhat, PsiElement psiWhat, PsiElement psiFrom, boolean forWriting, boolean forReading, PsiReferenceExpression expression2) {
        if (refWhat != null) {
            if (refWhat instanceof RefParameter) {
                if (forWriting) {
                    ((RefParameter)refWhat).parameterReferenced(true);
                }
                if (forReading) {
                    ((RefParameter)refWhat).parameterReferenced(false);
                }
            }
            this.addOutReference(refWhat);
            ((RefJavaElementImpl)refWhat).markReferenced(this, psiFrom, psiWhat, forWriting, forReading, expression2);
        } else {
            PsiClass containingClass;
            if (psiWhat instanceof PsiMethod && (containingClass = ((PsiMethod)psiWhat).getContainingClass()) != null && containingClass.isEnum() && "values".equals(((PsiMethod)psiWhat).getName())) {
                for (PsiField enumConstant : containingClass.getFields()) {
                    RefJavaElementImpl enumConstantReference;
                    if (!(enumConstant instanceof PsiEnumConstant) || (enumConstantReference = (RefJavaElementImpl)this.getRefManager().getReference((PsiElement)enumConstant)) == null) continue;
                    this.addOutReference(enumConstantReference);
                    enumConstantReference.markReferenced(this, psiFrom, (PsiElement)enumConstant, false, true, expression2);
                }
            }
            this.getRefManager().fireNodeMarkedReferenced(psiWhat, psiFrom);
        }
    }

    protected void markReferenced(RefElementImpl refFrom, PsiElement psiFrom, PsiElement psiWhat, boolean forWriting, boolean forReading, PsiReferenceExpression expressionFrom) {
        this.addInReference(refFrom);
        this.setUsedQualifiedOutsidePackageFlag(refFrom, expressionFrom);
        this.getRefManager().fireNodeMarkedReferenced(this, refFrom, false, forReading, forWriting);
    }

    void setUsedQualifiedOutsidePackageFlag(RefElementImpl refFrom, PsiReferenceExpression expressionFrom) {
        if (!this.checkFlag(2048L) && expressionFrom != null && expressionFrom.isQualified() && RefJavaUtil.getPackage((RefEntity)refFrom) != RefJavaUtil.getPackage((RefEntity)this)) {
            this.setFlag(true, 2048L);
        }
    }

    public boolean isUsedQualifiedOutsidePackage() {
        return this.checkFlag(2048L);
    }

    RefJavaManager getRefJavaManager() {
        return (RefJavaManager)this.getRefManager().getExtension(RefJavaManager.MANAGER);
    }

    @Override
    public void referenceRemoved() {
        super.referenceRemoved();
        if (this.isEntry()) {
            this.getRefJavaManager().getEntryPointsManager().removeEntryPoint((RefElement)this);
        }
    }

    @Override
    public Icon getIcon(boolean expanded) {
        PsiElement element;
        if (this.isSyntheticJSP() && (element = this.getElement()) != null && element.isValid()) {
            return IconUtil.getIcon((VirtualFile)element.getContainingFile().getVirtualFile(), (int)3, (Project)element.getProject());
        }
        return super.getIcon(expanded);
    }
}

