/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reflectiveAccess.JavaLangReflectHandleInvocationChecker;
import com.intellij.codeInspection.reflectiveAccess.JavaLangReflectVarHandleInvocationChecker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLangInvokeHandleSignatureInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Key<JavaReflectionReferenceUtil.ReflectiveSignature> DEFAULT_SIGNATURE = Key.create((String)"DEFAULT_SIGNATURE");
    public static final Key<List<LookupElement>> POSSIBLE_SIGNATURES = Key.create((String)"POSSIBLE_SIGNATURES");
    static final Set<String> KNOWN_METHOD_NAMES = Collections.unmodifiableSet(ContainerUtil.union(Arrays.asList(JavaReflectionReferenceUtil.HANDLE_FACTORY_METHOD_NAMES), Collections.singletonList("findConstructor")));
    private static final CallChecker[] CALL_CHECKERS = new CallChecker[]{JavaLangInvokeHandleSignatureInspection::checkHandlerFactoryCall, JavaLangReflectHandleInvocationChecker::checkMethodHandleInvocation, JavaLangReflectVarHandleInvocationChecker::checkVarHandleAccess};

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression callExpression) {
                super.visitMethodCallExpression(callExpression);
                for (CallChecker checker : CALL_CHECKERS) {
                    if (!checker.checkCall(callExpression, holder)) continue;
                    return;
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean checkHandlerFactoryCall(@NotNull PsiMethodCallExpression callExpression, @NotNull ProblemsHolder holder) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkHandlerFactoryCall"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkHandlerFactoryCall"));
        }
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (methodName != null && KNOWN_METHOD_NAMES.contains(methodName)) {
            PsiMethod method = callExpression.resolveMethod();
            if (method != null && JavaReflectionReferenceUtil.isClassWithName(method.getContainingClass(), "java.lang.invoke.MethodHandles.Lookup")) {
                PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
                JavaLangInvokeHandleSignatureInspection.checkHandleFactory(methodName, methodExpression, arguments, holder);
            }
            return true;
        }
        if (JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.invoke.MethodHandles", "arrayElementVarHandle")) {
            JavaLangInvokeHandleSignatureInspection.checkArrayElementVarHandle(callExpression, holder);
            return true;
        }
        return false;
    }

    private static void checkHandleFactory(@NotNull String factoryMethodName, @NotNull PsiReferenceExpression factoryMethodExpression, @NotNull PsiExpression[] arguments, @NotNull ProblemsHolder holder) {
        PsiExpression nameExpression;
        PsiExpression nameDefinition;
        String memberName;
        PsiClass ownerClass;
        if (factoryMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryMethodName", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkHandleFactory"));
        }
        if (factoryMethodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryMethodExpression", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkHandleFactory"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkHandleFactory"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkHandleFactory"));
        }
        if (arguments.length == 2) {
            PsiClass ownerClass2;
            if ("findConstructor".equals(factoryMethodName) && (ownerClass2 = JavaReflectionReferenceUtil.getReflectiveClass(arguments[0])) != null) {
                PsiExpression typeExpression = ParenthesesUtils.stripParentheses(arguments[1]);
                JavaLangInvokeHandleSignatureInspection.checkConstructor(ownerClass2, typeExpression, holder);
            }
        } else if (arguments.length >= 3 && (ownerClass = JavaReflectionReferenceUtil.getReflectiveClass(arguments[0])) != null && !StringUtil.isEmpty((String)(memberName = JavaReflectionReferenceUtil.computeConstantExpression(nameDefinition = JavaReflectionReferenceUtil.findDefinition(nameExpression = ParenthesesUtils.stripParentheses(arguments[1])), String.class)))) {
            PsiExpression typeExpression = ParenthesesUtils.stripParentheses(arguments[2]);
            switch (factoryMethodName) {
                case "findGetter": 
                case "findSetter": 
                case "findVarHandle": {
                    JavaLangInvokeHandleSignatureInspection.checkField(ownerClass, memberName, nameExpression, typeExpression, false, factoryMethodExpression, holder);
                    break;
                }
                case "findStaticGetter": 
                case "findStaticSetter": 
                case "findStaticVarHandle": {
                    JavaLangInvokeHandleSignatureInspection.checkField(ownerClass, memberName, nameExpression, typeExpression, true, factoryMethodExpression, holder);
                    break;
                }
                case "findVirtual": {
                    JavaLangInvokeHandleSignatureInspection.checkMethod(ownerClass, memberName, nameExpression, typeExpression, false, factoryMethodExpression, holder);
                    break;
                }
                case "findStatic": {
                    JavaLangInvokeHandleSignatureInspection.checkMethod(ownerClass, memberName, nameExpression, typeExpression, true, factoryMethodExpression, holder);
                    break;
                }
                case "findSpecial": {
                    JavaLangInvokeHandleSignatureInspection.checkMethod(ownerClass, memberName, nameExpression, typeExpression, false, factoryMethodExpression, holder);
                }
            }
        }
    }

    private static void checkConstructor(@NotNull PsiClass ownerClass, @NotNull PsiExpression constructorTypeExpression, @NotNull ProblemsHolder holder) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkConstructor"));
        }
        if (constructorTypeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorTypeExpression", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkConstructor"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkConstructor"));
        }
        JavaReflectionReferenceUtil.ReflectiveSignature constructorSignature = JavaLangInvokeHandleSignatureInspection.composeMethodSignature(constructorTypeExpression);
        if (constructorSignature != null) {
            String declarationText;
            List constructors = ContainerUtil.filter((Object[])ownerClass.getMethods(), PsiMethod::isConstructor);
            List<JavaReflectionReferenceUtil.ReflectiveSignature> validSignatures = null;
            if (constructors.isEmpty()) {
                if (!constructorSignature.equals(JavaReflectionReferenceUtil.ReflectiveSignature.NO_ARGUMENT_CONSTRUCTOR_SIGNATURE)) {
                    validSignatures = Collections.singletonList(JavaReflectionReferenceUtil.ReflectiveSignature.NO_ARGUMENT_CONSTRUCTOR_SIGNATURE);
                }
            } else if (!JavaLangInvokeHandleSignatureInspection.matchMethodSignature(constructors, constructorSignature)) {
                validSignatures = constructors.stream().map(JavaReflectionReferenceUtil::getMethodSignature).filter(Objects::nonNull).collect(Collectors.toList());
            }
            if (validSignatures != null && (declarationText = JavaLangInvokeHandleSignatureInspection.getConstructorDeclarationText(ownerClass, constructorSignature)) != null) {
                LocalQuickFix fix = null;
                String ownerClassName = ownerClass.getName();
                if (ownerClassName != null) {
                    fix = ReplaceSignatureQuickFix.createFix((PsiElement)constructorTypeExpression, ownerClassName, validSignatures, true, holder.isOnTheFly());
                }
                holder.registerProblem((PsiElement)constructorTypeExpression, JavaErrorMessages.message("cannot.resolve.constructor", declarationText), new LocalQuickFix[]{fix});
            }
        }
    }

    private static void checkField(@NotNull PsiClass ownerClass, @NotNull String fieldName, @NotNull PsiExpression fieldNameExpression, @NotNull PsiExpression fieldTypeExpression, boolean isStaticExpected, @NotNull PsiReferenceExpression factoryMethodExpression, @NotNull ProblemsHolder holder) {
        JavaReflectionReferenceUtil.ReflectiveType reflectiveType;
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkField"));
        }
        if (fieldNameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldNameExpression", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkField"));
        }
        if (fieldTypeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldTypeExpression", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkField"));
        }
        if (factoryMethodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryMethodExpression", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkField"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkField"));
        }
        PsiField field = ownerClass.findFieldByName(fieldName, true);
        if (field == null) {
            holder.registerProblem((PsiElement)fieldNameExpression, InspectionsBundle.message((String)"inspection.handle.signature.field.cannot.resolve", (Object[])new Object[]{fieldName}), new LocalQuickFix[0]);
            return;
        }
        if (field.hasModifierProperty("static") != isStaticExpected) {
            String factoryMethodName = factoryMethodExpression.getReferenceName();
            PsiElement factoryMethodNameElement = factoryMethodExpression.getReferenceNameElement();
            if (factoryMethodName != null && factoryMethodNameElement != null) {
                LocalQuickFix fix = SwitchStaticnessQuickFix.createFix(factoryMethodName, isStaticExpected);
                String message2 = InspectionsBundle.message((String)(isStaticExpected ? "inspection.handle.signature.field.not.static" : "inspection.handle.signature.field.static"), (Object[])new Object[]{fieldName});
                holder.registerProblem(factoryMethodNameElement, message2, new LocalQuickFix[]{fix});
                return;
            }
        }
        if ((reflectiveType = JavaReflectionReferenceUtil.getReflectiveType(fieldTypeExpression)) != null && !reflectiveType.isEqualTo(field.getType())) {
            String expectedTypeText = JavaReflectionReferenceUtil.getTypeText(field.getType());
            String message3 = InspectionsBundle.message((String)"inspection.handle.signature.field.type", (Object[])new Object[]{fieldName, expectedTypeText});
            holder.registerProblem((PsiElement)fieldTypeExpression, message3, new LocalQuickFix[]{new FieldTypeQuickFix(expectedTypeText)});
        }
    }

    private static void checkMethod(@NotNull PsiClass ownerClass, @NotNull String methodName, @NotNull PsiExpression methodNameExpression, @NotNull PsiExpression methodTypeExpression, boolean isStaticExpected, @NotNull PsiReferenceExpression factoryMethodExpression, @NotNull ProblemsHolder holder) {
        JavaReflectionReferenceUtil.ReflectiveSignature methodSignature;
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkMethod"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkMethod"));
        }
        if (methodNameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNameExpression", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkMethod"));
        }
        if (methodTypeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodTypeExpression", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkMethod"));
        }
        if (factoryMethodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryMethodExpression", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkMethod"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "checkMethod"));
        }
        Object[] methods = ownerClass.findMethodsByName(methodName, true);
        if (methods.length == 0) {
            holder.registerProblem((PsiElement)methodNameExpression, JavaErrorMessages.message("cannot.resolve.method", methodName), new LocalQuickFix[0]);
            return;
        }
        List filteredMethods = ContainerUtil.filter((Object[])methods, method -> method.hasModifierProperty("static") == isStaticExpected);
        if (filteredMethods.isEmpty()) {
            String factoryMethodName = factoryMethodExpression.getReferenceName();
            PsiElement factoryMethodNameElement = factoryMethodExpression.getReferenceNameElement();
            if (factoryMethodName != null && factoryMethodNameElement != null) {
                LocalQuickFix fix = SwitchStaticnessQuickFix.createFix(factoryMethodName, isStaticExpected);
                String message2 = InspectionsBundle.message((String)(isStaticExpected ? "inspection.handle.signature.method.not.static" : "inspection.handle.signature.method.static"), (Object[])new Object[]{methodName});
                holder.registerProblem(factoryMethodNameElement, message2, new LocalQuickFix[]{fix});
                return;
            }
        }
        if ((methodSignature = JavaLangInvokeHandleSignatureInspection.composeMethodSignature(methodTypeExpression)) != null && !JavaLangInvokeHandleSignatureInspection.matchMethodSignature(filteredMethods, methodSignature)) {
            String declarationText = JavaLangInvokeHandleSignatureInspection.getMethodDeclarationText(methodName, methodSignature);
            List validSignatures = filteredMethods.stream().map(JavaReflectionReferenceUtil::getMethodSignature).filter(Objects::nonNull).collect(Collectors.toList());
            LocalQuickFix fix = ReplaceSignatureQuickFix.createFix((PsiElement)methodTypeExpression, methodName, validSignatures, false, holder.isOnTheFly());
            holder.registerProblem((PsiElement)methodTypeExpression, JavaErrorMessages.message("cannot.resolve.method", declarationText), new LocalQuickFix[]{fix});
        }
    }

    private static void checkArrayElementVarHandle(PsiMethodCallExpression factoryCallExpression, ProblemsHolder holder) {
        String name2;
        PsiExpressionList argumentList = factoryCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 1) {
            holder.registerProblem((PsiElement)argumentList, InspectionsBundle.message((String)"inspection.reflection.invocation.argument.count", (Object[])new Object[]{1}), new LocalQuickFix[0]);
            return;
        }
        JavaReflectionReferenceUtil.ReflectiveType argumentType = JavaReflectionReferenceUtil.getReflectiveType(arguments[0]);
        if (argumentType == null || argumentType.getType() instanceof PsiArrayType) {
            return;
        }
        if (!argumentType.isPrimitive() && ("java.lang.Object".equals(name2 = argumentType.getQualifiedName()) || "java.io.Serializable".equals(name2) || "java.lang.Cloneable".equals(name2))) {
            return;
        }
        holder.registerProblem((PsiElement)arguments[0], InspectionsBundle.message((String)"inspection.reflect.handle.invocation.argument.not.array", (Object[])new Object[0]), new LocalQuickFix[0]);
    }

    @NotNull
    private static String getMethodDeclarationText(@NotNull String methodName, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature methodSignature) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "getMethodDeclarationText"));
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "getMethodDeclarationText"));
        }
        String returnType = methodSignature.getShortReturnType();
        String string = returnType + " " + methodName + methodSignature.getShortArgumentTypes();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "getMethodDeclarationText"));
        }
        return string;
    }

    @Nullable
    private static String getConstructorDeclarationText(@NotNull PsiClass ownerClass, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature methodSignature) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "getConstructorDeclarationText"));
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "getConstructorDeclarationText"));
        }
        String className = ownerClass.getName();
        if (className != null) {
            return JavaLangInvokeHandleSignatureInspection.getConstructorDeclarationText(className, methodSignature);
        }
        return null;
    }

    @NotNull
    private static String getConstructorDeclarationText(@NotNull String className, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature methodSignature) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "getConstructorDeclarationText"));
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "getConstructorDeclarationText"));
        }
        String returnType = methodSignature.getShortReturnType();
        String fakeReturnType = !"void".equals(returnType) ? returnType + " " : "";
        String string = fakeReturnType + className + methodSignature.getShortArgumentTypes();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "getConstructorDeclarationText"));
        }
        return string;
    }

    private static boolean matchMethodSignature(@NotNull List<PsiMethod> methods, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature expectedMethodSignature) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "matchMethodSignature"));
        }
        if (expectedMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedMethodSignature", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "matchMethodSignature"));
        }
        return methods.stream().map(JavaReflectionReferenceUtil::getMethodSignature).anyMatch(expectedMethodSignature::equals);
    }

    @Nullable
    public static JavaReflectionReferenceUtil.ReflectiveSignature composeMethodSignature(@Nullable PsiExpression methodTypeExpression) {
        PsiExpression typeDefinition = JavaReflectionReferenceUtil.findDefinition(methodTypeExpression);
        if (typeDefinition instanceof PsiMethodCallExpression) {
            PsiClass psiClass;
            PsiMethod method;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)typeDefinition;
            String referenceName = methodCallExpression.getMethodExpression().getReferenceName();
            Function<PsiExpression[], JavaReflectionReferenceUtil.ReflectiveSignature> composer = null;
            if ("methodType".equals(referenceName)) {
                composer = JavaLangInvokeHandleSignatureInspection::composeMethodSignatureFromTypes;
            } else if ("genericMethodType".equals(referenceName)) {
                composer = JavaLangInvokeHandleSignatureInspection::composeGenericMethodSignature;
            }
            if (composer != null && (method = methodCallExpression.resolveMethod()) != null && (psiClass = method.getContainingClass()) != null && "java.lang.invoke.MethodType".equals(psiClass.getQualifiedName())) {
                PsiExpression[] arguments = methodCallExpression.getArgumentList().getExpressions();
                return composer.apply(arguments);
            }
        }
        return null;
    }

    @Nullable
    private static JavaReflectionReferenceUtil.ReflectiveSignature composeMethodSignatureFromTypes(@NotNull PsiExpression[] returnAndParameterTypes) {
        if (returnAndParameterTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnAndParameterTypes", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "composeMethodSignatureFromTypes"));
        }
        List typeTexts = ContainerUtil.map((Object[])returnAndParameterTypes, JavaReflectionReferenceUtil::getTypeText);
        return JavaReflectionReferenceUtil.ReflectiveSignature.create(typeTexts);
    }

    @Nullable
    static Pair.NonNull<Integer, Boolean> getGenericSignature(@NotNull PsiExpression[] genericSignatureShape) {
        Boolean finalArray;
        if (genericSignatureShape == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericSignatureShape", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "getGenericSignature"));
        }
        if (genericSignatureShape.length == 0 || genericSignatureShape.length > 2) {
            return null;
        }
        Integer objectArgCount = JavaReflectionReferenceUtil.computeConstantExpression(genericSignatureShape[0], Integer.class);
        Boolean bl = finalArray = genericSignatureShape.length > 1 ? JavaReflectionReferenceUtil.computeConstantExpression(genericSignatureShape[1], Boolean.class) : Boolean.valueOf(false);
        if (objectArgCount == null || objectArgCount < 0 || objectArgCount > 255) {
            return null;
        }
        if (finalArray == null || finalArray.booleanValue() && objectArgCount > 254) {
            return null;
        }
        return Pair.createNonNull((Object)objectArgCount, (Object)finalArray);
    }

    @Nullable
    private static JavaReflectionReferenceUtil.ReflectiveSignature composeGenericMethodSignature(@NotNull PsiExpression[] genericSignatureShape) {
        if (genericSignatureShape == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericSignatureShape", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection", "composeGenericMethodSignature"));
        }
        Pair.NonNull<Integer, Boolean> signature = JavaLangInvokeHandleSignatureInspection.getGenericSignature(genericSignatureShape);
        if (signature == null) {
            return null;
        }
        int objectArgCount = (Integer)signature.getFirst();
        boolean finalArray = (Boolean)signature.getSecond();
        ArrayList<String> typeNames = new ArrayList<String>();
        typeNames.add("java.lang.Object");
        for (int i2 = 0; i2 < objectArgCount; ++i2) {
            typeNames.add("java.lang.Object");
        }
        if (finalArray) {
            typeNames.add("java.lang.Object[]");
        }
        return JavaReflectionReferenceUtil.ReflectiveSignature.create(typeNames);
    }

    private static class ReplaceSignatureQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final String myName;
        private final List<JavaReflectionReferenceUtil.ReflectiveSignature> mySignatures;
        private final boolean myIsConstructor;

        public ReplaceSignatureQuickFix(@Nullable PsiElement element, @NotNull String name2, @NotNull List<JavaReflectionReferenceUtil.ReflectiveSignature> signatures, boolean isConstructor) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "<init>"));
            }
            if (signatures == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatures", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "<init>"));
            }
            super(element);
            this.myName = name2;
            this.mySignatures = signatures;
            this.myIsConstructor = isConstructor;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getText() {
            if (this.mySignatures.size() == 1) {
                String declarationText = this.getDeclarationText(this.mySignatures.get(0));
                String string = InspectionsBundle.message((String)(this.myIsConstructor ? "inspection.handle.signature.use.constructor.fix.name" : "inspection.handle.signature.use.method.fix.name"), (Object[])new Object[]{declarationText});
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "getText"));
                }
                return string;
            }
            String string = InspectionsBundle.message((String)(this.myIsConstructor ? "inspection.handle.signature.use.constructor.fix.family.name" : "inspection.handle.signature.use.method.fix.family.name"), (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "getText"));
            }
            return string;
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "invoke"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "invoke"));
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                PsiElement element = this.myStartElement.getElement();
                if (editor != null && element != null) {
                    JavaReflectionReferenceUtil.ReflectiveSignature signature = (JavaReflectionReferenceUtil.ReflectiveSignature)editor.getUserData(DEFAULT_SIGNATURE);
                    if (signature != null && this.mySignatures.contains(signature)) {
                        ReplaceSignatureQuickFix.applyFix(project2, element, signature);
                    }
                    editor.putUserData(POSSIBLE_SIGNATURES, this.createLookupElements());
                }
                return;
            }
            if (this.mySignatures.size() == 1) {
                ReplaceSignatureQuickFix.applyFix(project2, startElement, this.mySignatures.get(0));
            } else if (editor != null) {
                this.showLookup(project2, editor);
            }
        }

        @NotNull
        private List<LookupElement> createLookupElements() {
            List<LookupElement> list2 = this.mySignatures.stream().sorted(JavaReflectionReferenceUtil.ReflectiveSignature::compareTo).map(signature -> LookupElementBuilder.create((Object)signature, (String)"").withIcon(signature.getIcon()).withPresentableText(this.myName + signature.getShortArgumentTypes()).withTypeText(!this.myIsConstructor ? signature.getShortReturnType() : null)).collect(Collectors.toList());
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "createLookupElements"));
            }
            return list2;
        }

        private void showLookup(final @NotNull Project project2, @NotNull Editor editor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "showLookup"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "showLookup"));
            }
            editor.getSelectionModel().removeSelection();
            List<LookupElement> items = this.createLookupElements();
            LookupManager lookupManager = LookupManager.getInstance(project2);
            LookupEx lookup = lookupManager.showLookup(editor, items.toArray(LookupElement.EMPTY_ARRAY));
            if (lookup != null) {
                lookup.addLookupListener(new LookupAdapter(){

                    @Override
                    public void itemSelected(LookupEvent event) {
                        LookupElement item = event.getItem();
                        if (item != null) {
                            PsiElement element = myStartElement.getElement();
                            Object object = item.getObject();
                            if (element != null && object instanceof JavaReflectionReferenceUtil.ReflectiveSignature) {
                                WriteAction.run(() -> {
                                    if (project2 == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix$1", "lambda$itemSelected$0"));
                                    }
                                    ReplaceSignatureQuickFix.applyFix(project2, element, (JavaReflectionReferenceUtil.ReflectiveSignature)object);
                                });
                            }
                        }
                    }
                });
            }
        }

        private static void applyFix(@NotNull Project project2, @NotNull PsiElement element, @NotNull JavaReflectionReferenceUtil.ReflectiveSignature signature) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "applyFix"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "applyFix"));
            }
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "applyFix"));
            }
            String replacementText = JavaReflectionReferenceUtil.getMethodTypeExpressionText(signature);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            PsiExpression replacement = factory.createExpressionFromText(replacementText, element);
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
            styleManager.shortenClassReferences(element.replace((PsiElement)replacement));
        }

        @NotNull
        private String getDeclarationText(@NotNull JavaReflectionReferenceUtil.ReflectiveSignature signature) {
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "getDeclarationText"));
            }
            String string = this.myIsConstructor ? JavaLangInvokeHandleSignatureInspection.getConstructorDeclarationText(this.myName, signature) : JavaLangInvokeHandleSignatureInspection.getMethodDeclarationText(this.myName, signature);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "getDeclarationText"));
            }
            return string;
        }

        @Nullable
        private static LocalQuickFix createFix(@Nullable PsiElement element, @NotNull String methodName, @NotNull List<JavaReflectionReferenceUtil.ReflectiveSignature> methodSignatures, boolean isConstructor, boolean isOnTheFly) {
            if (methodName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "createFix"));
            }
            if (methodSignatures == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignatures", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$ReplaceSignatureQuickFix", "createFix"));
            }
            if (isOnTheFly && !methodSignatures.isEmpty() || methodSignatures.size() == 1) {
                return new ReplaceSignatureQuickFix(element, methodName, methodSignatures, isConstructor);
            }
            return null;
        }
    }

    private static class SwitchStaticnessQuickFix
    implements LocalQuickFix {
        private static final Map<String, String> STATIC_TO_NON_STATIC = ContainerUtil.immutableMapBuilder().put((Object)"findStaticGetter", (Object)"findGetter").put((Object)"findStaticSetter", (Object)"findSetter").put((Object)"findStaticVarHandle", (Object)"findVarHandle").put((Object)"findStatic", (Object)"findVirtual").build();
        private static final Map<String, String> NON_STATIC_TO_STATIC = ContainerUtil.immutableMapBuilder().put((Object)"findGetter", (Object)"findStaticGetter").put((Object)"findSetter", (Object)"findStaticSetter").put((Object)"findVarHandle", (Object)"findStaticVarHandle").put((Object)"findVirtual", (Object)"findStatic").build();
        private final String myReplacementName;

        public SwitchStaticnessQuickFix(@NotNull String replacementName) {
            if (replacementName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacementName", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$SwitchStaticnessQuickFix", "<init>"));
            }
            this.myReplacementName = replacementName;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.handle.signature.replace.with.fix.name", (Object[])new Object[]{this.myReplacementName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$SwitchStaticnessQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$SwitchStaticnessQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$SwitchStaticnessQuickFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            PsiIdentifier identifier = factory.createIdentifier(this.myReplacementName);
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
            styleManager.shortenClassReferences(element.replace((PsiElement)identifier));
        }

        @Nullable
        public static LocalQuickFix createFix(@NotNull String methodName, boolean wasStatic) {
            if (methodName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$SwitchStaticnessQuickFix", "createFix"));
            }
            String replacementName = wasStatic ? STATIC_TO_NON_STATIC.get(methodName) : NON_STATIC_TO_STATIC.get(methodName);
            return replacementName != null ? new SwitchStaticnessQuickFix(replacementName) : null;
        }
    }

    private static class FieldTypeQuickFix
    implements LocalQuickFix {
        private final String myFieldTypeText;

        public FieldTypeQuickFix(String fieldTypeText) {
            this.myFieldTypeText = fieldTypeText;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.handle.signature.change.type.fix.name", (Object[])new Object[]{this.myFieldTypeText});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$FieldTypeQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$FieldTypeQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/reflectiveAccess/JavaLangInvokeHandleSignatureInspection$FieldTypeQuickFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            PsiExpression typeExpression = factory.createExpressionFromText(this.myFieldTypeText + ".class", element);
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
            styleManager.shortenClassReferences(element.replace((PsiElement)typeExpression));
        }
    }

    private static interface CallChecker {
        public boolean checkCall(@NotNull PsiMethodCallExpression var1, @NotNull ProblemsHolder var2);
    }
}

