/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReflectionInvocationInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final String JAVA_LANG_REFLECT_METHOD = "java.lang.reflect.Method";
    private static final String JAVA_LANG_REFLECT_CONSTRUCTOR = "java.lang.reflect.Constructor";
    private static final String INVOKE = "invoke";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionInvocationInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                super.visitMethodCallExpression(methodCall);
                if (JavaReflectionReferenceUtil.isCallToMethod(methodCall, JavaReflectionInvocationInspection.JAVA_LANG_REFLECT_METHOD, JavaReflectionInvocationInspection.INVOKE)) {
                    JavaReflectionInvocationInspection.checkReflectionCall(methodCall, 1, holder, x$0 -> JavaReflectionInvocationInspection.isReflectionMethod(x$0));
                } else if (JavaReflectionReferenceUtil.isCallToMethod(methodCall, JavaReflectionInvocationInspection.JAVA_LANG_REFLECT_CONSTRUCTOR, "newInstance")) {
                    JavaReflectionInvocationInspection.checkReflectionCall(methodCall, 0, holder, x$0 -> JavaReflectionInvocationInspection.isReflectionConstructor(x$0));
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionInvocationInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean isReflectionMethod(PsiMethodCallExpression callExpression) {
        return JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.Class", "getMethod") || JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.Class", "getDeclaredMethod");
    }

    private static boolean isReflectionConstructor(PsiMethodCallExpression callExpression) {
        return JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.Class", "getConstructor") || JavaReflectionReferenceUtil.isCallToMethod(callExpression, "java.lang.Class", "getDeclaredConstructor");
    }

    private static void checkReflectionCall(@NotNull PsiMethodCallExpression methodCall, int argumentOffset, @NotNull ProblemsHolder holder, @NotNull Predicate<PsiMethodCallExpression> methodPredicate) {
        PsiExpressionList argumentList;
        Arguments actualArguments;
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionInvocationInspection", "checkReflectionCall"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionInvocationInspection", "checkReflectionCall"));
        }
        if (methodPredicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodPredicate", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionInvocationInspection", "checkReflectionCall"));
        }
        List<PsiExpression> requiredTypes = JavaReflectionInvocationInspection.getRequiredMethodArguments(methodCall.getMethodExpression().getQualifierExpression(), argumentOffset, methodPredicate);
        if (requiredTypes != null && (actualArguments = JavaReflectionInvocationInspection.getActualMethodArguments((argumentList = methodCall.getArgumentList()).getExpressions(), argumentOffset, true)) != null) {
            if (requiredTypes.size() != actualArguments.expressions.length) {
                if (actualArguments.varargAsArray) {
                    PsiExpression[] expressions2 = argumentList.getExpressions();
                    PsiExpressionList element = expressions2.length == argumentOffset + 1 ? expressions2[argumentOffset] : argumentList;
                    holder.registerProblem((PsiElement)element, InspectionsBundle.message((String)"inspection.reflection.invocation.item.count", (Object[])new Object[]{requiredTypes.size()}), new LocalQuickFix[0]);
                } else {
                    holder.registerProblem((PsiElement)argumentList, InspectionsBundle.message((String)"inspection.reflection.invocation.argument.count", (Object[])new Object[]{requiredTypes.size() + argumentOffset}), new LocalQuickFix[0]);
                }
                return;
            }
            for (int i2 = 0; i2 < requiredTypes.size(); ++i2) {
                PsiExpression argument;
                PsiType actualType;
                JavaReflectionReferenceUtil.ReflectiveType requiredType = JavaReflectionReferenceUtil.getReflectiveType(requiredTypes.get(i2));
                if (requiredType == null || (actualType = (argument = actualArguments.expressions[i2]).getType()) == null || requiredType.isAssignableFrom(actualType)) continue;
                if (PsiTreeUtil.isAncestor((PsiElement)argumentList, (PsiElement)argument, (boolean)false)) {
                    holder.registerProblem((PsiElement)argument, InspectionsBundle.message((String)(actualArguments.varargAsArray ? "inspection.reflection.invocation.item.not.assignable" : "inspection.reflection.invocation.argument.not.assignable"), (Object[])new Object[]{requiredType.getQualifiedName()}), new LocalQuickFix[0]);
                    continue;
                }
                PsiExpression[] expressions3 = argumentList.getExpressions();
                PsiExpressionList element = expressions3.length == argumentOffset + 1 ? expressions3[argumentOffset] : argumentList;
                holder.registerProblem((PsiElement)element, InspectionsBundle.message((String)"inspection.reflection.invocation.array.not.assignable", (Object[])new Object[]{actualArguments.expressions.length}), new LocalQuickFix[0]);
                break;
            }
        }
    }

    @Nullable
    private static List<PsiExpression> getRequiredMethodArguments(@Nullable PsiExpression qualifier, int argumentOffset, @NotNull Predicate<PsiMethodCallExpression> methodPredicate) {
        PsiMethodCallExpression definitionCall;
        if (methodPredicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodPredicate", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionInvocationInspection", "getRequiredMethodArguments"));
        }
        PsiExpression definition = JavaReflectionReferenceUtil.findDefinition(ParenthesesUtils.stripParentheses(qualifier));
        if (definition instanceof PsiMethodCallExpression && methodPredicate.test(definitionCall = (PsiMethodCallExpression)definition)) {
            return JavaReflectionInvocationInspection.getRequiredMethodArguments(definitionCall, argumentOffset);
        }
        return null;
    }

    private static List<PsiExpression> getRequiredMethodArguments(@NotNull PsiMethodCallExpression definitionCall, int argumentOffset) {
        PsiExpression[] arrayElements;
        if (definitionCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitionCall", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionInvocationInspection", "getRequiredMethodArguments"));
        }
        PsiExpression[] arguments = definitionCall.getArgumentList().getExpressions();
        if (arguments.length == argumentOffset + 1 && (arrayElements = JavaReflectionInvocationInspection.getVarargAsArray(arguments[argumentOffset])) != null) {
            return Arrays.asList(arrayElements);
        }
        if (arguments.length >= argumentOffset) {
            return Arrays.asList(arguments).subList(argumentOffset, arguments.length);
        }
        return null;
    }

    @Nullable
    public static List<JavaReflectionReferenceUtil.ReflectiveType> getReflectionMethodParameterTypes(@NotNull PsiMethodCallExpression definitionCall, int argumentOffset) {
        if (definitionCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitionCall", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionInvocationInspection", "getReflectionMethodParameterTypes"));
        }
        List<PsiExpression> arguments = JavaReflectionInvocationInspection.getRequiredMethodArguments(definitionCall, argumentOffset);
        return arguments != null ? ContainerUtil.map(arguments, type2 -> JavaReflectionReferenceUtil.getReflectiveType(type2)) : null;
    }

    @Nullable
    static Arguments getActualMethodArguments(PsiExpression[] arguments, int argumentOffset, boolean allowVarargAsArray) {
        PsiExpression[] expressions2;
        if (allowVarargAsArray && arguments.length == argumentOffset + 1 && (expressions2 = JavaReflectionInvocationInspection.getVarargAsArray(arguments[argumentOffset])) != null) {
            return new Arguments(expressions2, true);
        }
        if (arguments.length >= argumentOffset) {
            expressions2 = argumentOffset != 0 ? Arrays.copyOfRange(arguments, argumentOffset, arguments.length) : arguments;
            for (int i2 = 0; i2 < expressions2.length; ++i2) {
                PsiExpression castOperand = JavaReflectionInvocationInspection.unwrapDisambiguatingCastToObject(expressions2[i2]);
                if (castOperand == null) continue;
                expressions2[i2] = castOperand;
            }
            return new Arguments(expressions2, false);
        }
        return null;
    }

    @Nullable
    private static PsiExpression[] getVarargAsArray(@Nullable PsiExpression maybeArray) {
        if (JavaReflectionInvocationInspection.isVarargAsArray(maybeArray)) {
            PsiExpression argumentsDefinition = JavaReflectionReferenceUtil.findDefinition(maybeArray);
            if (argumentsDefinition instanceof PsiArrayInitializerExpression) {
                return ((PsiArrayInitializerExpression)argumentsDefinition).getInitializers();
            }
            if (argumentsDefinition instanceof PsiNewExpression) {
                Integer itemCount;
                PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)argumentsDefinition).getArrayInitializer();
                if (arrayInitializer != null) {
                    return arrayInitializer.getInitializers();
                }
                PsiExpression[] dimensions = ((PsiNewExpression)argumentsDefinition).getArrayDimensions();
                if (dimensions.length == 1 && (itemCount = JavaReflectionReferenceUtil.computeConstantExpression(JavaReflectionReferenceUtil.findDefinition(dimensions[0]), Integer.class)) != null && itemCount == 0) {
                    return PsiExpression.EMPTY_ARRAY;
                }
            }
        }
        return null;
    }

    @Contract(value="null -> false")
    static boolean isVarargAsArray(@Nullable PsiExpression maybeArray) {
        PsiType type2 = maybeArray != null ? maybeArray.getType() : null;
        return type2 instanceof PsiArrayType && type2.getArrayDimensions() == 1 && type2.getDeepComponentType() instanceof PsiClassType;
    }

    @Nullable
    private static PsiExpression unwrapDisambiguatingCastToObject(@Nullable PsiExpression expression2) {
        PsiTypeCastExpression typeCast;
        PsiTypeElement castElement;
        if (expression2 instanceof PsiTypeCastExpression && (castElement = (typeCast = (PsiTypeCastExpression)expression2).getCastType()) != null && castElement.getType().equalsToText("java.lang.Object")) {
            return typeCast.getOperand();
        }
        return null;
    }

    static class Arguments {
        final PsiExpression[] expressions;
        final boolean varargAsArray;

        public Arguments(PsiExpression[] expressions2, boolean varargAsArray) {
            this.expressions = expressions2;
            this.varargAsArray = varargAsArray;
        }
    }
}

