/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reflectiveAccess.JavaReflectionInvocationInspection;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CheckBox;
import com.siyeh.ig.ui.UiUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReflectionMemberAccessInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Set<String> MEMBER_METHOD_NAMES = Collections.unmodifiableSet(ContainerUtil.set((Object[])new String[]{"getField", "getDeclaredField", "getMethod", "getDeclaredMethod", "getConstructor", "getDeclaredConstructor"}));
    private final List<String> ignoredClassNames = new ArrayList<String>();
    public boolean checkMemberExistsInNonFinalClasses = true;
    public String ignoredClassNamesString = "java.lang.Object,java.lang.Throwable";

    public JavaReflectionMemberAccessInspection() {
        this.parseSettings();
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        ListTable table = new ListTable(new ListWrappingTableModel(this.ignoredClassNames, InspectionsBundle.message((String)"inspection.reflection.member.access.check.exists.exclude", (Object[])new Object[0])));
        JPanel tablePanel = UiUtils.createAddRemoveTreeClassChooserPanel(table, InspectionsBundle.message((String)"inspection.reflection.member.access.check.exists.exclude.chooser", (Object[])new Object[0]), new String[0]);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        CheckBox checkBox = new CheckBox(InspectionsBundle.message((String)"inspection.reflection.member.access.check.exists", (Object[])new Object[0]), (InspectionProfileEntry)this, "checkMemberExistsInNonFinalClasses");
        panel2.add((Component)checkBox, constraints);
        constraints.weighty = 1.0;
        constraints.gridy = 1;
        constraints.fill = 1;
        panel2.add((Component)tablePanel, constraints);
        return panel2;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "readSettings"));
        }
        super.readSettings(element);
        this.parseSettings();
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "writeSettings"));
        }
        this.collectSettings();
        super.writeSettings(element);
    }

    private void parseSettings() {
        this.ignoredClassNames.clear();
        ContainerUtil.addAll(this.ignoredClassNames, (Object[])this.ignoredClassNamesString.split(","));
    }

    private void collectSettings() {
        this.ignoredClassNamesString = this.ignoredClassNames.stream().collect(Collectors.joining(","));
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiClass containingClass;
                PsiMethod method;
                super.visitMethodCallExpression(expression2);
                String referenceName = expression2.getMethodExpression().getReferenceName();
                if (referenceName != null && MEMBER_METHOD_NAMES.contains(referenceName) && (method = expression2.resolveMethod()) != null && (containingClass = method.getContainingClass()) != null && "java.lang.Class".equals(containingClass.getQualifiedName())) {
                    switch (referenceName) {
                        case "getField": {
                            JavaReflectionMemberAccessInspection.this.checkField(expression2, false, holder);
                            break;
                        }
                        case "getDeclaredField": {
                            JavaReflectionMemberAccessInspection.this.checkField(expression2, true, holder);
                            break;
                        }
                        case "getMethod": {
                            JavaReflectionMemberAccessInspection.this.checkMethod(expression2, false, holder);
                            break;
                        }
                        case "getDeclaredMethod": {
                            JavaReflectionMemberAccessInspection.this.checkMethod(expression2, true, holder);
                            break;
                        }
                        case "getConstructor": {
                            JavaReflectionMemberAccessInspection.this.checkConstructor(expression2, false, holder);
                            break;
                        }
                        case "getDeclaredConstructor": {
                            JavaReflectionMemberAccessInspection.this.checkConstructor(expression2, true, holder);
                        }
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private void checkField(@NotNull PsiMethodCallExpression callExpression, boolean isDeclared, @NotNull ProblemsHolder holder) {
        PsiClass psiClass;
        PsiExpression nameExpression;
        String fieldName;
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "checkField"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "checkField"));
        }
        PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
        if (arguments.length != 0 && (fieldName = JavaReflectionMemberAccessInspection.getMemberName(nameExpression = arguments[0])) != null && (psiClass = JavaReflectionMemberAccessInspection.getPsiClass(callExpression)) != null) {
            PsiField field = psiClass.findFieldByName(fieldName, true);
            if (field == null) {
                if (this.reportUnresolvedMembersOf(psiClass)) {
                    holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.cannot.resolve.field", (Object[])new Object[]{fieldName}), new LocalQuickFix[0]);
                }
                return;
            }
            if (isDeclared && field.getContainingClass() != psiClass) {
                holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.field.not.in.class", (Object[])new Object[]{fieldName, psiClass.getQualifiedName()}), new LocalQuickFix[0]);
                return;
            }
            if (!isDeclared && !field.hasModifierProperty("public")) {
                holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.field.not.public", (Object[])new Object[]{fieldName}), new LocalQuickFix[0]);
            }
        }
    }

    private void checkMethod(@NotNull PsiMethodCallExpression callExpression, boolean isDeclared, @NotNull ProblemsHolder holder) {
        PsiClass psiClass;
        PsiExpression nameExpression;
        String methodName;
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "checkMethod"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "checkMethod"));
        }
        PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
        if (arguments.length != 0 && (methodName = JavaReflectionMemberAccessInspection.getMemberName(nameExpression = arguments[0])) != null && (psiClass = JavaReflectionMemberAccessInspection.getPsiClass(callExpression)) != null) {
            PsiMethod[] methods = psiClass.findMethodsByName(methodName, true);
            if (methods.length == 0) {
                if (this.reportUnresolvedMembersOf(psiClass)) {
                    holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.cannot.resolve.method", (Object[])new Object[]{methodName}), new LocalQuickFix[0]);
                }
                return;
            }
            PsiMethod matchingMethod = JavaReflectionMemberAccessInspection.matchMethod(methods, arguments, 1);
            if (matchingMethod == null) {
                if (this.reportUnresolvedMembersOf(psiClass)) {
                    holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.cannot.resolve.method.arguments", (Object[])new Object[]{methodName}), new LocalQuickFix[0]);
                }
                return;
            }
            if (isDeclared && matchingMethod.getContainingClass() != psiClass) {
                holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.method.not.in.class", (Object[])new Object[]{methodName, psiClass.getQualifiedName()}), new LocalQuickFix[0]);
                return;
            }
            if (!isDeclared && !matchingMethod.hasModifierProperty("public")) {
                holder.registerProblem((PsiElement)nameExpression, InspectionsBundle.message((String)"inspection.reflection.member.access.method.not.public", (Object[])new Object[]{methodName}), new LocalQuickFix[0]);
            }
        }
    }

    private void checkConstructor(@NotNull PsiMethodCallExpression callExpression, boolean isDeclared, @NotNull ProblemsHolder holder) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "checkConstructor"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "checkConstructor"));
        }
        PsiClass psiClass = JavaReflectionMemberAccessInspection.getPsiClass(callExpression);
        if (psiClass != null) {
            PsiMethod constructorOrClass;
            PsiMethod[] methods = psiClass.getConstructors();
            PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
            if (methods.length != 0) {
                constructorOrClass = JavaReflectionMemberAccessInspection.matchMethod(methods, arguments, 0);
            } else {
                Object object = constructorOrClass = arguments.length == 0 ? psiClass : null;
            }
            if (constructorOrClass == null) {
                if (this.reportUnresolvedMembersOf(psiClass)) {
                    holder.registerProblem((PsiElement)callExpression.getArgumentList(), InspectionsBundle.message((String)"inspection.reflection.member.access.cannot.resolve.constructor.arguments", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
                return;
            }
            if (!isDeclared && !constructorOrClass.hasModifierProperty("public")) {
                holder.registerProblem((PsiElement)callExpression.getArgumentList(), InspectionsBundle.message((String)"inspection.reflection.member.access.constructor.not.public", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private boolean reportUnresolvedMembersOf(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "reportUnresolvedMembersOf"));
        }
        return (this.checkMemberExistsInNonFinalClasses || psiClass.hasModifierProperty("final")) && !this.ignoredClassNames.contains(psiClass.getQualifiedName());
    }

    @Contract(value="null->null")
    @Nullable
    private static String getMemberName(@Nullable PsiExpression memberNameArgument) {
        return JavaReflectionReferenceUtil.computeConstantExpression(memberNameArgument, String.class);
    }

    @Nullable
    private static PsiClass getPsiClass(@NotNull PsiMethodCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "getPsiClass"));
        }
        return JavaReflectionReferenceUtil.getReflectiveClass(callExpression.getMethodExpression().getQualifierExpression());
    }

    @Nullable
    private static PsiMethod matchMethod(PsiMethod[] methods, PsiExpression[] arguments, int argumentOffset) {
        JavaReflectionInvocationInspection.Arguments methodArguments = JavaReflectionInvocationInspection.getActualMethodArguments(arguments, argumentOffset, true);
        if (methodArguments == null) {
            return null;
        }
        List argumentTypes = ContainerUtil.map((Object[])methodArguments.expressions, JavaReflectionReferenceUtil::getReflectiveType);
        return JavaReflectionMemberAccessInspection.matchMethod(methods, argumentTypes);
    }

    @Nullable
    public static PsiMethod matchMethod(@NotNull PsiMethod[] methods, @NotNull List<JavaReflectionReferenceUtil.ReflectiveType> argumentTypes) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "matchMethod"));
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "com/intellij/codeInspection/reflectiveAccess/JavaReflectionMemberAccessInspection", "matchMethod"));
        }
        int mismatchCount = Integer.MAX_VALUE;
        PsiMethod bestGuess = null;
        for (PsiMethod method : methods) {
            int match = JavaReflectionMemberAccessInspection.matchMethodArguments(method, argumentTypes);
            if (match == 0) {
                return method;
            }
            if (match < 0 || mismatchCount <= match) continue;
            mismatchCount = match;
            bestGuess = method;
        }
        return bestGuess;
    }

    private static int matchMethodArguments(PsiMethod method, List<JavaReflectionReferenceUtil.ReflectiveType> argumentTypes) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != argumentTypes.size()) {
            return -1;
        }
        int mismatchCount = 0;
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            JavaReflectionReferenceUtil.ReflectiveType argumentType = argumentTypes.get(i2);
            if (argumentType == null) {
                ++mismatchCount;
                continue;
            }
            if (argumentType.isEqualTo(parameters2[i2].getType())) continue;
            return -1;
        }
        return mismatchCount;
    }
}

