/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

abstract class BaseStreamApiMigration {
    private final boolean myShouldWarn;
    private final String myReplacement;

    protected BaseStreamApiMigration(boolean shouldWarn, String replacement) {
        this.myShouldWarn = shouldWarn;
        this.myReplacement = replacement;
    }

    public String getReplacement() {
        return this.myReplacement;
    }

    abstract PsiElement migrate(@NotNull Project var1, @NotNull PsiStatement var2, @NotNull TerminalBlock var3);

    public boolean isShouldWarn() {
        return this.myShouldWarn;
    }

    static PsiElement replaceWithNumericAddition(PsiLoopStatement loopStatement, PsiVariable var, String streamText, PsiType expressionType) {
        PsiExpression initializer;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)loopStatement.getProject());
        BaseStreamApiMigration.restoreComments(loopStatement, loopStatement.getBody());
        ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus(var, loopStatement);
        if (status != ControlFlowUtils.InitializerUsageStatus.UNKNOWN && ExpressionUtils.isZero(initializer = var.getInitializer())) {
            PsiType type2 = var.getType();
            String replacement = (type2.equals(expressionType) ? "" : "(" + type2.getCanonicalText() + ") ") + streamText;
            return BaseStreamApiMigration.replaceInitializer(loopStatement, var, initializer, replacement, status);
        }
        return loopStatement.replace((PsiElement)elementFactory.createStatementFromText(var.getName() + "+=" + streamText + ";", (PsiElement)loopStatement));
    }

    static PsiElement replaceInitializer(PsiLoopStatement loopStatement, PsiVariable var, PsiExpression initializer, String replacement, ControlFlowUtils.InitializerUsageStatus status) {
        Project project2 = loopStatement.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        if (status == ControlFlowUtils.InitializerUsageStatus.DECLARED_JUST_BEFORE) {
            initializer.replace((PsiElement)elementFactory.createExpressionFromText(replacement, (PsiElement)loopStatement));
            BaseStreamApiMigration.removeLoop(loopStatement);
            return var;
        }
        if (status == ControlFlowUtils.InitializerUsageStatus.AT_WANTED_PLACE_ONLY) {
            initializer.delete();
        }
        return loopStatement.replace((PsiElement)elementFactory.createStatementFromText(var.getName() + " = " + replacement + ";", (PsiElement)loopStatement));
    }

    static void restoreComments(PsiLoopStatement loopStatement, PsiStatement body2) {
        PsiElement parent = loopStatement.getParent();
        for (PsiElement comment : PsiTreeUtil.findChildrenOfType((PsiElement)body2, PsiComment.class)) {
            parent.addBefore(comment, (PsiElement)loopStatement);
        }
    }

    static void removeLoop(@NotNull PsiLoopStatement statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInspection/streamMigration/BaseStreamApiMigration", "removeLoop"));
        }
        PsiElement parent = statement2.getParent();
        if (parent instanceof PsiLabeledStatement) {
            parent.delete();
        } else {
            statement2.delete();
        }
    }

    static boolean isReachable(PsiReturnStatement target2) {
        ControlFlow flow;
        try {
            flow = ControlFlowFactory.getInstance(target2.getProject()).getControlFlow(target2.getParent(), LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return ControlFlowUtil.isInstructionReachable(flow, flow.getStartOffset((PsiElement)target2), 0);
    }
}

