/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.CollectMigration;
import com.intellij.codeInspection.streamMigration.CountMigration;
import com.intellij.codeInspection.streamMigration.FindFirstMigration;
import com.intellij.codeInspection.streamMigration.ForEachMigration;
import com.intellij.codeInspection.streamMigration.MatchMigration;
import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.SumMigration;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.codeInspection.streamMigration.ToArrayMigration;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamApiMigrationInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(StreamApiMigrationInspection.class);
    public boolean REPLACE_TRIVIAL_FOREACH;
    public boolean SUGGEST_FOREACH;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox("Warn if only 'forEach' replacement is available", "SUGGEST_FOREACH");
        panel2.addCheckbox("Warn if the loop is trivial", "REPLACE_TRIVIAL_FOREACH");
        return panel2;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("foreach loop can be collapsed with Stream API" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "getDisplayName"));
        }
        return "foreach loop can be collapsed with Stream API";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("Convert2streamapi" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "getShortName"));
        }
        return "Convert2streamapi";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "buildVisitor"));
        }
        PsiFile file2 = holder.getFile();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)file2) || virtualFile == null || !FileIndexFacade.getInstance((Project)holder.getProject()).isInSourceContent(virtualFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        StreamApiMigrationVisitor streamApiMigrationVisitor = new StreamApiMigrationVisitor(holder, isOnTheFly);
        if (streamApiMigrationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection", "buildVisitor"));
        }
        return streamApiMigrationVisitor;
    }

    @Nullable
    static PsiReturnStatement getNextReturnStatement(PsiStatement statement2) {
        PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward((PsiElement)statement2, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        if (nextStatement instanceof PsiReturnStatement) {
            return (PsiReturnStatement)nextStatement;
        }
        PsiElement parent = statement2.getParent();
        if (parent instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)parent).getStatements();
            if (statements.length == 0 || statements[statements.length - 1] != statement2) {
                return null;
            }
            if (!((parent = parent.getParent()) instanceof PsiBlockStatement)) {
                return null;
            }
            parent = parent.getParent();
        }
        if (parent instanceof PsiIfStatement) {
            return StreamApiMigrationInspection.getNextReturnStatement((PsiStatement)parent);
        }
        return null;
    }

    @Contract(value="null, null -> true; null, !null -> false")
    private static boolean sameReference(PsiExpression expr1, PsiExpression expr2) {
        if (expr1 == null && expr2 == null) {
            return true;
        }
        if (!(expr1 instanceof PsiReferenceExpression) || !(expr2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression ref1 = (PsiReferenceExpression)expr1;
        PsiReferenceExpression ref2 = (PsiReferenceExpression)expr2;
        return Objects.equals(ref1.getReferenceName(), ref2.getReferenceName()) && StreamApiMigrationInspection.sameReference(ref1.getQualifierExpression(), ref2.getQualifierExpression());
    }

    @Nullable
    static PsiExpression extractAddend(PsiAssignmentExpression assignment) {
        PsiBinaryExpression binOp;
        if (JavaTokenType.PLUSEQ.equals(assignment.getOperationTokenType())) {
            return assignment.getRExpression();
        }
        if (JavaTokenType.EQ.equals(assignment.getOperationTokenType()) && assignment.getRExpression() instanceof PsiBinaryExpression && JavaTokenType.PLUS.equals((binOp = (PsiBinaryExpression)assignment.getRExpression()).getOperationTokenType())) {
            if (StreamApiMigrationInspection.sameReference(binOp.getLOperand(), assignment.getLExpression())) {
                return binOp.getROperand();
            }
            if (StreamApiMigrationInspection.sameReference(binOp.getROperand(), assignment.getLExpression())) {
                return binOp.getLOperand();
            }
        }
        return null;
    }

    @Nullable
    static PsiVariable extractAccumulator(PsiAssignmentExpression assignment) {
        PsiBinaryExpression binOp;
        PsiReferenceExpression lExpr = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
        if (lExpr == null) {
            return null;
        }
        PsiVariable var = (PsiVariable)ObjectUtils.tryCast((Object)lExpr.resolve(), PsiVariable.class);
        if (var == null) {
            return null;
        }
        if (JavaTokenType.PLUSEQ.equals(assignment.getOperationTokenType())) {
            return var;
        }
        if (JavaTokenType.EQ.equals(assignment.getOperationTokenType()) && assignment.getRExpression() instanceof PsiBinaryExpression && JavaTokenType.PLUS.equals((binOp = (PsiBinaryExpression)assignment.getRExpression()).getOperationTokenType())) {
            PsiExpression left = binOp.getLOperand();
            PsiExpression right = binOp.getROperand();
            if (StreamApiMigrationInspection.sameReference(left, (PsiExpression)lExpr) || StreamApiMigrationInspection.sameReference(right, (PsiExpression)lExpr)) {
                return var;
            }
        }
        return null;
    }

    @Contract(value="null -> null")
    static PsiExpression extractIncrementedLValue(PsiExpression expression2) {
        PsiAssignmentExpression assignment;
        if (expression2 instanceof PsiPostfixExpression) {
            if (JavaTokenType.PLUSPLUS.equals(((PsiPostfixExpression)expression2).getOperationTokenType())) {
                return ((PsiPostfixExpression)expression2).getOperand();
            }
        } else if (expression2 instanceof PsiPrefixExpression) {
            if (JavaTokenType.PLUSPLUS.equals(((PsiPrefixExpression)expression2).getOperationTokenType())) {
                return ((PsiPrefixExpression)expression2).getOperand();
            }
        } else if (expression2 instanceof PsiAssignmentExpression && ExpressionUtils.isLiteral((PsiElement)StreamApiMigrationInspection.extractAddend(assignment = (PsiAssignmentExpression)expression2), 1)) {
            return assignment.getLExpression();
        }
        return null;
    }

    @Nullable
    private static PsiLocalVariable getIncrementedVariable(PsiExpression expression2, TerminalBlock tb, List<PsiVariable> variables) {
        if (variables.size() != 1) {
            return null;
        }
        PsiReferenceExpression operand2 = (PsiReferenceExpression)ObjectUtils.tryCast((Object)StreamApiMigrationInspection.extractIncrementedLValue(expression2), PsiReferenceExpression.class);
        if (operand2 == null) {
            return null;
        }
        PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)operand2.resolve(), PsiLocalVariable.class);
        if (variable != null && variables.contains(variable) && !tb.isReferencedInOperations((PsiVariable)variable)) {
            return variable;
        }
        return null;
    }

    @Nullable
    private static PsiVariable getAccumulatedVariable(TerminalBlock tb, List<PsiVariable> variables) {
        if (variables.size() != 1) {
            return null;
        }
        PsiAssignmentExpression assignment = tb.getSingleExpression(PsiAssignmentExpression.class);
        if (assignment == null) {
            return null;
        }
        PsiVariable var = StreamApiMigrationInspection.extractAccumulator(assignment);
        if (var == null || !variables.contains(var)) {
            return null;
        }
        if (!(var.getType() instanceof PsiPrimitiveType) || var.getType().equalsToText("float")) {
            return null;
        }
        if (tb.isReferencedInOperations(var)) {
            return null;
        }
        PsiExpression addend = StreamApiMigrationInspection.extractAddend(assignment);
        LOG.assertTrue(addend != null);
        if (VariableAccessUtils.variableIsUsed(var, (PsiElement)addend)) {
            return null;
        }
        return var;
    }

    static boolean isAddAllCall(TerminalBlock tb) {
        PsiMethodCallExpression call = tb.getSingleMethodCall();
        if (call == null || tb.getVariable().getType() instanceof PsiPrimitiveType) {
            return false;
        }
        if (!ExpressionUtils.isReferenceTo(call.getArgumentList().getExpressions()[0], tb.getVariable())) {
            return false;
        }
        if (!"add".equals(call.getMethodExpression().getReferenceName())) {
            return false;
        }
        PsiExpression qualifierExpression2 = call.getMethodExpression().getQualifierExpression();
        if (qualifierExpression2 == null || qualifierExpression2 instanceof PsiThisExpression) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class);
            return method == null || !method.getName().equals("addAll");
        }
        return !(qualifierExpression2 instanceof PsiMethodCallExpression);
    }

    @Contract(value="null, _, _ -> false")
    static boolean isCallOf(PsiMethodCallExpression call, String className, String ... methodNames) {
        if (call == null) {
            return false;
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String name2 = methodExpression.getReferenceName();
        if (!ArrayUtil.contains((String)name2, (String[])methodNames)) {
            return false;
        }
        PsiMethod maybeMapMethod = call.resolveMethod();
        if (maybeMapMethod == null || maybeMapMethod.getParameterList().getParametersCount() != call.getArgumentList().getExpressions().length) {
            return false;
        }
        PsiClass containingClass = maybeMapMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (className.equals(containingClass.getQualifiedName())) {
            return true;
        }
        Object[] superMethods = maybeMapMethod.findDeepestSuperMethods();
        return ((StreamEx)StreamEx.of((Object[])superMethods).map(PsiMember::getContainingClass).nonNull()).map(PsiClass::getQualifiedName).has((Object)className);
    }

    private static boolean isCountOperation(List<PsiVariable> nonFinalVariables, TerminalBlock tb) {
        PsiLocalVariable variable = StreamApiMigrationInspection.getIncrementedVariable(tb.getSingleExpression(PsiExpression.class), tb, nonFinalVariables);
        PsiExpression counter = tb.getCountExpression();
        if (counter == null) {
            return variable != null;
        }
        if (tb.isEmpty()) {
            variable = StreamApiMigrationInspection.getIncrementedVariable(counter, tb, nonFinalVariables);
        } else if (!ExpressionUtils.isReferenceTo(counter, (PsiVariable)variable)) {
            return false;
        }
        return variable != null && ExpressionUtils.isZero(variable.getInitializer()) && ControlFlowUtils.getInitializerUsageStatus((PsiVariable)variable, tb.getMainLoop()) != ControlFlowUtils.InitializerUsageStatus.UNKNOWN;
    }

    private static boolean isTrivial(TerminalBlock tb) {
        PsiVariable variable = tb.getVariable();
        PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiElement)tb.getSingleStatement(), new PsiVariable[]{variable}, (PsiType)StreamApiMigrationInspection.createDefaultConsumerType(variable.getProject(), variable), null);
        if (!(candidate instanceof PsiCallExpression)) {
            return true;
        }
        PsiMethod method = ((PsiCallExpression)candidate).resolveMethod();
        return method == null;
    }

    @Nullable
    private static PsiClassType createDefaultConsumerType(Project project2, PsiVariable variable) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiClass consumerClass = psiFacade.findClass("java.util.function.Consumer", variable.getResolveScope());
        return consumerClass != null ? psiFacade.getElementFactory().createType(consumerClass, variable.getType()) : null;
    }

    static boolean isVariableSuitableForStream(PsiVariable variable, PsiStatement statement2, TerminalBlock tb) {
        if (ReferencesSearch.search((PsiElement)variable).forEach(ref -> {
            PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)ref.getElement(), PsiExpression.class);
            return expression2 == null || !PsiUtil.isAccessedForWriting((PsiExpression)expression2) || tb.operations().anyMatch(op -> op.isWriteAllowed(variable, expression2));
        })) {
            return true;
        }
        return HighlightControlFlowUtil.isEffectivelyFinal(variable, (PsiElement)statement2, null);
    }

    static String tryUnbox(PsiVariable variable) {
        PsiType type2 = variable.getType();
        String mapOp = null;
        if (type2.equals(PsiType.INT)) {
            mapOp = "mapToInt";
        } else if (type2.equals(PsiType.LONG)) {
            mapOp = "mapToLong";
        } else if (type2.equals(PsiType.DOUBLE)) {
            mapOp = "mapToDouble";
        }
        return mapOp == null ? "" : "." + mapOp + "(" + variable.getName() + " -> " + variable.getName() + ")";
    }

    static boolean isExpressionDependsOnUpdatedCollections(PsiExpression condition2, PsiExpression qualifierExpression2) {
        PsiElement collection;
        PsiElement psiElement = collection = qualifierExpression2 instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifierExpression2).resolve() : null;
        if (collection != null) {
            return collection instanceof PsiVariable && VariableAccessUtils.variableIsUsed((PsiVariable)collection, (PsiElement)condition2);
        }
        final boolean[] dependsOnCollection = new boolean[]{false};
        condition2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                super.visitMethodCallExpression(expression2);
                PsiExpression callQualifier = expression2.getMethodExpression().getQualifierExpression();
                if (callQualifier == null || callQualifier instanceof PsiThisExpression && ((PsiThisExpression)callQualifier).getQualifier() == null || callQualifier instanceof PsiSuperExpression && ((PsiSuperExpression)callQualifier).getQualifier() == null) {
                    dependsOnCollection[0] = true;
                }
            }

            public void visitThisExpression(PsiThisExpression expression2) {
                super.visitThisExpression(expression2);
                if (expression2.getQualifier() == null && expression2.getParent() instanceof PsiExpressionList) {
                    dependsOnCollection[0] = true;
                }
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }
        });
        return dependsOnCollection[0];
    }

    @Nullable
    static PsiLocalVariable extractArray(TerminalBlock tb) {
        CountingLoopSource loop = tb.getLastOperation(CountingLoopSource.class);
        if (loop == null || loop.myIncluding) {
            return null;
        }
        PsiAssignmentExpression assignment = tb.getSingleExpression(PsiAssignmentExpression.class);
        if (assignment == null || !assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
            return null;
        }
        PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiArrayAccessExpression.class);
        if (arrayAccess == null) {
            return null;
        }
        if (!ExpressionUtils.isReferenceTo(arrayAccess.getIndexExpression(), loop.getVariable())) {
            return null;
        }
        PsiReferenceExpression arrayReference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)arrayAccess.getArrayExpression(), PsiReferenceExpression.class);
        if (arrayReference == null) {
            return null;
        }
        PsiLocalVariable arrayVariable = (PsiLocalVariable)ObjectUtils.tryCast((Object)arrayReference.resolve(), PsiLocalVariable.class);
        if (arrayVariable == null || ControlFlowUtils.getInitializerUsageStatus((PsiVariable)arrayVariable, tb.getMainLoop()) == ControlFlowUtils.InitializerUsageStatus.UNKNOWN) {
            return null;
        }
        PsiNewExpression initializer = (PsiNewExpression)ObjectUtils.tryCast((Object)arrayVariable.getInitializer(), PsiNewExpression.class);
        if (initializer == null) {
            return null;
        }
        PsiArrayType arrayType = (PsiArrayType)ObjectUtils.tryCast((Object)initializer.getType(), PsiArrayType.class);
        if (arrayType == null || !StreamApiUtil.isSupportedStreamElement(arrayType.getComponentType())) {
            return null;
        }
        PsiExpression dimension = (PsiExpression)ArrayUtil.getFirstElement((Object[])initializer.getArrayDimensions());
        if (dimension == null) {
            return null;
        }
        PsiExpression bound = loop.myBound;
        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)dimension, (PsiElement)bound) && !ExpressionUtils.isReferenceTo(ExpressionUtils.getArrayFromLengthExpression(bound), (PsiVariable)arrayVariable)) {
            return null;
        }
        if (VariableAccessUtils.variableIsUsed((PsiVariable)arrayVariable, (PsiElement)assignment.getRExpression())) {
            return null;
        }
        return arrayVariable;
    }

    static class CountingLoopSource
    extends StreamSource {
        final PsiExpression myBound;
        final boolean myIncluding;

        private CountingLoopSource(PsiLoopStatement loop, PsiVariable counter, PsiExpression initializer, PsiExpression bound, boolean including) {
            super(loop, counter, initializer);
            this.myBound = bound;
            this.myIncluding = including;
        }

        @Override
        StreamEx<PsiExpression> expressions() {
            return StreamEx.of((Object[])new PsiExpression[]{this.myExpression, this.myBound});
        }

        @Override
        public String createReplacement() {
            String className = this.myVariable.getType().equals(PsiType.LONG) ? "java.util.stream.LongStream" : "java.util.stream.IntStream";
            String methodName = this.myIncluding ? "rangeClosed" : "range";
            return className + "." + methodName + "(" + this.myExpression.getText() + ", " + this.myBound.getText() + ")";
        }

        CountingLoopSource withBound(PsiExpression bound) {
            return new CountingLoopSource(this.getLoop(), this.getVariable(), this.getExpression(), bound, this.myIncluding);
        }

        @Override
        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            PsiForStatement forStatement;
            if (variable == this.myVariable && (forStatement = (PsiForStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiForStatement.class)) != null) {
                return PsiTreeUtil.isAncestor((PsiElement)forStatement.getUpdate(), (PsiElement)reference, (boolean)false);
            }
            return false;
        }

        @Override
        boolean canReassignVariable(PsiVariable variable) {
            return variable != this.myVariable;
        }

        @Nullable
        public static CountingLoopSource from(PsiForStatement forStatement) {
            CountingLoop loop = CountingLoop.from(forStatement);
            if (loop == null) {
                return null;
            }
            return new CountingLoopSource((PsiLoopStatement)forStatement, (PsiVariable)loop.getCounter(), loop.getInitializer(), loop.getBound(), loop.isIncluding());
        }
    }

    static class CollectionStream
    extends StreamSource {
        private CollectionStream(PsiLoopStatement loop, PsiVariable variable, PsiExpression expression2) {
            super(loop, variable, expression2);
        }

        @Override
        String createReplacement() {
            return ParenthesesUtils.getText(this.myExpression, 2) + ".stream()" + StreamApiMigrationInspection.tryUnbox(this.myVariable);
        }

        @Contract(value="null, _ -> false")
        static boolean isRawSubstitution(PsiType iteratedValueType, PsiClass collectionClass) {
            return iteratedValueType instanceof PsiClassType && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)collectionClass, (PsiSubstitutor)TypeConversionUtil.getSuperClassSubstitutor((PsiClass)collectionClass, (PsiClassType)((PsiClassType)iteratedValueType)));
        }

        @Nullable
        public static CollectionStream from(PsiForeachStatement statement2) {
            PsiExpression iteratedValue2 = statement2.getIteratedValue();
            if (iteratedValue2 == null) {
                return null;
            }
            PsiType iteratedValueType = iteratedValue2.getType();
            PsiClass collectionClass = JavaPsiFacade.getInstance((Project)statement2.getProject()).findClass("java.util.Collection", statement2.getResolveScope());
            PsiClass iteratorClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)iteratedValueType);
            if (collectionClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)iteratorClass, (PsiClass)collectionClass, (boolean)true) || CollectionStream.isRawSubstitution(iteratedValueType, collectionClass) || !StreamApiUtil.isSupportedStreamElement(statement2.getIterationParameter().getType())) {
                return null;
            }
            return new CollectionStream((PsiLoopStatement)statement2, (PsiVariable)statement2.getIterationParameter(), iteratedValue2);
        }
    }

    static class ArrayStream
    extends StreamSource {
        private ArrayStream(PsiLoopStatement loop, PsiVariable variable, PsiExpression expression2) {
            super(loop, variable, expression2);
        }

        @Override
        String createReplacement() {
            Object[] children2;
            PsiArrayInitializerExpression initializer;
            if (this.myExpression instanceof PsiNewExpression && (initializer = ((PsiNewExpression)this.myExpression).getArrayInitializer()) != null && (children2 = initializer.getChildren()).length > 2) {
                String initializerText = StreamEx.of((Object[])children2, (int)1, (int)(children2.length - 1)).map(PsiElement::getText).joining();
                PsiType type2 = this.myExpression.getType();
                if (type2 instanceof PsiArrayType) {
                    PsiType componentType = ((PsiArrayType)type2).getComponentType();
                    if (componentType.equals(PsiType.INT)) {
                        return "java.util.stream.IntStream.of(" + initializerText + ")";
                    }
                    if (componentType.equals(PsiType.LONG)) {
                        return "java.util.stream.LongStream.of(" + initializerText + ")";
                    }
                    if (componentType.equals(PsiType.DOUBLE)) {
                        return "java.util.stream.DoubleStream.of(" + initializerText + ")";
                    }
                    if (componentType instanceof PsiClassType) {
                        return "java.util.stream.Stream.<" + componentType.getCanonicalText() + ">of(" + initializerText + ")";
                    }
                }
            }
            return "java.util.Arrays.stream(" + this.myExpression.getText() + ")";
        }

        @Nullable
        public static ArrayStream from(PsiForeachStatement statement2) {
            PsiExpression iteratedValue2 = statement2.getIteratedValue();
            if (iteratedValue2 == null) {
                return null;
            }
            PsiArrayType iteratedValueType = (PsiArrayType)ObjectUtils.tryCast((Object)iteratedValue2.getType(), PsiArrayType.class);
            PsiParameter parameter = statement2.getIterationParameter();
            if (iteratedValueType != null && StreamApiUtil.isSupportedStreamElement(iteratedValueType.getComponentType()) && (!(parameter.getType() instanceof PsiPrimitiveType) || parameter.getType().equals(iteratedValueType.getComponentType()))) {
                return new ArrayStream((PsiLoopStatement)statement2, (PsiVariable)parameter, iteratedValue2);
            }
            return null;
        }
    }

    static class BufferedReaderLines
    extends StreamSource {
        private BufferedReaderLines(PsiLoopStatement loop, PsiVariable variable, PsiExpression expression2) {
            super(loop, variable, expression2);
        }

        @Override
        String createReplacement() {
            return this.myExpression.getText() + ".lines()";
        }

        @Override
        void cleanUp() {
            this.myVariable.delete();
        }

        @Override
        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            return this.myVariable == variable && reference.getParent() == PsiTreeUtil.getParentOfType((PsiElement)this.myExpression, PsiAssignmentExpression.class);
        }

        @Nullable
        public static BufferedReaderLines from(PsiWhileStatement whileLoop) {
            PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)whileLoop.getCondition()), PsiBinaryExpression.class);
            if (binOp == null) {
                return null;
            }
            if (!JavaTokenType.NE.equals(binOp.getOperationTokenType())) {
                return null;
            }
            PsiExpression operand2 = ExpressionUtils.getValueComparedWithNull(binOp);
            if (operand2 == null) {
                return null;
            }
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2));
            if (assignment == null) {
                return null;
            }
            PsiReferenceExpression lValue = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
            if (lValue == null) {
                return null;
            }
            PsiLocalVariable var = (PsiLocalVariable)ObjectUtils.tryCast((Object)lValue.resolve(), PsiLocalVariable.class);
            if (var == null) {
                return null;
            }
            if (!ReferencesSearch.search((PsiElement)var).forEach(ref -> PsiTreeUtil.isAncestor((PsiElement)whileLoop, (PsiElement)ref.getElement(), (boolean)true))) {
                return null;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression()), PsiMethodCallExpression.class);
            if (call == null || call.getArgumentList().getExpressions().length != 0) {
                return null;
            }
            if (!"readLine".equals(call.getMethodExpression().getReferenceName())) {
                return null;
            }
            PsiExpression readerExpression = call.getMethodExpression().getQualifierExpression();
            if (readerExpression == null) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return null;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null || !"java.io.BufferedReader".equals(aClass.getQualifiedName())) {
                return null;
            }
            return new BufferedReaderLines((PsiLoopStatement)whileLoop, (PsiVariable)var, readerExpression);
        }
    }

    static abstract class StreamSource
    extends Operation {
        private final PsiLoopStatement myLoop;

        protected StreamSource(PsiLoopStatement loop, PsiVariable variable, PsiExpression expression2) {
            super(expression2, variable);
            this.myLoop = loop;
        }

        PsiLoopStatement getLoop() {
            return this.myLoop;
        }

        @Contract(value="null -> null")
        static StreamSource tryCreate(PsiLoopStatement statement2) {
            if (statement2 instanceof PsiForStatement) {
                return CountingLoopSource.from((PsiForStatement)statement2);
            }
            if (statement2 instanceof PsiForeachStatement) {
                ArrayStream source = ArrayStream.from((PsiForeachStatement)statement2);
                return source == null ? CollectionStream.from((PsiForeachStatement)statement2) : source;
            }
            if (statement2 instanceof PsiWhileStatement) {
                return BufferedReaderLines.from((PsiWhileStatement)statement2);
            }
            return null;
        }
    }

    static class DistinctOp
    extends Operation {
        protected DistinctOp(PsiVariable variable) {
            super(null, variable);
        }

        @Override
        String createReplacement() {
            return ".distinct()";
        }
    }

    static class LimitOp
    extends Operation {
        private final PsiExpression myCounter;
        private final PsiLocalVariable myCounterVariable;
        private final int myDelta;

        LimitOp(PsiVariable variable, PsiExpression countExpression, PsiExpression limitExpression, PsiLocalVariable counterVariable, int delta) {
            super(limitExpression, variable);
            LOG.assertTrue(delta >= 0);
            this.myDelta = delta;
            this.myCounter = countExpression;
            this.myCounterVariable = counterVariable;
        }

        @Override
        String createReplacement() {
            return ".limit(" + this.getLimitExpression() + ")";
        }

        PsiLocalVariable getCounterVariable() {
            return this.myCounterVariable;
        }

        PsiExpression getCountExpression() {
            return this.myCounter;
        }

        @Override
        void cleanUp() {
            if (this.myCounterVariable != null) {
                this.myCounterVariable.delete();
            }
        }

        @Override
        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            return variable == this.myCounterVariable && PsiTreeUtil.isAncestor((PsiElement)this.myCounter, (PsiElement)reference, (boolean)false);
        }

        private String getLimitExpression() {
            Object value2;
            if (this.myDelta == 0) {
                return this.myExpression.getText();
            }
            if (this.myExpression instanceof PsiLiteralExpression && ((value2 = ((PsiLiteralExpression)this.myExpression).getValue()) instanceof Integer || value2 instanceof Long)) {
                return String.valueOf(((Number)value2).longValue() + (long)this.myDelta);
            }
            return ParenthesesUtils.getText(this.myExpression, 6) + "+" + this.myDelta;
        }
    }

    static class FlatMapOp
    extends Operation {
        private final StreamSource mySource;

        FlatMapOp(StreamSource source, PsiVariable variable) {
            super(source.getExpression(), variable);
            this.mySource = source;
        }

        @Override
        public String createReplacement() {
            String operation = "flatMap";
            PsiType inType = this.myVariable.getType();
            PsiType outType = this.mySource.getVariable().getType();
            String lambda2 = this.myVariable.getName() + " -> " + this.getStreamExpression();
            if (outType instanceof PsiPrimitiveType && !outType.equals(inType)) {
                if (outType.equals(PsiType.INT)) {
                    operation = "flatMapToInt";
                } else if (outType.equals(PsiType.LONG)) {
                    operation = "flatMapToLong";
                } else if (outType.equals(PsiType.DOUBLE)) {
                    operation = "flatMapToDouble";
                }
            }
            if (inType instanceof PsiPrimitiveType && !outType.equals(inType)) {
                return ".mapToObj(" + lambda2 + ")." + operation + "(" + "java.util.function.Function" + ".identity())";
            }
            return "." + operation + "(" + lambda2 + ")";
        }

        @NotNull
        String getStreamExpression() {
            String string = this.mySource.createReplacement();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$FlatMapOp", "getStreamExpression"));
            }
            return string;
        }

        @Override
        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            return this.mySource.isWriteAllowed(variable, reference);
        }

        @Override
        boolean canReassignVariable(PsiVariable variable) {
            return this.mySource.canReassignVariable(variable);
        }

        boolean breaksMe(PsiBreakStatement statement2) {
            return statement2.findExitedStatement() == this.mySource.getLoop();
        }
    }

    static class MapOp
    extends Operation {
        @Nullable
        private final PsiType myType;

        MapOp(PsiExpression expression2, PsiVariable variable, @Nullable PsiType targetType) {
            super(expression2, variable);
            this.myType = targetType;
        }

        @Override
        public String createReplacement() {
            return StreamApiUtil.generateMapOperation(this.myVariable, this.myType, (PsiElement)this.myExpression);
        }

        @Override
        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            return variable == this.myVariable && reference.getParent() == this.myExpression.getParent();
        }
    }

    static class CompoundFilterOp
    extends FilterOp {
        private final FlatMapOp myFlatMapOp;
        private final PsiVariable myMatchVariable;

        CompoundFilterOp(FilterOp source, FlatMapOp flatMapOp) {
            super(source.getExpression(), flatMapOp.myVariable, source.myNegated);
            this.myMatchVariable = source.myVariable;
            this.myFlatMapOp = flatMapOp;
        }

        @Override
        PsiExpression makeIntermediateExpression(PsiElementFactory factory) {
            return factory.createExpressionFromText(this.myFlatMapOp.getStreamExpression() + ".anyMatch(" + LambdaUtil.createLambda((PsiVariable)this.myMatchVariable, (PsiExpression)this.myExpression) + ")", (PsiElement)this.myExpression);
        }

        @Override
        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            return this.myFlatMapOp.isWriteAllowed(variable, reference);
        }

        @Override
        StreamEx<PsiExpression> expressions() {
            return StreamEx.of((Object[])new PsiExpression[]{this.myExpression, this.myFlatMapOp.myExpression});
        }
    }

    static class TakeWhileOp
    extends FilterOp {
        TakeWhileOp(PsiExpression condition2, PsiVariable variable, boolean negated) {
            super(condition2, variable, negated);
        }

        @Override
        @NotNull
        String getOpName() {
            if ("takeWhile" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$TakeWhileOp", "getOpName"));
            }
            return "takeWhile";
        }
    }

    static class FilterOp
    extends Operation {
        private final boolean myNegated;

        FilterOp(PsiExpression condition2, PsiVariable variable, boolean negated) {
            super(condition2, variable);
            this.myNegated = negated;
        }

        public boolean isNegated() {
            return this.myNegated;
        }

        @Override
        public String createReplacement() {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myExpression.getProject());
            PsiExpression intermediate = this.makeIntermediateExpression(factory);
            PsiExpression expression2 = this.myNegated ? factory.createExpressionFromText(BoolUtils.getNegatedExpressionText(intermediate), (PsiElement)this.myExpression) : intermediate;
            return "." + this.getOpName() + "(" + LambdaUtil.createLambda((PsiVariable)this.myVariable, (PsiExpression)expression2) + ")";
        }

        @NotNull
        String getOpName() {
            if ("filter" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$FilterOp", "getOpName"));
            }
            return "filter";
        }

        PsiExpression makeIntermediateExpression(PsiElementFactory factory) {
            return this.myExpression;
        }
    }

    static abstract class Operation {
        final PsiExpression myExpression;
        final PsiVariable myVariable;

        protected Operation(PsiExpression expression2, PsiVariable variable) {
            this.myExpression = expression2;
            this.myVariable = variable;
        }

        void cleanUp() {
        }

        public PsiVariable getVariable() {
            return this.myVariable;
        }

        PsiExpression getExpression() {
            return this.myExpression;
        }

        StreamEx<PsiExpression> expressions() {
            return StreamEx.ofNullable((Object)this.myExpression);
        }

        abstract String createReplacement();

        boolean isWriteAllowed(PsiVariable variable, PsiExpression reference) {
            return false;
        }

        boolean canReassignVariable(PsiVariable variable) {
            return true;
        }
    }

    private class StreamApiMigrationVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;

        public StreamApiMigrationVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            this.myHolder = holder;
            this.myIsOnTheFly = isOnTheFly;
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            super.visitForeachStatement(statement2);
            this.processLoop((PsiLoopStatement)statement2);
        }

        public void visitWhileStatement(PsiWhileStatement statement2) {
            super.visitWhileStatement(statement2);
            this.processLoop((PsiLoopStatement)statement2);
        }

        public void visitForStatement(PsiForStatement statement2) {
            super.visitForStatement(statement2);
            this.processLoop((PsiLoopStatement)statement2);
        }

        void processLoop(PsiLoopStatement statement2) {
            PsiStatement body2 = statement2.getBody();
            if (body2 == null) {
                return;
            }
            StreamSource source = StreamSource.tryCreate(statement2);
            if (source == null) {
                return;
            }
            if (!ExceptionUtil.getThrownCheckedExceptions(new PsiElement[]{body2}).isEmpty()) {
                return;
            }
            TerminalBlock tb = TerminalBlock.from(source, body2);
            BaseStreamApiMigration migration = this.findMigration(statement2, body2, tb);
            if (migration != null && (this.myIsOnTheFly || migration.isShouldWarn())) {
                Object[] fixes = new MigrateToStreamFix[]{new MigrateToStreamFix(migration)};
                if (migration instanceof ForEachMigration && !(tb.getLastOperation() instanceof CollectionStream)) {
                    fixes = (MigrateToStreamFix[])ArrayUtil.append((Object[])fixes, (Object)new MigrateToStreamFix(new ForEachMigration(migration.isShouldWarn(), "forEachOrdered")));
                }
                ProblemHighlightType highlightType = migration.isShouldWarn() ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                this.myHolder.registerProblem((PsiElement)statement2, "Can be replaced with '" + migration.getReplacement() + "' call", highlightType, this.getRange(migration.isShouldWarn(), statement2).shiftRight(-statement2.getTextOffset()), (LocalQuickFix[])fixes);
            }
        }

        @Nullable
        private BaseStreamApiMigration findMigration(PsiLoopStatement loop, PsiStatement body2, TerminalBlock tb) {
            PsiStatement breakStatement;
            CollectMigration.CollectTerminal terminal;
            ControlFlow controlFlow;
            try {
                controlFlow = ControlFlowFactory.getInstance(this.myHolder.getProject()).getControlFlow((PsiElement)body2, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
            }
            catch (AnalysisCanceledException ignored) {
                return null;
            }
            int startOffset = controlFlow.getStartOffset((PsiElement)body2);
            int endOffset = controlFlow.getEndOffset((PsiElement)body2);
            if (startOffset < 0 || endOffset < 0) {
                return null;
            }
            PsiElement surrounder = PsiTreeUtil.getParentOfType((PsiElement)loop, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class});
            List nonFinalVariables = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(ControlFlowUtil.getUsedVariables(controlFlow, startOffset, endOffset)).remove(variable -> variable instanceof PsiField)).remove(variable -> PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiLambdaExpression.class, PsiClass.class}) != surrounder)).remove(variable -> StreamApiMigrationInspection.isVariableSuitableForStream(variable, (PsiStatement)loop, tb))).toList();
            if (StreamApiMigrationInspection.isCountOperation(nonFinalVariables, tb)) {
                return new CountMigration(true);
            }
            if (nonFinalVariables.isEmpty() && (terminal = CollectMigration.extractCollectTerminal(tb)) != null) {
                boolean addAll;
                boolean bl = addAll = loop instanceof PsiForeachStatement && !tb.hasOperations() && StreamApiMigrationInspection.isAddAllCall(tb);
                if (addAll) {
                    return null;
                }
                boolean shouldWarn = StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH || tb.hasOperations() || tb.getLastOperation() instanceof BufferedReaderLines || !terminal.isTrivial();
                return new CollectMigration(shouldWarn, terminal.getMethodName());
            }
            if (tb.getCountExpression() != null || tb.isEmpty()) {
                return null;
            }
            if (nonFinalVariables.isEmpty() && StreamApiMigrationInspection.extractArray(tb) != null) {
                return new ToArrayMigration(true);
            }
            if (StreamApiMigrationInspection.getAccumulatedVariable(tb, nonFinalVariables) != null) {
                return new SumMigration(true);
            }
            Collection<PsiStatement> exitPoints = tb.findExitPoints(controlFlow);
            if (exitPoints == null) {
                return null;
            }
            if (exitPoints.isEmpty() && nonFinalVariables.isEmpty()) {
                boolean shouldWarn = StreamApiMigrationInspection.this.SUGGEST_FOREACH && (StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH || tb.hasOperations() || ForEachMigration.tryExtractMapExpression(tb) != null || !StreamApiMigrationInspection.isTrivial(tb));
                return new ForEachMigration(shouldWarn, "forEach");
            }
            if (nonFinalVariables.isEmpty() && tb.getSingleStatement() instanceof PsiReturnStatement) {
                return this.findMigrationForReturn(loop, tb);
            }
            if (tb.intermediateAndSourceExpressions().flatCollection(expr -> PsiTreeUtil.collectElementsOfType((PsiElement)expr, (Class[])new Class[]{PsiReferenceExpression.class})).map(PsiReference::resolve).select(PsiVariable.class).anyMatch(nonFinalVariables::contains)) {
                return null;
            }
            PsiStatement[] statements = tb.getStatements();
            if (statements.length == 2 && ControlFlowUtils.statementBreaksLoop(breakStatement = statements[1], loop) && exitPoints.size() == 1 && exitPoints.contains(breakStatement)) {
                return this.findMigrationForBreak(tb, nonFinalVariables, statements[0]);
            }
            return null;
        }

        @Nullable
        private BaseStreamApiMigration findMigrationForBreak(TerminalBlock tb, List<PsiVariable> nonFinalVariables, PsiStatement statement2) {
            boolean shouldWarn;
            boolean bl = shouldWarn = StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH || tb.hasOperations();
            if (ReferencesSearch.search((PsiElement)tb.getVariable(), (SearchScope)new LocalSearchScope((PsiElement)statement2)).findFirst() == null) {
                return new MatchMigration(shouldWarn, "anyMatch");
            }
            if (nonFinalVariables.isEmpty() && statement2 instanceof PsiExpressionStatement) {
                return new FindFirstMigration(shouldWarn);
            }
            if (nonFinalVariables.size() == 1) {
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)statement2);
                if (assignment == null) {
                    return null;
                }
                PsiReferenceExpression lValue = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
                if (lValue == null) {
                    return null;
                }
                PsiVariable var = (PsiVariable)ObjectUtils.tryCast((Object)lValue.resolve(), PsiVariable.class);
                if (var == null || !nonFinalVariables.contains(var)) {
                    return null;
                }
                PsiExpression rValue = assignment.getRExpression();
                if (rValue == null || VariableAccessUtils.variableIsUsed(var, (PsiElement)rValue)) {
                    return null;
                }
                if (tb.getVariable().getType() instanceof PsiPrimitiveType && !ExpressionUtils.isReferenceTo(rValue, tb.getVariable())) {
                    return null;
                }
                return new FindFirstMigration(shouldWarn);
            }
            return null;
        }

        @Nullable
        private BaseStreamApiMigration findMigrationForReturn(PsiLoopStatement statement2, TerminalBlock tb) {
            boolean shouldWarn = StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH || tb.hasOperations();
            PsiReturnStatement returnStatement = (PsiReturnStatement)tb.getSingleStatement();
            PsiExpression value2 = returnStatement.getReturnValue();
            PsiReturnStatement nextReturnStatement = StreamApiMigrationInspection.getNextReturnStatement((PsiStatement)statement2);
            if (nextReturnStatement != null && (ExpressionUtils.isLiteral((PsiElement)value2, Boolean.TRUE) || ExpressionUtils.isLiteral((PsiElement)value2, Boolean.FALSE))) {
                String methodName;
                boolean foundResult = (Boolean)((PsiLiteralExpression)value2).getValue();
                if (foundResult) {
                    methodName = "anyMatch";
                } else {
                    methodName = "noneMatch";
                    FilterOp lastFilter = tb.getLastOperation(FilterOp.class);
                    if (lastFilter != null && lastFilter.isNegated() ^ BoolUtils.isNegation(lastFilter.getExpression())) {
                        methodName = "allMatch";
                    }
                }
                if (nextReturnStatement.getParent() == statement2.getParent() || ExpressionUtils.isLiteral((PsiElement)nextReturnStatement.getReturnValue(), !foundResult)) {
                    return new MatchMigration(shouldWarn, methodName);
                }
            }
            if (!VariableAccessUtils.variableIsUsed(tb.getVariable(), (PsiElement)value2)) {
                if (!StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH && !tb.hasOperations() || tb.getLastOperation() instanceof FilterOp && tb.operations().count() == 2L) {
                    return null;
                }
                return new MatchMigration(shouldWarn, "anyMatch");
            }
            if (nextReturnStatement != null && ExpressionUtils.isSimpleExpression(nextReturnStatement.getReturnValue()) && (!(tb.getVariable().getType() instanceof PsiPrimitiveType) || ExpressionUtils.isReferenceTo(value2, tb.getVariable()))) {
                return new FindFirstMigration(shouldWarn);
            }
            return null;
        }

        @NotNull
        private TextRange getRange(boolean shouldWarn, PsiLoopStatement statement2) {
            boolean wholeStatement;
            boolean bl = wholeStatement = this.myIsOnTheFly && (!shouldWarn || InspectionProjectProfileManager.isInformationLevel(StreamApiMigrationInspection.this.getShortName(), (PsiElement)statement2));
            if (statement2 instanceof PsiForeachStatement) {
                PsiJavaToken rParenth = ((PsiForeachStatement)statement2).getRParenth();
                if (wholeStatement && rParenth != null) {
                    TextRange textRange = new TextRange(statement2.getTextOffset(), rParenth.getTextOffset() + 1);
                    if (textRange == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$StreamApiMigrationVisitor", "getRange"));
                    }
                    return textRange;
                }
                PsiExpression iteratedValue2 = ((PsiForeachStatement)statement2).getIteratedValue();
                LOG.assertTrue(iteratedValue2 != null);
                TextRange textRange = iteratedValue2.getTextRange();
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$StreamApiMigrationVisitor", "getRange"));
                }
                return textRange;
            }
            if (statement2 instanceof PsiForStatement) {
                PsiJavaToken rParenth = ((PsiForStatement)statement2).getRParenth();
                if (wholeStatement && rParenth != null) {
                    TextRange textRange = new TextRange(statement2.getTextOffset(), rParenth.getTextOffset() + 1);
                    if (textRange == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$StreamApiMigrationVisitor", "getRange"));
                    }
                    return textRange;
                }
                PsiStatement initialization = ((PsiForStatement)statement2).getInitialization();
                LOG.assertTrue(initialization != null);
                TextRange textRange = initialization.getTextRange();
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$StreamApiMigrationVisitor", "getRange"));
                }
                return textRange;
            }
            if (statement2 instanceof PsiWhileStatement) {
                PsiJavaToken rParenth = ((PsiWhileStatement)statement2).getRParenth();
                if (wholeStatement && rParenth != null) {
                    TextRange textRange = new TextRange(statement2.getTextOffset(), rParenth.getTextOffset() + 1);
                    if (textRange == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$StreamApiMigrationVisitor", "getRange"));
                    }
                    return textRange;
                }
                TextRange textRange = statement2.getFirstChild().getTextRange();
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/StreamApiMigrationInspection$StreamApiMigrationVisitor", "getRange"));
                }
                return textRange;
            }
            throw new IllegalStateException("Unexpected statement type: " + statement2);
        }
    }
}

