/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.suspiciousNameCombination;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.MethodMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousNameCombinationInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @NonNls
    private static final String ELEMENT_GROUPS = "group";
    @NonNls
    private static final String ATTRIBUTE_NAMES = "names";
    @NonNls
    private static final String ELEMENT_IGNORED_METHODS = "ignored";
    protected final List<String> myNameGroups = new ArrayList<String>();
    private final Map<String, String> myWordToGroupMap = new HashMap<String, String>();
    final MethodMatcher myIgnoredMethods = new MethodMatcher().add("java.io.PrintStream", "println").add("java.io.PrintWriter", "println").add("java.lang.System", "identityHashCode").add("java.sql.PreparedStatement", "set.*").add("java.sql.ResultSet", "update.*").add("java.sql.SQLOutput", "write.*").add("java.lang.Integer", "compare.*").add("java.lang.Long", "compare.*").add("java.lang.Short", "compare").add("java.lang.Byte", "compare").add("java.lang.Character", "compare").add("java.lang.Boolean", "compare").add("java.lang.Math", ".*").add("java.lang.StrictMath", ".*");

    public SuspiciousNameCombinationInspectionBase() {
        this.addNameGroup("x,width,left,right");
        this.addNameGroup("y,height,top,bottom");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    protected void clearNameGroups() {
        this.myNameGroups.clear();
        this.myWordToGroupMap.clear();
    }

    protected void addNameGroup(@NonNls String group) {
        this.myNameGroups.add(group);
        List words = StringUtil.split((String)group, (String)",");
        for (String word : words) {
            this.myWordToGroupMap.put(SuspiciousNameCombinationInspectionBase.canonicalize(word), group);
        }
    }

    @NotNull
    private static String canonicalize(String word) {
        String string = word.trim().toLowerCase(Locale.ENGLISH);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "canonicalize"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"suspicious.name.combination.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SuspiciousNameCombination" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "getShortName"));
        }
        return "SuspiciousNameCombination";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "buildVisitor"));
        }
        MyVisitor myVisitor = new MyVisitor(holder);
        if (myVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "buildVisitor"));
        }
        return myVisitor;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "readSettings"));
        }
        this.clearNameGroups();
        for (Object o : node.getChildren(ELEMENT_GROUPS)) {
            Element e = (Element)o;
            this.addNameGroup(e.getAttributeValue(ATTRIBUTE_NAMES));
        }
        Element ignoredMethods = node.getChild(ELEMENT_IGNORED_METHODS);
        if (ignoredMethods != null) {
            this.myIgnoredMethods.readSettings(ignoredMethods);
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/suspiciousNameCombination/SuspiciousNameCombinationInspectionBase", "writeSettings"));
        }
        for (String group : this.myNameGroups) {
            Element e = new Element(ELEMENT_GROUPS);
            node.addContent(e);
            e.setAttribute(ATTRIBUTE_NAMES, group);
        }
        Element ignoredMethods = new Element(ELEMENT_IGNORED_METHODS);
        node.addContent(ignoredMethods);
        this.myIgnoredMethods.writeSettings(ignoredMethods);
    }

    private class MyVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myProblemsHolder;

        public MyVisitor(ProblemsHolder problemsHolder) {
            this.myProblemsHolder = problemsHolder;
        }

        public void visitVariable(PsiVariable variable) {
            PsiExpression expr;
            if (variable.hasInitializer() && (expr = variable.getInitializer()) instanceof PsiReferenceExpression) {
                PsiReferenceExpression refExpr = (PsiReferenceExpression)expr;
                PsiIdentifier nameIdentifier = variable.getNameIdentifier();
                this.checkCombination((PsiElement)(nameIdentifier != null ? nameIdentifier : variable), variable.getName(), refExpr.getReferenceName(), "suspicious.name.assignment");
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            PsiExpression lhs = expression2.getLExpression();
            PsiExpression rhs = expression2.getRExpression();
            if (lhs instanceof PsiReferenceExpression && rhs instanceof PsiReferenceExpression) {
                PsiReferenceExpression lhsExpr = (PsiReferenceExpression)lhs;
                PsiReferenceExpression rhsExpr = (PsiReferenceExpression)rhs;
                this.checkCombination((PsiElement)lhsExpr, lhsExpr.getReferenceName(), rhsExpr.getReferenceName(), "suspicious.name.assignment");
            }
        }

        public void visitCallExpression(PsiCallExpression expression2) {
            PsiMethod psiMethod = expression2.resolveMethod();
            if (SuspiciousNameCombinationInspectionBase.this.myIgnoredMethods.matches(psiMethod)) {
                return;
            }
            PsiExpressionList argList = expression2.getArgumentList();
            if (psiMethod != null && argList != null) {
                PsiExpression[] args = argList.getExpressions();
                PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
                for (int i2 = 0; i2 < parameters2.length && i2 < args.length; ++i2) {
                    String refName;
                    if (!(args[i2] instanceof PsiReferenceExpression) || this.findNameGroup(refName = ((PsiReferenceExpression)args[i2]).getReferenceName()) == null) continue;
                    this.checkCombination((PsiElement)args[i2], parameters2[i2].getName(), refName, "suspicious.name.parameter");
                }
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement2) {
            PsiExpression returnValue = statement2.getReturnValue();
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)returnValue, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
            if (returnValue instanceof PsiReferenceExpression && containingMethod != null) {
                String refName = ((PsiReferenceExpression)returnValue).getReferenceName();
                this.checkCombination((PsiElement)returnValue, containingMethod.getName(), refName, "suspicious.name.return");
            }
        }

        private void checkCombination(PsiElement location, @Nullable String name2, @Nullable String referenceName, String key2) {
            String nameGroup1 = this.findNameGroup(name2);
            String nameGroup2 = this.findNameGroup(referenceName);
            if (nameGroup1 != null && nameGroup2 != null && !nameGroup1.equals(nameGroup2)) {
                this.myProblemsHolder.registerProblem(location, JavaErrorMessages.message(key2, referenceName, name2), new LocalQuickFix[0]);
            }
        }

        @Nullable
        private String findNameGroup(@Nullable String name2) {
            if (name2 == null) {
                return null;
            }
            String[] words = NameUtil.splitNameIntoWords((String)name2);
            String result2 = null;
            for (String word : words) {
                String group = (String)SuspiciousNameCombinationInspectionBase.this.myWordToGroupMap.get(SuspiciousNameCombinationInspectionBase.canonicalize(word));
                if (group == null) continue;
                if (result2 == null) {
                    result2 = group;
                    continue;
                }
                if (result2.equals(group)) continue;
                result2 = null;
                break;
            }
            return result2;
        }
    }
}

