/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.RunInspectionAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeTable;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLabelDecorator;
import com.intellij.ui.components.panels.StatelessCardLayout;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class InspectionNodeInfo
extends JPanel {
    private static final Logger LOG = Logger.getInstance(InspectionNodeInfo.class);

    public InspectionNodeInfo(final @NotNull InspectionTree tree, final @NotNull Project project2) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/codeInspection/ui/InspectionNodeInfo", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ui/InspectionNodeInfo", "<init>"));
        }
        this.setLayout(new GridBagLayout());
        this.setBorder(IdeBorderFactory.createEmptyBorder((int)11, (int)0, (int)0, (int)0));
        final InspectionToolWrapper toolWrapper = tree.getSelectedToolWrapper(false);
        LOG.assertTrue(toolWrapper != null);
        final InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance(project2).getCurrentProfile();
        final boolean enabled = currentProfile.getTools(toolWrapper.getShortName(), project2).isEnabled();
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 2));
        JBLabelDecorator label = JBLabelDecorator.createJBLabelDecorator().setBold(true);
        label.setText(toolWrapper.getDisplayName() + " inspection");
        titlePanel.add((Component)label);
        titlePanel.add(Box.createHorizontalStrut(JBUI.scale((int)16)));
        if (!enabled) {
            JBLabel enabledLabel = new JBLabel();
            enabledLabel.setForeground((Color)JBColor.GRAY);
            enabledLabel.setText("Disabled");
            titlePanel.add((Component)enabledLabel);
        }
        this.add((Component)titlePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)new JBInsets(0, 12, 5, 16), 0, 0));
        JEditorPane description = new JEditorPane();
        description.setContentType("text/html");
        description.setEditable(false);
        description.setOpaque(false);
        description.setBackground(UIUtil.getLabelBackground());
        description.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        String descriptionText = toolWrapper.loadDescription();
        LOG.assertTrue(descriptionText != null, (Object)("Inspection '" + toolWrapper.getShortName() + "' has no description"));
        String toolDescription = DefaultInspectionToolPresentation.stripUIRefsFromInspectionDescription(StringUtil.notNullize((String)descriptionText));
        SingleInspectionProfilePanel.readHTML(description, SingleInspectionProfilePanel.toHTML(description, toolDescription == null ? "" : toolDescription, false));
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)description, (boolean)true);
        int maxWidth = this.getFontMetrics(UIUtil.getLabelFont()).charWidth('f') * 110 - pane.getMinimumSize().width;
        pane.setMaximumSize(new Dimension(maxWidth, Integer.MAX_VALUE));
        pane.setAlignmentX(0.0f);
        this.add((Component)StatelessCardLayout.wrap((Component)pane), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, (Insets)new JBInsets(0, 10, 0, 0), 0, 0));
        JButton enableButton = new JButton((enabled ? "Disable" : "Enable") + " inspection");
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionNodeInfo$1", "onClick"));
                }
                InspectionsConfigTreeTable.setToolEnabled(!enabled, currentProfile, toolWrapper.getShortName(), project2);
                tree.getContext().getView().profileChanged();
                return true;
            }
        }.installOn((Component)enableButton);
        JButton runInspectionOnButton = new JButton(InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ui/InspectionNodeInfo$2", "onClick"));
                }
                RunInspectionAction.runInspection(project2, toolWrapper.getShortName(), null, null, null);
                return true;
            }
        }.installOn((Component)runInspectionOnButton);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 2));
        buttons.add(enableButton);
        buttons.add(Box.createHorizontalStrut(JBUI.scale((int)3)));
        buttons.add(runInspectionOnButton);
        this.add((Component)buttons, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 0, (Insets)new JBInsets(15, 9, 9, 0), 0, 0));
    }
}

