/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.ExcludedInspectionTreeNodesManager;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionTreeCellRenderer;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionTreeState;
import com.intellij.codeInspection.ui.InspectionTreeUpdater;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.psi.PsiElement;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionTree
extends Tree {
    private static final Logger LOG = Logger.getInstance(InspectionTree.class);
    @NotNull
    private final GlobalInspectionContextImpl myContext;
    @NotNull
    private final ExcludedInspectionTreeNodesManager myExcludedManager;
    @NotNull
    private InspectionTreeState myState;
    private boolean myQueueUpdate;

    public InspectionTree(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionResultsView view) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ui/InspectionTree", "<init>"));
        }
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ui/InspectionTree", "<init>"));
        }
        this.myState = new InspectionTreeState();
        Project project2 = context.getProject();
        this.setModel(new DefaultTreeModel(new InspectionRootNode(project2, new InspectionTreeUpdater(view))));
        this.myContext = context;
        this.myExcludedManager = view.getExcludedManager();
        this.setCellRenderer((TreeCellRenderer)((Object)new InspectionTreeCellRenderer(view)));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)((Object)this));
        this.addTreeWillExpandListener(new ExpandListener());
        this.myState.getExpandedUserObjects().add(project2);
        TreeUtil.installActions((JTree)((Object)this));
        new TreeSpeedSearch(this, (Convertor<TreePath, String>)((Convertor)o -> InspectionsConfigTreeComparator.getDisplayTextToSort(o.getLastPathComponent().toString())));
        this.addTreeSelectionListener(e -> {
            TreePath newSelection = e.getNewLeadSelectionPath();
            if (newSelection != null && !this.isUnderQueueUpdate()) {
                this.myState.setSelectionPath(newSelection);
            }
        });
    }

    public void setQueueUpdate(boolean queueUpdate) {
        this.myQueueUpdate = queueUpdate;
    }

    public boolean isUnderQueueUpdate() {
        return this.myQueueUpdate;
    }

    public void removeAllNodes() {
        this.getRoot().removeAllChildren();
        ApplicationManager.getApplication().invokeLater(() -> this.nodeStructureChanged(this.getRoot()));
    }

    public InspectionTreeNode getRoot() {
        return (InspectionTreeNode)this.getModel().getRoot();
    }

    @Nullable
    public String[] getSelectedGroupPath() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        TreePath commonPath = TreeUtil.findCommonPath((TreePath[])paths);
        for (Object n : commonPath.getPath()) {
            if (!(n instanceof InspectionGroupNode)) continue;
            return ((InspectionGroupNode)n).getGroupPath();
        }
        return null;
    }

    @Nullable
    public InspectionToolWrapper getSelectedToolWrapper(boolean allowDummy) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        InspectionToolWrapper toolWrapper = null;
        block0: for (TreePath path : paths) {
            Object[] nodes = path.getPath();
            for (int j = nodes.length - 1; j >= 0; --j) {
                Object node = nodes[j];
                if (node instanceof InspectionGroupNode) {
                    return null;
                }
                if (!(node instanceof InspectionNode)) continue;
                InspectionToolWrapper wrapper = ((InspectionNode)node).getToolWrapper();
                if (!allowDummy && this.getContext().getPresentation(wrapper).isDummy()) continue;
                if (toolWrapper == null) {
                    toolWrapper = wrapper;
                    continue block0;
                }
                if (toolWrapper == wrapper) continue block0;
                return null;
            }
        }
        return toolWrapper;
    }

    @Nullable
    public RefEntity getCommonSelectedElement() {
        Object node = this.getCommonSelectedNode();
        return node instanceof RefElementNode ? ((RefElementNode)node).getElement() : null;
    }

    @Nullable
    private Object getCommonSelectedNode() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        Object[][] resolvedPaths = new Object[paths.length][];
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            resolvedPaths[i] = path.getPath();
        }
        Object currentCommonNode = null;
        for (int i = 0; i < resolvedPaths[0].length; ++i) {
            Object currentNode = resolvedPaths[0][i];
            for (int j = 1; j < resolvedPaths.length; ++j) {
                Object o = resolvedPaths[j][i];
                if (o.equals(currentNode)) continue;
                return currentCommonNode;
            }
            currentCommonNode = currentNode;
        }
        return currentCommonNode;
    }

    @NotNull
    public RefEntity[] getSelectedElements() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            InspectionToolWrapper toolWrapper = this.getSelectedToolWrapper(true);
            if (toolWrapper == null) {
                if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionTree", "getSelectedElements"));
                }
                return RefEntity.EMPTY_ELEMENTS_ARRAY;
            }
            LinkedHashSet<RefEntity> result2 = new LinkedHashSet<RefEntity>();
            for (TreePath selectionPath : selectionPaths) {
                InspectionTreeNode node = (InspectionTreeNode)selectionPath.getLastPathComponent();
                InspectionTree.addElementsInNode(node, result2);
            }
            RefEntity[] refEntityArray = (RefEntity[])ArrayUtil.reverseArray((Object[])result2.toArray(new RefEntity[result2.size()]));
            if (refEntityArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionTree", "getSelectedElements"));
            }
            return refEntityArray;
        }
        if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionTree", "getSelectedElements"));
        }
        return RefEntity.EMPTY_ELEMENTS_ARRAY;
    }

    private static void addElementsInNode(InspectionTreeNode node, Set<RefEntity> out) {
        RefEntity element;
        if (!node.isValid()) {
            return;
        }
        if (node instanceof RefElementNode) {
            element = ((RefElementNode)node).getElement();
            out.add(element);
        }
        if (node instanceof ProblemDescriptionNode) {
            element = ((ProblemDescriptionNode)node).getElement();
            out.add(element);
        }
        Enumeration<TreeNode> children2 = node.children();
        while (children2.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)children2.nextElement();
            InspectionTree.addElementsInNode(child, out);
        }
    }

    @NotNull
    public CommonProblemDescriptor[] getAllValidSelectedDescriptors() {
        CommonProblemDescriptor[] commonProblemDescriptorArray = this.getSelectedDescriptors(false, null, true, false);
        if (commonProblemDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionTree", "getAllValidSelectedDescriptors"));
        }
        return commonProblemDescriptorArray;
    }

    @NotNull
    public CommonProblemDescriptor[] getSelectedDescriptors() {
        CommonProblemDescriptor[] commonProblemDescriptorArray = this.getSelectedDescriptors(false, null, false, false);
        if (commonProblemDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionTree", "getSelectedDescriptors"));
        }
        return commonProblemDescriptorArray;
    }

    @NotNull
    public CommonProblemDescriptor[] getSelectedDescriptors(boolean sortedByPosition, @Nullable Set<VirtualFile> readOnlyFilesSink, boolean allowResolved, boolean allowSuppressed) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            if (CommonProblemDescriptor.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionTree", "getSelectedDescriptors"));
            }
            return CommonProblemDescriptor.EMPTY_ARRAY;
        }
        TreePath[] selectionPaths = TreeUtil.selectMaximals((TreePath[])paths);
        ArrayList<CommonProblemDescriptor> descriptors = new ArrayList<CommonProblemDescriptor>();
        MultiMap parentToChildNode = new MultiMap();
        SmartList nonDescriptorNodes = new SmartList();
        for (TreePath path : selectionPaths) {
            int length;
            Object[] pathAsArray = path.getPath();
            Object node = pathAsArray[(length = pathAsArray.length) - 1];
            if (node instanceof ProblemDescriptionNode) {
                if (!this.isNodeValidAndIncluded((ProblemDescriptionNode)node, allowResolved, allowSuppressed)) continue;
                if (length >= 2) {
                    parentToChildNode.putValue(pathAsArray[length - 2], (Object)((ProblemDescriptionNode)node));
                    continue;
                }
                parentToChildNode.putValue(node, (Object)((ProblemDescriptionNode)node));
                continue;
            }
            nonDescriptorNodes.add((InspectionTreeNode)node);
        }
        for (InspectionTreeNode node : nonDescriptorNodes) {
            this.processChildDescriptorsDeep(node, descriptors, sortedByPosition, allowResolved, allowSuppressed, readOnlyFilesSink);
        }
        for (Map.Entry entry : parentToChildNode.entrySet()) {
            Collection siblings = (Collection)entry.getValue();
            if (siblings.size() == 1) {
                ProblemDescriptionNode descriptorNode = (ProblemDescriptionNode)ContainerUtil.getFirstItem((Collection)siblings);
                LOG.assertTrue(descriptorNode != null);
                CommonProblemDescriptor descriptor = descriptorNode.getDescriptor();
                if (descriptor == null) continue;
                descriptors.add(descriptor);
                if (readOnlyFilesSink == null) continue;
                InspectionTree.collectReadOnlyFiles(descriptor, readOnlyFilesSink);
                continue;
            }
            ArrayList<CommonProblemDescriptor> currentDescriptors = new ArrayList<CommonProblemDescriptor>();
            for (ProblemDescriptionNode sibling : siblings) {
                CommonProblemDescriptor descriptor = sibling.getDescriptor();
                if (descriptor == null) continue;
                if (readOnlyFilesSink != null) {
                    InspectionTree.collectReadOnlyFiles(descriptor, readOnlyFilesSink);
                }
                currentDescriptors.add(descriptor);
            }
            if (sortedByPosition) {
                Collections.sort(currentDescriptors, CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
            }
            descriptors.addAll(currentDescriptors);
        }
        CommonProblemDescriptor[] commonProblemDescriptorArray = descriptors.toArray(new CommonProblemDescriptor[descriptors.size()]);
        if (commonProblemDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionTree", "getSelectedDescriptors"));
        }
        return commonProblemDescriptorArray;
    }

    public boolean areDescriptorNodesSelected() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath path : paths) {
            if (path.getLastPathComponent() instanceof ProblemDescriptionNode) continue;
            return false;
        }
        return true;
    }

    public int getSelectedProblemCount(boolean allowSuppressed) {
        int count = 0;
        for (TreePath path : TreeUtil.selectMaximals((TreePath[])this.getSelectionPaths())) {
            count += ((InspectionTreeNode)path.getLastPathComponent()).getProblemCount(allowSuppressed);
        }
        return count;
    }

    private void processChildDescriptorsDeep(InspectionTreeNode node, List<CommonProblemDescriptor> descriptors, boolean sortedByPosition, boolean allowResolved, boolean allowSuppressed, @Nullable Set<VirtualFile> readOnlyFilesSink) {
        ArrayList<CommonProblemDescriptor> descriptorChildren = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            if (child instanceof ProblemDescriptionNode) {
                if (!this.isNodeValidAndIncluded((ProblemDescriptionNode)child, allowResolved, allowSuppressed)) continue;
                if (sortedByPosition) {
                    if (descriptorChildren == null) {
                        descriptorChildren = new ArrayList<CommonProblemDescriptor>();
                    }
                    descriptorChildren.add(((ProblemDescriptionNode)child).getDescriptor());
                    continue;
                }
                descriptors.add(((ProblemDescriptionNode)child).getDescriptor());
                continue;
            }
            this.processChildDescriptorsDeep((InspectionTreeNode)child, descriptors, sortedByPosition, allowResolved, allowSuppressed, readOnlyFilesSink);
        }
        if (descriptorChildren != null) {
            if (descriptorChildren.size() > 1) {
                Collections.sort(descriptorChildren, CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
            }
            if (readOnlyFilesSink != null) {
                InspectionTree.collectReadOnlyFiles((Collection<CommonProblemDescriptor>)descriptorChildren, readOnlyFilesSink);
            }
            descriptors.addAll((Collection<CommonProblemDescriptor>)descriptorChildren);
        }
    }

    private boolean isNodeValidAndIncluded(ProblemDescriptionNode node, boolean allowResolved, boolean allowSuppressed) {
        return node.isValid() && (allowResolved || !node.isExcluded(this.myExcludedManager) && (!node.isAlreadySuppressedFromView() || allowSuppressed && !node.getAvailableSuppressActions().isEmpty()) && !node.isQuickFixAppliedFromView());
    }

    private void nodeStructureChanged(InspectionTreeNode node) {
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(node);
    }

    public void queueUpdate() {
        ((InspectionRootNode)this.getRoot()).getUpdater().update(true);
    }

    public void restoreExpansionAndSelection(boolean treeNodesMightChange) {
        this.myState.restoreExpansionAndSelection(this, treeNodesMightChange);
    }

    public void setState(@NotNull InspectionTreeState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInspection/ui/InspectionTree", "setState"));
        }
        this.myState = state;
    }

    public InspectionTreeState getTreeState() {
        return this.myState;
    }

    public void setTreeState(@NotNull InspectionTreeState treeState) {
        if (treeState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeState", "com/intellij/codeInspection/ui/InspectionTree", "setTreeState"));
        }
        this.myState = treeState;
    }

    @NotNull
    public GlobalInspectionContextImpl getContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myContext;
        if (globalInspectionContextImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionTree", "getContext"));
        }
        return globalInspectionContextImpl;
    }

    private static void collectReadOnlyFiles(@NotNull Collection<CommonProblemDescriptor> descriptors, @NotNull Set<VirtualFile> readOnlySink) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/ui/InspectionTree", "collectReadOnlyFiles"));
        }
        if (readOnlySink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnlySink", "com/intellij/codeInspection/ui/InspectionTree", "collectReadOnlyFiles"));
        }
        for (CommonProblemDescriptor descriptor : descriptors) {
            InspectionTree.collectReadOnlyFiles(descriptor, readOnlySink);
        }
    }

    private static void collectReadOnlyFiles(@NotNull CommonProblemDescriptor descriptor, @NotNull Set<VirtualFile> readOnlySink) {
        PsiElement psiElement;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ui/InspectionTree", "collectReadOnlyFiles"));
        }
        if (readOnlySink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnlySink", "com/intellij/codeInspection/ui/InspectionTree", "collectReadOnlyFiles"));
        }
        if (descriptor instanceof ProblemDescriptor && (psiElement = ((ProblemDescriptor)descriptor).getPsiElement()) != null && !psiElement.isWritable()) {
            readOnlySink.add(psiElement.getContainingFile().getVirtualFile());
        }
    }

    private class ExpandListener
    implements TreeWillExpandListener {
        private ExpandListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            InspectionTreeNode node = (InspectionTreeNode)event.getPath().getLastPathComponent();
            InspectionTree.this.myState.getExpandedUserObjects().add(node.getUserObject());
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            InspectionTreeNode node = (InspectionTreeNode)event.getPath().getLastPathComponent();
            InspectionTree.this.myState.getExpandedUserObjects().remove(node.getUserObject());
        }
    }
}

