/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.ExcludedInspectionTreeNodesManager;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionTreeUpdater;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionTreeNode
extends DefaultMutableTreeNode {
    protected volatile InspectionTreeUpdater myUpdater;

    protected InspectionTreeNode(Object userObject) {
        super(userObject);
    }

    @Nullable
    public Icon getIcon(boolean expanded) {
        return null;
    }

    public void visitProblemSeverities(TObjectIntHashMap<HighlightDisplayLevel> counter) {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)enumeration.nextElement();
            child.visitProblemSeverities(counter);
        }
    }

    public int getProblemCount(boolean allowSuppressed) {
        int sum = 0;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)enumeration.nextElement();
            sum += child.getProblemCount(allowSuppressed);
        }
        return sum;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isExcluded(ExcludedInspectionTreeNodesManager excludedManager) {
        return excludedManager.isExcluded(this);
    }

    public boolean appearsBold() {
        return false;
    }

    @Nullable
    public String getTailText() {
        return null;
    }

    public FileStatus getNodeStatus() {
        return FileStatus.NOT_CHANGED;
    }

    public void excludeElement(ExcludedInspectionTreeNodesManager excludedManager) {
        excludedManager.exclude(this);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)enumeration.nextElement();
            child.excludeElement(excludedManager);
        }
    }

    public void amnestyElement(ExcludedInspectionTreeNodesManager excludedManager) {
        excludedManager.amnesty(this);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)enumeration.nextElement();
            child.amnestyElement(excludedManager);
        }
    }

    public InspectionTreeNode insertByOrder(InspectionTreeNode child, boolean allowDuplication) {
        return (InspectionTreeNode)ReadAction.compute(() -> {
            int index;
            if (!allowDuplication && (index = this.getIndex(child)) != -1) {
                return (InspectionTreeNode)this.getChildAt(index);
            }
            index = TreeUtil.indexedBinarySearch((TreeNode)this, (TreeNode)child, (Comparator)InspectionResultsViewComparator.getInstance());
            if (!allowDuplication && index >= 0) {
                return (InspectionTreeNode)this.getChildAt(index);
            }
            this.insert(child, Math.abs(index + 1));
            return child;
        });
    }

    @Override
    public void add(MutableTreeNode newChild) {
        super.add(newChild);
        if (this.myUpdater != null) {
            ((InspectionTreeNode)newChild).propagateUpdater(this.myUpdater);
            this.myUpdater.updateWithPreviewPanel();
        }
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        if (this.myUpdater != null) {
            ((InspectionTreeNode)newChild).propagateUpdater(this.myUpdater);
            this.myUpdater.updateWithPreviewPanel();
        }
    }

    private void propagateUpdater(InspectionTreeUpdater updater) {
        if (this.myUpdater != null) {
            return;
        }
        this.myUpdater = updater;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)enumeration.nextElement();
            child.propagateUpdater(updater);
        }
    }

    public RefEntity getContainingFileLocalEntity() {
        Enumeration<TreeNode> children2 = this.children();
        RefEntity current = null;
        while (children2.hasMoreElements()) {
            InspectionTreeNode child = (InspectionTreeNode)children2.nextElement();
            RefEntity entity = child.getContainingFileLocalEntity();
            if (entity == null || current != null) {
                return null;
            }
            current = entity;
        }
        return current;
    }

    @Override
    public synchronized TreeNode getParent() {
        return super.getParent();
    }

    @Override
    public synchronized void setParent(MutableTreeNode newParent) {
        super.setParent(newParent);
    }
}

